/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class JaybirdSystemProperties {
    private static final String COMMON_PREFIX = "org.firebirdsql.";
    private static final String JDBC_PREFIX = "org.firebirdsql.jdbc.";
    public static final String FORCE_CONSOLE_LOGGER_PROP = "org.firebirdsql.jdbc.forceConsoleLogger";
    public static final String DISABLE_LOGGING_PROP = "org.firebirdsql.jdbc.disableLogging";
    public static final String LOGGER_IMPLEMENTATION_PROP = "org.firebirdsql.jdbc.loggerImplementation";
    public static final String SYNC_WRAP_NATIVE_LIBRARY_PROP = "org.firebirdsql.jna.syncWrapNativeLibrary";
    public static final String PROCESS_ID_PROP = "org.firebirdsql.jdbc.pid";
    public static final String PROCESS_NAME_PROP = "org.firebirdsql.jdbc.processName";
    public static final String DEFAULT_CONNECTION_ENCODING_PROPERTY = "org.firebirdsql.jdbc.defaultConnectionEncoding";
    public static final String REQUIRE_CONNECTION_ENCODING_PROPERTY = "org.firebirdsql.jdbc.requireConnectionEncoding";
    public static final String DATATYPE_CODER_CACHE_SIZE = "org.firebirdsql.datatypeCoderCacheSize";
    public static final String NATIVE_LIBRARY_SHUTDOWN_DISABLED = "org.firebirdsql.nativeResourceShutdownDisabled";

    private JaybirdSystemProperties() {
    }

    public static boolean isForceConsoleLogger() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(FORCE_CONSOLE_LOGGER_PROP);
    }

    public static boolean isDisableLogging() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(DISABLE_LOGGING_PROP);
    }

    public static String getLoggerImplementation() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(LOGGER_IMPLEMENTATION_PROP);
    }

    public static boolean isSyncWrapNativeLibrary() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(SYNC_WRAP_NATIVE_LIBRARY_PROP);
    }

    public static Integer getProcessId() {
        return JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(PROCESS_ID_PROP);
    }

    public static String getProcessName() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(PROCESS_NAME_PROP);
    }

    public static String getDefaultConnectionEncoding() {
        return JaybirdSystemProperties.getSystemPropertyPrivileged(DEFAULT_CONNECTION_ENCODING_PROPERTY);
    }

    public static boolean isRequireConnectionEncoding() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(REQUIRE_CONNECTION_ENCODING_PROPERTY);
    }

    public static boolean isNativeResourceShutdownDisabled() {
        return JaybirdSystemProperties.getBooleanSystemPropertyPrivileged(NATIVE_LIBRARY_SHUTDOWN_DISABLED);
    }

    public static int getDatatypeCoderCacheSize(int defaultValue) {
        Integer value = JaybirdSystemProperties.getIntegerSystemPropertyPrivileged(DATATYPE_CODER_CACHE_SIZE);
        return value != null ? value : defaultValue;
    }

    private static String getSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }

    private static boolean getBooleanSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(propertyName);
            }
        });
    }

    private static Integer getIntegerSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(propertyName);
            }
        });
    }
}

