"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.merge = exports.cloneShallow = void 0;
function cloneShallow(obj) {
    return isPlainObject(obj)
        ? Object.assign({}, obj)
        : Object.setPrototypeOf(Object.assign({}, obj), Object.getPrototypeOf(obj));
}
exports.cloneShallow = cloneShallow;
function isPlainObject(obj) {
    if (typeof obj !== "object" ||
        obj === null ||
        Object.prototype.toString.call(obj) != "[object Object]") {
        // Not an object
        return false;
    }
    if (Object.getPrototypeOf(obj) === null) {
        return true;
    }
    var proto = obj;
    // Find the prototype
    while (Object.getPrototypeOf(proto) !== null) {
        proto = Object.getPrototypeOf(proto);
    }
    return Object.getPrototypeOf(obj) === proto;
}
function merge() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var output = null, items = __spreadArray([], args, true);
    while (items.length > 0) {
        var nextItem = items.shift();
        if (!output) {
            output = cloneShallow(nextItem);
        }
        else {
            output = mergeObjects(output, nextItem);
        }
    }
    return output;
}
exports.merge = merge;
function mergeObjects(obj1, obj2) {
    var output = cloneShallow(obj1);
    Object.keys(obj2).forEach(function (key) {
        if (!output.hasOwnProperty(key)) {
            output[key] = obj2[key];
            return;
        }
        if (Array.isArray(obj2[key])) {
            output[key] = Array.isArray(output[key])
                ? __spreadArray(__spreadArray([], output[key], true), obj2[key], true) : __spreadArray([], obj2[key], true);
        }
        else if (typeof obj2[key] === "object" && !!obj2[key]) {
            output[key] =
                typeof output[key] === "object" && !!output[key]
                    ? mergeObjects(output[key], obj2[key])
                    : cloneShallow(obj2[key]);
        }
        else {
            output[key] = obj2[key];
        }
    });
    return output;
}
