/* contacts-contact-list.c generated by valac 0.56.0, the Vala compiler
 * generated from contacts-contact-list.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <folks/folks.h>
#include "contacts.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_LIST_AVATAR_SIZE 48
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_CONTACT_LIST (contacts_contact_list_get_type ())
#define CONTACTS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactList))
#define CONTACTS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))
#define CONTACTS_IS_CONTACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_IS_CONTACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_LIST))
#define CONTACTS_CONTACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_LIST, ContactsContactListClass))

typedef struct _ContactsContactList ContactsContactList;
typedef struct _ContactsContactListClass ContactsContactListClass;
typedef struct _ContactsContactListPrivate ContactsContactListPrivate;
typedef enum  {
	CONTACTS_UI_STATE_NORMAL,
	CONTACTS_UI_STATE_SHOWING,
	CONTACTS_UI_STATE_SELECTING,
	CONTACTS_UI_STATE_UPDATING,
	CONTACTS_UI_STATE_CREATING
} ContactsUiState;

#define CONTACTS_TYPE_UI_STATE (contacts_ui_state_get_type ())
enum  {
	CONTACTS_CONTACT_LIST_0_PROPERTY,
	CONTACTS_CONTACT_LIST_STATE_PROPERTY,
	CONTACTS_CONTACT_LIST_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_list_properties[CONTACTS_CONTACT_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;
typedef struct _Block12Data Block12Data;

#define CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW (contacts_contact_list_contact_data_row_get_type ())
#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow))
#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRowClass))
#define CONTACTS_CONTACT_LIST_IS_CONTACT_DATA_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW))
#define CONTACTS_CONTACT_LIST_IS_CONTACT_DATA_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW))
#define CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRowClass))

typedef struct _ContactsContactListContactDataRow ContactsContactListContactDataRow;
typedef struct _ContactsContactListContactDataRowClass ContactsContactListContactDataRowClass;
typedef struct _ContactsContactListContactDataRowPrivate ContactsContactListContactDataRowPrivate;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
enum  {
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_0_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY,
	CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_NUM_PROPERTIES
};
static GParamSpec* contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_NUM_PROPERTIES];
enum  {
	CONTACTS_CONTACT_LIST_SELECTION_CHANGED_SIGNAL,
	CONTACTS_CONTACT_LIST_CONTACTS_MARKED_SIGNAL,
	CONTACTS_CONTACT_LIST_NUM_SIGNALS
};
static guint contacts_contact_list_signals[CONTACTS_CONTACT_LIST_NUM_SIGNALS] = {0};

struct _ContactsContactList {
	AdwBin parent_instance;
	ContactsContactListPrivate * priv;
};

struct _ContactsContactListClass {
	AdwBinClass parent_class;
};

struct _ContactsContactListPrivate {
	gint nr_contacts_marked;
	FolksQuery* filter_query;
	ContactsStore* store;
	gboolean sort_on_surname;
	gboolean got_long_press;
	ContactsUiState _state;
	GtkListBox* listbox;
	GtkAdjustment* vadjustment;
};

struct _Block12Data {
	int _ref_count_;
	ContactsContactList* self;
	ContactsSettings* settings;
};

struct _ContactsContactListContactDataRow {
	GtkListBoxRow parent_instance;
	ContactsContactListContactDataRowPrivate * priv;
	GtkCheckButton* selector_button;
};

struct _ContactsContactListContactDataRowClass {
	GtkListBoxRowClass parent_class;
};

struct _Block13Data {
	int _ref_count_;
	ContactsContactList* self;
	ContactsContactListContactDataRow* row;
};

struct _Block14Data {
	int _ref_count_;
	ContactsContactList* self;
	ContactsContactListContactDataRow* selected_row;
};

struct _ContactsContactListContactDataRowPrivate {
	FolksIndividual* _individual;
	GtkLabel* label;
	ContactsAvatar* avatar;
};

static gint ContactsContactList_private_offset;
static gpointer contacts_contact_list_parent_class = NULL;
static gint ContactsContactListContactDataRow_private_offset;
static gpointer contacts_contact_list_contact_data_row_parent_class = NULL;

VALA_EXTERN GType contacts_contact_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactList, g_object_unref)
VALA_EXTERN GType contacts_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType contacts_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsSettings, g_object_unref)
VALA_EXTERN ContactsContactList* contacts_contact_list_new (ContactsSettings* settings,
                                                ContactsStore* store,
                                                FolksQuery* query);
VALA_EXTERN ContactsContactList* contacts_contact_list_construct (GType object_type,
                                                      ContactsSettings* settings,
                                                      ContactsStore* store,
                                                      FolksQuery* query);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda6_ (ContactsContactList* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void contacts_contact_list_on_ui_state_changed (ContactsContactList* self,
                                                GObject* obj,
                                                GParamSpec* pspec);
static void _contacts_contact_list_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
VALA_EXTERN gboolean contacts_settings_get_sort_on_surname (ContactsSettings* self);
static void __lambda7_ (Block12Data* _data12_);
static void ___lambda7__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void contacts_contact_list_contact_added_cb (ContactsContactList* self,
                                             ContactsStore* store,
                                             FolksIndividual* i);
static void _contacts_contact_list_contact_added_cb_contacts_store_added (ContactsStore* _sender,
                                                                   FolksIndividual* c,
                                                                   gpointer self);
static void contacts_contact_list_contact_removed_cb (ContactsContactList* self,
                                               ContactsStore* store,
                                               FolksIndividual* i);
static void _contacts_contact_list_contact_removed_cb_contacts_store_removed (ContactsStore* _sender,
                                                                       FolksIndividual* c,
                                                                       gpointer self);
static GType contacts_contact_list_contact_data_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsContactListContactDataRow, g_object_unref)
VALA_EXTERN ContactsUiState contacts_contact_list_get_state (ContactsContactList* self);
static gint contacts_contact_list_compare_rows (ContactsContactList* self,
                                         GtkListBoxRow* row_a,
                                         GtkListBoxRow* row_b);
static FolksIndividual* contacts_contact_list_contact_data_row_get_individual (ContactsContactListContactDataRow* self);
static const gchar* contacts_contact_list_try_get_surname (ContactsContactList* self,
                                                    FolksIndividual* indiv);
static void contacts_contact_list_update_header (ContactsContactList* self,
                                          GtkListBoxRow* row,
                                          GtkListBoxRow* before);
static GtkLabel* contacts_contact_list_create_header_label (ContactsContactList* self,
                                                     const gchar* text);
static ContactsContactListContactDataRow* contacts_contact_list_find_row_for_contact (ContactsContactList* self,
                                                                               FolksIndividual* individual);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static ContactsContactListContactDataRow* contacts_contact_list_contact_data_row_new (FolksIndividual* i);
static ContactsContactListContactDataRow* contacts_contact_list_contact_data_row_construct (GType object_type,
                                                                                     FolksIndividual* i);
static void ___lambda8_ (Block13Data* _data13_);
static void contacts_contact_list_on_row_checkbox_toggled (ContactsContactList* self,
                                                    ContactsContactListContactDataRow* row);
static void ____lambda8__gtk_check_button_toggled (GtkCheckButton* _sender,
                                            gpointer self);
VALA_EXTERN void contacts_contact_list_set_state (ContactsContactList* self,
                                      ContactsUiState value);
static void contacts_contact_list_on_row_activated (ContactsContactList* self,
                                             GtkListBox* listbox,
                                             GtkListBoxRow* row);
static void contacts_contact_list_on_row_selected (ContactsContactList* self,
                                            GtkListBox* listbox,
                                            GtkListBoxRow* row);
static gboolean contacts_contact_list_filter_row (ContactsContactList* self,
                                           GtkListBoxRow* row);
VALA_EXTERN void contacts_contact_list_select_contact (ContactsContactList* self,
                                           FolksIndividual* individual);
VALA_EXTERN void contacts_contact_list_scroll_to_contact (ContactsContactList* self,
                                              GtkListBoxRow* row);
static void contacts_contact_list_load_visible_avatars (ContactsContactList* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static gboolean __lambda9_ (Block14Data* _data14_);
static gboolean ___lambda9__gsource_func (gpointer self);
VALA_EXTERN void contacts_contact_list_set_contact_visible (ContactsContactList* self,
                                                FolksIndividual* individual,
                                                gboolean visible);
VALA_EXTERN GeeLinkedList* contacts_contact_list_get_marked_contacts (ContactsContactList* self);
VALA_EXTERN GeeLinkedList* contacts_contact_list_get_marked_contacts_and_hide (ContactsContactList* self);
static void contacts_contact_list_on_right_click (ContactsContactList* self,
                                           GtkGestureClick* gesture,
                                           gint n_press,
                                           gdouble x,
                                           gdouble y);
static void contacts_contact_list_on_long_press (ContactsContactList* self,
                                          GtkGestureLongPress* gesture,
                                          gdouble x,
                                          gdouble y);
VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
static void contacts_contact_list_contact_data_row_on_contact_changed (ContactsContactListContactDataRow* self,
                                                                GObject* obj,
                                                                GParamSpec* pspec);
static void _contacts_contact_list_contact_data_row_on_contact_changed_g_object_notify (GObject* _sender,
                                                                                 GParamSpec* pspec,
                                                                                 gpointer self);
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
VALA_EXTERN void contacts_avatar_reload (ContactsAvatar* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void contacts_avatar_reload_finish (ContactsAvatar* self,
                                    GAsyncResult* _res_);
static void contacts_contact_list_contact_data_row_set_individual (ContactsContactListContactDataRow* self,
                                                            FolksIndividual* value);
static void contacts_contact_list_contact_data_row_finalize (GObject * obj);
static GType contacts_contact_list_contact_data_row_get_type_once (void);
static void _vala_contacts_contact_list_contact_data_row_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_contacts_contact_list_contact_data_row_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static GObject * contacts_contact_list_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _contacts_contact_list___lambda10_ (ContactsContactList* self,
                                         GtkAdjustment* vadj);
static void __contacts_contact_list___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                       gpointer self);
static gint _contacts_contact_list_compare_rows_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                 GtkListBoxRow* row2,
                                                                 gpointer self);
static gboolean _contacts_contact_list_filter_row_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                     gpointer self);
static void _contacts_contact_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                           GtkListBoxRow* before,
                                                                           gpointer self);
static void _contacts_contact_list_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self);
static void _contacts_contact_list_on_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self);
static void _contacts_contact_list_on_right_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                      gint n_press,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self);
static void _contacts_contact_list_on_long_press_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                          gdouble x,
                                                                          gdouble y,
                                                                          gpointer self);
static void contacts_contact_list_finalize (GObject * obj);
static GType contacts_contact_list_get_type_once (void);
static void _vala_contacts_contact_list_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_contacts_contact_list_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
contacts_contact_list_get_instance_private (ContactsContactList* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactList_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ContactsContactList* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda6_ (ContactsContactList* self)
{
	GtkListBox* _tmp0_;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_filter (_tmp0_);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((ContactsContactList*) self);
}

static void
_contacts_contact_list_on_ui_state_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	contacts_contact_list_on_ui_state_changed ((ContactsContactList*) self, _sender, pspec);
}

static void
__lambda7_ (Block12Data* _data12_)
{
	ContactsContactList* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkListBox* _tmp2_;
	self = _data12_->self;
	_tmp0_ = contacts_settings_get_sort_on_surname (_data12_->settings);
	_tmp1_ = _tmp0_;
	self->priv->sort_on_surname = _tmp1_;
	_tmp2_ = self->priv->listbox;
	gtk_list_box_invalidate_sort (_tmp2_);
}

static void
___lambda7__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda7_ (self);
}

static void
_contacts_contact_list_contact_added_cb_contacts_store_added (ContactsStore* _sender,
                                                              FolksIndividual* c,
                                                              gpointer self)
{
	contacts_contact_list_contact_added_cb ((ContactsContactList*) self, _sender, c);
}

static void
_contacts_contact_list_contact_removed_cb_contacts_store_removed (ContactsStore* _sender,
                                                                  FolksIndividual* c,
                                                                  gpointer self)
{
	contacts_contact_list_contact_removed_cb ((ContactsContactList*) self, _sender, c);
}

ContactsContactList*
contacts_contact_list_construct (GType object_type,
                                 ContactsSettings* settings,
                                 ContactsStore* store,
                                 FolksQuery* query)
{
	ContactsContactList * self = NULL;
	Block12Data* _data12_;
	ContactsSettings* _tmp0_;
	ContactsStore* _tmp1_;
	FolksQuery* _tmp2_;
	FolksQuery* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ContactsStore* _tmp6_;
	ContactsStore* _tmp7_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (_data12_->settings);
	_data12_->settings = _tmp0_;
	self = (ContactsContactList*) g_object_new (object_type, NULL);
	_data12_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (store);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp1_;
	_tmp2_ = _g_object_ref0 (query);
	_g_object_unref0 (self->priv->filter_query);
	self->priv->filter_query = _tmp2_;
	_tmp3_ = self->priv->filter_query;
	g_signal_connect_object ((GObject*) _tmp3_, "notify", (GCallback) ___lambda6__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) _contacts_contact_list_on_ui_state_changed_g_object_notify, self, 0);
	_tmp4_ = contacts_settings_get_sort_on_surname (_data12_->settings);
	_tmp5_ = _tmp4_;
	self->priv->sort_on_surname = _tmp5_;
	g_signal_connect_data ((GSettings*) _data12_->settings, "changed::sort-on-surname", (GCallback) ___lambda7__g_settings_changed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp6_ = self->priv->store;
	g_signal_connect_object (_tmp6_, "added", (GCallback) _contacts_contact_list_contact_added_cb_contacts_store_added, self, 0);
	_tmp7_ = self->priv->store;
	g_signal_connect_object (_tmp7_, "removed", (GCallback) _contacts_contact_list_contact_removed_cb_contacts_store_removed, self, 0);
	{
		GeeIterator* _i_it = NULL;
		ContactsStore* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
		_tmp8_ = self->priv->store;
		_tmp9_ = contacts_store_get_contacts (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_i_it = _tmp12_;
		while (TRUE) {
			GeeIterator* _tmp13_;
			FolksIndividual* i = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			ContactsStore* _tmp16_;
			FolksIndividual* _tmp17_;
			_tmp13_ = _i_it;
			if (!gee_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _i_it;
			_tmp15_ = gee_iterator_get (_tmp14_);
			i = (FolksIndividual*) _tmp15_;
			_tmp16_ = self->priv->store;
			_tmp17_ = i;
			contacts_contact_list_contact_added_cb (self, _tmp16_, _tmp17_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return self;
}

ContactsContactList*
contacts_contact_list_new (ContactsSettings* settings,
                           ContactsStore* store,
                           FolksQuery* query)
{
	return contacts_contact_list_construct (CONTACTS_TYPE_CONTACT_LIST, settings, store, query);
}

static void
contacts_contact_list_on_ui_state_changed (ContactsContactList* self,
                                           GObject* obj,
                                           GParamSpec* pspec)
{
	ContactsUiState _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ContactsContactListContactDataRow* row = NULL;
				GtkListBox* _tmp2_;
				GtkListBoxRow* _tmp3_;
				ContactsContactListContactDataRow* _tmp4_;
				ContactsContactListContactDataRow* _tmp5_;
				GtkCheckButton* _tmp6_;
				ContactsUiState _tmp7_;
				ContactsUiState _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->listbox;
				_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, i);
				row = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
				_tmp4_ = row;
				if (_tmp4_ == NULL) {
					break;
				}
				_tmp5_ = row;
				_tmp6_ = _tmp5_->selector_button;
				_tmp7_ = self->priv->_state;
				gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp7_ == CONTACTS_UI_STATE_SELECTING);
				_tmp8_ = self->priv->_state;
				if (_tmp8_ != CONTACTS_UI_STATE_SELECTING) {
					ContactsContactListContactDataRow* _tmp9_;
					GtkCheckButton* _tmp10_;
					_tmp9_ = row;
					_tmp10_ = _tmp9_->selector_button;
					gtk_check_button_set_active (_tmp10_, FALSE);
				}
			}
		}
	}
	_tmp11_ = self->priv->_state;
	if (_tmp11_ == CONTACTS_UI_STATE_SELECTING) {
		GtkListBox* _tmp12_;
		_tmp12_ = self->priv->listbox;
		gtk_list_box_set_selection_mode (_tmp12_, GTK_SELECTION_NONE);
	} else {
		GtkListBox* _tmp13_;
		_tmp13_ = self->priv->listbox;
		gtk_list_box_set_selection_mode (_tmp13_, GTK_SELECTION_BROWSE);
		self->priv->nr_contacts_marked = 0;
	}
}

static gint
contacts_contact_list_compare_rows (ContactsContactList* self,
                                    GtkListBoxRow* row_a,
                                    GtkListBoxRow* row_b)
{
	FolksIndividual* a = NULL;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* b = NULL;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksIndividual* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FolksIndividual* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp14_ = NULL;
	const gchar* a_name = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* b_name = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row_a != NULL, 0);
	g_return_val_if_fail (row_b != NULL, 0);
	_tmp0_ = contacts_contact_list_contact_data_row_get_individual (G_TYPE_CHECK_INSTANCE_CAST (row_a, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow));
	_tmp1_ = _tmp0_;
	a = _tmp1_;
	_tmp2_ = contacts_contact_list_contact_data_row_get_individual (G_TYPE_CHECK_INSTANCE_CAST (row_b, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow));
	_tmp3_ = _tmp2_;
	b = _tmp3_;
	_tmp4_ = a;
	_tmp5_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = b;
	_tmp8_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp6_ != _tmp9_) {
		gint _tmp10_ = 0;
		FolksIndividual* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = a;
		_tmp12_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			_tmp10_ = -1;
		} else {
			_tmp10_ = 1;
		}
		result = _tmp10_;
		return result;
	}
	if (self->priv->sort_on_surname) {
		FolksIndividual* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = a;
		_tmp16_ = contacts_contact_list_try_get_surname (self, _tmp15_);
		_tmp14_ = _tmp16_;
	} else {
		FolksIndividual* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = a;
		_tmp18_ = folks_individual_get_display_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp14_ = _tmp19_;
	}
	a_name = _tmp14_;
	if (self->priv->sort_on_surname) {
		FolksIndividual* _tmp21_;
		const gchar* _tmp22_;
		_tmp21_ = b;
		_tmp22_ = contacts_contact_list_try_get_surname (self, _tmp21_);
		_tmp20_ = _tmp22_;
	} else {
		FolksIndividual* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = b;
		_tmp24_ = folks_individual_get_display_name (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp20_ = _tmp25_;
	}
	b_name = _tmp20_;
	_tmp26_ = a_name;
	_tmp27_ = b_name;
	result = g_utf8_collate (_tmp26_, _tmp27_);
	return result;
}

static const gchar*
contacts_contact_list_try_get_surname (ContactsContactList* self,
                                       FolksIndividual* indiv)
{
	gboolean _tmp0_ = FALSE;
	FolksStructuredName* _tmp1_;
	FolksStructuredName* _tmp2_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (indiv != NULL, NULL);
	_tmp1_ = folks_name_details_get_structured_name ((FolksNameDetails*) indiv);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FolksStructuredName* _tmp3_;
		FolksStructuredName* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = folks_name_details_get_structured_name ((FolksNameDetails*) indiv);
		_tmp4_ = _tmp3_;
		_tmp5_ = folks_structured_name_get_family_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FolksStructuredName* _tmp7_;
		FolksStructuredName* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = folks_name_details_get_structured_name ((FolksNameDetails*) indiv);
		_tmp8_ = _tmp7_;
		_tmp9_ = folks_structured_name_get_family_name (_tmp8_);
		_tmp10_ = _tmp9_;
		result = _tmp10_;
		return result;
	}
	_tmp11_ = folks_individual_get_display_name (indiv);
	_tmp12_ = _tmp11_;
	result = _tmp12_;
	return result;
}

static void
contacts_contact_list_update_header (ContactsContactList* self,
                                     GtkListBoxRow* row,
                                     GtkListBoxRow* before)
{
	FolksIndividual* current = NULL;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* previous = NULL;
	FolksIndividual* _tmp9_;
	FolksIndividual* _tmp10_;
	gboolean _tmp11_ = FALSE;
	FolksIndividual* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = contacts_contact_list_contact_data_row_get_individual (G_TYPE_CHECK_INSTANCE_CAST (row, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow));
	_tmp1_ = _tmp0_;
	current = _tmp1_;
	if (before == NULL) {
		FolksIndividual* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = current;
		_tmp3_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			GtkLabel* _tmp5_;
			GtkLabel* _tmp6_;
			_tmp5_ = contacts_contact_list_create_header_label (self, _ ("Favorites"));
			_tmp6_ = _tmp5_;
			gtk_list_box_row_set_header (row, (GtkWidget*) _tmp6_);
			_g_object_unref0 (_tmp6_);
		} else {
			GtkLabel* _tmp7_;
			GtkLabel* _tmp8_;
			_tmp7_ = contacts_contact_list_create_header_label (self, _ ("All Contacts"));
			_tmp8_ = _tmp7_;
			gtk_list_box_row_set_header (row, (GtkWidget*) _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
		return;
	}
	_tmp9_ = contacts_contact_list_contact_data_row_get_individual (G_TYPE_CHECK_INSTANCE_CAST (before, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow));
	_tmp10_ = _tmp9_;
	previous = _tmp10_;
	_tmp12_ = current;
	_tmp13_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (!_tmp14_) {
		FolksIndividual* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = previous;
		_tmp16_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp11_ = _tmp17_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		_tmp18_ = contacts_contact_list_create_header_label (self, _ ("All Contacts"));
		_tmp19_ = _tmp18_;
		gtk_list_box_row_set_header (row, (GtkWidget*) _tmp19_);
		_g_object_unref0 (_tmp19_);
	} else {
		gtk_list_box_row_set_header (row, NULL);
	}
}

static GtkLabel*
contacts_contact_list_create_header_label (ContactsContactList* self,
                                           const gchar* text)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_widget_set_margin_start ((GtkWidget*) label, 6);
	gtk_widget_set_margin_end ((GtkWidget*) label, 3);
	gtk_widget_set_margin_top ((GtkWidget*) label, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) label, 3);
	gtk_widget_add_css_class ((GtkWidget*) label, "heading");
	gtk_widget_add_css_class ((GtkWidget*) label, "dim-label");
	result = label;
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ContactsContactList* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->row);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
___lambda8_ (Block13Data* _data13_)
{
	ContactsContactList* self;
	ContactsContactListContactDataRow* _tmp0_;
	self = _data13_->self;
	_tmp0_ = _data13_->row;
	contacts_contact_list_on_row_checkbox_toggled (self, _tmp0_);
}

static void
____lambda8__gtk_check_button_toggled (GtkCheckButton* _sender,
                                       gpointer self)
{
	___lambda8_ (self);
}

static void
contacts_contact_list_contact_added_cb (ContactsContactList* self,
                                        ContactsStore* store,
                                        FolksIndividual* i)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (i != NULL);
	if (!contacts_utils_is_ignorable (i)) {
		ContactsContactListContactDataRow* _tmp1_;
		_tmp1_ = contacts_contact_list_find_row_for_contact (self, i);
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Block13Data* _data13_;
		ContactsContactListContactDataRow* _tmp2_;
		ContactsContactListContactDataRow* _tmp3_;
		GtkCheckButton* _tmp4_;
		ContactsContactListContactDataRow* _tmp5_;
		GtkCheckButton* _tmp6_;
		ContactsUiState _tmp7_;
		GtkListBox* _tmp8_;
		ContactsContactListContactDataRow* _tmp9_;
		_data13_ = g_slice_new0 (Block13Data);
		_data13_->_ref_count_ = 1;
		_data13_->self = g_object_ref (self);
		_tmp2_ = contacts_contact_list_contact_data_row_new (i);
		g_object_ref_sink (_tmp2_);
		_data13_->row = _tmp2_;
		_tmp3_ = _data13_->row;
		_tmp4_ = _tmp3_->selector_button;
		g_signal_connect_data (_tmp4_, "toggled", (GCallback) ____lambda8__gtk_check_button_toggled, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
		_tmp5_ = _data13_->row;
		_tmp6_ = _tmp5_->selector_button;
		_tmp7_ = self->priv->_state;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp7_ == CONTACTS_UI_STATE_SELECTING);
		_tmp8_ = self->priv->listbox;
		_tmp9_ = _data13_->row;
		gtk_list_box_append (_tmp8_, (GtkWidget*) _tmp9_);
		block13_data_unref (_data13_);
		_data13_ = NULL;
	} else {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = folks_individual_get_id (i);
		_tmp11_ = _tmp10_;
		g_debug ("contacts-contact-list.vala:194: Contact %s was ignored", _tmp11_);
	}
}

static void
contacts_contact_list_on_row_checkbox_toggled (ContactsContactList* self,
                                               ContactsContactListContactDataRow* row)
{
	gint _tmp0_ = 0;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkCheckButton* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp1_ = row->selector_button;
	_tmp2_ = gtk_check_button_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = -1;
	}
	self->priv->nr_contacts_marked = self->priv->nr_contacts_marked + _tmp0_;
	_tmp5_ = row->selector_button;
	_tmp6_ = gtk_check_button_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp4_ = self->priv->nr_contacts_marked == 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		contacts_contact_list_set_state (self, CONTACTS_UI_STATE_SELECTING);
	}
	g_signal_emit (self, contacts_contact_list_signals[CONTACTS_CONTACT_LIST_CONTACTS_MARKED_SIGNAL], 0, self->priv->nr_contacts_marked);
}

static void
contacts_contact_list_contact_removed_cb (ContactsContactList* self,
                                          ContactsStore* store,
                                          FolksIndividual* i)
{
	ContactsContactListContactDataRow* row = NULL;
	ContactsContactListContactDataRow* _tmp0_;
	ContactsContactListContactDataRow* _tmp1_;
	ContactsContactListContactDataRow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = contacts_contact_list_find_row_for_contact (self, i);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	row = _tmp1_;
	_tmp2_ = row;
	if (_tmp2_ != NULL) {
		ContactsContactListContactDataRow* _tmp3_;
		_tmp3_ = row;
		g_signal_emit_by_name ((GtkWidget*) _tmp3_, "destroy");
	}
	_g_object_unref0 (row);
}

static void
contacts_contact_list_on_row_activated (ContactsContactList* self,
                                        GtkListBox* listbox,
                                        GtkListBoxRow* row)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	g_return_if_fail (row != NULL);
	if (!self->priv->got_long_press) {
		ContactsContactListContactDataRow* data = NULL;
		gboolean _tmp0_ = FALSE;
		ContactsContactListContactDataRow* _tmp1_;
		data = CONTACTS_CONTACT_LIST_IS_CONTACT_DATA_ROW (row) ? ((ContactsContactListContactDataRow*) row) : NULL;
		_tmp1_ = data;
		if (_tmp1_ != NULL) {
			ContactsUiState _tmp2_;
			_tmp2_ = self->priv->_state;
			_tmp0_ = _tmp2_ == CONTACTS_UI_STATE_SELECTING;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			ContactsContactListContactDataRow* _tmp3_;
			GtkCheckButton* _tmp4_;
			ContactsContactListContactDataRow* _tmp5_;
			GtkCheckButton* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = data;
			_tmp4_ = _tmp3_->selector_button;
			_tmp5_ = data;
			_tmp6_ = _tmp5_->selector_button;
			_tmp7_ = gtk_check_button_get_active (_tmp6_);
			_tmp8_ = _tmp7_;
			gtk_check_button_set_active (_tmp4_, !_tmp8_);
		}
	} else {
		self->priv->got_long_press = FALSE;
	}
}

static void
contacts_contact_list_on_row_selected (ContactsContactList* self,
                                       GtkListBox* listbox,
                                       GtkListBoxRow* row)
{
	ContactsUiState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (listbox != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != CONTACTS_UI_STATE_SELECTING) {
		ContactsContactListContactDataRow* data = NULL;
		FolksIndividual* _tmp1_ = NULL;
		ContactsContactListContactDataRow* _tmp2_;
		FolksIndividual* individual = NULL;
		FolksIndividual* _tmp6_;
		data = G_TYPE_CHECK_INSTANCE_CAST (row, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
		_tmp2_ = data;
		if (_tmp2_ != NULL) {
			ContactsContactListContactDataRow* _tmp3_;
			FolksIndividual* _tmp4_;
			FolksIndividual* _tmp5_;
			_tmp3_ = data;
			_tmp4_ = contacts_contact_list_contact_data_row_get_individual (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp1_ = _tmp5_;
		} else {
			_tmp1_ = NULL;
		}
		individual = _tmp1_;
		_tmp6_ = individual;
		g_signal_emit (self, contacts_contact_list_signals[CONTACTS_CONTACT_LIST_SELECTION_CHANGED_SIGNAL], 0, _tmp6_);
	}
}

static gboolean
contacts_contact_list_filter_row (ContactsContactList* self,
                                  GtkListBoxRow* row)
{
	FolksIndividual* individual = NULL;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksQuery* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = contacts_contact_list_contact_data_row_get_individual (G_TYPE_CHECK_INSTANCE_CAST (row, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow));
	_tmp1_ = _tmp0_;
	individual = _tmp1_;
	_tmp2_ = self->priv->filter_query;
	result = folks_query_is_match (_tmp2_, individual) > ((guint) 0);
	return result;
}

void
contacts_contact_list_select_contact (ContactsContactList* self,
                                      FolksIndividual* individual)
{
	ContactsContactListContactDataRow* row = NULL;
	ContactsContactListContactDataRow* _tmp1_;
	GtkListBox* _tmp2_;
	ContactsContactListContactDataRow* _tmp3_;
	ContactsContactListContactDataRow* _tmp4_;
	g_return_if_fail (self != NULL);
	if (individual == NULL) {
		GtkListBox* _tmp0_;
		_tmp0_ = self->priv->listbox;
		gtk_list_box_select_row (_tmp0_, NULL);
		return;
	}
	_tmp1_ = contacts_contact_list_find_row_for_contact (self, individual);
	row = _tmp1_;
	_tmp2_ = self->priv->listbox;
	_tmp3_ = row;
	gtk_list_box_select_row (_tmp2_, (GtkListBoxRow*) _tmp3_);
	_tmp4_ = row;
	contacts_contact_list_scroll_to_contact (self, (GtkListBoxRow*) _tmp4_);
}

static void
contacts_contact_list_load_visible_avatars (ContactsContactList* self)
{
	g_return_if_fail (self != NULL);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ContactsContactList* self;
		self = _data14_->self;
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static gboolean
__lambda9_ (Block14Data* _data14_)
{
	ContactsContactList* self;
	ContactsContactListContactDataRow* _tmp0_;
	gboolean result;
	self = _data14_->self;
	_tmp0_ = _data14_->selected_row;
	if (_tmp0_ != NULL) {
		ContactsContactListContactDataRow* _tmp1_;
		_tmp1_ = _data14_->selected_row;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ (self);
	return result;
}

void
contacts_contact_list_scroll_to_contact (ContactsContactList* self,
                                         GtkListBoxRow* row)
{
	Block14Data* _data14_;
	g_return_if_fail (self != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_data14_->selected_row = NULL;
	if (row == NULL) {
		GtkListBox* _tmp0_;
		GtkListBoxRow* _tmp1_;
		_tmp0_ = self->priv->listbox;
		_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
		_data14_->selected_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	} else {
		_data14_->selected_row = G_TYPE_CHECK_INSTANCE_CAST (row, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda9__gsource_func, block14_data_ref (_data14_), block14_data_unref);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}

void
contacts_contact_list_set_contact_visible (ContactsContactList* self,
                                           FolksIndividual* individual,
                                           gboolean visible)
{
	g_return_if_fail (self != NULL);
	if (individual != NULL) {
		ContactsContactListContactDataRow* _tmp0_;
		_tmp0_ = contacts_contact_list_find_row_for_contact (self, individual);
		gtk_widget_set_visible ((GtkWidget*) _tmp0_, visible);
	}
}

static ContactsContactListContactDataRow*
contacts_contact_list_find_row_for_contact (ContactsContactList* self,
                                            FolksIndividual* individual)
{
	ContactsContactListContactDataRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (individual != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ContactsContactListContactDataRow* row = NULL;
				GtkListBox* _tmp2_;
				GtkListBoxRow* _tmp3_;
				ContactsContactListContactDataRow* _tmp4_;
				ContactsContactListContactDataRow* _tmp5_;
				FolksIndividual* _tmp6_;
				FolksIndividual* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->listbox;
				_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, i);
				row = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
				_tmp4_ = row;
				if (_tmp4_ == NULL) {
					break;
				}
				_tmp5_ = row;
				_tmp6_ = contacts_contact_list_contact_data_row_get_individual (_tmp5_);
				_tmp7_ = _tmp6_;
				if (_tmp7_ == individual) {
					ContactsContactListContactDataRow* _tmp8_;
					_tmp8_ = row;
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

GeeLinkedList*
contacts_contact_list_get_marked_contacts (ContactsContactList* self)
{
	GeeLinkedList* cs = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	cs = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ContactsContactListContactDataRow* row = NULL;
				GtkListBox* _tmp3_;
				GtkListBoxRow* _tmp4_;
				ContactsContactListContactDataRow* _tmp5_;
				ContactsContactListContactDataRow* _tmp6_;
				GtkCheckButton* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->listbox;
				_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, i);
				row = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
				_tmp5_ = row;
				if (_tmp5_ == NULL) {
					break;
				}
				_tmp6_ = row;
				_tmp7_ = _tmp6_->selector_button;
				_tmp8_ = gtk_check_button_get_active (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					GeeLinkedList* _tmp10_;
					ContactsContactListContactDataRow* _tmp11_;
					FolksIndividual* _tmp12_;
					FolksIndividual* _tmp13_;
					_tmp10_ = cs;
					_tmp11_ = row;
					_tmp12_ = contacts_contact_list_contact_data_row_get_individual (_tmp11_);
					_tmp13_ = _tmp12_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp13_);
				}
			}
		}
	}
	result = cs;
	return result;
}

GeeLinkedList*
contacts_contact_list_get_marked_contacts_and_hide (ContactsContactList* self)
{
	GeeLinkedList* cs = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (FOLKS_TYPE_INDIVIDUAL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	cs = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ContactsContactListContactDataRow* row = NULL;
				GtkListBox* _tmp3_;
				GtkListBoxRow* _tmp4_;
				ContactsContactListContactDataRow* _tmp5_;
				ContactsContactListContactDataRow* _tmp6_;
				GtkCheckButton* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->listbox;
				_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, i);
				row = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
				_tmp5_ = row;
				if (_tmp5_ == NULL) {
					break;
				}
				_tmp6_ = row;
				_tmp7_ = _tmp6_->selector_button;
				_tmp8_ = gtk_check_button_get_active (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					ContactsContactListContactDataRow* _tmp10_;
					GeeLinkedList* _tmp11_;
					ContactsContactListContactDataRow* _tmp12_;
					FolksIndividual* _tmp13_;
					FolksIndividual* _tmp14_;
					_tmp10_ = row;
					gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
					_tmp11_ = cs;
					_tmp12_ = row;
					_tmp13_ = contacts_contact_list_contact_data_row_get_individual (_tmp12_);
					_tmp14_ = _tmp13_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
				}
			}
		}
	}
	result = cs;
	return result;
}

static void
contacts_contact_list_on_right_click (ContactsContactList* self,
                                      GtkGestureClick* gesture,
                                      gint n_press,
                                      gdouble x,
                                      gdouble y)
{
	ContactsContactListContactDataRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	ContactsContactListContactDataRow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, (gint) round (y));
	row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	_tmp2_ = row;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ContactsUiState _tmp4_;
		ContactsContactListContactDataRow* _tmp9_;
		GtkCheckButton* _tmp10_;
		_tmp4_ = self->priv->_state;
		if (_tmp4_ != CONTACTS_UI_STATE_SELECTING) {
			_tmp3_ = TRUE;
		} else {
			ContactsContactListContactDataRow* _tmp5_;
			GtkCheckButton* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp5_ = row;
			_tmp6_ = _tmp5_->selector_button;
			_tmp7_ = gtk_check_button_get_active (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp3_ = !_tmp8_;
		}
		_tmp9_ = row;
		_tmp10_ = _tmp9_->selector_button;
		gtk_check_button_set_active (_tmp10_, _tmp3_);
	}
}

static void
contacts_contact_list_on_long_press (ContactsContactList* self,
                                     GtkGestureLongPress* gesture,
                                     gdouble x,
                                     gdouble y)
{
	ContactsContactListContactDataRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	ContactsContactListContactDataRow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	self->priv->got_long_press = TRUE;
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, (gint) round (y));
	row = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	_tmp2_ = row;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ContactsUiState _tmp4_;
		ContactsContactListContactDataRow* _tmp9_;
		GtkCheckButton* _tmp10_;
		_tmp4_ = self->priv->_state;
		if (_tmp4_ != CONTACTS_UI_STATE_SELECTING) {
			_tmp3_ = TRUE;
		} else {
			ContactsContactListContactDataRow* _tmp5_;
			GtkCheckButton* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp5_ = row;
			_tmp6_ = _tmp5_->selector_button;
			_tmp7_ = gtk_check_button_get_active (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp3_ = !_tmp8_;
		}
		_tmp9_ = row;
		_tmp10_ = _tmp9_->selector_button;
		gtk_check_button_set_active (_tmp10_, _tmp3_);
	}
}

ContactsUiState
contacts_contact_list_get_state (ContactsContactList* self)
{
	ContactsUiState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
contacts_contact_list_set_state (ContactsContactList* self,
                                 ContactsUiState value)
{
	ContactsUiState old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STATE_PROPERTY]);
	}
}

static inline gpointer
contacts_contact_list_contact_data_row_get_instance_private (ContactsContactListContactDataRow* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsContactListContactDataRow_private_offset);
}

static void
_contacts_contact_list_contact_data_row_on_contact_changed_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self)
{
	contacts_contact_list_contact_data_row_on_contact_changed ((ContactsContactListContactDataRow*) self, _sender, pspec);
}

static ContactsContactListContactDataRow*
contacts_contact_list_contact_data_row_construct (GType object_type,
                                                  FolksIndividual* i)
{
	ContactsContactListContactDataRow * self = NULL;
	FolksIndividual* _tmp0_;
	GtkBox* box = NULL;
	GtkBox* _tmp1_;
	ContactsAvatar* avatar = NULL;
	FolksIndividual* _tmp2_;
	ContactsAvatar* _tmp3_;
	GtkLabel* label = NULL;
	FolksIndividual* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GtkLabel* _tmp7_;
	GtkCheckButton* selector_button = NULL;
	GtkCheckButton* _tmp8_;
	g_return_val_if_fail (i != NULL, NULL);
	self = (ContactsContactListContactDataRow*) g_object_new (object_type, "individual", i, NULL);
	_tmp0_ = self->priv->_individual;
	g_signal_connect_object ((GObject*) _tmp0_, "notify", (GCallback) _contacts_contact_list_contact_data_row_on_contact_changed_g_object_notify, self, 0);
	gtk_widget_add_css_class ((GtkWidget*) self, "contact-data-row");
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp1_);
	box = _tmp1_;
	gtk_widget_set_margin_top ((GtkWidget*) box, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) box, 6);
	_tmp2_ = self->priv->_individual;
	_tmp3_ = contacts_avatar_new (CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_LIST_AVATAR_SIZE, _tmp2_);
	g_object_ref_sink (_tmp3_);
	avatar = _tmp3_;
	gtk_box_append (box, (GtkWidget*) avatar);
	self->priv->avatar = avatar;
	_tmp4_ = self->priv->_individual;
	_tmp5_ = folks_individual_get_display_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	gtk_label_set_ellipsize (label, PANGO_ELLIPSIZE_END);
	gtk_widget_set_valign ((GtkWidget*) label, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_label_set_xalign (label, (gfloat) 0);
	gtk_box_append (box, (GtkWidget*) label);
	self->priv->label = label;
	_tmp8_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp8_);
	selector_button = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) selector_button, FALSE);
	gtk_widget_set_valign ((GtkWidget*) selector_button, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) selector_button, GTK_ALIGN_END);
	gtk_widget_set_hexpand ((GtkWidget*) selector_button, TRUE);
	gtk_widget_add_css_class ((GtkWidget*) selector_button, "selection-mode");
	gtk_widget_set_margin_end ((GtkWidget*) selector_button, 12);
	gtk_box_append (box, (GtkWidget*) selector_button);
	self->selector_button = selector_button;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) box);
	_g_object_unref0 (selector_button);
	_g_object_unref0 (label);
	_g_object_unref0 (avatar);
	_g_object_unref0 (box);
	return self;
}

static ContactsContactListContactDataRow*
contacts_contact_list_contact_data_row_new (FolksIndividual* i)
{
	return contacts_contact_list_contact_data_row_construct (CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, i);
}

static void
contacts_contact_list_contact_data_row_on_contact_changed (ContactsContactListContactDataRow* self,
                                                           GObject* obj,
                                                           GParamSpec* pspec)
{
	const gchar* _tmp0_;
	GtkLabel* _tmp2_;
	FolksIndividual* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = g_param_spec_get_name (pspec);
	if (g_strcmp0 (_tmp0_, "avatar") == 0) {
		ContactsAvatar* _tmp1_;
		_tmp1_ = self->priv->avatar;
		contacts_avatar_reload (_tmp1_, NULL, NULL);
	}
	_tmp2_ = self->priv->label;
	_tmp3_ = self->priv->_individual;
	_tmp4_ = folks_individual_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_text (_tmp2_, _tmp5_);
	gtk_list_box_row_changed ((GtkListBoxRow*) self);
}

static FolksIndividual*
contacts_contact_list_contact_data_row_get_individual (ContactsContactListContactDataRow* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individual;
	result = _tmp0_;
	return result;
}

static void
contacts_contact_list_contact_data_row_set_individual (ContactsContactListContactDataRow* self,
                                                       FolksIndividual* value)
{
	FolksIndividual* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_contact_list_contact_data_row_get_individual (self);
	if (old_value != value) {
		FolksIndividual* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_individual);
		self->priv->_individual = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY]);
	}
}

static void
contacts_contact_list_contact_data_row_class_init (ContactsContactListContactDataRowClass * klass,
                                                   gpointer klass_data)
{
	contacts_contact_list_contact_data_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactListContactDataRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_list_contact_data_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_list_contact_data_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_list_contact_data_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY, contacts_contact_list_contact_data_row_properties[CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
contacts_contact_list_contact_data_row_instance_init (ContactsContactListContactDataRow * self,
                                                      gpointer klass)
{
	self->priv = contacts_contact_list_contact_data_row_get_instance_private (self);
}

static void
contacts_contact_list_contact_data_row_finalize (GObject * obj)
{
	ContactsContactListContactDataRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	_g_object_unref0 (self->priv->_individual);
	G_OBJECT_CLASS (contacts_contact_list_contact_data_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_contact_list_contact_data_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactListContactDataRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_list_contact_data_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactListContactDataRow), 0, (GInstanceInitFunc) contacts_contact_list_contact_data_row_instance_init, NULL };
	GType contacts_contact_list_contact_data_row_type_id;
	contacts_contact_list_contact_data_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ContactsContactListContactDataRow", &g_define_type_info, 0);
	ContactsContactListContactDataRow_private_offset = g_type_add_instance_private (contacts_contact_list_contact_data_row_type_id, sizeof (ContactsContactListContactDataRowPrivate));
	return contacts_contact_list_contact_data_row_type_id;
}

static GType
contacts_contact_list_contact_data_row_get_type (void)
{
	static volatile gsize contacts_contact_list_contact_data_row_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_list_contact_data_row_type_id__once)) {
		GType contacts_contact_list_contact_data_row_type_id;
		contacts_contact_list_contact_data_row_type_id = contacts_contact_list_contact_data_row_get_type_once ();
		g_once_init_leave (&contacts_contact_list_contact_data_row_type_id__once, contacts_contact_list_contact_data_row_type_id);
	}
	return contacts_contact_list_contact_data_row_type_id__once;
}

static void
_vala_contacts_contact_list_contact_data_row_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	ContactsContactListContactDataRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, contacts_contact_list_contact_data_row_get_individual (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_list_contact_data_row_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	ContactsContactListContactDataRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_CONTACT_LIST_TYPE_CONTACT_DATA_ROW, ContactsContactListContactDataRow);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_CONTACT_DATA_ROW_INDIVIDUAL_PROPERTY:
		contacts_contact_list_contact_data_row_set_individual (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_contacts_contact_list___lambda10_ (ContactsContactList* self,
                                    GtkAdjustment* vadj)
{
	g_return_if_fail (vadj != NULL);
	contacts_contact_list_load_visible_avatars (self);
}

static void
__contacts_contact_list___lambda10__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                                  gpointer self)
{
	_contacts_contact_list___lambda10_ ((ContactsContactList*) self, _sender);
}

static gint
_contacts_contact_list_compare_rows_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                            GtkListBoxRow* row2,
                                                            gpointer self)
{
	gint result;
	result = contacts_contact_list_compare_rows ((ContactsContactList*) self, row1, row2);
	return result;
}

static gboolean
_contacts_contact_list_filter_row_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                            gpointer self)
{
	gboolean result;
	result = contacts_contact_list_filter_row ((ContactsContactList*) self, row);
	return result;
}

static void
_contacts_contact_list_update_header_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                      GtkListBoxRow* before,
                                                                      gpointer self)
{
	contacts_contact_list_update_header ((ContactsContactList*) self, row, before);
}

static void
_contacts_contact_list_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self)
{
	contacts_contact_list_on_row_activated ((ContactsContactList*) self, _sender, row);
}

static void
_contacts_contact_list_on_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self)
{
	contacts_contact_list_on_row_selected ((ContactsContactList*) self, _sender, row);
}

static void
_contacts_contact_list_on_right_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                 gint n_press,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self)
{
	contacts_contact_list_on_right_click ((ContactsContactList*) self, _sender, n_press, x, y);
}

static void
_contacts_contact_list_on_long_press_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                     gdouble x,
                                                                     gdouble y,
                                                                     gpointer self)
{
	contacts_contact_list_on_long_press ((ContactsContactList*) self, _sender, x, y);
}

static GObject *
contacts_contact_list_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsContactList * self;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkViewport* viewport = NULL;
	GtkScrolledWindow* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkScrolledWindow* _tmp13_;
	GtkAdjustment* _tmp14_;
	GtkAdjustment* _tmp15_;
	GtkViewport* _tmp16_;
	GtkViewport* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GtkViewport* _tmp19_;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp20_;
	GtkListBox* _tmp21_;
	GtkViewport* _tmp22_;
	GtkListBox* _tmp23_;
	GtkListBox* _tmp24_;
	GtkListBox* _tmp25_;
	GtkListBox* _tmp26_;
	GtkListBox* _tmp27_;
	GtkListBox* _tmp28_;
	GtkListBox* _tmp29_;
	GtkListBox* _tmp30_;
	GtkGestureClick* secondary_click_gesture = NULL;
	GtkGestureClick* _tmp31_;
	GtkGestureClick* _tmp32_;
	GtkGestureClick* _tmp33_;
	GtkListBox* _tmp34_;
	GtkGestureClick* _tmp35_;
	GtkEventController* _tmp36_;
	GtkGestureLongPress* long_press_gesture = NULL;
	GtkGestureLongPress* _tmp37_;
	GtkGestureLongPress* _tmp38_;
	GtkListBox* _tmp39_;
	GtkGestureLongPress* _tmp40_;
	GtkEventController* _tmp41_;
	parent_class = G_OBJECT_CLASS (contacts_contact_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_ref_sink (_tmp0_);
	sw = _tmp0_;
	_tmp1_ = sw;
	g_object_set (_tmp1_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp2_ = sw;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "contact-list-scrolled-window");
	_tmp3_ = sw;
	_tmp4_ = gtk_scrolled_window_get_vadjustment (_tmp3_);
	_tmp5_ = _tmp4_;
	self->priv->vadjustment = _tmp5_;
	_tmp6_ = sw;
	_tmp7_ = gtk_scrolled_window_get_vadjustment (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "value-changed", (GCallback) __contacts_contact_list___lambda10__gtk_adjustment_value_changed, self, 0);
	_tmp9_ = sw;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp9_);
	_tmp10_ = sw;
	_tmp11_ = gtk_scrolled_window_get_hadjustment (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = sw;
	_tmp14_ = gtk_scrolled_window_get_vadjustment (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = (GtkViewport*) gtk_viewport_new (_tmp12_, _tmp15_);
	g_object_ref_sink (_tmp16_);
	viewport = _tmp16_;
	_tmp17_ = viewport;
	gtk_viewport_set_scroll_to_focus (_tmp17_, TRUE);
	_tmp18_ = sw;
	_tmp19_ = viewport;
	gtk_scrolled_window_set_child (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp20_);
	list_box = _tmp20_;
	_tmp21_ = list_box;
	self->priv->listbox = _tmp21_;
	_tmp22_ = viewport;
	_tmp23_ = list_box;
	gtk_viewport_set_child (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->listbox;
	gtk_list_box_set_selection_mode (_tmp24_, GTK_SELECTION_BROWSE);
	_tmp25_ = self->priv->listbox;
	gtk_list_box_set_sort_func (_tmp25_, _contacts_contact_list_compare_rows_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp26_ = self->priv->listbox;
	gtk_list_box_set_filter_func (_tmp26_, _contacts_contact_list_filter_row_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp27_ = self->priv->listbox;
	gtk_list_box_set_header_func (_tmp27_, _contacts_contact_list_update_header_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp28_ = self->priv->listbox;
	gtk_widget_add_css_class ((GtkWidget*) _tmp28_, "navigation-sidebar");
	gtk_widget_add_css_class ((GtkWidget*) self, "contacts-contact-list");
	_tmp29_ = self->priv->listbox;
	g_signal_connect_object (_tmp29_, "row-activated", (GCallback) _contacts_contact_list_on_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp30_ = self->priv->listbox;
	g_signal_connect_object (_tmp30_, "row-selected", (GCallback) _contacts_contact_list_on_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp31_ = (GtkGestureClick*) gtk_gesture_click_new ();
	secondary_click_gesture = _tmp31_;
	_tmp32_ = secondary_click_gesture;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp32_, (guint) GDK_BUTTON_SECONDARY);
	_tmp33_ = secondary_click_gesture;
	g_signal_connect_object (_tmp33_, "pressed", (GCallback) _contacts_contact_list_on_right_click_gtk_gesture_click_pressed, self, 0);
	_tmp34_ = self->priv->listbox;
	_tmp35_ = secondary_click_gesture;
	_tmp36_ = _g_object_ref0 ((GtkEventController*) _tmp35_);
	gtk_widget_add_controller ((GtkWidget*) _tmp34_, _tmp36_);
	_tmp37_ = (GtkGestureLongPress*) gtk_gesture_long_press_new ();
	long_press_gesture = _tmp37_;
	_tmp38_ = long_press_gesture;
	g_signal_connect_object (_tmp38_, "pressed", (GCallback) _contacts_contact_list_on_long_press_gtk_gesture_long_press_pressed, self, 0);
	_tmp39_ = self->priv->listbox;
	_tmp40_ = long_press_gesture;
	_tmp41_ = _g_object_ref0 ((GtkEventController*) _tmp40_);
	gtk_widget_add_controller ((GtkWidget*) _tmp39_, _tmp41_);
	_g_object_unref0 (long_press_gesture);
	_g_object_unref0 (secondary_click_gesture);
	_g_object_unref0 (list_box);
	_g_object_unref0 (viewport);
	_g_object_unref0 (sw);
	return obj;
}

static void
contacts_contact_list_class_init (ContactsContactListClass * klass,
                                  gpointer klass_data)
{
	contacts_contact_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsContactList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_contact_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_contact_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_LIST_STATE_PROPERTY, contacts_contact_list_properties[CONTACTS_CONTACT_LIST_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", CONTACTS_TYPE_UI_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	contacts_contact_list_signals[CONTACTS_CONTACT_LIST_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", CONTACTS_TYPE_CONTACT_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FOLKS_TYPE_INDIVIDUAL);
	contacts_contact_list_signals[CONTACTS_CONTACT_LIST_CONTACTS_MARKED_SIGNAL] = g_signal_new ("contacts-marked", CONTACTS_TYPE_CONTACT_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
contacts_contact_list_instance_init (ContactsContactList * self,
                                     gpointer klass)
{
	self->priv = contacts_contact_list_get_instance_private (self);
	self->priv->nr_contacts_marked = 0;
	self->priv->sort_on_surname = FALSE;
	self->priv->got_long_press = FALSE;
}

static void
contacts_contact_list_finalize (GObject * obj)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	_g_object_unref0 (self->priv->filter_query);
	_g_object_unref0 (self->priv->store);
	G_OBJECT_CLASS (contacts_contact_list_parent_class)->finalize (obj);
}

/**
 * The ContactList is the actual list of {@link Individual}s that the user sees on
 * the left. It is contained by the {@link ListPane}, which also provides other
 * functionality, such as an action bar.
 */
 G_GNUC_NO_INLINE static GType
contacts_contact_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsContactListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContactList), 0, (GInstanceInitFunc) contacts_contact_list_instance_init, NULL };
	GType contacts_contact_list_type_id;
	contacts_contact_list_type_id = g_type_register_static (adw_bin_get_type (), "ContactsContactList", &g_define_type_info, 0);
	ContactsContactList_private_offset = g_type_add_instance_private (contacts_contact_list_type_id, sizeof (ContactsContactListPrivate));
	return contacts_contact_list_type_id;
}

GType
contacts_contact_list_get_type (void)
{
	static volatile gsize contacts_contact_list_type_id__once = 0;
	if (g_once_init_enter (&contacts_contact_list_type_id__once)) {
		GType contacts_contact_list_type_id;
		contacts_contact_list_type_id = contacts_contact_list_get_type_once ();
		g_once_init_leave (&contacts_contact_list_type_id__once, contacts_contact_list_type_id);
	}
	return contacts_contact_list_type_id__once;
}

static void
_vala_contacts_contact_list_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_STATE_PROPERTY:
		g_value_set_enum (value, contacts_contact_list_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_contact_list_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ContactsContactList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT_LIST, ContactsContactList);
	switch (property_id) {
		case CONTACTS_CONTACT_LIST_STATE_PROPERTY:
		contacts_contact_list_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

