/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.ResourceBundleELResolver;
import javax.el.StaticFieldELResolver;
import javax.servlet.jsp.el.ImplicitObjectELResolver;
import javax.servlet.jsp.el.ScopedAttributeELResolver;

public class JasperELResolver
extends CompositeELResolver {
    private static final int STANDARD_RESOLVERS_COUNT = 9;
    private AtomicInteger resolversSize = new AtomicInteger(0);
    private volatile ELResolver[] resolvers;
    private final int appResolversSize;

    public JasperELResolver(List<ELResolver> list, ELResolver eLResolver) {
        this.appResolversSize = list.size();
        this.resolvers = new ELResolver[this.appResolversSize + 9];
        this.add((ELResolver)new ImplicitObjectELResolver());
        for (ELResolver eLResolver2 : list) {
            this.add(eLResolver2);
        }
        this.add(eLResolver);
        this.add((ELResolver)new StaticFieldELResolver());
        this.add((ELResolver)new MapELResolver());
        this.add((ELResolver)new ResourceBundleELResolver());
        this.add((ELResolver)new ListELResolver());
        this.add((ELResolver)new ArrayELResolver());
        this.add((ELResolver)new BeanELResolver());
        this.add((ELResolver)new ScopedAttributeELResolver());
    }

    public synchronized void add(ELResolver eLResolver) {
        super.add(eLResolver);
        int n = this.resolversSize.get();
        if (this.resolvers.length > n) {
            this.resolvers[n] = eLResolver;
        } else {
            ELResolver[] eLResolverArray = new ELResolver[n + 1];
            System.arraycopy(this.resolvers, 0, eLResolverArray, 0, n);
            eLResolverArray[n] = eLResolver;
            this.resolvers = eLResolverArray;
        }
        this.resolversSize.incrementAndGet();
    }

    public Object getValue(ELContext eLContext, Object object, Object object2) throws NullPointerException, PropertyNotFoundException, ELException {
        int n;
        int n2;
        int n3;
        eLContext.setPropertyResolved(false);
        Object object3 = null;
        if (object == null) {
            n3 = 1 + this.appResolversSize;
            for (n2 = 0; n2 < n3; ++n2) {
                object3 = this.resolvers[n2].getValue(eLContext, object, object2);
                if (!eLContext.isPropertyResolved()) continue;
                return object3;
            }
            n = n3 + 7;
        } else {
            n = 1;
        }
        n3 = this.resolversSize.get();
        for (n2 = n; n2 < n3; ++n2) {
            object3 = this.resolvers[n2].getValue(eLContext, object, object2);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    public Object invoke(ELContext eLContext, Object object, Object object2, Class<?>[] classArray, Object[] objectArray) {
        int n;
        String string = JasperELResolver.coerceToString(object2);
        if (string.length() == 0) {
            throw new ELException((Throwable)new NoSuchMethodException());
        }
        eLContext.setPropertyResolved(false);
        Object object3 = null;
        int n2 = 1 + this.appResolversSize + 2;
        for (n = 1; n < n2; ++n) {
            object3 = this.resolvers[n].invoke(eLContext, object, (Object)string, (Class[])classArray, objectArray);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        n = this.resolversSize.get();
        for (int i = n2 += 4; i < n; ++i) {
            object3 = this.resolvers[i].invoke(eLContext, object, (Object)string, (Class[])classArray, objectArray);
            if (!eLContext.isPropertyResolved()) continue;
            return object3;
        }
        return null;
    }

    private static final String coerceToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        return object.toString();
    }
}

