"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toBase64 = exports.fromBase64 = exports.decodeHTMLEntities = void 0;
var base_64_1 = require("base-64");
function decodeHTMLEntities(text) {
    if (typeof WEB === "undefined") {
        // Node
        var he = require("he");
        return he.decode(text);
    }
    else {
        // Nasty browser way
        var txt = document.createElement("textarea");
        txt.innerHTML = text;
        return txt.value;
    }
}
exports.decodeHTMLEntities = decodeHTMLEntities;
function fromBase64(text) {
    return (0, base_64_1.decode)(text);
}
exports.fromBase64 = fromBase64;
function toBase64(text) {
    return (0, base_64_1.encode)(text);
}
exports.toBase64 = toBase64;
