/* special-folders.c generated by valac 0.56.3, the Vala compiler
 * generated from special-folders.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "special-folders.h"
#include <glib-object.h>
#include <glib.h>
#include <libpeas/peas.h>
#include "geary-client-43.0.h"
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "geary-engine.h"
#include <glib/gi18n-lib.h>

#define PLUGIN_SPECIAL_FOLDERS_ACTION_EDIT "edit-draft"
#define PLUGIN_SPECIAL_FOLDERS_ACTION_EMPTY "empty-folder"
#define PLUGIN_SPECIAL_FOLDERS_PRIORITY 0

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PLUGIN_SPECIAL_FOLDERS_0_PROPERTY,
	PLUGIN_SPECIAL_FOLDERS_FOLDERS_PROPERTY,
	PLUGIN_SPECIAL_FOLDERS_EMAIL_PROPERTY,
	PLUGIN_SPECIAL_FOLDERS_NUM_PROPERTIES
};
static GParamSpec* plugin_special_folders_properties[PLUGIN_SPECIAL_FOLDERS_NUM_PROPERTIES];
typedef struct _PluginSpecialFoldersActivateData PluginSpecialFoldersActivateData;
typedef struct _PluginSpecialFoldersDeactivateData PluginSpecialFoldersDeactivateData;
typedef struct _PluginSpecialFoldersUpdateEmailData PluginSpecialFoldersUpdateEmailData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PluginSpecialFoldersEditDraftData PluginSpecialFoldersEditDraftData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _PluginSpecialFoldersPrivate {
	PluginFolderContext* _folders;
	PluginEmailContext* _email;
	PluginEmailStore* email_store;
	PluginFolderStore* folder_store;
	GeeMap* info_bars;
	GSimpleAction* edit_action;
	GSimpleAction* empty_action;
	GCancellable* cancellable;
};

struct _PluginSpecialFoldersActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginSpecialFolders* self;
	gboolean is_startup;
	PluginEmailStore* _tmp0_;
	PluginEmailContext* _tmp1_;
	PluginEmailContext* _tmp2_;
	PluginEmailStore* _tmp3_;
	PluginEmailStore* _tmp4_;
	PluginEmailStore* _tmp5_;
	PluginFolderStore* _tmp6_;
	PluginFolderContext* _tmp7_;
	PluginFolderContext* _tmp8_;
	PluginFolderStore* _tmp9_;
	PluginFolderStore* _tmp10_;
	PluginFolderStore* _tmp11_;
	PluginFolderStore* _tmp12_;
	PluginEmailStore* _tmp13_;
	const GVariantType* _tmp14_;
	const GVariantType* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	PluginApplication* _tmp18_;
	PluginApplication* _tmp19_;
	GSimpleAction* _tmp20_;
	PluginFolderStore* _tmp21_;
	const GVariantType* _tmp22_;
	const GVariantType* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	PluginApplication* _tmp26_;
	PluginApplication* _tmp27_;
	GSimpleAction* _tmp28_;
	GError* _inner_error0_;
};

struct _PluginSpecialFoldersDeactivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginSpecialFolders* self;
	gboolean is_shutdown;
	PluginApplication* _tmp0_;
	PluginApplication* _tmp1_;
	GSimpleAction* _tmp2_;
	PluginApplication* _tmp3_;
	PluginApplication* _tmp4_;
	GSimpleAction* _tmp5_;
	PluginEmailStore* _tmp6_;
	guint _tmp7_;
	PluginFolderStore* _tmp8_;
	guint _tmp9_;
	PluginFolderStore* _tmp10_;
	guint _tmp11_;
	GCancellable* _tmp12_;
};

struct _PluginSpecialFoldersUpdateEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginSpecialFolders* self;
	PluginEmail* target;
	gboolean is_draft;
	GearyEmailFlags* _tmp0_;
	GearyEmailFlags* _tmp1_;
	PluginFolderStore* _tmp2_;
	GeeCollection* folders;
	PluginFolderStore* _tmp3_;
	PluginEmailIdentifier* _tmp4_;
	PluginEmailIdentifier* _tmp5_;
	GCancellable* _tmp6_;
	GeeCollection* _tmp7_;
	GeeIterator* _folder_it;
	GeeCollection* _tmp8_;
	GeeIterator* _tmp9_;
	GeeIterator* _tmp10_;
	PluginFolder* folder;
	GeeIterator* _tmp11_;
	gpointer _tmp12_;
	PluginFolder* _tmp13_;
	GearyFolderSpecialUse _tmp14_;
	GearyFolderSpecialUse _tmp15_;
	PluginEmailContext* _tmp16_;
	PluginEmailContext* _tmp17_;
	PluginEmailIdentifier* _tmp18_;
	PluginEmailIdentifier* _tmp19_;
	PluginInfoBar* _tmp20_;
	PluginInfoBar* _tmp21_;
	GearyEmailFlags* _tmp22_;
	GearyEmailFlags* _tmp23_;
	PluginEmailContext* _tmp24_;
	PluginEmailContext* _tmp25_;
	PluginEmailIdentifier* _tmp26_;
	PluginEmailIdentifier* _tmp27_;
	PluginInfoBar* _tmp28_;
	PluginInfoBar* _tmp29_;
	GError* _inner_error0_;
};

struct _PluginSpecialFoldersEditDraftData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginSpecialFolders* self;
	PluginEmailIdentifier* id;
	PluginComposer* composer;
	PluginApplication* _tmp0_;
	PluginApplication* _tmp1_;
	PluginAccount* _tmp2_;
	PluginAccount* _tmp3_;
	PluginComposer* _tmp4_;
	GError* err;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

static gint PluginSpecialFolders_private_offset;
static gpointer plugin_special_folders_parent_class = NULL;
static PluginFolderExtensionIface * plugin_special_folders_plugin_folder_extension_parent_iface = NULL;
static PluginEmailExtensionIface * plugin_special_folders_plugin_email_extension_parent_iface = NULL;
static GType plugin_special_folders_type_id = 0;

static void plugin_special_folders_real_activate_data_free (gpointer _data);
static void plugin_special_folders_real_activate (PluginPluginBase* base,
                                           gboolean is_startup,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean plugin_special_folders_real_activate_co (PluginSpecialFoldersActivateData* _data_);
static void plugin_special_folders_activate_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void plugin_special_folders_on_email_displayed (PluginSpecialFolders* self,
                                                PluginEmail* email);
static void _plugin_special_folders_on_email_displayed_plugin_email_store_email_displayed (PluginEmailStore* _sender,
                                                                                    PluginEmail* sent,
                                                                                    gpointer self);
static void plugin_special_folders_on_folder_selected (PluginSpecialFolders* self,
                                                PluginFolder* selected);
static void _plugin_special_folders_on_folder_selected_plugin_folder_store_folder_selected (PluginFolderStore* _sender,
                                                                                     PluginFolder* selected,
                                                                                     gpointer self);
static void plugin_special_folders_on_folders_type_changed (PluginSpecialFolders* self,
                                                     GeeCollection* changed);
static void _plugin_special_folders_on_folders_type_changed_plugin_folder_store_folders_type_changed (PluginFolderStore* _sender,
                                                                                               GeeCollection* changed,
                                                                                               gpointer self);
static void plugin_special_folders_on_edit_activated (PluginSpecialFolders* self,
                                               GAction* action,
                                               GVariant* target);
static void _plugin_special_folders_on_edit_activated_g_simple_action_activate (GSimpleAction* _sender,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void plugin_special_folders_on_empty_activated (PluginSpecialFolders* self,
                                                GAction* action,
                                                GVariant* target);
static void _plugin_special_folders_on_empty_activated_g_simple_action_activate (GSimpleAction* _sender,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void plugin_special_folders_real_deactivate_data_free (gpointer _data);
static void plugin_special_folders_real_deactivate (PluginPluginBase* base,
                                             gboolean is_shutdown,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean plugin_special_folders_real_deactivate_co (PluginSpecialFoldersDeactivateData* _data_);
static void plugin_special_folders_update_folder (PluginSpecialFolders* self,
                                           PluginFolder* target);
static PluginInfoBar* plugin_special_folders_get_folder_info_bar (PluginSpecialFolders* self,
                                                           PluginFolder* target);
static void plugin_special_folders_update_email_data_free (gpointer _data);
static void plugin_special_folders_update_email (PluginSpecialFolders* self,
                                          PluginEmail* target,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void plugin_special_folders_update_email_finish (PluginSpecialFolders* self,
                                                 GAsyncResult* _res_);
static gboolean plugin_special_folders_update_email_co (PluginSpecialFoldersUpdateEmailData* _data_);
static void plugin_special_folders_update_email_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static PluginInfoBar* plugin_special_folders_new_draft_info_bar (PluginSpecialFolders* self,
                                                          PluginEmail* target);
static PluginInfoBar* plugin_special_folders_new_unsaved_info_bar (PluginSpecialFolders* self,
                                                            PluginEmail* target);
static void plugin_special_folders_edit_draft_data_free (gpointer _data);
static void plugin_special_folders_edit_draft (PluginSpecialFolders* self,
                                        PluginEmailIdentifier* id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void plugin_special_folders_edit_draft_finish (PluginSpecialFolders* self,
                                               GAsyncResult* _res_);
static gboolean plugin_special_folders_edit_draft_co (PluginSpecialFoldersEditDraftData* _data_);
static void plugin_special_folders_edit_draft_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void plugin_special_folders_finalize (GObject * obj);
static void _vala_plugin_special_folders_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_plugin_special_folders_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* obj = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (module, g_type_module_get_type ()));
	plugin_special_folders_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	obj = _tmp0_;
	peas_object_module_register_extension_type (obj, PLUGIN_TYPE_PLUGIN_BASE, PLUGIN_TYPE_SPECIAL_FOLDERS);
	_g_object_unref0 (obj);
}

static inline gpointer
plugin_special_folders_get_instance_private (PluginSpecialFolders* self)
{
	return G_STRUCT_MEMBER_P (self, PluginSpecialFolders_private_offset);
}

static PluginFolderContext*
plugin_special_folders_real_get_folders (PluginFolderExtension* base)
{
	PluginFolderContext* result;
	PluginSpecialFolders* self;
	PluginFolderContext* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	_tmp0_ = self->priv->_folders;
	result = _tmp0_;
	return result;
}

static void
plugin_special_folders_real_set_folders (PluginFolderExtension* base,
                                         PluginFolderContext* value)
{
	PluginSpecialFolders* self;
	PluginFolderContext* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	old_value = plugin_special_folders_real_get_folders (base);
	if (old_value != value) {
		PluginFolderContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folders);
		self->priv->_folders = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_special_folders_properties[PLUGIN_SPECIAL_FOLDERS_FOLDERS_PROPERTY]);
	}
}

static PluginEmailContext*
plugin_special_folders_real_get_email (PluginEmailExtension* base)
{
	PluginEmailContext* result;
	PluginSpecialFolders* self;
	PluginEmailContext* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	_tmp0_ = self->priv->_email;
	result = _tmp0_;
	return result;
}

static void
plugin_special_folders_real_set_email (PluginEmailExtension* base,
                                       PluginEmailContext* value)
{
	PluginSpecialFolders* self;
	PluginEmailContext* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	old_value = plugin_special_folders_real_get_email (base);
	if (old_value != value) {
		PluginEmailContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_email);
		self->priv->_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_special_folders_properties[PLUGIN_SPECIAL_FOLDERS_EMAIL_PROPERTY]);
	}
}

static void
plugin_special_folders_real_activate_data_free (gpointer _data)
{
	PluginSpecialFoldersActivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginSpecialFoldersActivateData, _data_);
}

static void
plugin_special_folders_real_activate (PluginPluginBase* base,
                                      gboolean is_startup,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	PluginSpecialFolders * self;
	PluginSpecialFoldersActivateData* _data_;
	PluginSpecialFolders* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	_data_ = g_slice_new0 (PluginSpecialFoldersActivateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_special_folders_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->is_startup = is_startup;
	plugin_special_folders_real_activate_co (_data_);
}

static void
plugin_special_folders_activate_finish (PluginPluginBase* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	PluginSpecialFoldersActivateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
plugin_special_folders_activate_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	PluginSpecialFoldersActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	plugin_special_folders_real_activate_co (_data_);
}

static void
_plugin_special_folders_on_email_displayed_plugin_email_store_email_displayed (PluginEmailStore* _sender,
                                                                               PluginEmail* sent,
                                                                               gpointer self)
{
	plugin_special_folders_on_email_displayed ((PluginSpecialFolders*) self, sent);
}

static void
_plugin_special_folders_on_folder_selected_plugin_folder_store_folder_selected (PluginFolderStore* _sender,
                                                                                PluginFolder* selected,
                                                                                gpointer self)
{
	plugin_special_folders_on_folder_selected ((PluginSpecialFolders*) self, selected);
}

static void
_plugin_special_folders_on_folders_type_changed_plugin_folder_store_folders_type_changed (PluginFolderStore* _sender,
                                                                                          GeeCollection* changed,
                                                                                          gpointer self)
{
	plugin_special_folders_on_folders_type_changed ((PluginSpecialFolders*) self, changed);
}

static void
_plugin_special_folders_on_edit_activated_g_simple_action_activate (GSimpleAction* _sender,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	plugin_special_folders_on_edit_activated ((PluginSpecialFolders*) self, _sender, parameter);
}

static void
_plugin_special_folders_on_empty_activated_g_simple_action_activate (GSimpleAction* _sender,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	plugin_special_folders_on_empty_activated ((PluginSpecialFolders*) self, _sender, parameter);
}

static gboolean
plugin_special_folders_real_activate_co (PluginSpecialFoldersActivateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = plugin_email_extension_get_email (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	plugin_email_context_get_email_store (_data_->_tmp2_, plugin_special_folders_activate_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = plugin_email_context_get_email_store_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_g_object_unref0 (_data_->self->priv->email_store);
	_data_->self->priv->email_store = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->email_store;
	g_signal_connect_object (_data_->_tmp5_, "email-displayed", (GCallback) _plugin_special_folders_on_email_displayed_plugin_email_store_email_displayed, _data_->self, 0);
	_data_->_tmp7_ = plugin_folder_extension_get_folders (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension));
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_state_ = 2;
	plugin_folder_context_get_folder_store (_data_->_tmp8_, plugin_special_folders_activate_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp9_ = plugin_folder_context_get_folder_store_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp6_ = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp6_;
	_data_->_tmp6_ = NULL;
	_g_object_unref0 (_data_->self->priv->folder_store);
	_data_->self->priv->folder_store = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->self->priv->folder_store;
	g_signal_connect_object (_data_->_tmp11_, "folder-selected", (GCallback) _plugin_special_folders_on_folder_selected_plugin_folder_store_folder_selected, _data_->self, 0);
	_data_->_tmp12_ = _data_->self->priv->folder_store;
	g_signal_connect_object (_data_->_tmp12_, "folders-type-changed", (GCallback) _plugin_special_folders_on_folders_type_changed_plugin_folder_store_folders_type_changed, _data_->self, 0);
	_data_->_tmp13_ = _data_->self->priv->email_store;
	_data_->_tmp14_ = plugin_email_store_get_email_identifier_variant_type (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = g_simple_action_new (PLUGIN_SPECIAL_FOLDERS_ACTION_EDIT, _data_->_tmp15_);
	_g_object_unref0 (_data_->self->priv->edit_action);
	_data_->self->priv->edit_action = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->self->priv->edit_action;
	g_signal_connect_object (_data_->_tmp17_, "activate", (GCallback) _plugin_special_folders_on_edit_activated_g_simple_action_activate, _data_->self, 0);
	_data_->_tmp18_ = plugin_plugin_base_get_plugin_application (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_PLUGIN_BASE, PluginPluginBase));
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = _data_->self->priv->edit_action;
	plugin_application_register_action (_data_->_tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, g_action_get_type (), GAction));
	_data_->_tmp21_ = _data_->self->priv->folder_store;
	_data_->_tmp22_ = plugin_folder_store_get_folder_variant_type (_data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	_data_->_tmp24_ = g_simple_action_new (PLUGIN_SPECIAL_FOLDERS_ACTION_EMPTY, _data_->_tmp23_);
	_g_object_unref0 (_data_->self->priv->empty_action);
	_data_->self->priv->empty_action = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->self->priv->empty_action;
	g_signal_connect_object (_data_->_tmp25_, "activate", (GCallback) _plugin_special_folders_on_empty_activated_g_simple_action_activate, _data_->self, 0);
	_data_->_tmp26_ = plugin_plugin_base_get_plugin_application (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_PLUGIN_BASE, PluginPluginBase));
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = _data_->self->priv->empty_action;
	plugin_application_register_action (_data_->_tmp27_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp28_, g_action_get_type (), GAction));
	_g_object_unref0 (_data_->_tmp6_);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
plugin_special_folders_real_deactivate_data_free (gpointer _data)
{
	PluginSpecialFoldersDeactivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginSpecialFoldersDeactivateData, _data_);
}

static void
plugin_special_folders_real_deactivate (PluginPluginBase* base,
                                        gboolean is_shutdown,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	PluginSpecialFolders * self;
	PluginSpecialFoldersDeactivateData* _data_;
	PluginSpecialFolders* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	_data_ = g_slice_new0 (PluginSpecialFoldersDeactivateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_special_folders_real_deactivate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->is_shutdown = is_shutdown;
	plugin_special_folders_real_deactivate_co (_data_);
}

static void
plugin_special_folders_deactivate_finish (PluginPluginBase* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	PluginSpecialFoldersDeactivateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
plugin_special_folders_real_deactivate_co (PluginSpecialFoldersDeactivateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = plugin_plugin_base_get_plugin_application (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_PLUGIN_BASE, PluginPluginBase));
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->self->priv->edit_action;
	plugin_application_deregister_action (_data_->_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, g_action_get_type (), GAction));
	_g_object_unref0 (_data_->self->priv->edit_action);
	_data_->self->priv->edit_action = NULL;
	_data_->_tmp3_ = plugin_plugin_base_get_plugin_application (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_PLUGIN_BASE, PluginPluginBase));
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->self->priv->empty_action;
	plugin_application_deregister_action (_data_->_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, g_action_get_type (), GAction));
	_g_object_unref0 (_data_->self->priv->empty_action);
	_data_->self->priv->empty_action = NULL;
	_data_->_tmp6_ = _data_->self->priv->email_store;
	g_signal_parse_name ("email-displayed", PLUGIN_TYPE_EMAIL_STORE, &_data_->_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data_->_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp7_, 0, NULL, (GCallback) _plugin_special_folders_on_email_displayed_plugin_email_store_email_displayed, _data_->self);
	_g_object_unref0 (_data_->self->priv->email_store);
	_data_->self->priv->email_store = NULL;
	_data_->_tmp8_ = _data_->self->priv->folder_store;
	g_signal_parse_name ("folder-selected", PLUGIN_TYPE_FOLDER_STORE, &_data_->_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data_->_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp9_, 0, NULL, (GCallback) _plugin_special_folders_on_folder_selected_plugin_folder_store_folder_selected, _data_->self);
	_data_->_tmp10_ = _data_->self->priv->folder_store;
	g_signal_parse_name ("folders-type-changed", PLUGIN_TYPE_FOLDER_STORE, &_data_->_tmp11_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data_->_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp11_, 0, NULL, (GCallback) _plugin_special_folders_on_folders_type_changed_plugin_folder_store_folders_type_changed, _data_->self);
	_g_object_unref0 (_data_->self->priv->folder_store);
	_data_->self->priv->folder_store = NULL;
	_data_->_tmp12_ = _data_->self->priv->cancellable;
	g_cancellable_cancel (_data_->_tmp12_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
plugin_special_folders_update_folder (PluginSpecialFolders* self,
                                      PluginFolder* target)
{
	GearyFolderSpecialUse _tmp0_;
	GearyFolderSpecialUse _tmp1_;
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, PLUGIN_TYPE_FOLDER));
	_tmp0_ = plugin_folder_get_used_as (target);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case GEARY_FOLDER_SPECIAL_USE_TRASH:
		{
			PluginFolderContext* _tmp2_;
			PluginFolderContext* _tmp3_;
			PluginInfoBar* _tmp4_;
			PluginInfoBar* _tmp5_;
			_tmp2_ = plugin_folder_extension_get_folders (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension));
			_tmp3_ = _tmp2_;
			_tmp4_ = plugin_special_folders_get_folder_info_bar (self, target);
			_tmp5_ = _tmp4_;
			plugin_folder_context_add_folder_info_bar (_tmp3_, target, _tmp5_, (guint) PLUGIN_SPECIAL_FOLDERS_PRIORITY);
			_g_object_unref0 (_tmp5_);
			break;
		}
		case GEARY_FOLDER_SPECIAL_USE_JUNK:
		{
			PluginFolderContext* _tmp6_;
			PluginFolderContext* _tmp7_;
			PluginInfoBar* _tmp8_;
			PluginInfoBar* _tmp9_;
			_tmp6_ = plugin_folder_extension_get_folders (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension));
			_tmp7_ = _tmp6_;
			_tmp8_ = plugin_special_folders_get_folder_info_bar (self, target);
			_tmp9_ = _tmp8_;
			plugin_folder_context_add_folder_info_bar (_tmp7_, target, _tmp9_, (guint) PLUGIN_SPECIAL_FOLDERS_PRIORITY);
			_g_object_unref0 (_tmp9_);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
plugin_special_folders_update_email_data_free (gpointer _data)
{
	PluginSpecialFoldersUpdateEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->target);
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginSpecialFoldersUpdateEmailData, _data_);
}

static void
plugin_special_folders_update_email (PluginSpecialFolders* self,
                                     PluginEmail* target,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	PluginSpecialFoldersUpdateEmailData* _data_;
	PluginSpecialFolders* _tmp0_;
	PluginEmail* _tmp1_;
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, PLUGIN_TYPE_EMAIL));
	_data_ = g_slice_new0 (PluginSpecialFoldersUpdateEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_special_folders_update_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (target);
	_g_object_unref0 (_data_->target);
	_data_->target = _tmp1_;
	plugin_special_folders_update_email_co (_data_);
}

static void
plugin_special_folders_update_email_finish (PluginSpecialFolders* self,
                                            GAsyncResult* _res_)
{
	PluginSpecialFoldersUpdateEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
plugin_special_folders_update_email_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	PluginSpecialFoldersUpdateEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	plugin_special_folders_update_email_co (_data_);
}

static gboolean
plugin_special_folders_update_email_co (PluginSpecialFoldersUpdateEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->is_draft = FALSE;
	_data_->_tmp0_ = plugin_email_get_flags (_data_->target);
	_data_->_tmp1_ = _data_->_tmp0_;
	if (geary_email_flags_is_draft (_data_->_tmp1_)) {
		_data_->is_draft = TRUE;
	} else {
		_data_->_tmp2_ = _data_->self->priv->folder_store;
		if (_data_->_tmp2_ != NULL) {
			{
				_data_->_tmp3_ = _data_->self->priv->folder_store;
				_data_->_tmp4_ = plugin_email_get_identifier (_data_->target);
				_data_->_tmp5_ = _data_->_tmp4_;
				_data_->_tmp6_ = _data_->self->priv->cancellable;
				_data_->_state_ = 1;
				plugin_folder_store_list_containing_folders (_data_->_tmp3_, _data_->_tmp5_, _data_->_tmp6_, plugin_special_folders_update_email_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp7_ = plugin_folder_store_list_containing_folders_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
				_data_->folders = _data_->_tmp7_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				{
					_data_->_tmp8_ = _data_->folders;
					_data_->_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
					_data_->_folder_it = _data_->_tmp9_;
					while (TRUE) {
						_data_->_tmp10_ = _data_->_folder_it;
						if (!gee_iterator_next (_data_->_tmp10_)) {
							break;
						}
						_data_->_tmp11_ = _data_->_folder_it;
						_data_->_tmp12_ = gee_iterator_get (_data_->_tmp11_);
						_data_->folder = (PluginFolder*) _data_->_tmp12_;
						_data_->_tmp13_ = _data_->folder;
						_data_->_tmp14_ = plugin_folder_get_used_as (_data_->_tmp13_);
						_data_->_tmp15_ = _data_->_tmp14_;
						if (_data_->_tmp15_ == GEARY_FOLDER_SPECIAL_USE_DRAFTS) {
							_data_->is_draft = TRUE;
							_g_object_unref0 (_data_->folder);
							break;
						}
						_g_object_unref0 (_data_->folder);
					}
					_g_object_unref0 (_data_->_folder_it);
				}
				_g_object_unref0 (_data_->folders);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_data_->_inner_error0_);
				g_warning ("special-folders.vala:127: Could not list containing folders for email");
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	if (_data_->is_draft) {
		_data_->_tmp16_ = plugin_email_extension_get_email (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension));
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = plugin_email_get_identifier (_data_->target);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = plugin_special_folders_new_draft_info_bar (_data_->self, _data_->target);
		_data_->_tmp21_ = _data_->_tmp20_;
		plugin_email_context_add_email_info_bar (_data_->_tmp17_, _data_->_tmp19_, _data_->_tmp21_, (guint) PLUGIN_SPECIAL_FOLDERS_PRIORITY);
		_g_object_unref0 (_data_->_tmp21_);
	}
	_data_->_tmp22_ = plugin_email_get_flags (_data_->target);
	_data_->_tmp23_ = _data_->_tmp22_;
	if (geary_email_flags_is_outbox_sent (_data_->_tmp23_)) {
		_data_->_tmp24_ = plugin_email_extension_get_email (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension));
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = plugin_email_get_identifier (_data_->target);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = plugin_special_folders_new_unsaved_info_bar (_data_->self, _data_->target);
		_data_->_tmp29_ = _data_->_tmp28_;
		plugin_email_context_add_email_info_bar (_data_->_tmp25_, _data_->_tmp27_, _data_->_tmp29_, (guint) PLUGIN_SPECIAL_FOLDERS_PRIORITY);
		_g_object_unref0 (_data_->_tmp29_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
plugin_special_folders_edit_draft_data_free (gpointer _data)
{
	PluginSpecialFoldersEditDraftData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginSpecialFoldersEditDraftData, _data_);
}

static void
plugin_special_folders_edit_draft (PluginSpecialFolders* self,
                                   PluginEmailIdentifier* id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	PluginSpecialFoldersEditDraftData* _data_;
	PluginSpecialFolders* _tmp0_;
	PluginEmailIdentifier* _tmp1_;
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (id, PLUGIN_TYPE_EMAIL_IDENTIFIER));
	_data_ = g_slice_new0 (PluginSpecialFoldersEditDraftData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_special_folders_edit_draft_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (id);
	_g_object_unref0 (_data_->id);
	_data_->id = _tmp1_;
	plugin_special_folders_edit_draft_co (_data_);
}

static void
plugin_special_folders_edit_draft_finish (PluginSpecialFolders* self,
                                          GAsyncResult* _res_)
{
	PluginSpecialFoldersEditDraftData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
plugin_special_folders_edit_draft_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	PluginSpecialFoldersEditDraftData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	plugin_special_folders_edit_draft_co (_data_);
}

static gboolean
plugin_special_folders_edit_draft_co (PluginSpecialFoldersEditDraftData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = plugin_plugin_base_get_plugin_application (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_PLUGIN_BASE, PluginPluginBase));
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = plugin_email_identifier_get_account (_data_->id);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 1;
		plugin_application_compose_with_context (_data_->_tmp1_, _data_->_tmp3_, PLUGIN_COMPOSER_CONTEXT_TYPE_EDIT, _data_->id, NULL, plugin_special_folders_edit_draft_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = plugin_application_compose_with_context_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->composer = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		plugin_composer_present (_data_->composer);
		_g_object_unref0 (_data_->composer);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->err;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("special-folders.vala:156: Unable to construct composer: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static PluginInfoBar*
plugin_special_folders_get_folder_info_bar (PluginSpecialFolders* self,
                                            PluginFolder* target)
{
	PluginInfoBar* bar = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	PluginInfoBar* _tmp2_;
	PluginInfoBar* result;
	g_return_val_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, PLUGIN_TYPE_FOLDER), NULL);
	_tmp0_ = self->priv->info_bars;
	_tmp1_ = gee_map_get (_tmp0_, target);
	bar = (PluginInfoBar*) _tmp1_;
	_tmp2_ = bar;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		PluginInfoBar* _tmp5_;
		PluginInfoBar* _tmp6_;
		GSimpleAction* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		PluginActionable* _tmp10_;
		PluginActionable* _tmp11_;
		GeeMap* _tmp12_;
		PluginInfoBar* _tmp13_;
		_tmp3_ = plugin_folder_get_display_name (target);
		_tmp4_ = _tmp3_;
		_tmp5_ = plugin_info_bar_new (_tmp4_, NULL);
		_g_object_unref0 (bar);
		bar = _tmp5_;
		_tmp6_ = bar;
		_tmp7_ = self->priv->empty_action;
		_tmp8_ = plugin_folder_to_variant (target);
		_tmp9_ = _tmp8_;
		_tmp10_ = plugin_actionable_new (_ ("Empty"), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_action_get_type (), GAction), _tmp9_);
		_tmp11_ = _tmp10_;
		plugin_info_bar_set_primary_button (_tmp6_, _tmp11_);
		_g_object_unref0 (_tmp11_);
		_g_variant_unref0 (_tmp9_);
		_tmp12_ = self->priv->info_bars;
		_tmp13_ = bar;
		gee_map_set (_tmp12_, target, _tmp13_);
	}
	result = bar;
	return result;
}

static PluginInfoBar*
plugin_special_folders_new_draft_info_bar (PluginSpecialFolders* self,
                                           PluginEmail* target)
{
	PluginInfoBar* bar = NULL;
	PluginInfoBar* _tmp0_;
	GSimpleAction* _tmp1_;
	PluginEmailIdentifier* _tmp2_;
	PluginEmailIdentifier* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	PluginActionable* _tmp6_;
	PluginActionable* _tmp7_;
	PluginInfoBar* result;
	g_return_val_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, PLUGIN_TYPE_EMAIL), NULL);
	_tmp0_ = plugin_info_bar_new (_ ("Draft message"), _ ("This message has not yet been sent."));
	bar = _tmp0_;
	_tmp1_ = self->priv->edit_action;
	_tmp2_ = plugin_email_get_identifier (target);
	_tmp3_ = _tmp2_;
	_tmp4_ = plugin_email_identifier_to_variant (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = plugin_actionable_new (_ ("Edit"), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_action_get_type (), GAction), _tmp5_);
	_tmp7_ = _tmp6_;
	plugin_info_bar_set_primary_button (bar, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_g_variant_unref0 (_tmp5_);
	result = bar;
	return result;
}

static PluginInfoBar*
plugin_special_folders_new_unsaved_info_bar (PluginSpecialFolders* self,
                                             PluginEmail* target)
{
	PluginInfoBar* _tmp0_;
	PluginInfoBar* result;
	g_return_val_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, PLUGIN_TYPE_EMAIL), NULL);
	_tmp0_ = plugin_info_bar_new (_ ("Message not saved"), _ ("This message was sent, but has not been saved to your account."));
	result = _tmp0_;
	return result;
}

static void
plugin_special_folders_on_folder_selected (PluginSpecialFolders* self,
                                           PluginFolder* selected)
{
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (selected, PLUGIN_TYPE_FOLDER));
	plugin_special_folders_update_folder (self, selected);
}

static void
plugin_special_folders_on_folders_type_changed (PluginSpecialFolders* self,
                                                GeeCollection* changed)
{
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (changed, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _folder_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (changed, GEE_TYPE_ITERABLE, GeeIterable));
		_folder_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			PluginFolder* folder = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			PluginInfoBar* existing = NULL;
			GeeMap* _tmp4_;
			PluginFolder* _tmp5_;
			gpointer _tmp6_;
			PluginInfoBar* _tmp7_;
			PluginFolder* _tmp14_;
			_tmp1_ = _folder_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _folder_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			folder = (PluginFolder*) _tmp3_;
			_tmp4_ = self->priv->info_bars;
			_tmp5_ = folder;
			_tmp6_ = gee_map_get (_tmp4_, _tmp5_);
			existing = (PluginInfoBar*) _tmp6_;
			_tmp7_ = existing;
			if (_tmp7_ != NULL) {
				PluginFolderContext* _tmp8_;
				PluginFolderContext* _tmp9_;
				PluginFolder* _tmp10_;
				PluginInfoBar* _tmp11_;
				GeeMap* _tmp12_;
				PluginFolder* _tmp13_;
				_tmp8_ = plugin_folder_extension_get_folders (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension));
				_tmp9_ = _tmp8_;
				_tmp10_ = folder;
				_tmp11_ = existing;
				plugin_folder_context_remove_folder_info_bar (_tmp9_, _tmp10_, _tmp11_);
				_tmp12_ = self->priv->info_bars;
				_tmp13_ = folder;
				gee_map_unset (_tmp12_, _tmp13_, NULL);
			}
			_tmp14_ = folder;
			plugin_special_folders_update_folder (self, _tmp14_);
			_g_object_unref0 (existing);
			_g_object_unref0 (folder);
		}
		_g_object_unref0 (_folder_it);
	}
}

static void
plugin_special_folders_on_edit_activated (PluginSpecialFolders* self,
                                          GAction* action,
                                          GVariant* target)
{
	gboolean _tmp0_ = FALSE;
	PluginEmailStore* _tmp1_;
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_action_get_type ()));
	_tmp1_ = self->priv->email_store;
	if (_tmp1_ != NULL) {
		_tmp0_ = target != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PluginEmailIdentifier* id = NULL;
		PluginEmailStore* _tmp2_;
		PluginEmailIdentifier* _tmp3_;
		PluginEmailIdentifier* _tmp4_;
		_tmp2_ = self->priv->email_store;
		_tmp3_ = plugin_email_store_get_email_identifier_for_variant (_tmp2_, target);
		id = _tmp3_;
		_tmp4_ = id;
		if (_tmp4_ != NULL) {
			PluginEmailIdentifier* _tmp5_;
			_tmp5_ = id;
			plugin_special_folders_edit_draft (self, _tmp5_, NULL, NULL);
		} else {
			g_warning ("special-folders.vala:228: Bad draft id");
		}
		_g_object_unref0 (id);
	}
}

static void
plugin_special_folders_on_empty_activated (PluginSpecialFolders* self,
                                           GAction* action,
                                           GVariant* target)
{
	gboolean _tmp0_ = FALSE;
	PluginFolderStore* _tmp1_;
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (action, g_action_get_type ()));
	_tmp1_ = self->priv->folder_store;
	if (_tmp1_ != NULL) {
		_tmp0_ = target != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		PluginFolder* folder = NULL;
		PluginFolderStore* _tmp2_;
		PluginFolder* _tmp3_;
		PluginFolder* _tmp4_;
		_tmp2_ = self->priv->folder_store;
		_tmp3_ = plugin_folder_store_get_folder_for_variant (_tmp2_, target);
		folder = _tmp3_;
		_tmp4_ = folder;
		if (_tmp4_ != NULL) {
			PluginApplication* _tmp5_;
			PluginApplication* _tmp6_;
			PluginFolder* _tmp7_;
			_tmp5_ = plugin_plugin_base_get_plugin_application (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_PLUGIN_BASE, PluginPluginBase));
			_tmp6_ = _tmp5_;
			_tmp7_ = folder;
			plugin_application_empty_folder (_tmp6_, _tmp7_, NULL, NULL);
		}
		_g_object_unref0 (folder);
	}
}

static void
plugin_special_folders_on_email_displayed (PluginSpecialFolders* self,
                                           PluginEmail* email)
{
	g_return_if_fail (PLUGIN_IS_SPECIAL_FOLDERS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, PLUGIN_TYPE_EMAIL));
	plugin_special_folders_update_email (self, email, NULL, NULL);
}

PluginSpecialFolders*
plugin_special_folders_construct (GType object_type)
{
	PluginSpecialFolders * self = NULL;
	self = (PluginSpecialFolders*) plugin_plugin_base_construct (object_type);
	return self;
}

PluginSpecialFolders*
plugin_special_folders_new (void)
{
	return plugin_special_folders_construct (PLUGIN_TYPE_SPECIAL_FOLDERS);
}

static void
plugin_special_folders_class_init (PluginSpecialFoldersClass * klass,
                                   gpointer klass_data)
{
	plugin_special_folders_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginSpecialFolders_private_offset);
	((PluginPluginBaseClass *) klass)->activate = (void (*) (PluginPluginBase*, gboolean, GAsyncReadyCallback, gpointer)) plugin_special_folders_real_activate;
	((PluginPluginBaseClass *) klass)->activate_finish = (void (*) (PluginPluginBase*, GAsyncResult*, GError**)) plugin_special_folders_activate_finish;
	((PluginPluginBaseClass *) klass)->deactivate = (void (*) (PluginPluginBase*, gboolean, GAsyncReadyCallback, gpointer)) plugin_special_folders_real_deactivate;
	((PluginPluginBaseClass *) klass)->deactivate_finish = (void (*) (PluginPluginBase*, GAsyncResult*, GError**)) plugin_special_folders_deactivate_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_plugin_special_folders_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plugin_special_folders_set_property;
	G_OBJECT_CLASS (klass)->finalize = plugin_special_folders_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_SPECIAL_FOLDERS_FOLDERS_PROPERTY, plugin_special_folders_properties[PLUGIN_SPECIAL_FOLDERS_FOLDERS_PROPERTY] = g_param_spec_object ("folders", "folders", "folders", PLUGIN_TYPE_FOLDER_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_SPECIAL_FOLDERS_EMAIL_PROPERTY, plugin_special_folders_properties[PLUGIN_SPECIAL_FOLDERS_EMAIL_PROPERTY] = g_param_spec_object ("email", "email", "email", PLUGIN_TYPE_EMAIL_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
plugin_special_folders_plugin_folder_extension_interface_init (PluginFolderExtensionIface * iface,
                                                               gpointer iface_data)
{
	plugin_special_folders_plugin_folder_extension_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_folders = plugin_special_folders_real_get_folders;
	iface->set_folders = plugin_special_folders_real_set_folders;
}

static void
plugin_special_folders_plugin_email_extension_interface_init (PluginEmailExtensionIface * iface,
                                                              gpointer iface_data)
{
	plugin_special_folders_plugin_email_extension_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email = plugin_special_folders_real_get_email;
	iface->set_email = plugin_special_folders_real_set_email;
}

static void
plugin_special_folders_instance_init (PluginSpecialFolders * self,
                                      gpointer klass)
{
	GeeHashMap* _tmp0_;
	GCancellable* _tmp1_;
	self->priv = plugin_special_folders_get_instance_private (self);
	self->priv->email_store = NULL;
	self->priv->folder_store = NULL;
	_tmp0_ = gee_hash_map_new (PLUGIN_TYPE_FOLDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, PLUGIN_TYPE_INFO_BAR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->info_bars = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	self->priv->edit_action = NULL;
	self->priv->empty_action = NULL;
	_tmp1_ = g_cancellable_new ();
	self->priv->cancellable = _tmp1_;
}

static void
plugin_special_folders_finalize (GObject * obj)
{
	PluginSpecialFolders * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	_g_object_unref0 (self->priv->_folders);
	_g_object_unref0 (self->priv->_email);
	_g_object_unref0 (self->priv->email_store);
	_g_object_unref0 (self->priv->folder_store);
	_g_object_unref0 (self->priv->info_bars);
	_g_object_unref0 (self->priv->edit_action);
	_g_object_unref0 (self->priv->empty_action);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (plugin_special_folders_parent_class)->finalize (obj);
}

/**
 * Manages UI for special folders.
 */
GType
plugin_special_folders_get_type (void)
{
	return plugin_special_folders_type_id;
}

GType
plugin_special_folders_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginSpecialFoldersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_special_folders_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginSpecialFolders), 0, (GInstanceInitFunc) plugin_special_folders_instance_init, NULL };
	static const GInterfaceInfo plugin_folder_extension_info = { (GInterfaceInitFunc) plugin_special_folders_plugin_folder_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo plugin_email_extension_info = { (GInterfaceInitFunc) plugin_special_folders_plugin_email_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	plugin_special_folders_type_id = g_type_module_register_type (module, PLUGIN_TYPE_PLUGIN_BASE, "PluginSpecialFolders", &g_define_type_info, 0);
	g_type_module_add_interface (module, plugin_special_folders_type_id, PLUGIN_TYPE_FOLDER_EXTENSION, &plugin_folder_extension_info);
	g_type_module_add_interface (module, plugin_special_folders_type_id, PLUGIN_TYPE_EMAIL_EXTENSION, &plugin_email_extension_info);
	PluginSpecialFolders_private_offset = sizeof (PluginSpecialFoldersPrivate);
	return plugin_special_folders_type_id;
}

static void
_vala_plugin_special_folders_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	PluginSpecialFolders * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	switch (property_id) {
		case PLUGIN_SPECIAL_FOLDERS_FOLDERS_PROPERTY:
		g_value_set_object (value, plugin_folder_extension_get_folders (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension)));
		break;
		case PLUGIN_SPECIAL_FOLDERS_EMAIL_PROPERTY:
		g_value_set_object (value, plugin_email_extension_get_email (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plugin_special_folders_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	PluginSpecialFolders * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_SPECIAL_FOLDERS, PluginSpecialFolders);
	switch (property_id) {
		case PLUGIN_SPECIAL_FOLDERS_FOLDERS_PROPERTY:
		plugin_folder_extension_set_folders (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension), g_value_get_object (value));
		break;
		case PLUGIN_SPECIAL_FOLDERS_EMAIL_PROPERTY:
		plugin_email_extension_set_email (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

