/* geary-client-service.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-client-service.vala, do not modify */

/*
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

#define GEARY_CLIENT_SERVICE_BECAME_REACHABLE_TIMEOUT_SEC 3
#define GEARY_CLIENT_SERVICE_BECAME_UNREACHABLE_TIMEOUT_SEC 1

enum  {
	GEARY_CLIENT_SERVICE_0_PROPERTY,
	GEARY_CLIENT_SERVICE_ACCOUNT_PROPERTY,
	GEARY_CLIENT_SERVICE_CONFIGURATION_PROPERTY,
	GEARY_CLIENT_SERVICE_CURRENT_STATUS_PROPERTY,
	GEARY_CLIENT_SERVICE_REMOTE_PROPERTY,
	GEARY_CLIENT_SERVICE_IS_RUNNING_PROPERTY,
	GEARY_CLIENT_SERVICE_LAST_ERROR_PROPERTY,
	GEARY_CLIENT_SERVICE_LOGGING_PARENT_PROPERTY,
	GEARY_CLIENT_SERVICE_NUM_PROPERTIES
};
static GParamSpec* geary_client_service_properties[GEARY_CLIENT_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyClientServiceUpdateConfigurationData GearyClientServiceUpdateConfigurationData;
typedef struct _GearyClientServiceRestartData GearyClientServiceRestartData;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GEARY_CLIENT_SERVICE_CONNECTION_ERROR_SIGNAL,
	GEARY_CLIENT_SERVICE_UNRECOVERABLE_ERROR_SIGNAL,
	GEARY_CLIENT_SERVICE_NUM_SIGNALS
};
static guint geary_client_service_signals[GEARY_CLIENT_SERVICE_NUM_SIGNALS] = {0};

struct _GearyClientServicePrivate {
	GearyAccountInformation* _account;
	GearyServiceInformation* _configuration;
	GearyClientServiceStatus _current_status;
	GearyEndpoint* _remote;
	gboolean _is_running;
	GearyTimeoutManager* became_reachable_timer;
	GearyTimeoutManager* became_unreachable_timer;
	GearyErrorContext* _last_error;
	GearyLoggingSource* _logging_parent;
};

struct _GearyClientServiceUpdateConfigurationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyClientService* self;
	GearyServiceInformation* configuration;
	GearyEndpoint* remote;
	GCancellable* cancellable;
	gboolean do_restart;
	gboolean _tmp0_;
	GError* _inner_error0_;
};

struct _GearyClientServiceRestartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyClientService* self;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GError* _inner_error0_;
};

static gint GearyClientService_private_offset;
static gpointer geary_client_service_parent_class = NULL;
static GearyLoggingSourceIface * geary_client_service_geary_logging_source_parent_iface = NULL;

static void geary_client_service_disconnect_handlers (GearyClientService* self);
static void geary_client_service_set_account (GearyClientService* self,
                                       GearyAccountInformation* value);
static void geary_client_service_set_configuration (GearyClientService* self,
                                             GearyServiceInformation* value);
static void geary_client_service_set_remote (GearyClientService* self,
                                      GearyEndpoint* value);
static void geary_client_service_set_is_running (GearyClientService* self,
                                          gboolean value);
static void geary_client_service_set_last_error (GearyClientService* self,
                                          GearyErrorContext* value);
static void _geary_client_service_became_reachable_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                gpointer self);
static void _geary_client_service_became_unreachable_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                                  gpointer self);
static void geary_client_service_connect_handlers (GearyClientService* self);
static void geary_client_service_on_running_notify (GearyClientService* self);
static void _geary_client_service_on_running_notify_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void geary_client_service_on_current_status_notify (GearyClientService* self);
static void _geary_client_service_on_current_status_notify_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void geary_client_service_update_configuration_data_free (gpointer _data);
static gboolean geary_client_service_update_configuration_co (GearyClientServiceUpdateConfigurationData* _data_);
static void geary_client_service_update_configuration_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void geary_client_service_restart_data_free (gpointer _data);
static gboolean geary_client_service_restart_co (GearyClientServiceRestartData* _data_);
static void geary_client_service_restart_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static GearyLoggingState* geary_client_service_real_to_logging_state (GearyClientService* self);
VALA_EXTERN void geary_client_service_set_logging_parent (GearyClientService* self,
                                              GearyLoggingSource* parent);
static void geary_client_service_real_became_reachable (GearyClientService* self);
static void geary_client_service_real_became_unreachable (GearyClientService* self);
static void geary_client_service_on_connectivity_change (GearyClientService* self);
static void _geary_client_service_on_connectivity_change_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void geary_client_service_on_connectivity_error (GearyClientService* self,
                                                 GError* _error_);
static void _geary_client_service_on_connectivity_error_geary_connectivity_manager_remote_error_reported (GearyConnectivityManager* _sender,
                                                                                                   GError* _error_,
                                                                                                   gpointer self);
static void geary_client_service_on_untrusted_host (GearyClientService* self,
                                             GearyEndpoint* remote,
                                             GTlsConnection* cx);
static void _geary_client_service_on_untrusted_host_geary_endpoint_untrusted_host (GearyEndpoint* _sender,
                                                                            GTlsConnection* cx,
                                                                            gpointer self);
static void geary_client_service_finalize (GObject * obj);
static GType geary_client_service_get_type_once (void);
static void _vala_geary_client_service_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_geary_client_service_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
geary_client_service_get_instance_private (GearyClientService* self)
{
	return G_STRUCT_MEMBER_P (self, GearyClientService_private_offset);
}

/**
     * Denotes the service's current status.
     *
     * @see ClientService.current_status
     * @see Account.current_status
     */
/**
         * Determines if re-connection should be attempted from this state.
         *
         * If the service is in this state, it will automatically
         * attempt to reconnect when connectivity changes have been
         * detected.
         */
gboolean
geary_client_service_status_automatically_reconnect (GearyClientServiceStatus self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	if (self == GEARY_CLIENT_SERVICE_STATUS_UNKNOWN) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self == GEARY_CLIENT_SERVICE_STATUS_UNREACHABLE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self == GEARY_CLIENT_SERVICE_STATUS_CONNECTED;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self == GEARY_CLIENT_SERVICE_STATUS_CONNECTION_FAILED;
	}
	result = _tmp0_;
	return result;
}

/**
         * Determines the current status is an error condition.
         *
         * Returns true if not offline or connected.
         */
gboolean
geary_client_service_status_is_error (GearyClientServiceStatus self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (self != GEARY_CLIENT_SERVICE_STATUS_UNKNOWN) {
		_tmp1_ = self != GEARY_CLIENT_SERVICE_STATUS_UNREACHABLE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = self != GEARY_CLIENT_SERVICE_STATUS_CONNECTED;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
geary_client_service_status_to_value (GearyClientServiceStatus self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_object_utils_to_enum_nick (GEARY_CLIENT_SERVICE_TYPE_STATUS, NULL, NULL, GEARY_CLIENT_SERVICE_TYPE_STATUS, (gpointer) ((gintptr) self));
	result = _tmp0_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_client_service_status_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_CLIENT_SERVICE_STATUS_UNKNOWN, "GEARY_CLIENT_SERVICE_STATUS_UNKNOWN", "unknown"}, {GEARY_CLIENT_SERVICE_STATUS_UNREACHABLE, "GEARY_CLIENT_SERVICE_STATUS_UNREACHABLE", "unreachable"}, {GEARY_CLIENT_SERVICE_STATUS_CONNECTED, "GEARY_CLIENT_SERVICE_STATUS_CONNECTED", "connected"}, {GEARY_CLIENT_SERVICE_STATUS_CONNECTION_FAILED, "GEARY_CLIENT_SERVICE_STATUS_CONNECTION_FAILED", "connection-failed"}, {GEARY_CLIENT_SERVICE_STATUS_AUTHENTICATION_FAILED, "GEARY_CLIENT_SERVICE_STATUS_AUTHENTICATION_FAILED", "authentication-failed"}, {GEARY_CLIENT_SERVICE_STATUS_TLS_VALIDATION_FAILED, "GEARY_CLIENT_SERVICE_STATUS_TLS_VALIDATION_FAILED", "tls-validation-failed"}, {GEARY_CLIENT_SERVICE_STATUS_UNRECOVERABLE_ERROR, "GEARY_CLIENT_SERVICE_STATUS_UNRECOVERABLE_ERROR", "unrecoverable-error"}, {0, NULL, NULL}};
	GType geary_client_service_status_type_id;
	geary_client_service_status_type_id = g_enum_register_static ("GearyClientServiceStatus", values);
	return geary_client_service_status_type_id;
}

GType
geary_client_service_status_get_type (void)
{
	static gsize geary_client_service_status_type_id__once = 0;
	if (g_once_init_enter (&geary_client_service_status_type_id__once)) {
		GType geary_client_service_status_type_id;
		geary_client_service_status_type_id = geary_client_service_status_get_type_once ();
		g_once_init_leave (&geary_client_service_status_type_id__once, geary_client_service_status_type_id);
	}
	return geary_client_service_status_type_id__once;
}

GearyAccountInformation*
geary_client_service_get_account (GearyClientService* self)
{
	GearyAccountInformation* result;
	GearyAccountInformation* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_client_service_set_account (GearyClientService* self,
                                  GearyAccountInformation* value)
{
	GearyAccountInformation* old_value;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	old_value = geary_client_service_get_account (self);
	if (old_value != value) {
		GearyAccountInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_client_service_properties[GEARY_CLIENT_SERVICE_ACCOUNT_PROPERTY]);
	}
}

GearyServiceInformation*
geary_client_service_get_configuration (GearyClientService* self)
{
	GearyServiceInformation* result;
	GearyServiceInformation* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), NULL);
	_tmp0_ = self->priv->_configuration;
	result = _tmp0_;
	return result;
}

static void
geary_client_service_set_configuration (GearyClientService* self,
                                        GearyServiceInformation* value)
{
	GearyServiceInformation* old_value;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	old_value = geary_client_service_get_configuration (self);
	if (old_value != value) {
		GearyServiceInformation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_configuration);
		self->priv->_configuration = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_client_service_properties[GEARY_CLIENT_SERVICE_CONFIGURATION_PROPERTY]);
	}
}

GearyClientServiceStatus
geary_client_service_get_current_status (GearyClientService* self)
{
	GearyClientServiceStatus result;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), 0);
	result = self->priv->_current_status;
	return result;
}

void
geary_client_service_set_current_status (GearyClientService* self,
                                         GearyClientServiceStatus value)
{
	GearyClientServiceStatus old_value;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	old_value = geary_client_service_get_current_status (self);
	if (old_value != value) {
		self->priv->_current_status = value;
		g_object_notify_by_pspec ((GObject *) self, geary_client_service_properties[GEARY_CLIENT_SERVICE_CURRENT_STATUS_PROPERTY]);
	}
}

GearyEndpoint*
geary_client_service_get_remote (GearyClientService* self)
{
	GearyEndpoint* result;
	GearyEndpoint* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), NULL);
	_tmp0_ = self->priv->_remote;
	result = _tmp0_;
	return result;
}

static void
geary_client_service_set_remote (GearyClientService* self,
                                 GearyEndpoint* value)
{
	GearyEndpoint* old_value;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	old_value = geary_client_service_get_remote (self);
	if (old_value != value) {
		GearyEndpoint* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_remote);
		self->priv->_remote = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_client_service_properties[GEARY_CLIENT_SERVICE_REMOTE_PROPERTY]);
	}
}

gboolean
geary_client_service_get_is_running (GearyClientService* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), FALSE);
	result = self->priv->_is_running;
	return result;
}

static void
geary_client_service_set_is_running (GearyClientService* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	old_value = geary_client_service_get_is_running (self);
	if (old_value != value) {
		self->priv->_is_running = value;
		g_object_notify_by_pspec ((GObject *) self, geary_client_service_properties[GEARY_CLIENT_SERVICE_IS_RUNNING_PROPERTY]);
	}
}

GearyErrorContext*
geary_client_service_get_last_error (GearyClientService* self)
{
	GearyErrorContext* result;
	GearyErrorContext* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), NULL);
	_tmp0_ = self->priv->_last_error;
	result = _tmp0_;
	return result;
}

static void
geary_client_service_set_last_error (GearyClientService* self,
                                     GearyErrorContext* value)
{
	GearyErrorContext* old_value;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	old_value = geary_client_service_get_last_error (self);
	if (old_value != value) {
		GearyErrorContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_last_error);
		self->priv->_last_error = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_client_service_properties[GEARY_CLIENT_SERVICE_LAST_ERROR_PROPERTY]);
	}
}

const gchar*
geary_client_service_get_logging_domain (GearyClientService* self)
{
	GearyClientServiceClass* _klass_;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), NULL);
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->get_logging_domain) {
		return _klass_->get_logging_domain (self);
	}
	return NULL;
}

static const gchar*
geary_client_service_real_get_logging_domain (GearyClientService* base)
{
	const gchar* result;
	GearyClientService* self;
	self = base;
	result = GEARY_LOGGING_DOMAIN;
	return result;
}

static GearyLoggingSource*
geary_client_service_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyClientService* self;
	GearyLoggingSource* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_CLIENT_SERVICE, GearyClientService);
	_tmp0_ = self->priv->_logging_parent;
	result = _tmp0_;
	return result;
}

static void
_geary_client_service_became_reachable_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                           gpointer self)
{
	geary_client_service_became_reachable ((GearyClientService*) self);
}

static void
_geary_client_service_became_unreachable_geary_timeout_manager_timeout_func (GearyTimeoutManager* manager,
                                                                             gpointer self)
{
	geary_client_service_became_unreachable ((GearyClientService*) self);
}

static void
_geary_client_service_on_running_notify_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	geary_client_service_on_running_notify ((GearyClientService*) self);
}

static void
_geary_client_service_on_current_status_notify_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	geary_client_service_on_current_status_notify ((GearyClientService*) self);
}

GearyClientService*
geary_client_service_construct (GType object_type,
                                GearyAccountInformation* account,
                                GearyServiceInformation* configuration,
                                GearyEndpoint* remote)
{
	GearyClientService * self = NULL;
	GearyTimeoutManager* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (account), NULL);
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (configuration), NULL);
	g_return_val_if_fail (GEARY_IS_ENDPOINT (remote), NULL);
	self = (GearyClientService*) geary_base_object_construct (object_type);
	geary_client_service_set_account (self, account);
	geary_client_service_set_configuration (self, configuration);
	geary_client_service_set_remote (self, remote);
	_tmp0_ = geary_timeout_manager_new_seconds ((guint) GEARY_CLIENT_SERVICE_BECAME_REACHABLE_TIMEOUT_SEC, _geary_client_service_became_reachable_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->became_reachable_timer);
	self->priv->became_reachable_timer = _tmp0_;
	_tmp1_ = geary_timeout_manager_new_seconds ((guint) GEARY_CLIENT_SERVICE_BECAME_UNREACHABLE_TIMEOUT_SEC, _geary_client_service_became_unreachable_geary_timeout_manager_timeout_func, self);
	_g_object_unref0 (self->priv->became_unreachable_timer);
	self->priv->became_unreachable_timer = _tmp1_;
	geary_client_service_connect_handlers (self);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::is-running", (GCallback) _geary_client_service_on_running_notify_g_object_notify, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "notify::current-status", (GCallback) _geary_client_service_on_current_status_notify_g_object_notify, self, 0);
	return self;
}

static void
geary_client_service_update_configuration_data_free (gpointer _data)
{
	GearyClientServiceUpdateConfigurationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->configuration);
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyClientServiceUpdateConfigurationData, _data_);
}

void
geary_client_service_update_configuration (GearyClientService* self,
                                           GearyServiceInformation* configuration,
                                           GearyEndpoint* remote,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GearyClientServiceUpdateConfigurationData* _data_;
	GearyClientService* _tmp0_;
	GearyServiceInformation* _tmp1_;
	GearyEndpoint* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_SERVICE_INFORMATION (configuration));
	g_return_if_fail (GEARY_IS_ENDPOINT (remote));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyClientServiceUpdateConfigurationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_client_service_update_configuration_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (configuration);
	_g_object_unref0 (_data_->configuration);
	_data_->configuration = _tmp1_;
	_tmp2_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_client_service_update_configuration_co (_data_);
}

void
geary_client_service_update_configuration_finish (GearyClientService* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyClientServiceUpdateConfigurationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Updates the configuration for the service.
     *
     * The service will be restarted if it is already running, and if
     * so will be stopped before the old configuration and endpoint is
     * replaced by the new one, then started again.
     */
static void
geary_client_service_update_configuration_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GearyClientServiceUpdateConfigurationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_client_service_update_configuration_co (_data_);
}

static gboolean
geary_client_service_update_configuration_co (GearyClientServiceUpdateConfigurationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_client_service_disconnect_handlers (_data_->self);
	_data_->_tmp0_ = _data_->self->priv->_is_running;
	_data_->do_restart = _data_->_tmp0_;
	if (_data_->do_restart) {
		_data_->_state_ = 1;
		geary_client_service_stop (_data_->self, _data_->cancellable, geary_client_service_update_configuration_ready, _data_);
		return FALSE;
		_state_1:
		geary_client_service_stop_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	geary_client_service_set_configuration (_data_->self, _data_->configuration);
	geary_client_service_set_remote (_data_->self, _data_->remote);
	geary_client_service_connect_handlers (_data_->self);
	if (_data_->do_restart) {
		_data_->_state_ = 2;
		geary_client_service_start (_data_->self, _data_->cancellable, geary_client_service_update_configuration_ready, _data_);
		return FALSE;
		_state_2:
		geary_client_service_start_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_client_service_start (GearyClientService* self,
                            GCancellable* cancellable,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	GearyClientServiceClass* _klass_;
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->start) {
		_klass_->start (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_client_service_start_finish (GearyClientService* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GearyClientServiceClass* _klass_;
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->start_finish) {
		_klass_->start_finish (self, _res_, error);
	}
}

void
geary_client_service_stop (GearyClientService* self,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	GearyClientServiceClass* _klass_;
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->stop) {
		_klass_->stop (self, cancellable, _callback_, _user_data_);
	}
}

void
geary_client_service_stop_finish (GearyClientService* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	GearyClientServiceClass* _klass_;
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->stop_finish) {
		_klass_->stop_finish (self, _res_, error);
	}
}

static void
geary_client_service_restart_data_free (gpointer _data)
{
	GearyClientServiceRestartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyClientServiceRestartData, _data_);
}

void
geary_client_service_restart (GearyClientService* self,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GearyClientServiceRestartData* _data_;
	GearyClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyClientServiceRestartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_client_service_restart_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_client_service_restart_co (_data_);
}

void
geary_client_service_restart_finish (GearyClientService* self,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	GearyClientServiceRestartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Starts the service, stopping it first if running.
     *
     * An error will be thrown if the service could not be stopped or
     * could not be started again. If an error is thrown while
     * stopping the service, no attempt will be made to start it
     * again.
     */
static void
geary_client_service_restart_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	GearyClientServiceRestartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_client_service_restart_co (_data_);
}

static gboolean
geary_client_service_restart_co (GearyClientServiceRestartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_is_running;
	if (_data_->_tmp0_) {
		_data_->_state_ = 1;
		geary_client_service_stop (_data_->self, _data_->cancellable, geary_client_service_restart_ready, _data_);
		return FALSE;
		_state_1:
		geary_client_service_stop_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_state_ = 2;
	geary_client_service_start (_data_->self, _data_->cancellable, geary_client_service_restart_ready, _data_);
	return FALSE;
	_state_2:
	geary_client_service_start_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_client_service_real_to_logging_state (GearyClientService* self)
{
	GearyServiceInformation* _tmp0_;
	GearyProtocol _tmp1_;
	GearyProtocol _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GearyLoggingState* _tmp5_;
	GearyLoggingState* _tmp6_;
	GearyLoggingState* result;
	_tmp0_ = self->priv->_configuration;
	_tmp1_ = geary_service_information_get_protocol (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_protocol_to_value (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}

GearyLoggingState*
geary_client_service_to_logging_state (GearyClientService* self)
{
	GearyClientServiceClass* _klass_;
	g_return_val_if_fail (GEARY_IS_CLIENT_SERVICE (self), NULL);
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

/** Sets the service's logging parent. */
void
geary_client_service_set_logging_parent (GearyClientService* self,
                                         GearyLoggingSource* parent)
{
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_LOGGING_IS_SOURCE (parent));
	self->priv->_logging_parent = parent;
}

/**
     * Called when the network service has become reachable.
     *
     * Derived classes may wish to attempt to establish a network
     * connection to the remote service when this is called.
     */
static void
geary_client_service_real_became_reachable (GearyClientService* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_client_service_became_reachable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
geary_client_service_became_reachable (GearyClientService* self)
{
	GearyClientServiceClass* _klass_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->became_reachable) {
		_klass_->became_reachable (self);
	}
}

/**
     * Called when the network service has become unreachable.
     *
     * Derived classes should close any network connections that are
     * being established, or have been established with remote
     * service.
     */
static void
geary_client_service_real_became_unreachable (GearyClientService* self)
{
	g_critical ("Type `%s' does not implement abstract method `geary_client_service_became_unreachable'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
geary_client_service_became_unreachable (GearyClientService* self)
{
	GearyClientServiceClass* _klass_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	_klass_ = GEARY_CLIENT_SERVICE_GET_CLASS (self);
	if (_klass_->became_unreachable) {
		_klass_->became_unreachable (self);
	}
}

/**
     * Notifies the network service has been started.
     *
     * Derived classes must call this when they consider the service
     * to has been successfully started, to update service status and
     * start reachable checking.
     */
void
geary_client_service_notify_started (GearyClientService* self)
{
	GearyEndpoint* _tmp0_;
	GearyConnectivityManager* _tmp1_;
	GearyConnectivityManager* _tmp2_;
	GearyTrillian _tmp3_;
	GearyTrillian _tmp4_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	geary_client_service_set_is_running (self, TRUE);
	_tmp0_ = self->priv->_remote;
	_tmp1_ = geary_endpoint_get_connectivity (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_connectivity_manager_get_is_reachable (_tmp2_);
	_tmp4_ = _tmp3_;
	if (geary_trillian_is_certain (_tmp4_)) {
		geary_client_service_became_reachable (self);
	} else {
		GearyEndpoint* _tmp5_;
		GearyConnectivityManager* _tmp6_;
		GearyConnectivityManager* _tmp7_;
		GearyTrillian _tmp8_;
		GearyTrillian _tmp9_;
		_tmp5_ = self->priv->_remote;
		_tmp6_ = geary_endpoint_get_connectivity (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_connectivity_manager_get_is_reachable (_tmp7_);
		_tmp9_ = _tmp8_;
		if (geary_trillian_is_impossible (_tmp9_)) {
			geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_UNREACHABLE);
		} else {
			GearyEndpoint* _tmp10_;
			GearyConnectivityManager* _tmp11_;
			GearyConnectivityManager* _tmp12_;
			_tmp10_ = self->priv->_remote;
			_tmp11_ = geary_endpoint_get_connectivity (_tmp10_);
			_tmp12_ = _tmp11_;
			geary_connectivity_manager_check_reachable (_tmp12_, NULL, NULL);
		}
	}
}

/**
     * Notifies when the network service has been stopped.
     *
     * Derived classes must call this before stopping the service to
     * update service status and cancel any pending reachable checks.
     */
void
geary_client_service_notify_stopped (GearyClientService* self)
{
	GearyTimeoutManager* _tmp0_;
	GearyTimeoutManager* _tmp1_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	geary_client_service_set_is_running (self, FALSE);
	geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_UNKNOWN);
	_tmp0_ = self->priv->became_reachable_timer;
	geary_timeout_manager_reset (_tmp0_);
	_tmp1_ = self->priv->became_unreachable_timer;
	geary_timeout_manager_reset (_tmp1_);
}

/**
     * Notifies that the service has successfully connected.
     *
     * Derived classes should call this when a connection to the
     * network service has been successfully negotiated and appears to
     * be operating normally.
     */
void
geary_client_service_notify_connected (GearyClientService* self)
{
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_CONNECTED);
}

/**
     * Notifies that a connection error occurred.
     *
     * Derived classes should call this when a connection to the
     * network service encountered some network error other than a
     * login failure or TLS certificate validation error.
     */
void
geary_client_service_notify_connection_failed (GearyClientService* self,
                                               GearyErrorContext* _error_)
{
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	g_return_if_fail ((_error_ == NULL) || GEARY_IS_ERROR_CONTEXT (_error_));
	geary_client_service_set_last_error (self, _error_);
	geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_CONNECTION_FAILED);
	g_signal_emit (self, geary_client_service_signals[GEARY_CLIENT_SERVICE_CONNECTION_ERROR_SIGNAL], 0, _error_);
}

/**
     * Notifies that an authentication failure has occurred.
     *
     * Derived classes should call this when they have detected that
     * authentication has failed because the service rejected the
     * supplied credentials, but not when login failed for other
     * reasons (for example, connection limits being reached, service
     * temporarily unavailable, etc).
     */
void
geary_client_service_notify_authentication_failed (GearyClientService* self)
{
	GearyAccountInformation* _tmp0_;
	GearyServiceInformation* _tmp1_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_AUTHENTICATION_FAILED);
	_tmp0_ = self->priv->_account;
	_tmp1_ = self->priv->_configuration;
	g_signal_emit_by_name (_tmp0_, "authentication-failure", _tmp1_);
}

/**
     * Notifies that an unrecoverable error has occurred.
     *
     * Derived classes should call this when they have detected that
     * some unrecoverable error has occurred when connecting to the
     * service, such as an unsupported protocol or version.
     */
void
geary_client_service_notify_unrecoverable_error (GearyClientService* self,
                                                 GearyErrorContext* _error_)
{
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_ERROR_CONTEXT (_error_));
	geary_client_service_set_last_error (self, _error_);
	geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_UNRECOVERABLE_ERROR);
	g_signal_emit (self, geary_client_service_signals[GEARY_CLIENT_SERVICE_UNRECOVERABLE_ERROR_SIGNAL], 0, _error_);
}

static void
_geary_client_service_on_connectivity_change_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	geary_client_service_on_connectivity_change ((GearyClientService*) self);
}

static void
_geary_client_service_on_connectivity_error_geary_connectivity_manager_remote_error_reported (GearyConnectivityManager* _sender,
                                                                                              GError* _error_,
                                                                                              gpointer self)
{
	geary_client_service_on_connectivity_error ((GearyClientService*) self, _error_);
}

static void
_geary_client_service_on_untrusted_host_geary_endpoint_untrusted_host (GearyEndpoint* _sender,
                                                                       GTlsConnection* cx,
                                                                       gpointer self)
{
	geary_client_service_on_untrusted_host ((GearyClientService*) self, _sender, cx);
}

static void
geary_client_service_connect_handlers (GearyClientService* self)
{
	GearyEndpoint* _tmp0_;
	GearyConnectivityManager* _tmp1_;
	GearyConnectivityManager* _tmp2_;
	GearyEndpoint* _tmp3_;
	GearyConnectivityManager* _tmp4_;
	GearyConnectivityManager* _tmp5_;
	GearyEndpoint* _tmp6_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	_tmp0_ = self->priv->_remote;
	_tmp1_ = geary_endpoint_get_connectivity (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), "notify::is-reachable", (GCallback) _geary_client_service_on_connectivity_change_g_object_notify, self, 0);
	_tmp3_ = self->priv->_remote;
	_tmp4_ = geary_endpoint_get_connectivity (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "remote-error-reported", (GCallback) _geary_client_service_on_connectivity_error_geary_connectivity_manager_remote_error_reported, self, 0);
	_tmp6_ = self->priv->_remote;
	g_signal_connect_object (_tmp6_, "untrusted-host", (GCallback) _geary_client_service_on_untrusted_host_geary_endpoint_untrusted_host, self, 0);
}

static void
geary_client_service_disconnect_handlers (GearyClientService* self)
{
	GearyEndpoint* _tmp0_;
	GearyConnectivityManager* _tmp1_;
	GearyConnectivityManager* _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	GearyEndpoint* _tmp5_;
	GearyConnectivityManager* _tmp6_;
	GearyConnectivityManager* _tmp7_;
	guint _tmp8_;
	GearyEndpoint* _tmp9_;
	guint _tmp10_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	_tmp0_ = self->priv->_remote;
	_tmp1_ = geary_endpoint_get_connectivity (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_parse_name ("notify::is-reachable", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _geary_client_service_on_connectivity_change_g_object_notify, self);
	_tmp5_ = self->priv->_remote;
	_tmp6_ = geary_endpoint_get_connectivity (_tmp5_);
	_tmp7_ = _tmp6_;
	g_signal_parse_name ("remote-error-reported", GEARY_TYPE_CONNECTIVITY_MANAGER, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _geary_client_service_on_connectivity_error_geary_connectivity_manager_remote_error_reported, self);
	_tmp9_ = self->priv->_remote;
	g_signal_parse_name ("untrusted-host", GEARY_TYPE_ENDPOINT, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _geary_client_service_on_untrusted_host_geary_endpoint_untrusted_host, self);
}

static void
geary_client_service_on_running_notify (GearyClientService* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	_tmp1_ = self->priv->_is_running;
	if (_tmp1_) {
		_tmp0_ = "Started";
	} else {
		_tmp0_ = "Stopped";
	}
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp0_);
}

static void
geary_client_service_on_current_status_notify (GearyClientService* self)
{
	GearyClientServiceStatus _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	_tmp0_ = self->priv->_current_status;
	_tmp1_ = geary_client_service_status_to_value (_tmp0_);
	_tmp2_ = _tmp1_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Status changed to: %s", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
geary_client_service_on_connectivity_change (GearyClientService* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	_tmp1_ = self->priv->_is_running;
	if (_tmp1_) {
		GearyClientServiceStatus _tmp2_;
		_tmp2_ = self->priv->_current_status;
		_tmp0_ = geary_client_service_status_automatically_reconnect (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyEndpoint* _tmp3_;
		GearyConnectivityManager* _tmp4_;
		GearyConnectivityManager* _tmp5_;
		GearyTrillian _tmp6_;
		GearyTrillian _tmp7_;
		_tmp3_ = self->priv->_remote;
		_tmp4_ = geary_endpoint_get_connectivity (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_connectivity_manager_get_is_reachable (_tmp5_);
		_tmp7_ = _tmp6_;
		if (geary_trillian_is_certain (_tmp7_)) {
			GearyTimeoutManager* _tmp8_;
			GearyTimeoutManager* _tmp9_;
			_tmp8_ = self->priv->became_reachable_timer;
			geary_timeout_manager_start (_tmp8_);
			_tmp9_ = self->priv->became_unreachable_timer;
			geary_timeout_manager_reset (_tmp9_);
		} else {
			GearyTimeoutManager* _tmp10_;
			GearyTimeoutManager* _tmp11_;
			geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_UNREACHABLE);
			_tmp10_ = self->priv->became_unreachable_timer;
			geary_timeout_manager_start (_tmp10_);
			_tmp11_ = self->priv->became_reachable_timer;
			geary_timeout_manager_reset (_tmp11_);
		}
	}
}

static void
geary_client_service_on_connectivity_error (GearyClientService* self,
                                            GError* _error_)
{
	gboolean _tmp0_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	g_return_if_fail (_error_ != NULL);
	_tmp0_ = self->priv->_is_running;
	if (_tmp0_) {
		GearyTimeoutManager* _tmp1_;
		GearyTimeoutManager* _tmp2_;
		GearyErrorContext* _tmp3_;
		GearyErrorContext* _tmp4_;
		_tmp1_ = self->priv->became_reachable_timer;
		geary_timeout_manager_reset (_tmp1_);
		_tmp2_ = self->priv->became_unreachable_timer;
		geary_timeout_manager_reset (_tmp2_);
		geary_client_service_became_unreachable (self);
		_tmp3_ = geary_error_context_new (_error_);
		_tmp4_ = _tmp3_;
		geary_client_service_notify_connection_failed (self, _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
}

static void
geary_client_service_on_untrusted_host (GearyClientService* self,
                                        GearyEndpoint* remote,
                                        GTlsConnection* cx)
{
	gboolean _tmp0_;
	g_return_if_fail (GEARY_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_ENDPOINT (remote));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cx, g_tls_connection_get_type ()));
	_tmp0_ = self->priv->_is_running;
	if (_tmp0_) {
		GearyTimeoutManager* _tmp1_;
		GearyTimeoutManager* _tmp2_;
		GearyAccountInformation* _tmp3_;
		GearyServiceInformation* _tmp4_;
		geary_client_service_set_current_status (self, GEARY_CLIENT_SERVICE_STATUS_TLS_VALIDATION_FAILED);
		_tmp1_ = self->priv->became_reachable_timer;
		geary_timeout_manager_reset (_tmp1_);
		_tmp2_ = self->priv->became_unreachable_timer;
		geary_timeout_manager_reset (_tmp2_);
		geary_client_service_became_unreachable (self);
		_tmp3_ = self->priv->_account;
		_tmp4_ = self->priv->_configuration;
		g_signal_emit_by_name (_tmp3_, "untrusted-host", _tmp4_, remote, cx);
	}
}

static void
geary_client_service_class_init (GearyClientServiceClass * klass,
                                 gpointer klass_data)
{
	geary_client_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyClientService_private_offset);
	((GearyClientServiceClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearyClientService*)) geary_client_service_real_to_logging_state;
	((GearyClientServiceClass *) klass)->became_reachable = (void (*) (GearyClientService*)) geary_client_service_real_became_reachable;
	((GearyClientServiceClass *) klass)->became_unreachable = (void (*) (GearyClientService*)) geary_client_service_real_became_unreachable;
	GEARY_CLIENT_SERVICE_CLASS (klass)->get_logging_domain = geary_client_service_real_get_logging_domain;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_client_service_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_client_service_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_client_service_finalize;
	/** The service's account. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CLIENT_SERVICE_ACCOUNT_PROPERTY, geary_client_service_properties[GEARY_CLIENT_SERVICE_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The configuration for the service. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CLIENT_SERVICE_CONFIGURATION_PROPERTY, geary_client_service_properties[GEARY_CLIENT_SERVICE_CONFIGURATION_PROPERTY] = g_param_spec_object ("configuration", "configuration", "configuration", GEARY_TYPE_SERVICE_INFORMATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The service's current status.
	     *
	     * The current state of certain aspects of the service
	     * (e.g. online/offline state may not be fully known, and hence
	     * the value of this property reflects the engine's current
	     * understanding of the service's status, not necessarily that of
	     * actual reality.
	     *
	     * The initial value for this property is {@link Status.UNKNOWN}.
	     *
	     * @see Account.current_status
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CLIENT_SERVICE_CURRENT_STATUS_PROPERTY, geary_client_service_properties[GEARY_CLIENT_SERVICE_CURRENT_STATUS_PROPERTY] = g_param_spec_enum ("current-status", "current-status", "current-status", GEARY_CLIENT_SERVICE_TYPE_STATUS, GEARY_CLIENT_SERVICE_STATUS_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** The network endpoint the service will connect to. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CLIENT_SERVICE_REMOTE_PROPERTY, geary_client_service_properties[GEARY_CLIENT_SERVICE_REMOTE_PROPERTY] = g_param_spec_object ("remote", "remote", "remote", GEARY_TYPE_ENDPOINT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if this service has been started. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CLIENT_SERVICE_IS_RUNNING_PROPERTY, geary_client_service_properties[GEARY_CLIENT_SERVICE_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The last reported error, if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CLIENT_SERVICE_LAST_ERROR_PROPERTY, geary_client_service_properties[GEARY_CLIENT_SERVICE_LAST_ERROR_PROPERTY] = g_param_spec_object ("last-error", "last-error", "last-error", GEARY_TYPE_ERROR_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CLIENT_SERVICE_LOGGING_PARENT_PROPERTY, geary_client_service_properties[GEARY_CLIENT_SERVICE_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Fired when the service encounters a connection error.
	     *
	     * @see Status.CONNECTION_FAILED
	     */
	geary_client_service_signals[GEARY_CLIENT_SERVICE_CONNECTION_ERROR_SIGNAL] = g_signal_new ("connection-error", GEARY_TYPE_CLIENT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_ERROR_CONTEXT);
	/**
	     * Fired when the service encounters an unrecoverable error.
	     *
	     * @see Status.UNRECOVERABLE_ERROR
	     */
	geary_client_service_signals[GEARY_CLIENT_SERVICE_UNRECOVERABLE_ERROR_SIGNAL] = g_signal_new ("unrecoverable-error", GEARY_TYPE_CLIENT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_ERROR_CONTEXT);
}

static void
geary_client_service_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                          gpointer iface_data)
{
	geary_client_service_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_client_service_to_logging_state;
	iface->get_logging_domain = (const gchar* (*) (GearyLoggingSource *)) geary_client_service_get_logging_domain;
	iface->get_logging_parent = geary_client_service_real_get_logging_parent;
}

static void
geary_client_service_instance_init (GearyClientService * self,
                                    gpointer klass)
{
	self->priv = geary_client_service_get_instance_private (self);
	self->priv->_current_status = GEARY_CLIENT_SERVICE_STATUS_UNKNOWN;
	self->priv->_is_running = FALSE;
	self->priv->_last_error = NULL;
	self->priv->_logging_parent = NULL;
}

static void
geary_client_service_finalize (GObject * obj)
{
	GearyClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_CLIENT_SERVICE, GearyClientService);
	geary_client_service_disconnect_handlers (self);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->_configuration);
	_g_object_unref0 (self->priv->_remote);
	_g_object_unref0 (self->priv->became_reachable_timer);
	_g_object_unref0 (self->priv->became_unreachable_timer);
	_g_object_unref0 (self->priv->_last_error);
	G_OBJECT_CLASS (geary_client_service_parent_class)->finalize (obj);
}

/**
 * Manages client connections to a specific network service.
 *
 * Client service object are used by accounts to manage client
 * connections to a specific network service, such as IMAP or SMTP
 * services. This abstract class does not connect to the service
 * itself, rather manages the configuration, status tracking, and
 * life-cycle of concrete implementations.
 */
 G_GNUC_NO_INLINE static GType
geary_client_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyClientServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_client_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyClientService), 0, (GInstanceInitFunc) geary_client_service_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_client_service_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_client_service_type_id;
	geary_client_service_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyClientService", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_client_service_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearyClientService_private_offset = g_type_add_instance_private (geary_client_service_type_id, sizeof (GearyClientServicePrivate));
	return geary_client_service_type_id;
}

GType
geary_client_service_get_type (void)
{
	static gsize geary_client_service_type_id__once = 0;
	if (g_once_init_enter (&geary_client_service_type_id__once)) {
		GType geary_client_service_type_id;
		geary_client_service_type_id = geary_client_service_get_type_once ();
		g_once_init_leave (&geary_client_service_type_id__once, geary_client_service_type_id);
	}
	return geary_client_service_type_id__once;
}

static void
_vala_geary_client_service_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GearyClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_CLIENT_SERVICE, GearyClientService);
	switch (property_id) {
		case GEARY_CLIENT_SERVICE_ACCOUNT_PROPERTY:
		g_value_set_object (value, geary_client_service_get_account (self));
		break;
		case GEARY_CLIENT_SERVICE_CONFIGURATION_PROPERTY:
		g_value_set_object (value, geary_client_service_get_configuration (self));
		break;
		case GEARY_CLIENT_SERVICE_CURRENT_STATUS_PROPERTY:
		g_value_set_enum (value, geary_client_service_get_current_status (self));
		break;
		case GEARY_CLIENT_SERVICE_REMOTE_PROPERTY:
		g_value_set_object (value, geary_client_service_get_remote (self));
		break;
		case GEARY_CLIENT_SERVICE_IS_RUNNING_PROPERTY:
		g_value_set_boolean (value, geary_client_service_get_is_running (self));
		break;
		case GEARY_CLIENT_SERVICE_LAST_ERROR_PROPERTY:
		g_value_set_object (value, geary_client_service_get_last_error (self));
		break;
		case GEARY_CLIENT_SERVICE_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_client_service_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GearyClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_CLIENT_SERVICE, GearyClientService);
	switch (property_id) {
		case GEARY_CLIENT_SERVICE_ACCOUNT_PROPERTY:
		geary_client_service_set_account (self, g_value_get_object (value));
		break;
		case GEARY_CLIENT_SERVICE_CONFIGURATION_PROPERTY:
		geary_client_service_set_configuration (self, g_value_get_object (value));
		break;
		case GEARY_CLIENT_SERVICE_CURRENT_STATUS_PROPERTY:
		geary_client_service_set_current_status (self, g_value_get_enum (value));
		break;
		case GEARY_CLIENT_SERVICE_REMOTE_PROPERTY:
		geary_client_service_set_remote (self, g_value_get_object (value));
		break;
		case GEARY_CLIENT_SERVICE_IS_RUNNING_PROPERTY:
		geary_client_service_set_is_running (self, g_value_get_boolean (value));
		break;
		case GEARY_CLIENT_SERVICE_LAST_ERROR_PROPERTY:
		geary_client_service_set_last_error (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

