/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.NodeRemover;
import org.jetbrains.kotlin.js.inline.clean.UsedImportsCollector;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"collectUsedImports", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "to", "", "removeUnusedImports", "", "fragment", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "code", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "js.translator"})
public final class RemoveUnusedImportsKt {
    /*
     * WARNING - void declaration
     */
    public static final void removeUnusedImports(@NotNull JsProgramFragment fragment, @NotNull JsBlock code) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        Intrinsics.checkNotNullParameter(code, "code");
        Set usedImports = new LinkedHashSet();
        RemoveUnusedImportsKt.collectUsedImports(code, usedImports);
        CollectionsKt.retainAll(fragment.getNameBindings(), (Function1)new Function1<JsNameBinding, Boolean>((Set<JsName>)usedImports){
            final /* synthetic */ Set<JsName> $usedImports;
            {
                this.$usedImports = $usedImports;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull JsNameBinding it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !MetadataProperties.getImported(it.getName()) || this.$usedImports.contains(it.getName());
            }
        });
        Iterable $this$map$iv = fragment.getNameBindings();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsNameBinding jsNameBinding = (JsNameBinding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        Set<String> existingTags = CollectionsKt.toSet((List)destination$iv$iv);
        CollectionsKt.retainAll((Iterable)fragment.getImports().entrySet(), (Function1)new Function1<Map.Entry<String, JsExpression>, Boolean>(existingTags){
            final /* synthetic */ Set<String> $existingTags;
            {
                this.$existingTags = $existingTags;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, JsExpression> entry) {
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                String k = entry.getKey();
                return this.$existingTags.contains(k);
            }
        });
    }

    private static final Set<JsName> collectUsedImports(JsNode root2, Set<JsName> to) {
        UsedImportsCollector collector2 = new UsedImportsCollector(to);
        root2.accept(collector2);
        Set removedPseudoImports = new LinkedHashSet();
        new NodeRemover<JsVars>(JsVars.class, new Function1<JsVars, Boolean>(collector2, (Set<JsName>)removedPseudoImports){
            final /* synthetic */ UsedImportsCollector $collector;
            final /* synthetic */ Set<JsName> $removedPseudoImports;
            {
                this.$collector = $collector;
                this.$removedPseudoImports = $removedPseudoImports;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull JsVars statement2) {
                boolean bl;
                Intrinsics.checkNotNullParameter(statement2, "statement");
                if (statement2.getVars().size() == 1) {
                    JsName name = statement2.getVars().get(0).getName();
                    Intrinsics.checkNotNullExpressionValue(name, "name");
                    boolean bl2 = MetadataProperties.getImported(name) && !this.$collector.getUsedImports().contains(name);
                    Set<JsName> set = this.$removedPseudoImports;
                    boolean it = bl2;
                    boolean bl3 = false;
                    if (it) {
                        ((Collection)set).add(name);
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                return bl;
            }
        }).accept((JsVars)root2);
        Iterable $this$forEach$iv = collector2.getPseudoImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            boolean bl = false;
            if (removedPseudoImports.contains(it.getName())) continue;
            it.getInitExpression().accept(collector2);
        }
        return collector2.getUsedImports();
    }
}

