/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KotlinAliasedFunctionIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsicWithReceiverComputed;", "functionName", "", "(Ljava/lang/String;)V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "receiver", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
public class KotlinAliasedFunctionIntrinsic
extends FunctionIntrinsicWithReceiverComputed {
    @NotNull
    private final String functionName;

    public KotlinAliasedFunctionIntrinsic(@NotNull String functionName) {
        Intrinsics.checkNotNullParameter(functionName, "functionName");
        this.functionName = functionName;
    }

    @Override
    @NotNull
    public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
        List<? extends JsExpression> list2;
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(context, "context");
        JsExpression jsExpression = context.getReferenceToIntrinsic(this.functionName);
        Intrinsics.checkNotNullExpressionValue(jsExpression, "context.getReferenceToIntrinsic(functionName)");
        JsExpression function2 = jsExpression;
        JsExpression jsExpression2 = receiver;
        if (jsExpression2 == null) {
            list2 = arguments2;
        } else {
            List<JsExpression> list3 = TranslationUtils.generateInvocationArguments(jsExpression2, arguments2);
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, "generateInvocationArguments(receiver, arguments)");
        }
        return new JsInvocation(function2, list2);
    }
}

