/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.document;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class DocumentField
implements Writeable,
ToXContentFragment,
Iterable<Object> {
    private final String name;
    private final List<Object> values;

    public DocumentField(StreamInput in) throws IOException {
        this.name = in.readString();
        this.values = in.readList(StreamInput::readGenericValue);
    }

    public DocumentField(String name, List<Object> values) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.values = Objects.requireNonNull(values, "values must not be null");
    }

    public String getName() {
        return this.name;
    }

    public <V> V getValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return (V)this.values.get(0);
    }

    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeCollection(this.values, StreamOutput::writeGenericValue);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(this.name);
        for (Object value : this.values) {
            builder.value(value);
        }
        builder.endArray();
        return builder;
    }

    public static DocumentField fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
        String fieldName = parser.currentName();
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, token, parser);
        ArrayList<Object> values = new ArrayList<Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            values.add(XContentParserUtils.parseFieldsValue(parser));
        }
        return new DocumentField(fieldName, values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentField objects = (DocumentField)o;
        return Objects.equals(this.name, objects.name) && Objects.equals(this.values, objects.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String toString() {
        return "DocumentField{name='" + this.name + "', values=" + this.values + "}";
    }
}

