/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.Classes;
import org.opensearch.common.inject.Binder;
import org.opensearch.common.inject.Binding;
import org.opensearch.common.inject.ConfigurationException;
import org.opensearch.common.inject.ConstantFactory;
import org.opensearch.common.inject.ConstructorBindingImpl;
import org.opensearch.common.inject.ConstructorInjectorStore;
import org.opensearch.common.inject.ContextualCallable;
import org.opensearch.common.inject.DeferredLookups;
import org.opensearch.common.inject.ImplementedBy;
import org.opensearch.common.inject.Initializables;
import org.opensearch.common.inject.Initializer;
import org.opensearch.common.inject.Injector;
import org.opensearch.common.inject.Key;
import org.opensearch.common.inject.Lookups;
import org.opensearch.common.inject.MembersInjector;
import org.opensearch.common.inject.MembersInjectorImpl;
import org.opensearch.common.inject.MembersInjectorStore;
import org.opensearch.common.inject.ProvidedBy;
import org.opensearch.common.inject.Provider;
import org.opensearch.common.inject.ProvisionException;
import org.opensearch.common.inject.Scopes;
import org.opensearch.common.inject.SingleParameterInjector;
import org.opensearch.common.inject.State;
import org.opensearch.common.inject.TypeLiteral;
import org.opensearch.common.inject.internal.Annotations;
import org.opensearch.common.inject.internal.BindingImpl;
import org.opensearch.common.inject.internal.Errors;
import org.opensearch.common.inject.internal.ErrorsException;
import org.opensearch.common.inject.internal.InstanceBindingImpl;
import org.opensearch.common.inject.internal.InternalContext;
import org.opensearch.common.inject.internal.InternalFactory;
import org.opensearch.common.inject.internal.LinkedBindingImpl;
import org.opensearch.common.inject.internal.LinkedProviderBindingImpl;
import org.opensearch.common.inject.internal.MatcherAndConverter;
import org.opensearch.common.inject.internal.Scoping;
import org.opensearch.common.inject.internal.SourceProvider;
import org.opensearch.common.inject.internal.ToStringBuilder;
import org.opensearch.common.inject.spi.BindingTargetVisitor;
import org.opensearch.common.inject.spi.ConvertedConstantBinding;
import org.opensearch.common.inject.spi.Dependency;
import org.opensearch.common.inject.spi.ProviderBinding;
import org.opensearch.common.inject.spi.ProviderKeyBinding;
import org.opensearch.common.inject.util.Providers;

class InjectorImpl
implements Injector,
Lookups {
    final State state;
    boolean readOnly;
    BindingsMultimap bindingsMultimap = new BindingsMultimap();
    final Initializer initializer;
    Map<Key<?>, BindingImpl<?>> jitBindings = new HashMap();
    Lookups lookups = new DeferredLookups(this);
    ConstructorInjectorStore constructors = new ConstructorInjectorStore(this);
    MembersInjectorStore membersInjectorStore;
    private final ThreadLocal<Object[]> localContext;

    InjectorImpl(State state, Initializer initializer) {
        this.state = state;
        this.initializer = initializer;
        this.localContext = new ThreadLocal();
    }

    void index() {
        for (Binding<?> binding : this.state.getExplicitBindingsThisLevel().values()) {
            this.index(binding);
        }
    }

    <T> void index(Binding<T> binding) {
        this.bindingsMultimap.put(binding.getKey().getTypeLiteral(), binding);
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return this.bindingsMultimap.getAll(type);
    }

    public <T> BindingImpl<T> getBindingOrThrow(Key<T> key, Errors errors) throws ErrorsException {
        BindingImpl<T> binding = this.state.getExplicitBinding(key);
        if (binding != null) {
            return binding;
        }
        return this.getJustInTimeBinding(key, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BindingImpl<T> getJustInTimeBinding(Key<T> key, Errors errors) throws ErrorsException {
        Object object = this.state.lock();
        synchronized (object) {
            BindingImpl<?> binding = this.jitBindings.get(key);
            if (binding != null) {
                return binding;
            }
            return this.createJustInTimeBindingRecursive(key, errors);
        }
    }

    static boolean isProvider(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(Provider.class);
    }

    static boolean isMembersInjector(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(MembersInjector.class) && !key.hasAnnotationType();
    }

    private <T> BindingImpl<MembersInjector<T>> createMembersInjectorBinding(Key<MembersInjector<T>> key, Errors errors) throws ErrorsException {
        Type membersInjectorType = key.getTypeLiteral().getType();
        if (!(membersInjectorType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawMembersInjector().toException();
        }
        TypeLiteral<?> instanceType = TypeLiteral.get(((ParameterizedType)membersInjectorType).getActualTypeArguments()[0]);
        MembersInjectorImpl<?> membersInjector = this.membersInjectorStore.get(instanceType, errors);
        ConstantFactory factory = new ConstantFactory(Initializables.of(membersInjector));
        return new InstanceBindingImpl<MembersInjector<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, factory, Collections.emptySet(), membersInjector);
    }

    private <T> BindingImpl<Provider<T>> createProviderBinding(Key<Provider<T>> key, Errors errors) throws ErrorsException {
        Type providerType = key.getTypeLiteral().getType();
        if (!(providerType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawProvider().toException();
        }
        Type entryType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
        Key<?> providedKey = key.ofType(entryType);
        BindingImpl<?> delegate = this.getBindingOrThrow(providedKey, errors);
        return new ProviderBindingImpl<T>(this, key, delegate);
    }

    private <T> BindingImpl<T> convertConstantStringBinding(Key<T> key, Errors errors) throws ErrorsException {
        Key<String> stringKey = key.ofType(String.class);
        BindingImpl<String> stringBinding = this.state.getExplicitBinding(stringKey);
        if (stringBinding == null || !stringBinding.isConstant()) {
            return null;
        }
        String stringValue = stringBinding.getProvider().get();
        Object source = stringBinding.getSource();
        TypeLiteral<T> type = key.getTypeLiteral();
        MatcherAndConverter matchingConverter = this.state.getConverter(stringValue, type, errors, source);
        if (matchingConverter == null) {
            return null;
        }
        try {
            Object converted = matchingConverter.getTypeConverter().convert(stringValue, type);
            if (converted == null) {
                throw errors.converterReturnedNull(stringValue, source, type, matchingConverter).toException();
            }
            if (!type.getRawType().isInstance(converted)) {
                throw errors.conversionTypeError(stringValue, source, type, matchingConverter, converted).toException();
            }
            return new ConvertedConstantBindingImpl<Object>(this, key, converted, stringBinding);
        }
        catch (ErrorsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw errors.conversionError(stringValue, source, type, matchingConverter, e).toException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void initializeBinding(BindingImpl<T> binding, Errors errors) throws ErrorsException {
        if (binding instanceof ConstructorBindingImpl) {
            Key<T> key = binding.getKey();
            this.jitBindings.put(key, binding);
            boolean successful = false;
            try {
                ((ConstructorBindingImpl)binding).initialize(this, errors);
                successful = true;
            }
            finally {
                if (!successful) {
                    this.jitBindings.remove(key);
                }
            }
        }
    }

    <T> BindingImpl<T> createUnitializedBinding(Key<T> key, Scoping scoping, Object source, Errors errors) throws ErrorsException {
        Class<? extends Annotation> scopeAnnotation;
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType.isArray() || rawType.isEnum()) {
            throw errors.missingImplementation(key).toException();
        }
        if (rawType == TypeLiteral.class) {
            BindingImpl<TypeLiteral<T>> binding = this.createTypeLiteralBinding(key, errors);
            return binding;
        }
        ImplementedBy implementedBy = rawType.getAnnotation(ImplementedBy.class);
        if (implementedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source, errors);
            return this.createImplementedByBinding(key, scoping, implementedBy, errors);
        }
        ProvidedBy providedBy = rawType.getAnnotation(ProvidedBy.class);
        if (providedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source, errors);
            return this.createProvidedByBinding(key, scoping, providedBy, errors);
        }
        if (Modifier.isAbstract(rawType.getModifiers())) {
            throw errors.missingImplementation(key).toException();
        }
        if (Classes.isInnerClass(rawType)) {
            throw errors.cannotInjectInnerClass(rawType).toException();
        }
        if (!scoping.isExplicitlyScoped() && (scopeAnnotation = Annotations.findScopeAnnotation(errors, rawType)) != null) {
            scoping = Scopes.makeInjectable(Scoping.forAnnotation(scopeAnnotation), this, errors.withSource(rawType));
        }
        return ConstructorBindingImpl.create(this, key, source, scoping);
    }

    private <T> BindingImpl<TypeLiteral<T>> createTypeLiteralBinding(Key<TypeLiteral<T>> key, Errors errors) throws ErrorsException {
        Type typeLiteralType = key.getTypeLiteral().getType();
        if (!(typeLiteralType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawTypeLiteral().toException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)typeLiteralType;
        Type innerType = parameterizedType.getActualTypeArguments()[0];
        if (!(innerType instanceof Class || innerType instanceof GenericArrayType || innerType instanceof ParameterizedType)) {
            throw errors.cannotInjectTypeLiteralOf(innerType).toException();
        }
        TypeLiteral<?> value = TypeLiteral.get(innerType);
        ConstantFactory factory = new ConstantFactory(Initializables.of(value));
        return new InstanceBindingImpl<TypeLiteral<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, factory, Collections.emptySet(), value);
    }

    <T> BindingImpl<T> createProvidedByBinding(Key<T> key, Scoping scoping, ProvidedBy providedBy, Errors errors) throws ErrorsException {
        final Class<T> rawType = key.getTypeLiteral().getRawType();
        final Class<? extends Provider<?>> providerType = providedBy.value();
        if (providerType == rawType) {
            throw errors.recursiveProviderType().toException();
        }
        final Key<? extends Provider<?>> providerKey = Key.get(providerType);
        final BindingImpl<? extends Provider<?>> providerBinding = this.getBindingOrThrow(providerKey, errors);
        InternalFactory internalFactory = new InternalFactory<T>(){

            @Override
            public T get(Errors errors, InternalContext context, Dependency dependency) throws ErrorsException {
                errors = errors.withSource(providerKey);
                Provider provider = (Provider)providerBinding.getInternalFactory().get(errors, context, dependency);
                try {
                    Object o = provider.get();
                    if (o != null && !rawType.isInstance(o)) {
                        throw errors.subtypeNotProvided(providerType, rawType).toException();
                    }
                    Object t = o;
                    return t;
                }
                catch (RuntimeException e) {
                    throw errors.errorInProvider(e).toException();
                }
            }
        };
        return new LinkedProviderBindingImpl<T>(this, key, rawType, Scopes.scope(key, this, internalFactory, scoping), scoping, providerKey);
    }

    <T> BindingImpl<T> createImplementedByBinding(Key<T> key, Scoping scoping, ImplementedBy implementedBy, Errors errors) throws ErrorsException {
        Class<T> rawType = key.getTypeLiteral().getRawType();
        Class<?> implementationType = implementedBy.value();
        if (implementationType == rawType) {
            throw errors.recursiveImplementationType().toException();
        }
        if (!rawType.isAssignableFrom(implementationType)) {
            throw errors.notASubtype(implementationType, rawType).toException();
        }
        Class<?> subclass = implementationType;
        final Key<?> targetKey = Key.get(subclass);
        final BindingImpl<?> targetBinding = this.getBindingOrThrow(targetKey, errors);
        InternalFactory internalFactory = new InternalFactory<T>(){

            @Override
            public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
                return targetBinding.getInternalFactory().get(errors.withSource(targetKey), context, dependency);
            }
        };
        return new LinkedBindingImpl<T>(this, key, rawType, Scopes.scope(key, this, internalFactory, scoping), scoping, targetKey);
    }

    private <T> BindingImpl<T> createJustInTimeBindingRecursive(Key<T> key, Errors errors) throws ErrorsException {
        if (this.state.isDenylisted(key)) {
            throw errors.childBindingAlreadySet(key).toException();
        }
        BindingImpl<T> binding = this.createJustInTimeBinding(key, errors);
        this.state.parent().denylist(key);
        this.jitBindings.put(key, binding);
        return binding;
    }

    <T> BindingImpl<T> createJustInTimeBinding(Key<T> key, Errors errors) throws ErrorsException {
        if (this.state.isDenylisted(key)) {
            throw errors.childBindingAlreadySet(key).toException();
        }
        if (InjectorImpl.isProvider(key)) {
            BindingImpl<Provider<T>> binding = this.createProviderBinding(key, errors);
            return binding;
        }
        if (InjectorImpl.isMembersInjector(key)) {
            BindingImpl<MembersInjector<T>> binding = this.createMembersInjectorBinding(key, errors);
            return binding;
        }
        BindingImpl<Provider<T>> convertedBinding = this.convertConstantStringBinding(key, errors);
        if (convertedBinding != null) {
            return convertedBinding;
        }
        if (key.hasAnnotationType()) {
            if (key.hasAttributes()) {
                try {
                    Errors ignored = new Errors();
                    return this.getBindingOrThrow(key.withoutAttributes(), ignored);
                }
                catch (ErrorsException ignored) {
                    // empty catch block
                }
            }
            throw errors.missingImplementation(key).toException();
        }
        Class<Provider<T>> source = key.getTypeLiteral().getRawType();
        BindingImpl<Provider<T>> binding = this.createUnitializedBinding(key, Scoping.UNSCOPED, source, errors);
        this.initializeBinding(binding, errors);
        return binding;
    }

    <T> InternalFactory<? extends T> getInternalFactory(Key<T> key, Errors errors) throws ErrorsException {
        return this.getBindingOrThrow(key, errors).getInternalFactory();
    }

    SingleParameterInjector<?>[] getParametersInjectors(List<Dependency<?>> parameters, Errors errors) throws ErrorsException {
        if (parameters.isEmpty()) {
            return null;
        }
        int numErrorsBefore = errors.size();
        SingleParameterInjector[] result = new SingleParameterInjector[parameters.size()];
        int i = 0;
        for (Dependency<?> parameter : parameters) {
            try {
                result[i++] = this.createParameterInjector(parameter, errors.withSource(parameter));
            }
            catch (ErrorsException errorsException) {}
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return result;
    }

    <T> SingleParameterInjector<T> createParameterInjector(Dependency<T> dependency, Errors errors) throws ErrorsException {
        InternalFactory<T> factory = this.getInternalFactory(dependency.getKey(), errors);
        return new SingleParameterInjector<T>(dependency, factory);
    }

    @Override
    public void injectMembers(Object instance) {
        MembersInjector<?> membersInjector = this.getMembersInjector(instance.getClass());
        membersInjector.injectMembers(instance);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Errors errors = new Errors(typeLiteral);
        try {
            return this.membersInjectorStore.get(typeLiteral, errors);
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.getMembersInjector(TypeLiteral.get(type));
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    <T> Provider<T> getProviderOrThrow(Key<T> key, Errors errors) throws ErrorsException {
        final InternalFactory<T> factory = this.getInternalFactory(key, errors);
        if (factory instanceof InternalFactory.Instance) {
            return new Provider<T>(){

                @Override
                public T get() {
                    try {
                        return ((InternalFactory.Instance)factory).get(null, null, null);
                    }
                    catch (ErrorsException errorsException) {
                        assert (false);
                        return null;
                    }
                }
            };
        }
        final Dependency<T> dependency = Dependency.get(key);
        return new Provider<T>(){

            @Override
            public T get() {
                final Errors errors = new Errors(dependency);
                try {
                    Object t = InjectorImpl.this.callInContext(new ContextualCallable<T>(){

                        @Override
                        public T call(InternalContext context) throws ErrorsException {
                            context.setDependency(dependency);
                            try {
                                Object t = factory.get(errors, context, dependency);
                                return t;
                            }
                            finally {
                                context.setDependency(null);
                            }
                        }
                    });
                    errors.throwIfNewErrors(0);
                    return t;
                }
                catch (ErrorsException e) {
                    throw new ProvisionException(errors.merge(e.getErrors()).getMessages());
                }
            }

            public String toString() {
                return factory.toString();
            }
        };
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        Errors errors = new Errors(key);
        try {
            Provider<T> result = this.getProviderOrThrow(key, errors);
            errors.throwIfNewErrors(0);
            return result;
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.getProvider(key).get();
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.getProvider(type).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T callInContext(ContextualCallable<T> callable) throws ErrorsException {
        Object[] reference = this.localContext.get();
        if (reference == null) {
            reference = new Object[1];
            this.localContext.set(reference);
        }
        if (reference[0] == null) {
            reference[0] = new InternalContext();
            try {
                T t = callable.call((InternalContext)reference[0]);
                return t;
            }
            finally {
                reference[0] = null;
            }
        }
        return callable.call((InternalContext)reference[0]);
    }

    public String toString() {
        return new ToStringBuilder(Injector.class).add("bindings", this.state.getExplicitBindingsThisLevel().values()).toString();
    }

    public void clearCache() {
        this.state.clearDenylisted();
        this.constructors = new ConstructorInjectorStore(this);
        this.membersInjectorStore = new MembersInjectorStore(this, this.state.getTypeListenerBindings());
        this.jitBindings = new HashMap();
    }

    public void readOnlyAllSingletons() {
        this.readOnly = true;
        this.state.makeAllBindingsToEagerSingletons(this);
        this.bindingsMultimap = new BindingsMultimap();
        this.index();
    }

    static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;
    }

    private static class BindingsMultimap {
        final Map<TypeLiteral<?>, List<Binding<?>>> multimap = new HashMap();

        private BindingsMultimap() {
        }

        <T> void put(TypeLiteral<T> type, Binding<T> binding) {
            List<Binding<?>> bindingsForType = this.multimap.get(type);
            if (bindingsForType == null) {
                bindingsForType = new ArrayList();
                this.multimap.put(type, bindingsForType);
            }
            bindingsForType.add(binding);
        }

        <T> List<Binding<T>> getAll(TypeLiteral<T> type) {
            List<Binding<?>> bindings = this.multimap.get(type);
            return bindings != null ? Collections.unmodifiableList(this.multimap.get(type)) : Collections.emptyList();
        }
    }

    private static class ConvertedConstantBindingImpl<T>
    extends BindingImpl<T>
    implements ConvertedConstantBinding<T> {
        final T value;
        final Provider<T> provider;
        final Binding<String> originalBinding;

        ConvertedConstantBindingImpl(Injector injector, Key<T> key, T value, Binding<String> originalBinding) {
            super(injector, key, originalBinding.getSource(), new ConstantFactory<T>(Initializables.of(value)), Scoping.UNSCOPED);
            this.value = value;
            this.provider = Providers.of(value);
            this.originalBinding = originalBinding;
        }

        @Override
        public Provider<T> getProvider() {
            return this.provider;
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public Key<String> getSourceKey() {
            return this.originalBinding.getKey();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return Collections.singleton(Dependency.get(this.getSourceKey()));
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return new ToStringBuilder(ConvertedConstantBinding.class).add("key", this.getKey()).add("sourceKey", this.getSourceKey()).add("value", this.value).toString();
        }
    }

    static class ProviderBindingImpl<T>
    extends BindingImpl<Provider<T>>
    implements ProviderBinding<Provider<T>> {
        final BindingImpl<T> providedBinding;

        ProviderBindingImpl(InjectorImpl injector, Key<Provider<T>> key, Binding<T> providedBinding) {
            super(injector, key, providedBinding.getSource(), ProviderBindingImpl.createInternalFactory(providedBinding), Scoping.UNSCOPED);
            this.providedBinding = (BindingImpl)providedBinding;
        }

        static <T> InternalFactory<Provider<T>> createInternalFactory(Binding<T> providedBinding) {
            final Provider<T> provider = providedBinding.getProvider();
            return new InternalFactory<Provider<T>>(){

                @Override
                public Provider<T> get(Errors errors, InternalContext context, Dependency dependency) {
                    return provider;
                }
            };
        }

        @Override
        public Key<? extends T> getProvidedKey() {
            return this.providedBinding.getKey();
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super Provider<T>, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return new ToStringBuilder(ProviderKeyBinding.class).add("key", this.getKey()).add("providedKey", this.getProvidedKey()).toString();
        }
    }
}

