/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;

public class VectorField
extends Field {
    public VectorField(String name, float[] value, IndexableFieldType type) {
        super(name, new BytesRef(), type);
        try {
            KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getDefaultSerializer();
            byte[] floatToByte = vectorSerializer.floatToByteArray(value);
            this.setBytesValue(floatToByte);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

