/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.opensearch.notifications.core.repackage.com.amazonaws.services.simpleemail.model.SNSAction;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.StaxUnmarshallerContext;
import org.opensearch.notifications.core.repackage.com.amazonaws.transform.Unmarshaller;

public class SNSActionStaxUnmarshaller
implements Unmarshaller<SNSAction, StaxUnmarshallerContext> {
    private static SNSActionStaxUnmarshaller instance;

    @Override
    public SNSAction unmarshall(StaxUnmarshallerContext context) throws Exception {
        SNSAction sNSAction = new SNSAction();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sNSAction;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicArn", targetDepth)) {
                    sNSAction.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Encoding", targetDepth)) continue;
                sNSAction.setEncoding(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sNSAction;
    }

    public static SNSActionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SNSActionStaxUnmarshaller();
        }
        return instance;
    }
}

