/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.summaries;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.grpc.FlowUnitMessage;
import org.opensearch.performanceanalyzer.grpc.HotResourceSummaryMessage;
import org.opensearch.performanceanalyzer.grpc.Resource;
import org.opensearch.performanceanalyzer.grpc.TopConsumerSummaryMessage;
import org.opensearch.performanceanalyzer.rca.framework.api.persist.JooqFieldValue;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.ResourceUtil;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.TopConsumerSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.GenericSummary;

public class HotResourceSummary
extends GenericSummary {
    public static final String HOT_RESOURCE_SUMMARY_TABLE = HotResourceSummary.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(HotResourceSummary.class);
    private final Resource resource;
    private double threshold;
    private double value;
    private double avgValue;
    private double minValue;
    private double maxValue;
    private int timePeriod;
    private String metaData;
    private List<TopConsumerSummary> topConsumerSummaryList;

    public HotResourceSummary(Resource resource, double threshold, double value, int timePeriod) {
        this.resource = resource;
        this.threshold = threshold;
        this.value = value;
        this.avgValue = Double.NaN;
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        this.timePeriod = timePeriod;
        this.metaData = "";
        this.topConsumerSummaryList = new ArrayList<TopConsumerSummary>();
    }

    public HotResourceSummary(Resource resource, double threshold, double value, int timePeriod, String metaData) {
        this.resource = resource;
        this.threshold = threshold;
        this.value = value;
        this.avgValue = Double.NaN;
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        this.timePeriod = timePeriod;
        this.metaData = metaData;
        this.topConsumerSummaryList = new ArrayList<TopConsumerSummary>();
    }

    public void setValueDistribution(double minValue, double maxValue, double avgValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.avgValue = avgValue;
    }

    public Resource getResource() {
        return this.resource;
    }

    public double getValue() {
        return this.value;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getTimePeriod() {
        return this.timePeriod;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public List<TopConsumerSummary> getTopConsumerSummaryList() {
        return this.topConsumerSummaryList;
    }

    public void appendNestedSummary(TopConsumerSummary summary) {
        this.topConsumerSummaryList.add(summary);
    }

    public HotResourceSummaryMessage buildSummaryMessage() {
        HotResourceSummaryMessage.Builder summaryMessageBuilder = HotResourceSummaryMessage.newBuilder();
        summaryMessageBuilder.setResource(this.resource);
        summaryMessageBuilder.setThreshold(this.threshold);
        summaryMessageBuilder.setValue(this.value);
        summaryMessageBuilder.setAvgValue(this.avgValue);
        summaryMessageBuilder.setMinValue(this.minValue);
        summaryMessageBuilder.setMaxValue(this.maxValue);
        summaryMessageBuilder.setTimePeriod(this.timePeriod);
        summaryMessageBuilder.setMetaData(this.metaData);
        for (GenericSummary nestedSummary : this.getNestedSummaryList()) {
            summaryMessageBuilder.getConsumersBuilder().addConsumer((TopConsumerSummaryMessage)nestedSummary.buildSummaryMessage());
        }
        return summaryMessageBuilder.build();
    }

    @Override
    public void buildSummaryMessageAndAddToFlowUnit(FlowUnitMessage.Builder messageBuilder) {
        messageBuilder.setHotResourceSummary(this.buildSummaryMessage());
    }

    public static HotResourceSummary buildHotResourceSummaryFromMessage(HotResourceSummaryMessage message) {
        HotResourceSummary newSummary = new HotResourceSummary(message.getResource(), message.getThreshold(), message.getValue(), message.getTimePeriod());
        newSummary.setValueDistribution(message.getMinValue(), message.getMaxValue(), message.getAvgValue());
        if (message.hasConsumers()) {
            for (int i = 0; i < message.getConsumers().getConsumerCount(); ++i) {
                newSummary.appendNestedSummary(TopConsumerSummary.buildTopConsumerSummaryFromMessage(message.getConsumers().getConsumer(i)));
            }
        }
        return newSummary;
    }

    public String toString() {
        return ResourceUtil.getResourceTypeName(this.resource) + " " + ResourceUtil.getResourceMetricName(this.resource) + " " + this.threshold + " " + this.value + " " + this.topConsumerSummaryList + " " + this.metaData;
    }

    @Override
    public String getTableName() {
        return HOT_RESOURCE_SUMMARY_TABLE;
    }

    @Override
    public List<Field<?>> getSqlSchema() {
        ArrayList schema = new ArrayList();
        schema.add(ResourceSummaryField.RESOURCE_TYPE_FIELD.getField());
        schema.add(ResourceSummaryField.RESOURCE_METRIC_FIELD.getField());
        schema.add(ResourceSummaryField.THRESHOLD_FIELD.getField());
        schema.add(ResourceSummaryField.VALUE_FIELD.getField());
        schema.add(ResourceSummaryField.AVG_VALUE_FIELD.getField());
        schema.add(ResourceSummaryField.MIN_VALUE_FIELD.getField());
        schema.add(ResourceSummaryField.MAX_VALUE_FIELD.getField());
        schema.add(ResourceSummaryField.TIME_PERIOD_FIELD.getField());
        schema.add(ResourceSummaryField.METADATA_FIELD.getField());
        return schema;
    }

    @Override
    public List<Object> getSqlValue() {
        ArrayList<Object> value = new ArrayList<Object>();
        value.add(this.resource.getResourceEnumValue());
        value.add(this.resource.getMetricEnumValue());
        value.add(this.threshold);
        value.add(this.value);
        value.add(this.avgValue);
        value.add(this.minValue);
        value.add(this.maxValue);
        value.add(this.timePeriod);
        value.add(this.metaData);
        return value;
    }

    @Override
    public JsonElement toJson() {
        JsonObject summaryObj = new JsonObject();
        summaryObj.addProperty("resource_type", ResourceUtil.getResourceTypeName(this.resource));
        summaryObj.addProperty("resource_metric", ResourceUtil.getResourceMetricName(this.resource));
        summaryObj.addProperty("threshold", (Number)this.threshold);
        summaryObj.addProperty("value", (Number)this.value);
        summaryObj.addProperty("avg", (Number)this.avgValue);
        summaryObj.addProperty("min", (Number)this.minValue);
        summaryObj.addProperty("max", (Number)this.maxValue);
        summaryObj.addProperty("time_period_seconds", (Number)this.timePeriod);
        summaryObj.addProperty("meta_data", this.metaData);
        if (!this.getNestedSummaryList().isEmpty()) {
            String tableName = this.getNestedSummaryList().get(0).getTableName();
            summaryObj.add(tableName, (JsonElement)this.nestedSummaryListToJson());
        }
        return summaryObj;
    }

    @Override
    public List<GenericSummary> getNestedSummaryList() {
        return new ArrayList<GenericSummary>(this.topConsumerSummaryList);
    }

    @Override
    public GenericSummary buildNestedSummary(String summaryTable, Record record) throws IllegalArgumentException {
        if (summaryTable.equals(TopConsumerSummary.TOP_CONSUMER_SUMMARY_TABLE)) {
            TopConsumerSummary topConsumerSummary = TopConsumerSummary.buildSummary(record);
            if (topConsumerSummary != null) {
                this.topConsumerSummaryList.add(topConsumerSummary);
            }
            return topConsumerSummary;
        }
        throw new IllegalArgumentException(summaryTable + " does not belong to the nested summaries of " + this.getTableName());
    }

    @Override
    public List<String> getNestedSummaryTables() {
        return Collections.unmodifiableList(Collections.singletonList(TopConsumerSummary.TOP_CONSUMER_SUMMARY_TABLE));
    }

    @Nullable
    public static HotResourceSummary buildSummary(Record record) {
        if (record == null) {
            return null;
        }
        HotResourceSummary summary = null;
        try {
            int resourceTypeEnumVal = (Integer)record.get(ResourceSummaryField.RESOURCE_TYPE_FIELD.getField(), Integer.class);
            int resourceMetricEnumVal = (Integer)record.get(ResourceSummaryField.RESOURCE_METRIC_FIELD.getField(), Integer.class);
            Double threshold = (Double)record.get(ResourceSummaryField.THRESHOLD_FIELD.getField(), Double.class);
            Double value = (Double)record.get(ResourceSummaryField.VALUE_FIELD.getField(), Double.class);
            Double avgValue = (Double)record.get(ResourceSummaryField.AVG_VALUE_FIELD.getField(), Double.class);
            Double minValue = (Double)record.get(ResourceSummaryField.MIN_VALUE_FIELD.getField(), Double.class);
            Double maxValue = (Double)record.get(ResourceSummaryField.MAX_VALUE_FIELD.getField(), Double.class);
            Integer timePeriod = (Integer)record.get(ResourceSummaryField.TIME_PERIOD_FIELD.getField(), Integer.class);
            String metaData = (String)record.get(ResourceSummaryField.METADATA_FIELD.getField(), String.class);
            if (threshold == null || value == null || timePeriod == null) {
                LOG.warn("read null object from SQL, threshold: {}, value: {}, timePeriod: {}", (Object)threshold, (Object)value, (Object)timePeriod);
                return null;
            }
            summary = new HotResourceSummary(ResourceUtil.buildResource(resourceTypeEnumVal, resourceMetricEnumVal), threshold, value, timePeriod, metaData);
            if (avgValue != null && minValue != null && maxValue != null) {
                summary.setValueDistribution(minValue, maxValue, avgValue);
            }
        }
        catch (IllegalArgumentException ie) {
            LOG.error("Some fields might not be found in record, cause : {}", (Object)ie.getMessage());
        }
        catch (DataTypeException de) {
            LOG.error("Fails to convert data type");
        }
        return summary;
    }

    public static enum ResourceSummaryField implements JooqFieldValue
    {
        RESOURCE_TYPE_FIELD("resource_type", Integer.class),
        RESOURCE_METRIC_FIELD("resource_metric", Integer.class),
        THRESHOLD_FIELD("threshold", Double.class),
        VALUE_FIELD("value", Double.class),
        AVG_VALUE_FIELD("avg", Double.class),
        MIN_VALUE_FIELD("min", Double.class),
        MAX_VALUE_FIELD("max", Double.class),
        TIME_PERIOD_FIELD("time_period_seconds", Integer.class),
        METADATA_FIELD("meta_data", String.class);

        private String name;
        private Class<?> clazz;

        private ResourceSummaryField(String name, Class<?> clazz) {
            this.name = name;
            this.clazz = clazz;
        }

        public Field<?> getField() {
            return DSL.field((Name)DSL.name((String)this.name), this.clazz);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class SQL_SCHEMA_CONSTANTS {
        public static final String RESOURCE_TYPE_COL_NAME = "resource_type";
        public static final String RESOURCE_METRIC_COL_NAME = "resource_metric";
        public static final String THRESHOLD_COL_NAME = "threshold";
        public static final String VALUE_COL_NAME = "value";
        public static final String AVG_VALUE_COL_NAME = "avg";
        public static final String MIN_VALUE_COL_NAME = "min";
        public static final String MAX_VALUE_COL_NAME = "max";
        public static final String TIME_PERIOD_COL_NAME = "time_period_seconds";
        public static final String META_DATA_COL_NAME = "meta_data";
    }
}

