/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.store.rca.temperature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.api.Rca;
import org.opensearch.performanceanalyzer.rca.framework.api.Resources;
import org.opensearch.performanceanalyzer.rca.framework.api.contexts.ResourceContext;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.temperature.ClusterTemperatureFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.flow_units.temperature.CompactNodeTemperatureFlowUnit;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.ClusterTemperatureSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactClusterLevelNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.api.summaries.temperature.CompactNodeSummary;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureDimension;
import org.opensearch.performanceanalyzer.rca.framework.core.temperature.TemperatureVector;
import org.opensearch.performanceanalyzer.rca.scheduler.FlowUnitOperationArgWrapper;
import org.opensearch.performanceanalyzer.rca.store.rca.temperature.NodeTemperatureRca;

public class ClusterTemperatureRca
extends Rca<ClusterTemperatureFlowUnit> {
    private final NodeTemperatureRca nodeTemperatureRca;
    public static final String TABLE_NAME = ClusterTemperatureRca.class.getSimpleName();
    private static final Logger LOG = LogManager.getLogger(ClusterTemperatureRca.class);

    public ClusterTemperatureRca(NodeTemperatureRca nodeTemperatureRca) {
        super(5L);
        this.nodeTemperatureRca = nodeTemperatureRca;
    }

    @Override
    public void generateFlowUnitListFromWire(FlowUnitOperationArgWrapper args) {
        throw new IllegalArgumentException(this.name() + "'s generateFlowUnitListFromWire() should not be required.");
    }

    @Override
    public ClusterTemperatureFlowUnit operate() {
        List<CompactNodeTemperatureFlowUnit> flowUnitsAcrossNodes = this.nodeTemperatureRca.getFlowUnits();
        if (flowUnitsAcrossNodes.size() < 1) {
            LOG.debug("Empty flowUnitsAcrossNodes");
            return new ClusterTemperatureFlowUnit(System.currentTimeMillis());
        }
        AtomicBoolean emptyFlowUnit = new AtomicBoolean(false);
        flowUnitsAcrossNodes.forEach(flowUnitForOneNode -> {
            if (flowUnitForOneNode.isEmpty()) {
                LOG.debug("Empty flowUnitAcrossOneDimension");
                emptyFlowUnit.set(true);
            } else {
                emptyFlowUnit.set(false);
            }
        });
        if (emptyFlowUnit.get()) {
            return new ClusterTemperatureFlowUnit(System.currentTimeMillis());
        }
        LOG.error("Number of dataNode Instances in the cluster {}", (Object)this.getDataNodeInstances().size());
        if (flowUnitsAcrossNodes.size() > this.getDataNodeInstances().size()) {
            LOG.error("Extra flowUnitsAcrossNodes Received {}", (Object)flowUnitsAcrossNodes.toString());
            return new ClusterTemperatureFlowUnit(System.currentTimeMillis());
        }
        HashMap<String, CompactClusterLevelNodeSummary> nodeTemperatureSummaryMap = new HashMap<String, CompactClusterLevelNodeSummary>();
        int TOTAL_NODES_IN_CLUSTER = flowUnitsAcrossNodes.size();
        ClusterTemperatureSummary clusterTemperatureSummary = new ClusterTemperatureSummary(TOTAL_NODES_IN_CLUSTER);
        for (TemperatureDimension dimension : TemperatureDimension.values()) {
            double totalUsageInClusterForDimension = 0.0;
            boolean allFlowUnitSummariesNull = true;
            for (CompactNodeTemperatureFlowUnit nodeFlowUnit : flowUnitsAcrossNodes) {
                CompactNodeSummary summary = nodeFlowUnit.getCompactNodeTemperatureSummary();
                if (summary == null) continue;
                totalUsageInClusterForDimension += summary.getTotalConsumedByDimension(dimension);
                allFlowUnitSummariesNull = false;
            }
            if (allFlowUnitSummariesNull) continue;
            double nodeAverageForDimension = totalUsageInClusterForDimension / (double)TOTAL_NODES_IN_CLUSTER;
            TemperatureVector.NormalizedValue normalizedAvgForDimension = TemperatureVector.NormalizedValue.calculate(nodeAverageForDimension, totalUsageInClusterForDimension);
            clusterTemperatureSummary.createClusterDimensionalTemperature(dimension, normalizedAvgForDimension, totalUsageInClusterForDimension);
            this.recalibrateNodeTemperaturesAtClusterLevelUsage(flowUnitsAcrossNodes, nodeTemperatureSummaryMap, dimension, totalUsageInClusterForDimension);
        }
        clusterTemperatureSummary.addNodesSummaries(nodeTemperatureSummaryMap);
        return new ClusterTemperatureFlowUnit(System.currentTimeMillis(), new ResourceContext(Resources.State.UNKNOWN), clusterTemperatureSummary);
    }

    private void recalibrateNodeTemperaturesAtClusterLevelUsage(List<CompactNodeTemperatureFlowUnit> flowUnitsAcrossNodes, Map<String, CompactClusterLevelNodeSummary> nodeTemperatureSummaryMap, TemperatureDimension dimension, double totalForDimension) {
        for (CompactNodeTemperatureFlowUnit nodeFlowUnit : flowUnitsAcrossNodes) {
            CompactNodeSummary obtainedNodeTempSummary = nodeFlowUnit.getCompactNodeTemperatureSummary();
            if (obtainedNodeTempSummary == null) continue;
            String key = obtainedNodeTempSummary.getNodeId();
            nodeTemperatureSummaryMap.putIfAbsent(key, new CompactClusterLevelNodeSummary(obtainedNodeTempSummary.getNodeId(), obtainedNodeTempSummary.getHostAddress()));
            CompactClusterLevelNodeSummary constructedCompactNodeTemperatureSummary = nodeTemperatureSummaryMap.get(key);
            double obtainedTotal = obtainedNodeTempSummary.getTotalConsumedByDimension(dimension);
            TemperatureVector.NormalizedValue newClusterBasedValue = TemperatureVector.NormalizedValue.calculate(obtainedTotal, totalForDimension);
            constructedCompactNodeTemperatureSummary.setTemperatureForDimension(dimension, newClusterBasedValue);
            constructedCompactNodeTemperatureSummary.setNumOfShards(dimension, obtainedNodeTempSummary.getNumberOfShardsByDimension(dimension));
            constructedCompactNodeTemperatureSummary.setTotalConsumedByDimension(dimension, obtainedTotal);
        }
    }
}

