/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.Removable;

public class OSMetricsSnapshot
implements Removable {
    private static final Logger LOG = LogManager.getLogger(OSMetricsSnapshot.class);
    private final DSLContext create;
    private final String tableName;
    private Set<String> dimensionColumns;
    private static final String LAST_UPDATE_TIME_FIELD = "lastUpdateTime";
    private static final LinkedHashSet<String> METRIC_COLUMNS = new LinkedHashSet();

    public DSLContext getDSLContext() {
        return this.create;
    }

    public OSMetricsSnapshot(Connection conn, String tableNamePrefix, Long windowEndTime) {
        this.tableName = tableNamePrefix + windowEndTime;
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.dimensionColumns = new LinkedHashSet<String>(){
            {
                this.add(Fields.tid.toString());
                this.add(Fields.tName.toString());
            }
        };
        LOG.debug("Creating a new os snapshot table - {}", (Object)this.tableName);
        this.create.createTable(this.tableName).columns(this.getFields()).execute();
    }

    public OSMetricsSnapshot(Connection conn, Long windowEndTime) {
        this(conn, "os_", windowEndTime);
    }

    public void putMetric(Map<String, Double> metrics, Map<String, String> dimensions, long updateTime) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        HashMap<Field, Double> metricMap = new HashMap<Field, Double>();
        HashMap<Field, Long> updateTimeMap = new HashMap<Field, Long>();
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)entry.getKey()), String.class), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : metrics.entrySet()) {
            metricMap.put(DSL.field((Name)DSL.name((String)entry.getKey()), Double.class), (Double)entry.getValue());
        }
        updateTimeMap.put(DSL.field((String)LAST_UPDATE_TIME_FIELD, Long.class), updateTime);
        this.create.insertInto(DSL.table((String)this.tableName)).set(metricMap).set(dimensionMap).set(updateTimeMap).execute();
    }

    public void putMetric(Map<String, Double> metrics, String tid, String tName) {
        HashMap<Field, Double> metricMap = new HashMap<Field, Double>();
        for (Map.Entry<String, Double> metricName : metrics.entrySet()) {
            metricMap.put(DSL.field((Name)DSL.name((String)metricName.getKey()), Double.class), metricName.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((String)Fields.tid.toString()), (Object)tid).set(DSL.field((String)Fields.tName.toString()), (Object)tName).set(metricMap).execute();
    }

    public BatchBindStep startBatchPut() {
        int i;
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (i = 0; i < this.dimensionColumns.size(); ++i) {
            dummyValues.add(null);
        }
        for (i = 0; i < METRIC_COLUMNS.size(); ++i) {
            dummyValues.add(null);
        }
        dummyValues.add(null);
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public void deleteByTid(List<String> tids) {
        this.create.delete(DSL.table((String)this.tableName)).where(new Condition[]{DSL.field((String)Fields.tid.name(), String.class).in(tids)}).execute();
    }

    public List<Field<?>> getMetricColumnFields() {
        return METRIC_COLUMNS.stream().map(s -> DSL.field((String)s, Double.class)).collect(Collectors.toList());
    }

    public String getTableName() {
        return this.tableName;
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    public Result<Record> fetchNegative() {
        return this.create.select(new SelectField[0]).from((TableLike)DSL.table((String)this.tableName)).where(new Condition[]{DSL.field((String)AllMetrics.OSMetrics.CPU_UTILIZATION.toString()).lt((Object)0L)}).fetch();
    }

    public SelectHavingStep<Record> selectAll() {
        return this.create.select(this.getFields()).from(this.tableName);
    }

    @Override
    public void remove() {
        LOG.debug("Dropping {}", (Object)this.tableName);
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public void logSnap() {
        LOG.debug(() -> this.getDebugSnap());
    }

    public Result<?> getDebugSnap() {
        return this.create.select((SelectField)DSL.field((String)Fields.tid.toString()).as(Fields.tid.toString()), (SelectField)DSL.field((String)Fields.tName.toString()).as(Fields.tName.toString()), (SelectField)DSL.field((String)AllMetrics.OSMetrics.CPU_UTILIZATION.toString()), (SelectField)DSL.field((String)AllMetrics.OSMetrics.PAGING_MIN_FLT_RATE.toString())).from(this.tableName).where(new Condition[]{DSL.field((String)AllMetrics.OSMetrics.CPU_UTILIZATION.toString(), Double.class).ne((Object)0.0)}).fetch();
    }

    public Result<Record> getOSMetrics() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(DSL.field((String)Fields.tid.toString()).as(Fields.tid.toString()));
        fields.add(DSL.field((String)Fields.tName.toString()).as(Fields.tName.toString()));
        for (String metricColumn : METRIC_COLUMNS) {
            fields.add(DSL.field((String)metricColumn, Double.class).as(metricColumn));
        }
        return this.create.select(fields).from(this.tableName).fetch();
    }

    public Map<String, Long> getLastUpdateTimePerTid() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(DSL.field((String)Fields.tid.name()).as(Fields.tid.name()));
        fields.add(DSL.field((String)LAST_UPDATE_TIME_FIELD).as(LAST_UPDATE_TIME_FIELD));
        Result ret = this.create.select(fields).from(this.tableName).fetch();
        HashMap<String, Long> lastUpdateTimePerTid = new HashMap<String, Long>();
        for (int i = 0; i < ret.size(); ++i) {
            lastUpdateTimePerTid.put(((Record)ret.get(i)).get(Fields.tid.name()).toString(), Long.parseLong(((Record)ret.get(i)).get(LAST_UPDATE_TIME_FIELD).toString()));
        }
        return lastUpdateTimePerTid;
    }

    public static void alignWindow(OSMetricsSnapshot leftWindow, OSMetricsSnapshot rightWindow, String alignedWindow, long a, long b) {
        DSLContext create = leftWindow.getDSLContext();
        String leftPrefix = "l_";
        String rightPrefix = "r_";
        SelectHavingStep<Record> alignWindow = OSMetricsSnapshot.selectAlignWindow(create, leftWindow.tableName, rightWindow.tableName, leftPrefix, rightPrefix);
        create.insertInto(DSL.table((String)alignedWindow)).select((Select)OSMetricsSnapshot.selectFieldsHasLeftAndRight(create, leftPrefix, rightPrefix, a, b, alignWindow).unionAll(OSMetricsSnapshot.selectFieldsHasLeftOnly(create, leftPrefix, rightPrefix, alignWindow)).unionAll(OSMetricsSnapshot.selectFieldsHasRightOnly(create, leftPrefix, rightPrefix, alignWindow))).execute();
    }

    private static SelectHavingStep<Record> selectFieldsHasLeftAndRight(DSLContext create, String leftPrefix, String rightPrefix, long a, long b, SelectHavingStep<Record> alignWindow) {
        ArrayList<Field> fieldsHasLeftAndRight = new ArrayList<Field>();
        fieldsHasLeftAndRight.add(DSL.field((String)Fields.tid.name()).as(Fields.tid.name()));
        fieldsHasLeftAndRight.add(DSL.field((String)Fields.tName.name()).as(Fields.tName.name()));
        for (String metricName : METRIC_COLUMNS) {
            fieldsHasLeftAndRight.add(DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD), Long.class).sub((Number)a).mul(DSL.field((String)(leftPrefix + metricName), Double.class)).add(DSL.val((long)b).sub(DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD), Long.class)).mul(DSL.field((String)(rightPrefix + metricName), Double.class))).div((Number)(b - a)).as(metricName));
        }
        fieldsHasLeftAndRight.add(DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD)).as(LAST_UPDATE_TIME_FIELD));
        Condition conditionHasLeftAndRight = DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD), Long.class).isNotNull().and(DSL.field((String)(rightPrefix + LAST_UPDATE_TIME_FIELD), Long.class).isNotNull());
        return create.select(fieldsHasLeftAndRight).from(alignWindow).where(new Condition[]{conditionHasLeftAndRight});
    }

    private static SelectHavingStep<Record> selectFieldsHasLeftOnly(DSLContext create, String leftPrefix, String rightPrefix, SelectHavingStep<Record> alignWindow) {
        ArrayList<Field> fieldsHasLeftOnly = new ArrayList<Field>();
        fieldsHasLeftOnly.add(DSL.field((String)Fields.tid.name()).as(Fields.tid.name()));
        fieldsHasLeftOnly.add(DSL.field((String)Fields.tName.name()).as(Fields.tName.name()));
        for (String metricName : METRIC_COLUMNS) {
            fieldsHasLeftOnly.add(DSL.field((String)(leftPrefix + metricName), Double.class).as(metricName));
        }
        fieldsHasLeftOnly.add(DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD)).as(LAST_UPDATE_TIME_FIELD));
        Condition conditionHasLeftOnly = DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD), Long.class).isNotNull().and(DSL.field((String)(rightPrefix + LAST_UPDATE_TIME_FIELD), Long.class).isNull());
        return create.select(fieldsHasLeftOnly).from(alignWindow).where(new Condition[]{conditionHasLeftOnly});
    }

    private static SelectHavingStep<Record> selectFieldsHasRightOnly(DSLContext create, String leftPrefix, String rightPrefix, SelectHavingStep<Record> alignWindow) {
        ArrayList<Field> fieldsHasRightOnly = new ArrayList<Field>();
        fieldsHasRightOnly.add(DSL.field((String)Fields.tid.name()).as(Fields.tid.name()));
        fieldsHasRightOnly.add(DSL.field((String)Fields.tName.name()).as(Fields.tName.name()));
        for (String metricName : METRIC_COLUMNS) {
            fieldsHasRightOnly.add(DSL.field((String)(rightPrefix + metricName), Double.class).as(metricName));
        }
        fieldsHasRightOnly.add(DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD)).as(LAST_UPDATE_TIME_FIELD));
        Condition conditionHasRightOnly = DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD), Long.class).isNull().and(DSL.field((String)(rightPrefix + LAST_UPDATE_TIME_FIELD), Long.class).isNotNull());
        return create.select(fieldsHasRightOnly).from(alignWindow).where(new Condition[]{conditionHasRightOnly});
    }

    private static SelectHavingStep<Record> selectAlignWindow(DSLContext create, String leftTableName, String rightTableName, String leftPrefix, String rightPrefix) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(DSL.field((String)Fields.tid.name(), String.class).as(Fields.tid.name()));
        fields.add(DSL.field((String)Fields.tName.name(), String.class).as(Fields.tName.name()));
        fields.add(DSL.max((Field)DSL.field((String)(leftPrefix + LAST_UPDATE_TIME_FIELD), Long.class)).as(leftPrefix + LAST_UPDATE_TIME_FIELD));
        for (String c : METRIC_COLUMNS) {
            fields.add(DSL.max((Field)DSL.field((String)(leftPrefix + c), Double.class)).as(leftPrefix + c));
        }
        fields.add(DSL.max((Field)DSL.field((String)(rightPrefix + LAST_UPDATE_TIME_FIELD), Long.class)).as(rightPrefix + LAST_UPDATE_TIME_FIELD));
        for (String c : METRIC_COLUMNS) {
            fields.add(DSL.max((Field)DSL.field((String)(rightPrefix + c), Double.class)).as(rightPrefix + c));
        }
        return create.select(fields).from((TableLike)OSMetricsSnapshot.selectAlignWindowFromLeft(create, leftTableName, leftPrefix, rightPrefix).unionAll(OSMetricsSnapshot.selectAlignWindowFromRight(create, rightTableName, leftPrefix, rightPrefix))).groupBy(new GroupField[]{DSL.field((String)Fields.tid.name(), String.class)});
    }

    private static SelectHavingStep<Record> selectAlignWindowFromLeft(DSLContext create, String tableName, String leftPrefix, String rightPrefix) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(DSL.field((String)Fields.tid.name(), String.class).as(Fields.tid.name()));
        fields.add(DSL.field((String)Fields.tName.name(), String.class).as(Fields.tName.name()));
        fields.add(DSL.field((String)LAST_UPDATE_TIME_FIELD, Long.class).as(leftPrefix + LAST_UPDATE_TIME_FIELD));
        for (String c : METRIC_COLUMNS) {
            fields.add(DSL.field((String)c, Double.class).as(leftPrefix + c));
        }
        fields.add(DSL.val(null, Long.class).as(rightPrefix + LAST_UPDATE_TIME_FIELD));
        for (String c : METRIC_COLUMNS) {
            fields.add(DSL.val(null, Double.class).as(rightPrefix + c));
        }
        return create.select(fields).from(tableName);
    }

    private static SelectHavingStep<Record> selectAlignWindowFromRight(DSLContext create, String tableName, String leftPrefix, String rightPrefix) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(DSL.field((String)Fields.tid.name(), String.class).as(Fields.tid.name()));
        fields.add(DSL.field((String)Fields.tName.name(), String.class).as(Fields.tName.name()));
        fields.add(DSL.val(null, Long.class).as(leftPrefix + LAST_UPDATE_TIME_FIELD));
        for (String c : METRIC_COLUMNS) {
            fields.add(DSL.val(null, Double.class).as(leftPrefix + c));
        }
        fields.add(DSL.field((String)LAST_UPDATE_TIME_FIELD, Long.class).as(rightPrefix + LAST_UPDATE_TIME_FIELD));
        for (String c : METRIC_COLUMNS) {
            fields.add(DSL.field((String)c, Double.class).as(rightPrefix + c));
        }
        return create.select(fields).from(tableName);
    }

    public List<Field<?>> getFields() {
        ArrayList fields = new ArrayList();
        for (String dimension : this.dimensionColumns) {
            fields.add(DSL.field((String)dimension, String.class));
        }
        for (String metric : METRIC_COLUMNS) {
            fields.add(DSL.field((String)metric, Double.class));
        }
        fields.add(DSL.field((Name)DSL.name((String)LAST_UPDATE_TIME_FIELD), Long.class));
        return fields;
    }

    public Set<String> getMetricColumns() {
        return METRIC_COLUMNS;
    }

    static {
        for (AllMetrics.OSMetrics metric : AllMetrics.OSMetrics.values()) {
            METRIC_COLUMNS.add(metric.toString());
        }
    }

    public static enum Fields {
        tid,
        tName,
        weight;

    }
}

