/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.azure.core.implementation.http.HttpHeadersHelper;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class RequestIdPolicy
implements HttpPipelinePolicy {
    private static final String REQUEST_ID_HEADER = "x-ms-client-request-id";
    private final String requestIdHeaderName;
    private final String requestIdHeaderNameLowerCase;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext context) {
            HttpHeaders headers = context.getHttpRequest().getHeaders();
            String requestId = HttpHeadersHelper.getValueNoKeyFormatting(headers, RequestIdPolicy.this.requestIdHeaderNameLowerCase);
            if (requestId == null) {
                HttpHeadersHelper.setNoKeyFormatting(headers, RequestIdPolicy.this.requestIdHeaderNameLowerCase, RequestIdPolicy.this.requestIdHeaderName, UUID.randomUUID().toString());
            }
        }
    };

    public RequestIdPolicy(String requestIdHeaderName) {
        this.requestIdHeaderName = Objects.requireNonNull(requestIdHeaderName, "requestIdHeaderName can not be null.");
        this.requestIdHeaderNameLowerCase = requestIdHeaderName.toLowerCase(Locale.ROOT);
    }

    public RequestIdPolicy() {
        this.requestIdHeaderName = REQUEST_ID_HEADER;
        this.requestIdHeaderNameLowerCase = REQUEST_ID_HEADER;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.inner.process(context, next);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.inner.processSync(context, next);
    }
}

