/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.RestStatus;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.ssl.SecurityKeyStore;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class SecuritySSLCertsInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/ssl/certs")));
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private Settings settings;
    private SecurityKeyStore odsks;
    private AdminDNs adminDns;
    private ThreadContext threadContext;

    public SecuritySSLCertsInfoAction(Settings settings, RestController restController, SecurityKeyStore odsks, ThreadPool threadPool, AdminDNs adminDns) {
        this.settings = settings;
        this.odsks = odsks;
        this.adminDns = adminDns;
        this.threadContext = threadPool.getThreadContext();
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                BytesRestResponse response = null;
                User user = (User)SecuritySSLCertsInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                if (user == null || !SecuritySSLCertsInfoAction.this.adminDns.isAdmin(user)) {
                    response = new BytesRestResponse(RestStatus.FORBIDDEN, builder);
                } else {
                    try {
                        if (SecuritySSLCertsInfoAction.this.odsks != null) {
                            builder.startObject();
                            builder.field("http_certificates_list", this.generateCertDetailList(SecuritySSLCertsInfoAction.this.odsks.getHttpCerts()));
                            builder.field("transport_certificates_list", this.generateCertDetailList(SecuritySSLCertsInfoAction.this.odsks.getTransportCerts()));
                            builder.endObject();
                            response = new BytesRestResponse(RestStatus.OK, builder);
                        } else {
                            builder.startObject();
                            builder.field("message", "keystore is not initialized");
                            builder.endObject();
                            response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                        }
                    }
                    catch (Exception e1) {
                        SecuritySSLCertsInfoAction.this.log.error("Error handle request ", (Throwable)e1);
                        builder = channel.newBuilder();
                        builder.startObject();
                        builder.field("error", e1.toString());
                        builder.endObject();
                        response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                    }
                    finally {
                        if (builder != null) {
                            builder.close();
                        }
                    }
                }
                channel.sendResponse((RestResponse)response);
            }

            private List<Map<String, String>> generateCertDetailList(X509Certificate[] certs) {
                if (certs == null) {
                    return null;
                }
                return Arrays.stream(certs).map(cert -> {
                    String issuerDn = cert != null && cert.getIssuerX500Principal() != null ? cert.getIssuerX500Principal().getName() : "";
                    String subjectDn = cert != null && cert.getSubjectX500Principal() != null ? cert.getSubjectX500Principal().getName() : "";
                    String san = SecuritySSLCertsInfoAction.this.odsks.getSubjectAlternativeNames((X509Certificate)cert);
                    String notBefore = cert != null && cert.getNotBefore() != null ? cert.getNotBefore().toInstant().toString() : "";
                    String notAfter = cert != null && cert.getNotAfter() != null ? cert.getNotAfter().toInstant().toString() : "";
                    return ImmutableMap.builder().put((Object)"issuer_dn", (Object)issuerDn).put((Object)"subject_dn", (Object)subjectDn).put((Object)"san", (Object)san).put((Object)"not_before", (Object)notBefore).put((Object)"not_after", (Object)notAfter).build();
                }).collect(Collectors.toList());
            }
        };
    }

    public String getName() {
        return "SSL Certificate Information Action";
    }
}

