/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.nio;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.http.HttpResponse;
import org.opensearch.http.nio.ByteBufUtils;
import org.opensearch.rest.RestStatus;

public class NioHttpResponse
extends DefaultFullHttpResponse
implements HttpResponse {
    private final HttpHeaders requestHeaders;

    NioHttpResponse(HttpHeaders requestHeaders, HttpVersion version, RestStatus status, BytesReference content) {
        super(version, HttpResponseStatus.valueOf((int)status.getStatus()), ByteBufUtils.toByteBuf(content));
        this.requestHeaders = requestHeaders;
    }

    public void addHeader(String name, String value) {
        this.headers().add(name, (Object)value);
    }

    public boolean containsHeader(String name) {
        return this.headers().contains(name);
    }

    public HttpHeaders requestHeaders() {
        return this.requestHeaders;
    }
}

