/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.nio.BytesChannelContext;
import org.opensearch.nio.ChannelFactory;
import org.opensearch.nio.Config;
import org.opensearch.nio.InboundChannelBuffer;
import org.opensearch.nio.NioChannelHandler;
import org.opensearch.nio.NioGroup;
import org.opensearch.nio.NioSelector;
import org.opensearch.nio.NioServerSocketChannel;
import org.opensearch.nio.NioSocketChannel;
import org.opensearch.nio.ServerChannelContext;
import org.opensearch.nio.SocketChannelContext;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TcpTransport;
import org.opensearch.transport.nio.NioGroupFactory;
import org.opensearch.transport.nio.NioTcpChannel;
import org.opensearch.transport.nio.NioTcpServerChannel;
import org.opensearch.transport.nio.PageAllocator;
import org.opensearch.transport.nio.TcpReadWriteHandler;

public class NioTransport
extends TcpTransport {
    private static final Logger logger = LogManager.getLogger(NioTransport.class);
    protected final PageAllocator pageAllocator;
    private final ConcurrentMap<String, TcpChannelFactory> profileToChannelFactory = ConcurrentCollections.newConcurrentMap();
    private final NioGroupFactory groupFactory;
    private volatile NioGroup nioGroup;
    private volatile Function<DiscoveryNode, TcpChannelFactory> clientChannelFactory;

    protected NioTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, NioGroupFactory groupFactory) {
        super(settings, version, threadPool, pageCacheRecycler, circuitBreakerService, namedWriteableRegistry, networkService);
        this.pageAllocator = new PageAllocator(pageCacheRecycler);
        this.groupFactory = groupFactory;
    }

    protected NioTcpServerChannel bind(String name, InetSocketAddress address) throws IOException {
        TcpChannelFactory channelFactory = (TcpChannelFactory)((Object)this.profileToChannelFactory.get(name));
        NioTcpServerChannel serverChannel = (NioTcpServerChannel)this.nioGroup.bindServerChannel(address, (ChannelFactory)channelFactory);
        PlainActionFuture future = PlainActionFuture.newFuture();
        serverChannel.addBindListener(ActionListener.toBiConsumer((ActionListener)future));
        future.actionGet();
        return serverChannel;
    }

    protected NioTcpChannel initiateChannel(DiscoveryNode node) throws IOException {
        InetSocketAddress address = node.getAddress().address();
        return (NioTcpChannel)this.nioGroup.openChannel(address, (ChannelFactory)this.clientChannelFactory.apply(node));
    }

    protected void doStart() {
        boolean success = false;
        try {
            this.nioGroup = this.groupFactory.getTransportGroup();
            TcpTransport.ProfileSettings clientProfileSettings = new TcpTransport.ProfileSettings(this.settings, "default");
            this.clientChannelFactory = this.clientChannelFactoryFunction(clientProfileSettings);
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    String profileName = profileSettings.profileName;
                    TcpChannelFactory factory = this.serverChannelFactory(profileSettings);
                    this.profileToChannelFactory.putIfAbsent(profileName, factory);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        catch (IOException e) {
            throw new OpenSearchException((Throwable)e);
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected void stopInternal() {
        try {
            this.nioGroup.close();
        }
        catch (Exception e) {
            logger.warn("unexpected exception while stopping nio group", (Throwable)e);
        }
        this.profileToChannelFactory.clear();
    }

    protected void acceptChannel(NioSocketChannel channel) {
        this.serverAcceptedChannel((NioTcpChannel)channel);
    }

    protected TcpChannelFactory serverChannelFactory(TcpTransport.ProfileSettings profileSettings) {
        return new TcpChannelFactoryImpl(profileSettings, false);
    }

    protected Function<DiscoveryNode, TcpChannelFactory> clientChannelFactoryFunction(TcpTransport.ProfileSettings profileSettings) {
        return n -> new TcpChannelFactoryImpl(profileSettings, true);
    }

    private class TcpChannelFactoryImpl
    extends TcpChannelFactory {
        private final boolean isClient;
        private final String profileName;

        private TcpChannelFactoryImpl(TcpTransport.ProfileSettings profileSettings, boolean isClient) {
            super(profileSettings);
            this.isClient = isClient;
            this.profileName = profileSettings.profileName;
        }

        public NioTcpChannel createChannel(NioSelector selector, SocketChannel channel, Config.Socket socketConfig) {
            NioTcpChannel nioChannel = new NioTcpChannel(!this.isClient, this.profileName, channel);
            Consumer<Exception> exceptionHandler = e -> NioTransport.this.onException(nioChannel, (Exception)e);
            TcpReadWriteHandler handler = new TcpReadWriteHandler(nioChannel, NioTransport.this.pageCacheRecycler, NioTransport.this);
            BytesChannelContext context = new BytesChannelContext((NioSocketChannel)nioChannel, selector, socketConfig, exceptionHandler, (NioChannelHandler)handler, new InboundChannelBuffer((IntFunction)NioTransport.this.pageAllocator));
            nioChannel.setContext((SocketChannelContext)context);
            return nioChannel;
        }

        public NioTcpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel, Config.ServerSocket socketConfig) {
            NioTcpServerChannel nioChannel = new NioTcpServerChannel(channel);
            Consumer<Exception> exceptionHandler = e -> NioTransport.this.onServerException(nioChannel, e);
            Consumer<NioSocketChannel> acceptor = NioTransport.this::acceptChannel;
            ServerChannelContext context = new ServerChannelContext((NioServerSocketChannel)nioChannel, (ChannelFactory)this, selector, socketConfig, acceptor, exceptionHandler);
            nioChannel.setContext(context);
            return nioChannel;
        }
    }

    protected static abstract class TcpChannelFactory
    extends ChannelFactory<NioTcpServerChannel, NioTcpChannel> {
        protected TcpChannelFactory(TcpTransport.ProfileSettings profileSettings) {
            super(profileSettings.tcpNoDelay, profileSettings.tcpKeepAlive, profileSettings.tcpKeepIdle, profileSettings.tcpKeepInterval, profileSettings.tcpKeepCount, profileSettings.reuseAddress, Math.toIntExact(profileSettings.sendBufferSize.getBytes()), Math.toIntExact(profileSettings.receiveBufferSize.getBytes()));
        }
    }
}

