/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.w3c.dom.Element;

abstract class NoRowsResultSetImpl
implements ResultSet {
    final Activation activation;
    private NoPutResultSet[] subqueryTrackingArray;
    private final boolean statisticsTimingOn;
    private boolean isOpen;
    final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    protected long beginExecutionTime;
    protected long endExecutionTime;
    private int firstColumn = -1;
    private int[] generatedColumnPositions;
    private DataValueDescriptor[] normalizedGeneratedValues;

    NoRowsResultSetImpl(Activation activation) {
        this.activation = activation;
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.beginExecutionTime = this.beginTime = this.getCurrentTimeMillis();
    }

    void setup() throws StandardException {
        this.isOpen = true;
        StatementContext statementContext = this.lcc.getStatementContext();
        statementContext.setTopResultSet(this, this.subqueryTrackingArray);
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = statementContext.getSubqueryTrackingArray();
        }
    }

    @Override
    public final boolean returnsRows() {
        return false;
    }

    @Override
    public long modifiedRowCount() {
        return 0L;
    }

    @Override
    public ResultDescription getResultDescription() {
        return null;
    }

    @Override
    public final Activation getActivation() {
        return this.activation;
    }

    @Override
    public final ExecRow getAbsoluteRow(int n) throws StandardException {
        throw StandardException.newException("XCL01.S", "absolute");
    }

    @Override
    public final ExecRow getRelativeRow(int n) throws StandardException {
        throw StandardException.newException("XCL01.S", "relative");
    }

    @Override
    public final ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "beforeFirst");
    }

    @Override
    public final ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "first");
    }

    @Override
    public final ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    @Override
    public final ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "previous");
    }

    @Override
    public final ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "last");
    }

    @Override
    public final ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "afterLast");
    }

    @Override
    public final void clearCurrentRow() {
    }

    @Override
    public final boolean checkRowPosition(int n) {
        return false;
    }

    @Override
    public final int getRowNumber() {
        return 0;
    }

    public void close(boolean bl) throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.lcc.getRunTimeStatisticsMode() && !this.doesCommit() && !this.activation.isClosed() && !this.lcc.getStatementContext().getStatementWasInvalidated()) {
            this.endExecutionTime = this.getCurrentTimeMillis();
            ResultSetStatisticsFactory resultSetStatisticsFactory = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory();
            RunTimeStatistics runTimeStatistics = resultSetStatisticsFactory.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray);
            this.lcc.setRunTimeStatisticsObject(runTimeStatistics);
            XPLAINVisitor xPLAINVisitor = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getXPLAINFactory().getXPLAINVisitor();
            xPLAINVisitor.doXPLAIN(runTimeStatistics, this.activation);
        }
        int n = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.subqueryTrackingArray[i] == null || this.subqueryTrackingArray[i].isClosed()) continue;
            this.subqueryTrackingArray[i].close();
        }
        this.isOpen = false;
        if (this.activation.isSingleExecution() && !bl) {
            this.activation.close();
        }
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
    }

    @Override
    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int n) {
        return MessageService.getTextMessage("42Z47.U", this.getClass().getName());
    }

    @Override
    public long getTimeSpent(int n) {
        return 0L;
    }

    @Override
    public final NoPutResultSet[] getSubqueryTrackingArray(int n) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[n];
        }
        return this.subqueryTrackingArray;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateGenerationClauses(GeneratedMethod generatedMethod, Activation activation, NoPutResultSet noPutResultSet, ExecRow execRow, boolean bl) throws StandardException {
        if (generatedMethod != null) {
            ExecRow execRow2 = (ExecRow)activation.getCurrentRow(noPutResultSet.resultSetNumber());
            try {
                noPutResultSet.setCurrentRow(execRow);
                activation.setCurrentRow(execRow, noPutResultSet.resultSetNumber());
                generatedMethod.invoke(activation);
                if (this.firstColumn < 0) {
                    this.firstColumn = NormalizeResultSet.computeStartColumn(bl, activation.getResultDescription());
                }
                if (this.generatedColumnPositions == null) {
                    this.setupGeneratedColumns(activation, (ValueRow)execRow);
                }
                ResultDescription resultDescription = activation.getResultDescription();
                int n = this.generatedColumnPositions.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = this.generatedColumnPositions[i];
                    DataValueDescriptor dataValueDescriptor = NormalizeResultSet.normalizeColumn(resultDescription.getColumnDescriptor(n2).getType(), execRow, n2, this.normalizedGeneratedValues[i], resultDescription);
                    execRow.setColumn(n2, dataValueDescriptor);
                }
            }
            finally {
                if (execRow2 == null) {
                    noPutResultSet.clearCurrentRow();
                } else {
                    noPutResultSet.setCurrentRow(execRow2);
                }
            }
        }
    }

    private void setupGeneratedColumns(Activation activation, ValueRow valueRow) throws StandardException {
        int n;
        ResultDescription resultDescription = activation.getResultDescription();
        int n2 = resultDescription.getColumnCount();
        ExecRow execRow = valueRow.getNewNullRow();
        int n3 = 0;
        for (n = 1; n <= n2; ++n) {
            ResultColumnDescriptor resultColumnDescriptor;
            if (n < this.firstColumn || !(resultColumnDescriptor = resultDescription.getColumnDescriptor(n)).hasGenerationClause()) continue;
            ++n3;
        }
        this.generatedColumnPositions = new int[n3];
        this.normalizedGeneratedValues = new DataValueDescriptor[n3];
        n = 0;
        for (int i = 1; i <= n2; ++i) {
            ResultColumnDescriptor resultColumnDescriptor;
            if (i < this.firstColumn || !(resultColumnDescriptor = resultDescription.getColumnDescriptor(i)).hasGenerationClause()) continue;
            this.generatedColumnPositions[n] = i;
            this.normalizedGeneratedValues[n] = execRow.getColumn(i);
            ++n;
        }
    }

    public boolean doesCommit() {
        return false;
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        this.getActivation().addWarning(sQLWarning);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public Element toXML(Element element, String string) throws Exception {
        return BasicNoPutResultSetImpl.childrenToXML(BasicNoPutResultSetImpl.toXML(element, string, this), this);
    }
}

