/* geary-abstract-local-folder.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-abstract-local-folder.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_ABSTRACT_LOCAL_FOLDER_0_PROPERTY,
	GEARY_ABSTRACT_LOCAL_FOLDER_OPENING_MONITOR_PROPERTY,
	GEARY_ABSTRACT_LOCAL_FOLDER_NUM_PROPERTIES
};
static GParamSpec* geary_abstract_local_folder_properties[GEARY_ABSTRACT_LOCAL_FOLDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyAbstractLocalFolderOpenAsyncData GearyAbstractLocalFolderOpenAsyncData;
typedef struct _GearyAbstractLocalFolderCloseAsyncData GearyAbstractLocalFolderCloseAsyncData;
typedef struct _GearyAbstractLocalFolderWaitForCloseAsyncData GearyAbstractLocalFolderWaitForCloseAsyncData;
typedef struct _GearyAbstractLocalFolderSynchroniseRemoteData GearyAbstractLocalFolderSynchroniseRemoteData;

struct _GearyAbstractLocalFolderPrivate {
	GearyProgressMonitor* _opening_monitor;
	gint open_count;
	GearyNonblockingSemaphore* closed_semaphore;
};

struct _GearyAbstractLocalFolderOpenAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAbstractLocalFolder* self;
	GearyFolderOpenFlags open_flags;
	GCancellable* cancellable;
	gboolean result;
	gint _tmp0_;
	GearyNonblockingSemaphore* _tmp1_;
	GearyFolderProperties* _tmp2_;
	GearyFolderProperties* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
};

struct _GearyAbstractLocalFolderCloseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAbstractLocalFolder* self;
	GCancellable* cancellable;
	gboolean result;
	gboolean _tmp0_;
	gint _tmp1_;
	GearyNonblockingSemaphore* _tmp2_;
};

struct _GearyAbstractLocalFolderWaitForCloseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAbstractLocalFolder* self;
	GCancellable* cancellable;
	GearyNonblockingSemaphore* _tmp0_;
	GError* _inner_error0_;
};

struct _GearyAbstractLocalFolderSynchroniseRemoteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyAbstractLocalFolder* self;
	GCancellable* cancellable;
};

static gint GearyAbstractLocalFolder_private_offset;
static gpointer geary_abstract_local_folder_parent_class = NULL;

static GearyFolderOpenState geary_abstract_local_folder_real_get_open_state (GearyFolder* base);
static void geary_abstract_local_folder_real_open_async_data_free (gpointer _data);
static void geary_abstract_local_folder_real_open_async (GearyFolder* base,
                                                  GearyFolderOpenFlags open_flags,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean geary_abstract_local_folder_real_open_async_co (GearyAbstractLocalFolderOpenAsyncData* _data_);
static void geary_abstract_local_folder_real_close_async_data_free (gpointer _data);
static void geary_abstract_local_folder_real_close_async (GearyFolder* base,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean geary_abstract_local_folder_real_close_async_co (GearyAbstractLocalFolderCloseAsyncData* _data_);
static void geary_abstract_local_folder_real_wait_for_close_async_data_free (gpointer _data);
static void geary_abstract_local_folder_real_wait_for_close_async (GearyFolder* base,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gboolean geary_abstract_local_folder_real_wait_for_close_async_co (GearyAbstractLocalFolderWaitForCloseAsyncData* _data_);
static void geary_abstract_local_folder_wait_for_close_async_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void geary_abstract_local_folder_real_synchronise_remote_data_free (gpointer _data);
static void geary_abstract_local_folder_real_synchronise_remote (GearyFolder* base,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
static gboolean geary_abstract_local_folder_real_synchronise_remote_co (GearyAbstractLocalFolderSynchroniseRemoteData* _data_);
static void geary_abstract_local_folder_finalize (GObject * obj);
static GType geary_abstract_local_folder_get_type_once (void);
static void _vala_geary_abstract_local_folder_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
geary_abstract_local_folder_get_instance_private (GearyAbstractLocalFolder* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAbstractLocalFolder_private_offset);
}

static GearyProgressMonitor*
geary_abstract_local_folder_real_get_opening_monitor (GearyFolder* base)
{
	GearyProgressMonitor* result;
	GearyAbstractLocalFolder* self;
	GearyProgressMonitor* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	_tmp0_ = self->priv->_opening_monitor;
	result = _tmp0_;
	return result;
}

GearyAbstractLocalFolder*
geary_abstract_local_folder_construct (GType object_type)
{
	GearyAbstractLocalFolder * self = NULL;
	GearyNonblockingSemaphore* _tmp0_;
	self = (GearyAbstractLocalFolder*) geary_folder_construct (object_type);
	_tmp0_ = self->priv->closed_semaphore;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	return self;
}

static GearyFolderOpenState
geary_abstract_local_folder_real_get_open_state (GearyFolder* base)
{
	GearyAbstractLocalFolder * self;
	GearyFolderOpenState _tmp0_ = 0;
	GearyFolderOpenState result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	if (self->priv->open_count > 0) {
		_tmp0_ = GEARY_FOLDER_OPEN_STATE_LOCAL;
	} else {
		_tmp0_ = GEARY_FOLDER_OPEN_STATE_CLOSED;
	}
	result = _tmp0_;
	return result;
}

void
geary_abstract_local_folder_check_open (GearyAbstractLocalFolder* self,
                                        GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IS_ABSTRACT_LOCAL_FOLDER (self));
	if (self->priv->open_count == 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		GError* _tmp3_;
		_tmp0_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_OPEN_REQUIRED, "%s not open", _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == GEARY_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
geary_abstract_local_folder_is_open (GearyAbstractLocalFolder* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_ABSTRACT_LOCAL_FOLDER (self), FALSE);
	result = self->priv->open_count > 0;
	return result;
}

static void
geary_abstract_local_folder_real_open_async_data_free (gpointer _data)
{
	GearyAbstractLocalFolderOpenAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAbstractLocalFolderOpenAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_abstract_local_folder_real_open_async (GearyFolder* base,
                                             GearyFolderOpenFlags open_flags,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GearyAbstractLocalFolder * self;
	GearyAbstractLocalFolderOpenAsyncData* _data_;
	GearyAbstractLocalFolder* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	_data_ = g_slice_new0 (GearyAbstractLocalFolderOpenAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_abstract_local_folder_real_open_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->open_flags = open_flags;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_abstract_local_folder_real_open_async_co (_data_);
}

static gboolean
geary_abstract_local_folder_open_finish (GearyFolder* base,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	gboolean result;
	GearyAbstractLocalFolderOpenAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
geary_abstract_local_folder_real_open_async_co (GearyAbstractLocalFolderOpenAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->open_count;
	_data_->self->priv->open_count = _data_->_tmp0_ + 1;
	if (_data_->_tmp0_ > 0) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->closed_semaphore;
	geary_nonblocking_lock_reset (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	_data_->_tmp2_ = geary_folder_get_properties (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = geary_folder_properties_get_email_total (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	geary_folder_notify_opened (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder), GEARY_FOLDER_OPEN_STATE_LOCAL, _data_->_tmp5_);
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_abstract_local_folder_real_close_async_data_free (gpointer _data)
{
	GearyAbstractLocalFolderCloseAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAbstractLocalFolderCloseAsyncData, _data_);
}

static void
geary_abstract_local_folder_real_close_async (GearyFolder* base,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearyAbstractLocalFolder * self;
	GearyAbstractLocalFolderCloseAsyncData* _data_;
	GearyAbstractLocalFolder* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	_data_ = g_slice_new0 (GearyAbstractLocalFolderCloseAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_abstract_local_folder_real_close_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_abstract_local_folder_real_close_async_co (_data_);
}

static gboolean
geary_abstract_local_folder_close_finish (GearyFolder* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	gboolean result;
	GearyAbstractLocalFolderCloseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
geary_abstract_local_folder_real_close_async_co (GearyAbstractLocalFolderCloseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->open_count == 0) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->self->priv->open_count = _data_->self->priv->open_count - 1;
		_data_->_tmp1_ = _data_->self->priv->open_count;
		_data_->_tmp0_ = _data_->_tmp1_ > 0;
	}
	if (_data_->_tmp0_) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->closed_semaphore;
	geary_nonblocking_lock_blind_notify (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock));
	geary_folder_notify_closed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder), GEARY_FOLDER_CLOSE_REASON_LOCAL_CLOSE);
	geary_folder_notify_closed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder), GEARY_FOLDER_CLOSE_REASON_FOLDER_CLOSED);
	_data_->result = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_abstract_local_folder_real_wait_for_close_async_data_free (gpointer _data)
{
	GearyAbstractLocalFolderWaitForCloseAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAbstractLocalFolderWaitForCloseAsyncData, _data_);
}

static void
geary_abstract_local_folder_real_wait_for_close_async (GearyFolder* base,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	GearyAbstractLocalFolder * self;
	GearyAbstractLocalFolderWaitForCloseAsyncData* _data_;
	GearyAbstractLocalFolder* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	_data_ = g_slice_new0 (GearyAbstractLocalFolderWaitForCloseAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_abstract_local_folder_real_wait_for_close_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_abstract_local_folder_real_wait_for_close_async_co (_data_);
}

static void
geary_abstract_local_folder_wait_for_close_finish (GearyFolder* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GearyAbstractLocalFolderWaitForCloseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_abstract_local_folder_wait_for_close_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	GearyAbstractLocalFolderWaitForCloseAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_abstract_local_folder_real_wait_for_close_async_co (_data_);
}

static gboolean
geary_abstract_local_folder_real_wait_for_close_async_co (GearyAbstractLocalFolderWaitForCloseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->closed_semaphore;
	_data_->_state_ = 1;
	geary_nonblocking_lock_wait_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->cancellable, geary_abstract_local_folder_wait_for_close_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_nonblocking_lock_wait_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_NONBLOCKING_TYPE_LOCK, GearyNonblockingLock), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_abstract_local_folder_real_synchronise_remote_data_free (gpointer _data)
{
	GearyAbstractLocalFolderSynchroniseRemoteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyAbstractLocalFolderSynchroniseRemoteData, _data_);
}

static void
geary_abstract_local_folder_real_synchronise_remote (GearyFolder* base,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GearyAbstractLocalFolder * self;
	GearyAbstractLocalFolderSynchroniseRemoteData* _data_;
	GearyAbstractLocalFolder* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	_data_ = g_slice_new0 (GearyAbstractLocalFolderSynchroniseRemoteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_abstract_local_folder_real_synchronise_remote_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_abstract_local_folder_real_synchronise_remote_co (_data_);
}

static void
geary_abstract_local_folder_synchronise_remote_finish (GearyFolder* base,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GearyAbstractLocalFolderSynchroniseRemoteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
geary_abstract_local_folder_real_synchronise_remote_co (GearyAbstractLocalFolderSynchroniseRemoteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_abstract_local_folder_class_init (GearyAbstractLocalFolderClass * klass,
                                        gpointer klass_data)
{
	geary_abstract_local_folder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAbstractLocalFolder_private_offset);
	((GearyFolderClass *) klass)->get_open_state = (GearyFolderOpenState (*) (GearyFolder*)) geary_abstract_local_folder_real_get_open_state;
	((GearyFolderClass *) klass)->open_async = (void (*) (GearyFolder*, GearyFolderOpenFlags, GCancellable*, GAsyncReadyCallback, gpointer)) geary_abstract_local_folder_real_open_async;
	((GearyFolderClass *) klass)->open_finish = (gboolean (*) (GearyFolder*, GAsyncResult*, GError**)) geary_abstract_local_folder_open_finish;
	((GearyFolderClass *) klass)->close_async = (void (*) (GearyFolder*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_abstract_local_folder_real_close_async;
	((GearyFolderClass *) klass)->close_finish = (gboolean (*) (GearyFolder*, GAsyncResult*, GError**)) geary_abstract_local_folder_close_finish;
	((GearyFolderClass *) klass)->wait_for_close_async = (void (*) (GearyFolder*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_abstract_local_folder_real_wait_for_close_async;
	((GearyFolderClass *) klass)->wait_for_close_finish = (void (*) (GearyFolder*, GAsyncResult*, GError**)) geary_abstract_local_folder_wait_for_close_finish;
	((GearyFolderClass *) klass)->synchronise_remote = (void (*) (GearyFolder*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_abstract_local_folder_real_synchronise_remote;
	((GearyFolderClass *) klass)->synchronise_remote_finish = (void (*) (GearyFolder*, GAsyncResult*, GError**)) geary_abstract_local_folder_synchronise_remote_finish;
	GEARY_FOLDER_CLASS (klass)->get_opening_monitor = geary_abstract_local_folder_real_get_opening_monitor;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_abstract_local_folder_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_abstract_local_folder_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_ABSTRACT_LOCAL_FOLDER_OPENING_MONITOR_PROPERTY, geary_abstract_local_folder_properties[GEARY_ABSTRACT_LOCAL_FOLDER_OPENING_MONITOR_PROPERTY] = g_param_spec_object ("opening-monitor", "opening-monitor", "opening-monitor", GEARY_TYPE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_abstract_local_folder_instance_init (GearyAbstractLocalFolder * self,
                                           gpointer klass)
{
	GearyReentrantProgressMonitor* _tmp0_;
	GearyNonblockingSemaphore* _tmp1_;
	self->priv = geary_abstract_local_folder_get_instance_private (self);
	_tmp0_ = geary_reentrant_progress_monitor_new (GEARY_PROGRESS_TYPE_ACTIVITY);
	self->priv->_opening_monitor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor);
	self->priv->open_count = 0;
	_tmp1_ = geary_nonblocking_semaphore_new (NULL);
	self->priv->closed_semaphore = _tmp1_;
}

static void
geary_abstract_local_folder_finalize (GObject * obj)
{
	GearyAbstractLocalFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	_g_object_unref0 (self->priv->_opening_monitor);
	_g_object_unref0 (self->priv->closed_semaphore);
	G_OBJECT_CLASS (geary_abstract_local_folder_parent_class)->finalize (obj);
}

/**
 * Handles open/close for local folders.
 */
 G_GNUC_NO_INLINE static GType
geary_abstract_local_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAbstractLocalFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_abstract_local_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAbstractLocalFolder), 0, (GInstanceInitFunc) geary_abstract_local_folder_instance_init, NULL };
	GType geary_abstract_local_folder_type_id;
	geary_abstract_local_folder_type_id = g_type_register_static (GEARY_TYPE_FOLDER, "GearyAbstractLocalFolder", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyAbstractLocalFolder_private_offset = g_type_add_instance_private (geary_abstract_local_folder_type_id, sizeof (GearyAbstractLocalFolderPrivate));
	return geary_abstract_local_folder_type_id;
}

GType
geary_abstract_local_folder_get_type (void)
{
	static gsize geary_abstract_local_folder_type_id__once = 0;
	if (g_once_init_enter (&geary_abstract_local_folder_type_id__once)) {
		GType geary_abstract_local_folder_type_id;
		geary_abstract_local_folder_type_id = geary_abstract_local_folder_get_type_once ();
		g_once_init_leave (&geary_abstract_local_folder_type_id__once, geary_abstract_local_folder_type_id);
	}
	return geary_abstract_local_folder_type_id__once;
}

static void
_vala_geary_abstract_local_folder_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GearyAbstractLocalFolder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_ABSTRACT_LOCAL_FOLDER, GearyAbstractLocalFolder);
	switch (property_id) {
		case GEARY_ABSTRACT_LOCAL_FOLDER_OPENING_MONITOR_PROPERTY:
		g_value_set_object (value, geary_folder_get_opening_monitor (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_FOLDER, GearyFolder)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

