/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.shrink.ResizeRequest;
import org.opensearch.action.admin.indices.shrink.ResizeResponse;
import org.opensearch.action.admin.indices.shrink.ResizeType;
import org.opensearch.action.admin.indices.stats.IndexShardStats;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.store.StoreStats;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportResizeAction
extends TransportClusterManagerNodeAction<ResizeRequest, ResizeResponse> {
    private final MetadataCreateIndexService createIndexService;
    private final Client client;

    @Inject
    public TransportResizeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        this("indices:admin/resize", transportService, clusterService, threadPool, createIndexService, actionFilters, indexNameExpressionResolver, client);
    }

    protected TransportResizeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, ResizeRequest::new, indexNameExpressionResolver);
        this.createIndexService = createIndexService;
        this.client = client;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ResizeResponse read(StreamInput in) throws IOException {
        return new ResizeResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getTargetIndexRequest().index());
    }

    @Override
    protected void clusterManagerOperation(ResizeRequest resizeRequest, ClusterState state, ActionListener<ResizeResponse> listener) {
        String sourceIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getSourceIndex());
        String targetIndex = this.indexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getTargetIndexRequest().index());
        this.client.admin().indices().prepareStats(sourceIndex).clear().setDocs(true).setStore(true).execute(ActionListener.delegateFailure(listener, (delegatedListener, indicesStatsResponse) -> {
            CreateIndexClusterStateUpdateRequest updateRequest = TransportResizeAction.prepareCreateIndexRequest(resizeRequest, state, i -> {
                IndexShardStats shard = indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                return shard == null ? null : shard.getPrimary().getDocs();
            }, indicesStatsResponse.getPrimaries().store, sourceIndex, targetIndex);
            this.createIndexService.createIndex(updateRequest, ActionListener.map(delegatedListener, response -> new ResizeResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
        }));
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ResizeRequest resizeRequest, ClusterState state, IntFunction<DocsStats> perShardDocStats, StoreStats primaryShardsStoreStats, String sourceIndexName, String targetIndexName) {
        int numShards;
        CreateIndexRequest targetIndex = resizeRequest.getTargetIndexRequest();
        IndexMetadata metadata = state.metadata().index(sourceIndexName);
        if (metadata == null) {
            throw new IndexNotFoundException(sourceIndexName);
        }
        Settings.Builder targetIndexSettingsBuilder = Settings.builder().put(targetIndex.settings()).normalizePrefix("index.");
        targetIndexSettingsBuilder.remove("index.history.uuid");
        Settings targetIndexSettings = targetIndexSettingsBuilder.build();
        ByteSizeValue maxShardSize = resizeRequest.getMaxShardSize();
        if (resizeRequest.getResizeType() != ResizeType.SHRINK && maxShardSize != null) {
            throw new IllegalArgumentException("Unsupported parameter [max_shard_size]");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            numShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings);
            if (resizeRequest.getResizeType() == ResizeType.SHRINK && maxShardSize != null) {
                throw new IllegalArgumentException("Cannot set max_shard_size and index.number_of_shards at the same time!");
            }
        } else {
            assert (resizeRequest.getResizeType() != ResizeType.SPLIT) : "split must specify the number of shards explicitly";
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                numShards = TransportResizeAction.calculateTargetIndexShardsNum(maxShardSize, primaryShardsStoreStats, metadata);
            } else {
                assert (resizeRequest.getResizeType() == ResizeType.CLONE);
                numShards = metadata.getNumberOfShards();
            }
        }
        for (int i = 0; i < numShards; ++i) {
            if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
                Set<ShardId> shardIds = IndexMetadata.selectShrinkShards(i, metadata, numShards);
                long count = 0L;
                for (ShardId id : shardIds) {
                    DocsStats docsStats = perShardDocStats.apply(id.id());
                    if (docsStats != null) {
                        count += docsStats.getCount();
                    }
                    if (count <= 0x7FFFFF7FL) continue;
                    throw new IllegalStateException("Can't merge index with more than [2147483519] docs - too many documents in shards " + shardIds);
                }
                continue;
            }
            if (resizeRequest.getResizeType() == ResizeType.SPLIT) {
                Objects.requireNonNull(IndexMetadata.selectSplitShard(i, metadata, numShards));
                continue;
            }
            Objects.requireNonNull(IndexMetadata.selectCloneShard(i, metadata, numShards));
        }
        if (IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.exists(targetIndexSettings)) {
            throw new IllegalArgumentException("cannot provide a routing partition size value when resizing an index");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(targetIndexSettings)) {
            boolean splitFromSingleShards;
            boolean bl = splitFromSingleShards = resizeRequest.getResizeType() == ResizeType.SPLIT && metadata.getNumberOfShards() == 1;
            if (!splitFromSingleShards) {
                throw new IllegalArgumentException("cannot provide index.number_of_routing_shards on resize");
            }
        }
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(metadata.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(targetIndexSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(targetIndexSettings).booleanValue()) {
            throw new IllegalArgumentException("Can't disable [index.soft_deletes.enabled] setting on resize");
        }
        String cause = resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT) + "_index";
        targetIndex.cause(cause);
        Settings.Builder settingsBuilder = Settings.builder().put(targetIndexSettings);
        settingsBuilder.put("index.number_of_shards", numShards);
        targetIndex.settings(settingsBuilder);
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, targetIndex.index(), targetIndexName).ackTimeout(targetIndex.timeout())).masterNodeTimeout(targetIndex.clusterManagerNodeTimeout())).settings(targetIndex.settings()).aliases(targetIndex.aliases()).waitForActiveShards(targetIndex.waitForActiveShards()).recoverFrom(metadata.getIndex()).resizeType(resizeRequest.getResizeType()).copySettings(resizeRequest.getCopySettings() == null ? false : resizeRequest.getCopySettings());
    }

    protected static int calculateTargetIndexShardsNum(ByteSizeValue maxShardSize, StoreStats sourceIndexShardStoreStats, IndexMetadata sourceIndexMetaData) {
        if (maxShardSize == null || sourceIndexShardStoreStats == null || maxShardSize.getBytes() == 0L || sourceIndexShardStoreStats.getSizeInBytes() == 0L) {
            return 1;
        }
        int sourceIndexShardsNum = sourceIndexMetaData.getNumberOfShards();
        int minValue = (int)Math.ceil((double)sourceIndexShardStoreStats.getSizeInBytes() / (double)maxShardSize.getBytes());
        if (minValue >= sourceIndexShardsNum) {
            return sourceIndexShardsNum;
        }
        for (int i = minValue; i < sourceIndexShardsNum; ++i) {
            if (sourceIndexShardsNum % i != 0) continue;
            return i;
        }
        return sourceIndexShardsNum;
    }

    @Override
    protected String getClusterManagerActionName(DiscoveryNode node) {
        return super.getClusterManagerActionName(node);
    }
}

