/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.common.Nullable;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class GetComposableIndexTemplateAction
extends ActionType<Response> {
    public static final GetComposableIndexTemplateAction INSTANCE = new GetComposableIndexTemplateAction();
    public static final String NAME = "indices:admin/index_template/get";

    private GetComposableIndexTemplateAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField NAME = new ParseField("name", new String[0]);
        public static final ParseField INDEX_TEMPLATES = new ParseField("index_templates", new String[0]);
        public static final ParseField INDEX_TEMPLATE = new ParseField("index_template", new String[0]);
        private final Map<String, ComposableIndexTemplate> indexTemplates;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.indexTemplates = in.readMap(StreamInput::readString, ComposableIndexTemplate::new);
        }

        public Response(Map<String, ComposableIndexTemplate> indexTemplates) {
            this.indexTemplates = indexTemplates;
        }

        public Map<String, ComposableIndexTemplate> indexTemplates() {
            return this.indexTemplates;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.indexTemplates, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)o;
            return Objects.equals(this.indexTemplates, that.indexTemplates);
        }

        public int hashCode() {
            return Objects.hash(this.indexTemplates);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(INDEX_TEMPLATES.getPreferredName());
            for (Map.Entry<String, ComposableIndexTemplate> indexTemplate : this.indexTemplates.entrySet()) {
                builder.startObject();
                builder.field(NAME.getPreferredName(), indexTemplate.getKey());
                builder.field(INDEX_TEMPLATE.getPreferredName(), (ToXContent)indexTemplate.getValue());
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }
    }

    public static class Request
    extends ClusterManagerNodeReadRequest<Request> {
        @Nullable
        private String name;

        public Request() {
        }

        public Request(@Nullable String name) {
            this.name = name;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.name);
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request name(String name) {
            this.name = name;
            return this;
        }

        public String name() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return Objects.equals(this.name, other.name);
        }
    }
}

