/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.Index;
import org.opensearch.index.IndexModule;
import org.opensearch.transport.TransportRequest;

public class IndicesModuleRequest
extends TransportRequest {
    private final Index index;
    private final Settings indexSettings;

    public IndicesModuleRequest(IndexModule indexModule) {
        this.index = indexModule.getIndex();
        this.indexSettings = indexModule.getSettings();
    }

    public IndicesModuleRequest(StreamInput in) throws IOException {
        super(in);
        this.index = new Index(in);
        this.indexSettings = Settings.readSettingsFromStream(in);
    }

    public IndicesModuleRequest(Index index, Settings settings) {
        this.index = index;
        this.indexSettings = settings;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.index.writeTo(out);
        Settings.writeSettingsToStream(this.indexSettings, out);
    }

    public String toString() {
        return "IndicesModuleRequest{index=" + this.index + ", indexSettings=" + this.indexSettings + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndicesModuleRequest that = (IndicesModuleRequest)o;
        return Objects.equals(this.index, that.index) && Objects.equals(this.indexSettings, that.indexSettings);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.indexSettings);
    }
}

