/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.opensearch.index.store.remote.utils.BlobFetchRequest;
import org.opensearch.index.store.remote.utils.ConcurrentInvocationLinearizer;

public class TransferManager {
    private final BlobContainer blobContainer;
    private final ConcurrentInvocationLinearizer<Path, IndexInput> invocationLinearizer;

    public TransferManager(BlobContainer blobContainer, ExecutorService remoteStoreExecutorService) {
        this.blobContainer = blobContainer;
        this.invocationLinearizer = new ConcurrentInvocationLinearizer(remoteStoreExecutorService);
    }

    public CompletableFuture<IndexInput> asyncFetchBlob(BlobFetchRequest blobFetchRequest) {
        return this.asyncFetchBlob(blobFetchRequest.getFilePath(), () -> {
            try {
                return this.fetchBlob(blobFetchRequest);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public CompletableFuture<IndexInput> asyncFetchBlob(Path path, Supplier<IndexInput> indexInputSupplier) {
        return this.invocationLinearizer.linearize(path, p -> (IndexInput)indexInputSupplier.get());
    }

    private IndexInput fetchBlob(BlobFetchRequest blobFetchRequest) throws IOException {
        try (InputStream snapshotFileInputStream = this.blobContainer.readBlob(blobFetchRequest.getBlobName(), blobFetchRequest.getPosition(), blobFetchRequest.getLength());){
            ByteArrayIndexInput byteArrayIndexInput = new ByteArrayIndexInput(blobFetchRequest.getBlobName(), snapshotFileInputStream.readAllBytes());
            return byteArrayIndexInput;
        }
    }
}

