/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.trackers;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.util.MovingAverage;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.search.backpressure.settings.SearchBackpressureSettings;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTracker;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackerType;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskCancellation;

public class HeapUsageTracker
extends TaskResourceUsageTracker {
    private static final long HEAP_SIZE_BYTES = JvmStats.jvmStats().getMem().getHeapMax().getBytes();
    private volatile double heapPercentThreshold;
    public static final Setting<Double> SETTING_HEAP_PERCENT_THRESHOLD = Setting.doubleSetting("search_backpressure.search_shard_task.heap_percent_threshold", 0.005, 0.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile double heapVarianceThreshold;
    public static final Setting<Double> SETTING_HEAP_VARIANCE_THRESHOLD = Setting.doubleSetting("search_backpressure.search_shard_task.heap_variance", 2.0, 0.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int heapMovingAverageWindowSize;
    public static final Setting<Integer> SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting("search_backpressure.search_shard_task.heap_moving_average_window_size", 100, 0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final AtomicReference<MovingAverage> movingAverageReference;

    public HeapUsageTracker(SearchBackpressureSettings settings) {
        this.heapPercentThreshold = SETTING_HEAP_PERCENT_THRESHOLD.get(settings.getSettings());
        settings.getClusterSettings().addSettingsUpdateConsumer(SETTING_HEAP_PERCENT_THRESHOLD, this::setHeapPercentThreshold);
        this.heapVarianceThreshold = SETTING_HEAP_VARIANCE_THRESHOLD.get(settings.getSettings());
        settings.getClusterSettings().addSettingsUpdateConsumer(SETTING_HEAP_VARIANCE_THRESHOLD, this::setHeapVarianceThreshold);
        this.heapMovingAverageWindowSize = SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE.get(settings.getSettings());
        settings.getClusterSettings().addSettingsUpdateConsumer(SETTING_HEAP_MOVING_AVERAGE_WINDOW_SIZE, this::setHeapMovingAverageWindowSize);
        this.movingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(this.heapMovingAverageWindowSize));
    }

    @Override
    public String name() {
        return TaskResourceUsageTrackerType.HEAP_USAGE_TRACKER.getName();
    }

    @Override
    public void update(Task task) {
        this.movingAverageReference.get().record(task.getTotalResourceStats().getMemoryInBytes());
    }

    @Override
    public Optional<TaskCancellation.Reason> checkAndMaybeGetCancellationReason(Task task) {
        MovingAverage movingAverage = this.movingAverageReference.get();
        if (!movingAverage.isReady()) {
            return Optional.empty();
        }
        double currentUsage = task.getTotalResourceStats().getMemoryInBytes();
        double averageUsage = movingAverage.getAverage();
        double allowedUsage = averageUsage * this.getHeapVarianceThreshold();
        if (currentUsage < (double)this.getHeapBytesThreshold() || currentUsage < allowedUsage) {
            return Optional.empty();
        }
        return Optional.of(new TaskCancellation.Reason("heap usage exceeded [" + new ByteSizeValue((long)currentUsage) + " >= " + new ByteSizeValue((long)allowedUsage) + "]", (int)(currentUsage / averageUsage)));
    }

    public long getHeapBytesThreshold() {
        return (long)((double)HEAP_SIZE_BYTES * this.heapPercentThreshold);
    }

    public void setHeapPercentThreshold(double heapPercentThreshold) {
        this.heapPercentThreshold = heapPercentThreshold;
    }

    public double getHeapVarianceThreshold() {
        return this.heapVarianceThreshold;
    }

    public void setHeapVarianceThreshold(double heapVarianceThreshold) {
        this.heapVarianceThreshold = heapVarianceThreshold;
    }

    public void setHeapMovingAverageWindowSize(int heapMovingAverageWindowSize) {
        this.heapMovingAverageWindowSize = heapMovingAverageWindowSize;
        this.movingAverageReference.set(new MovingAverage(heapMovingAverageWindowSize));
    }

    @Override
    public TaskResourceUsageTracker.Stats stats(List<? extends Task> activeTasks) {
        long currentMax = activeTasks.stream().mapToLong(t -> t.getTotalResourceStats().getMemoryInBytes()).max().orElse(0L);
        long currentAvg = (long)activeTasks.stream().mapToLong(t -> t.getTotalResourceStats().getMemoryInBytes()).average().orElse(0.0);
        return new Stats(this.getCancellations(), currentMax, currentAvg, (long)this.movingAverageReference.get().getAverage());
    }

    public static class Stats
    implements TaskResourceUsageTracker.Stats {
        private final long cancellationCount;
        private final long currentMax;
        private final long currentAvg;
        private final long rollingAvg;

        public Stats(long cancellationCount, long currentMax, long currentAvg, long rollingAvg) {
            this.cancellationCount = cancellationCount;
            this.currentMax = currentMax;
            this.currentAvg = currentAvg;
            this.rollingAvg = rollingAvg;
        }

        public Stats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("cancellation_count", this.cancellationCount).humanReadableField("current_max_bytes", "current_max", (Object)new ByteSizeValue(this.currentMax)).humanReadableField("current_avg_bytes", "current_avg", (Object)new ByteSizeValue(this.currentAvg)).humanReadableField("rolling_avg_bytes", "rolling_avg", (Object)new ByteSizeValue(this.rollingAvg)).endObject();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.cancellationCount);
            out.writeVLong(this.currentMax);
            out.writeVLong(this.currentAvg);
            out.writeVLong(this.rollingAvg);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats stats = (Stats)o;
            return this.cancellationCount == stats.cancellationCount && this.currentMax == stats.currentMax && this.currentAvg == stats.currentAvg && this.rollingAvg == stats.rollingAvg;
        }

        public int hashCode() {
            return Objects.hash(this.cancellationCount, this.currentMax, this.currentAvg, this.rollingAvg);
        }
    }

    private static class Defaults {
        private static final double HEAP_PERCENT_THRESHOLD = 0.005;
        private static final double HEAP_VARIANCE_THRESHOLD = 2.0;
        private static final int HEAP_MOVING_AVERAGE_WINDOW_SIZE = 100;

        private Defaults() {
        }
    }
}

