/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.search.profile.AbstractProfileBreakdown;
import org.opensearch.search.profile.ContextualProfileBreakdown;
import org.opensearch.search.profile.query.QueryProfileBreakdown;
import org.opensearch.search.profile.query.QueryTimingType;

public final class ConcurrentQueryProfileBreakdown
extends ContextualProfileBreakdown<QueryTimingType> {
    private final Map<Object, AbstractProfileBreakdown<QueryTimingType>> contexts = new ConcurrentHashMap<Object, AbstractProfileBreakdown<QueryTimingType>>();

    public ConcurrentQueryProfileBreakdown() {
        super(QueryTimingType.class);
    }

    @Override
    public AbstractProfileBreakdown<QueryTimingType> context(Object context) {
        AbstractProfileBreakdown<QueryTimingType> profile = this.contexts.get(context);
        if (profile != null) {
            return profile;
        }
        return this.contexts.computeIfAbsent(context, ctx -> new QueryProfileBreakdown());
    }

    @Override
    public Map<String, Long> toBreakdownMap() {
        HashMap<String, Long> map = new HashMap<String, Long>(this.buildBreakdownMap(this));
        for (AbstractProfileBreakdown<QueryTimingType> context : this.contexts.values()) {
            for (Map.Entry<String, Long> entry : this.buildBreakdownMap(context).entrySet()) {
                map.merge(entry.getKey(), entry.getValue(), Long::sum);
            }
        }
        return map;
    }
}

