/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless;

import java.util.Objects;
import org.opensearch.painless.WriterConstants;

public final class Location {
    private final String sourceName;
    private final int offset;
    private static final int MAX_NAME_LENGTH = 256;

    public Location(String sourceName, int offset) {
        this.sourceName = Objects.requireNonNull(sourceName);
        this.offset = offset;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getOffset() {
        return this.offset;
    }

    public RuntimeException createError(RuntimeException exception) {
        StackTraceElement element = new StackTraceElement(WriterConstants.CLASS_NAME, "compile", this.sourceName, this.offset + 1);
        StackTraceElement[] oldStack = exception.getStackTrace();
        StackTraceElement[] newStack = new StackTraceElement[oldStack.length + 1];
        System.arraycopy(oldStack, 0, newStack, 1, oldStack.length);
        newStack[0] = element;
        exception.setStackTrace(newStack);
        assert (exception.getStackTrace().length == newStack.length) : "non-writeable stacktrace for exception: " + exception.getClass();
        return exception;
    }

    public static String computeSourceName(String scriptName) {
        StringBuilder fileName = new StringBuilder();
        int limit = scriptName.indexOf(10);
        if (limit >= 0) {
            int limit2 = scriptName.indexOf(13);
            if (limit2 >= 0) {
                limit = Math.min(limit, limit2);
            }
        } else {
            limit = scriptName.length();
        }
        limit = Math.min(limit, 256);
        fileName.append(scriptName, 0, limit);
        if (limit != scriptName.length()) {
            fileName.append(" ...");
        }
        return fileName.toString();
    }
}

