/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest.geoip;

import com.maxmind.geoip2.DatabaseReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.core.internal.io.IOUtils;

class DatabaseReaderLazyLoader
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(DatabaseReaderLazyLoader.class);
    private final Path databasePath;
    private final CheckedSupplier<DatabaseReader, IOException> loader;
    final SetOnce<DatabaseReader> databaseReader;
    final SetOnce<String> databaseType;

    DatabaseReaderLazyLoader(Path databasePath, CheckedSupplier<DatabaseReader, IOException> loader) {
        this.databasePath = Objects.requireNonNull(databasePath);
        this.loader = Objects.requireNonNull(loader);
        this.databaseReader = new SetOnce();
        this.databaseType = new SetOnce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getDatabaseType() throws IOException {
        if (this.databaseType.get() == null) {
            SetOnce<String> setOnce = this.databaseType;
            synchronized (setOnce) {
                if (this.databaseType.get() == null) {
                    long fileSize = this.databaseFileSize();
                    if (fileSize <= 512L) {
                        throw new IOException("unexpected file length [" + fileSize + "] for [" + this.databasePath + "]");
                    }
                    int[] databaseTypeMarker = new int[]{100, 97, 116, 97, 98, 97, 115, 101, 95, 116, 121, 112, 101};
                    try (InputStream in = this.databaseInputStream();){
                        int actualBytesRead;
                        long skipped = in.skip(fileSize - 512L);
                        if (skipped != fileSize - 512L) {
                            throw new IOException("failed to skip [" + (fileSize - 512L) + "] bytes while reading [" + this.databasePath + "]");
                        }
                        byte[] tail = new byte[512];
                        int read = 0;
                        do {
                            if ((actualBytesRead = in.read(tail, read, 512 - read)) != -1) continue;
                            throw new IOException("unexpected end of stream [" + this.databasePath + "] after reading [" + read + "] bytes");
                        } while ((read += actualBytesRead) != 512);
                        int metadataOffset = -1;
                        int markerOffset = 0;
                        for (int i = 0; i < tail.length; ++i) {
                            byte b = tail[i];
                            markerOffset = b == databaseTypeMarker[markerOffset] ? ++markerOffset : 0;
                            if (markerOffset != databaseTypeMarker.length) continue;
                            metadataOffset = i + 1;
                            break;
                        }
                        if (metadataOffset == -1) {
                            throw new IOException("database type marker not found");
                        }
                        int offsetByte = tail[metadataOffset] & 0xFF;
                        int type = offsetByte >>> 5;
                        if (type != 2) {
                            throw new IOException("type must be UTF-8 string");
                        }
                        int size = offsetByte & 0x1F;
                        this.databaseType.set((Object)new String(tail, metadataOffset + 1, size, StandardCharsets.UTF_8));
                    }
                }
            }
        }
        return (String)this.databaseType.get();
    }

    long databaseFileSize() throws IOException {
        return Files.size(this.databasePath);
    }

    InputStream databaseInputStream() throws IOException {
        return Files.newInputStream(this.databasePath, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseReader get() throws IOException {
        if (this.databaseReader.get() == null) {
            SetOnce<DatabaseReader> setOnce = this.databaseReader;
            synchronized (setOnce) {
                if (this.databaseReader.get() == null) {
                    this.databaseReader.set((Object)((DatabaseReader)this.loader.get()));
                    LOGGER.debug("loaded [{}] geo-IP database", (Object)this.databasePath);
                }
            }
        }
        return (DatabaseReader)this.databaseReader.get();
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.close((Closeable)((Closeable)this.databaseReader.get()));
    }
}

