/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.metadata;

import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateTaskExecutor;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.replication.action.replicationstatedetails.UpdateReplicationStateDetailsRequest;
import org.opensearch.replication.metadata.state.ReplicationStateMetadata;

@kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/replication/metadata/UpdateReplicationStateDetailsTaskExecutor;", "Lorg/opensearch/cluster/ClusterStateTaskExecutor;", "Lorg/opensearch/replication/action/replicationstatedetails/UpdateReplicationStateDetailsRequest;", "()V", "execute", "Lorg/opensearch/cluster/ClusterStateTaskExecutor$ClusterTasksResult;", "currentState", "Lorg/opensearch/cluster/ClusterState;", "tasks", "", "getClusterStateUpdateTaskResult", "request", "getStateUpdateTaskResultForClusterState", "clusterState", "getUpdatedReplicationMetadata", "Lorg/opensearch/replication/metadata/state/ReplicationStateMetadata;", "currentStateMetadata", "Companion", "opensearch-cross-cluster-replication"})
public final class UpdateReplicationStateDetailsTaskExecutor
implements ClusterStateTaskExecutor<UpdateReplicationStateDetailsRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LogManager.getLogger(UpdateReplicationStateDetailsTaskExecutor.class);
    @NotNull
    private static final UpdateReplicationStateDetailsTaskExecutor INSTANCE = new UpdateReplicationStateDetailsTaskExecutor();

    private UpdateReplicationStateDetailsTaskExecutor() {
    }

    @NotNull
    public ClusterStateTaskExecutor.ClusterTasksResult<UpdateReplicationStateDetailsRequest> execute(@NotNull ClusterState currentState, @NotNull List<UpdateReplicationStateDetailsRequest> tasks) {
        Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
        Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
        return this.getClusterStateUpdateTaskResult(tasks.get(0), currentState);
    }

    private final ClusterStateTaskExecutor.ClusterTasksResult<UpdateReplicationStateDetailsRequest> getClusterStateUpdateTaskResult(UpdateReplicationStateDetailsRequest request, ClusterState currentState) {
        ReplicationStateMetadata newMetadata;
        ReplicationStateMetadata currentMetadata;
        ReplicationStateMetadata replicationStateMetadata = (ReplicationStateMetadata)currentState.metadata().custom("replication_metadata");
        if (replicationStateMetadata == null) {
            replicationStateMetadata = ReplicationStateMetadata.Companion.getEMPTY();
        }
        if (Intrinsics.areEqual((Object)(currentMetadata = replicationStateMetadata), (Object)(newMetadata = this.getUpdatedReplicationMetadata(request, currentMetadata)))) {
            return this.getStateUpdateTaskResultForClusterState(request, currentState);
        }
        Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.getMetadata()).putCustom("replication_metadata", (Metadata.Custom)newMetadata);
        ClusterState newClusterState = new ClusterState.Builder(currentState).metadata(mdBuilder).build();
        Intrinsics.checkNotNullExpressionValue((Object)newClusterState, (String)"newClusterState");
        return this.getStateUpdateTaskResultForClusterState(request, newClusterState);
    }

    private final ClusterStateTaskExecutor.ClusterTasksResult<UpdateReplicationStateDetailsRequest> getStateUpdateTaskResultForClusterState(UpdateReplicationStateDetailsRequest request, ClusterState clusterState) {
        ClusterStateTaskExecutor.ClusterTasksResult clusterTasksResult = ClusterStateTaskExecutor.ClusterTasksResult.builder().success((Object)request).build(clusterState);
        Intrinsics.checkNotNullExpressionValue((Object)clusterTasksResult, (String)"builder<UpdateReplicatio\u2026uest).build(clusterState)");
        return clusterTasksResult;
    }

    private final ReplicationStateMetadata getUpdatedReplicationMetadata(UpdateReplicationStateDetailsRequest request, ReplicationStateMetadata currentStateMetadata) {
        if (request.getUpdateType() == UpdateReplicationStateDetailsRequest.UpdateType.ADD) {
            return currentStateMetadata.addReplicationStateParams(request.getFollowIndexName(), request.getReplicationStateParams());
        }
        return currentStateMetadata.removeReplicationStateParams(request.getFollowIndexName());
    }

    @kotlin.Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/opensearch/replication/metadata/UpdateReplicationStateDetailsTaskExecutor$Companion;", "", "()V", "INSTANCE", "Lorg/opensearch/replication/metadata/UpdateReplicationStateDetailsTaskExecutor;", "getINSTANCE", "()Lorg/opensearch/replication/metadata/UpdateReplicationStateDetailsTaskExecutor;", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UpdateReplicationStateDetailsTaskExecutor getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

