/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.RequestIpamResourceTag;
import com.amazonaws.services.ec2.model.transform.ModifyIpamPoolRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyIpamPoolRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyIpamPoolRequest> {
    private String ipamPoolId;
    private String description;
    private Boolean autoImport;
    private Integer allocationMinNetmaskLength;
    private Integer allocationMaxNetmaskLength;
    private Integer allocationDefaultNetmaskLength;
    private Boolean clearAllocationDefaultNetmaskLength;
    private SdkInternalList<RequestIpamResourceTag> addAllocationResourceTags;
    private SdkInternalList<RequestIpamResourceTag> removeAllocationResourceTags;

    public void setIpamPoolId(String ipamPoolId) {
        this.ipamPoolId = ipamPoolId;
    }

    public String getIpamPoolId() {
        return this.ipamPoolId;
    }

    public ModifyIpamPoolRequest withIpamPoolId(String ipamPoolId) {
        this.setIpamPoolId(ipamPoolId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ModifyIpamPoolRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setAutoImport(Boolean autoImport) {
        this.autoImport = autoImport;
    }

    public Boolean getAutoImport() {
        return this.autoImport;
    }

    public ModifyIpamPoolRequest withAutoImport(Boolean autoImport) {
        this.setAutoImport(autoImport);
        return this;
    }

    public Boolean isAutoImport() {
        return this.autoImport;
    }

    public void setAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
        this.allocationMinNetmaskLength = allocationMinNetmaskLength;
    }

    public Integer getAllocationMinNetmaskLength() {
        return this.allocationMinNetmaskLength;
    }

    public ModifyIpamPoolRequest withAllocationMinNetmaskLength(Integer allocationMinNetmaskLength) {
        this.setAllocationMinNetmaskLength(allocationMinNetmaskLength);
        return this;
    }

    public void setAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
        this.allocationMaxNetmaskLength = allocationMaxNetmaskLength;
    }

    public Integer getAllocationMaxNetmaskLength() {
        return this.allocationMaxNetmaskLength;
    }

    public ModifyIpamPoolRequest withAllocationMaxNetmaskLength(Integer allocationMaxNetmaskLength) {
        this.setAllocationMaxNetmaskLength(allocationMaxNetmaskLength);
        return this;
    }

    public void setAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
        this.allocationDefaultNetmaskLength = allocationDefaultNetmaskLength;
    }

    public Integer getAllocationDefaultNetmaskLength() {
        return this.allocationDefaultNetmaskLength;
    }

    public ModifyIpamPoolRequest withAllocationDefaultNetmaskLength(Integer allocationDefaultNetmaskLength) {
        this.setAllocationDefaultNetmaskLength(allocationDefaultNetmaskLength);
        return this;
    }

    public void setClearAllocationDefaultNetmaskLength(Boolean clearAllocationDefaultNetmaskLength) {
        this.clearAllocationDefaultNetmaskLength = clearAllocationDefaultNetmaskLength;
    }

    public Boolean getClearAllocationDefaultNetmaskLength() {
        return this.clearAllocationDefaultNetmaskLength;
    }

    public ModifyIpamPoolRequest withClearAllocationDefaultNetmaskLength(Boolean clearAllocationDefaultNetmaskLength) {
        this.setClearAllocationDefaultNetmaskLength(clearAllocationDefaultNetmaskLength);
        return this;
    }

    public Boolean isClearAllocationDefaultNetmaskLength() {
        return this.clearAllocationDefaultNetmaskLength;
    }

    public List<RequestIpamResourceTag> getAddAllocationResourceTags() {
        if (this.addAllocationResourceTags == null) {
            this.addAllocationResourceTags = new SdkInternalList();
        }
        return this.addAllocationResourceTags;
    }

    public void setAddAllocationResourceTags(Collection<RequestIpamResourceTag> addAllocationResourceTags) {
        if (addAllocationResourceTags == null) {
            this.addAllocationResourceTags = null;
            return;
        }
        this.addAllocationResourceTags = new SdkInternalList(addAllocationResourceTags);
    }

    public ModifyIpamPoolRequest withAddAllocationResourceTags(RequestIpamResourceTag ... addAllocationResourceTags) {
        if (this.addAllocationResourceTags == null) {
            this.setAddAllocationResourceTags((Collection<RequestIpamResourceTag>)new SdkInternalList(addAllocationResourceTags.length));
        }
        for (RequestIpamResourceTag ele : addAllocationResourceTags) {
            this.addAllocationResourceTags.add((Object)ele);
        }
        return this;
    }

    public ModifyIpamPoolRequest withAddAllocationResourceTags(Collection<RequestIpamResourceTag> addAllocationResourceTags) {
        this.setAddAllocationResourceTags(addAllocationResourceTags);
        return this;
    }

    public List<RequestIpamResourceTag> getRemoveAllocationResourceTags() {
        if (this.removeAllocationResourceTags == null) {
            this.removeAllocationResourceTags = new SdkInternalList();
        }
        return this.removeAllocationResourceTags;
    }

    public void setRemoveAllocationResourceTags(Collection<RequestIpamResourceTag> removeAllocationResourceTags) {
        if (removeAllocationResourceTags == null) {
            this.removeAllocationResourceTags = null;
            return;
        }
        this.removeAllocationResourceTags = new SdkInternalList(removeAllocationResourceTags);
    }

    public ModifyIpamPoolRequest withRemoveAllocationResourceTags(RequestIpamResourceTag ... removeAllocationResourceTags) {
        if (this.removeAllocationResourceTags == null) {
            this.setRemoveAllocationResourceTags((Collection<RequestIpamResourceTag>)new SdkInternalList(removeAllocationResourceTags.length));
        }
        for (RequestIpamResourceTag ele : removeAllocationResourceTags) {
            this.removeAllocationResourceTags.add((Object)ele);
        }
        return this;
    }

    public ModifyIpamPoolRequest withRemoveAllocationResourceTags(Collection<RequestIpamResourceTag> removeAllocationResourceTags) {
        this.setRemoveAllocationResourceTags(removeAllocationResourceTags);
        return this;
    }

    @Override
    public Request<ModifyIpamPoolRequest> getDryRunRequest() {
        Request<ModifyIpamPoolRequest> request = new ModifyIpamPoolRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpamPoolId() != null) {
            sb.append("IpamPoolId: ").append(this.getIpamPoolId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getAutoImport() != null) {
            sb.append("AutoImport: ").append(this.getAutoImport()).append(",");
        }
        if (this.getAllocationMinNetmaskLength() != null) {
            sb.append("AllocationMinNetmaskLength: ").append(this.getAllocationMinNetmaskLength()).append(",");
        }
        if (this.getAllocationMaxNetmaskLength() != null) {
            sb.append("AllocationMaxNetmaskLength: ").append(this.getAllocationMaxNetmaskLength()).append(",");
        }
        if (this.getAllocationDefaultNetmaskLength() != null) {
            sb.append("AllocationDefaultNetmaskLength: ").append(this.getAllocationDefaultNetmaskLength()).append(",");
        }
        if (this.getClearAllocationDefaultNetmaskLength() != null) {
            sb.append("ClearAllocationDefaultNetmaskLength: ").append(this.getClearAllocationDefaultNetmaskLength()).append(",");
        }
        if (this.getAddAllocationResourceTags() != null) {
            sb.append("AddAllocationResourceTags: ").append(this.getAddAllocationResourceTags()).append(",");
        }
        if (this.getRemoveAllocationResourceTags() != null) {
            sb.append("RemoveAllocationResourceTags: ").append(this.getRemoveAllocationResourceTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpamPoolRequest)) {
            return false;
        }
        ModifyIpamPoolRequest other = (ModifyIpamPoolRequest)obj;
        if (other.getIpamPoolId() == null ^ this.getIpamPoolId() == null) {
            return false;
        }
        if (other.getIpamPoolId() != null && !other.getIpamPoolId().equals(this.getIpamPoolId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getAutoImport() == null ^ this.getAutoImport() == null) {
            return false;
        }
        if (other.getAutoImport() != null && !other.getAutoImport().equals(this.getAutoImport())) {
            return false;
        }
        if (other.getAllocationMinNetmaskLength() == null ^ this.getAllocationMinNetmaskLength() == null) {
            return false;
        }
        if (other.getAllocationMinNetmaskLength() != null && !other.getAllocationMinNetmaskLength().equals(this.getAllocationMinNetmaskLength())) {
            return false;
        }
        if (other.getAllocationMaxNetmaskLength() == null ^ this.getAllocationMaxNetmaskLength() == null) {
            return false;
        }
        if (other.getAllocationMaxNetmaskLength() != null && !other.getAllocationMaxNetmaskLength().equals(this.getAllocationMaxNetmaskLength())) {
            return false;
        }
        if (other.getAllocationDefaultNetmaskLength() == null ^ this.getAllocationDefaultNetmaskLength() == null) {
            return false;
        }
        if (other.getAllocationDefaultNetmaskLength() != null && !other.getAllocationDefaultNetmaskLength().equals(this.getAllocationDefaultNetmaskLength())) {
            return false;
        }
        if (other.getClearAllocationDefaultNetmaskLength() == null ^ this.getClearAllocationDefaultNetmaskLength() == null) {
            return false;
        }
        if (other.getClearAllocationDefaultNetmaskLength() != null && !other.getClearAllocationDefaultNetmaskLength().equals(this.getClearAllocationDefaultNetmaskLength())) {
            return false;
        }
        if (other.getAddAllocationResourceTags() == null ^ this.getAddAllocationResourceTags() == null) {
            return false;
        }
        if (other.getAddAllocationResourceTags() != null && !other.getAddAllocationResourceTags().equals(this.getAddAllocationResourceTags())) {
            return false;
        }
        if (other.getRemoveAllocationResourceTags() == null ^ this.getRemoveAllocationResourceTags() == null) {
            return false;
        }
        return other.getRemoveAllocationResourceTags() == null || other.getRemoveAllocationResourceTags().equals(this.getRemoveAllocationResourceTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpamPoolId() == null ? 0 : this.getIpamPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAutoImport() == null ? 0 : this.getAutoImport().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationMinNetmaskLength() == null ? 0 : this.getAllocationMinNetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationMaxNetmaskLength() == null ? 0 : this.getAllocationMaxNetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationDefaultNetmaskLength() == null ? 0 : this.getAllocationDefaultNetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getClearAllocationDefaultNetmaskLength() == null ? 0 : this.getClearAllocationDefaultNetmaskLength().hashCode());
        hashCode = 31 * hashCode + (this.getAddAllocationResourceTags() == null ? 0 : this.getAddAllocationResourceTags().hashCode());
        hashCode = 31 * hashCode + (this.getRemoveAllocationResourceTags() == null ? 0 : this.getRemoveAllocationResourceTags().hashCode());
        return hashCode;
    }

    public ModifyIpamPoolRequest clone() {
        return (ModifyIpamPoolRequest)super.clone();
    }
}

