/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeClientVpnTargetNetworksRequestMarshaller
implements Marshaller<Request<DescribeClientVpnTargetNetworksRequest>, DescribeClientVpnTargetNetworksRequest> {
    public Request<DescribeClientVpnTargetNetworksRequest> marshall(DescribeClientVpnTargetNetworksRequest describeClientVpnTargetNetworksRequest) {
        SdkInternalList describeClientVpnTargetNetworksRequestFiltersList;
        SdkInternalList describeClientVpnTargetNetworksRequestAssociationIdsList;
        if (describeClientVpnTargetNetworksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClientVpnTargetNetworksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeClientVpnTargetNetworks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClientVpnTargetNetworksRequest.getClientVpnEndpointId() != null) {
            request.addParameter("ClientVpnEndpointId", StringUtils.fromString((String)describeClientVpnTargetNetworksRequest.getClientVpnEndpointId()));
        }
        if (!(describeClientVpnTargetNetworksRequestAssociationIdsList = (SdkInternalList)describeClientVpnTargetNetworksRequest.getAssociationIds()).isEmpty() || !describeClientVpnTargetNetworksRequestAssociationIdsList.isAutoConstruct()) {
            int associationIdsListIndex = 1;
            for (String describeClientVpnTargetNetworksRequestAssociationIdsListValue : describeClientVpnTargetNetworksRequestAssociationIdsList) {
                if (describeClientVpnTargetNetworksRequestAssociationIdsListValue != null) {
                    request.addParameter("AssociationIds." + associationIdsListIndex, StringUtils.fromString((String)describeClientVpnTargetNetworksRequestAssociationIdsListValue));
                }
                ++associationIdsListIndex;
            }
        }
        if (describeClientVpnTargetNetworksRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeClientVpnTargetNetworksRequest.getMaxResults()));
        }
        if (describeClientVpnTargetNetworksRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeClientVpnTargetNetworksRequest.getNextToken()));
        }
        if (!(describeClientVpnTargetNetworksRequestFiltersList = (SdkInternalList)describeClientVpnTargetNetworksRequest.getFilters()).isEmpty() || !describeClientVpnTargetNetworksRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeClientVpnTargetNetworksRequestFiltersListValue : describeClientVpnTargetNetworksRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeClientVpnTargetNetworksRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeClientVpnTargetNetworksRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeClientVpnTargetNetworksRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

