/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeIpamScopesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeIpamScopesRequestMarshaller
implements Marshaller<Request<DescribeIpamScopesRequest>, DescribeIpamScopesRequest> {
    public Request<DescribeIpamScopesRequest> marshall(DescribeIpamScopesRequest describeIpamScopesRequest) {
        SdkInternalList describeIpamScopesRequestIpamScopeIdsList;
        if (describeIpamScopesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIpamScopesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeIpamScopes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeIpamScopesRequestFiltersList = (SdkInternalList)describeIpamScopesRequest.getFilters();
        if (!describeIpamScopesRequestFiltersList.isEmpty() || !describeIpamScopesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeIpamScopesRequestFiltersListValue : describeIpamScopesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeIpamScopesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeIpamScopesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeIpamScopesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIpamScopesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeIpamScopesRequest.getMaxResults()));
        }
        if (describeIpamScopesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeIpamScopesRequest.getNextToken()));
        }
        if (!(describeIpamScopesRequestIpamScopeIdsList = (SdkInternalList)describeIpamScopesRequest.getIpamScopeIds()).isEmpty() || !describeIpamScopesRequestIpamScopeIdsList.isAutoConstruct()) {
            int ipamScopeIdsListIndex = 1;
            for (String describeIpamScopesRequestIpamScopeIdsListValue : describeIpamScopesRequestIpamScopeIdsList) {
                if (describeIpamScopesRequestIpamScopeIdsListValue != null) {
                    request.addParameter("IpamScopeId." + ipamScopeIdsListIndex, StringUtils.fromString((String)describeIpamScopesRequestIpamScopeIdsListValue));
                }
                ++ipamScopeIdsListIndex;
            }
        }
        return request;
    }
}

