/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.join;

import java.io.IOException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.sql.legacy.domain.Condition;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.query.join.JoinRequestBuilder;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.maker.QueryMaker;

public class NestedLoopsElasticRequestBuilder
extends JoinRequestBuilder {
    private Where connectedWhere;
    private int multiSearchMaxSize = 100;

    @Override
    public String explain() {
        Object conditions = "";
        try {
            Where where = (Where)this.connectedWhere.clone();
            this.setValueTypeConditionToStringRecursive(where);
            if (where != null) {
                conditions = QueryMaker.explain(where, false).toString();
            }
        }
        catch (CloneNotSupportedException | SqlParseException e) {
            conditions = "Could not parse conditions due to " + e.getMessage();
        }
        String desc = "Nested Loops run first query, and for each result run second query with additional conditions as following.";
        String[] queries = this.explainNL();
        JSONStringer jsonStringer = new JSONStringer();
        jsonStringer.object().key("description").value((Object)desc).key("conditions").value((Object)new JSONObject((String)conditions)).key("first query").value((Object)new JSONObject(queries[0])).key("second query").value((Object)new JSONObject(queries[1])).endObject();
        return jsonStringer.toString();
    }

    public int getMultiSearchMaxSize() {
        return this.multiSearchMaxSize;
    }

    public void setMultiSearchMaxSize(int multiSearchMaxSize) {
        this.multiSearchMaxSize = multiSearchMaxSize;
    }

    public Where getConnectedWhere() {
        return this.connectedWhere;
    }

    public void setConnectedWhere(Where connectedWhere) {
        this.connectedWhere = connectedWhere;
    }

    private void setValueTypeConditionToStringRecursive(Where where) {
        if (where == null) {
            return;
        }
        if (where instanceof Condition) {
            Condition c = (Condition)where;
            c.setValue(c.getValue().toString());
            return;
        }
        for (Where innerWhere : where.getWheres()) {
            this.setValueTypeConditionToStringRecursive(innerWhere);
        }
    }

    private String[] explainNL() {
        return new String[]{this.explainQuery(this.getFirstTable()), this.explainQuery(this.getSecondTable())};
    }

    private String explainQuery(TableInJoinRequestBuilder requestBuilder) {
        try {
            XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).prettyPrint();
            ((SearchRequest)requestBuilder.getRequestBuilder().request()).source().toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            return BytesReference.bytes((XContentBuilder)xContentBuilder).utf8ToString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

