/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.awt.geom.XRectangle2D;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.image.EntityImageNote;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageTips
extends AbstractEntityImage {
    private final ISkinParam skinParam;
    private final HColor noteBackgroundColor;
    private final HColor borderColor;
    private final Bibliotekon bibliotekon;
    private final Style style;
    private final double ySpacing = 10.0;

    public EntityImageTips(ILeaf entity, ISkinParam skinParam, Bibliotekon bibliotekon, UmlDiagramType type) {
        super(entity, EntityImageNote.getSkin(skinParam, entity));
        this.skinParam = skinParam;
        this.bibliotekon = bibliotekon;
        this.style = this.getDefaultStyleDefinition(type.getStyleName()).getMergedStyle(skinParam.getCurrentStyleBuilder());
        this.noteBackgroundColor = entity.getColors().getColor(ColorType.BACK) == null ? this.style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet()) : entity.getColors().getColor(ColorType.BACK);
        this.borderColor = this.style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
    }

    private StyleSignature getDefaultStyleDefinition(SName sname) {
        return StyleSignatureBasic.of(SName.root, SName.element, sname, SName.note).withTOBECHANGED(this.getStereo());
    }

    private Position getPosition() {
        if (this.getEntity().getCodeGetName().endsWith(Position.RIGHT.name())) {
            return Position.RIGHT;
        }
        return Position.LEFT;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            XDimension2D dim = this.getOpale(display).calculateDimension(stringBounder);
            height += dim.getHeight();
            height += 10.0;
            width = Math.max(width, dim.getWidth());
        }
        return new XDimension2D(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        IEntity other = this.bibliotekon.getOnlyOther(this.getEntity());
        SvekNode nodeMe = this.bibliotekon.getNode(this.getEntity());
        SvekNode nodeOther = this.bibliotekon.getNode(other);
        XPoint2D positionMe = nodeMe.getPosition();
        if (nodeOther == null) {
            System.err.println("Error in EntityImageTips");
            return;
        }
        XPoint2D positionOther = nodeOther.getPosition();
        this.bibliotekon.getNode(this.getEntity());
        Position position = this.getPosition();
        Direction direction = position.reverseDirection();
        double height = 0.0;
        for (Map.Entry<String, Display> ent : this.getEntity().getTips().entrySet()) {
            Display display = ent.getValue();
            XRectangle2D memberPosition = nodeOther.getImage().getInnerPosition(ent.getKey(), stringBounder, InnerStrategy.STRICT);
            if (memberPosition == null) {
                return;
            }
            Opale opale = this.getOpale(display);
            XDimension2D dim = opale.calculateDimension(stringBounder);
            XPoint2D pp1 = new XPoint2D(0.0, dim.getHeight() / 2.0);
            double x = positionOther.getX() - positionMe.getX();
            if (direction == Direction.RIGHT && x < 0.0) {
                direction = direction.getInv();
            }
            x = direction == Direction.LEFT ? (x += memberPosition.getMaxX()) : (x += 4.0);
            double y = positionOther.getY() - positionMe.getY() - height + memberPosition.getCenterY();
            XPoint2D pp2 = new XPoint2D(x, y);
            opale.setOpale(direction, pp1, pp2);
            opale.drawU(ug);
            ug = ug.apply(UTranslate.dy(dim.getHeight() + 10.0));
            height += dim.getHeight();
            height += 10.0;
        }
    }

    private Opale getOpale(Display display) {
        double shadowing = this.style.value(PName.Shadowing).asDouble();
        FontConfiguration fc = this.style.getFontConfiguration(this.skinParam.getIHtmlColorSet());
        UStroke stroke = this.style.getStroke();
        TextBlock textBlock = BodyFactory.create3(display, this.skinParam, HorizontalAlignment.LEFT, fc, this.skinParam.wrapWidth(), this.style);
        return new Opale(shadowing, this.borderColor, this.noteBackgroundColor, textBlock, true, stroke);
    }
}

