/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardStepsView;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import com.eteks.sweethome3d.viewcontroller.WizardController;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class ImportedFurnitureWizardController
extends WizardController
implements Controller {
    private final Home home;
    private final CatalogPieceOfFurniture piece;
    private final String modelName;
    private final UserPreferences preferences;
    private final FurnitureController furnitureController;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private final ImportedFurnitureWizardStepState furnitureModelStepState;
    private final ImportedFurnitureWizardStepState furnitureOrientationStepState;
    private final ImportedFurnitureWizardStepState furnitureAttributesStepState;
    private final ImportedFurnitureWizardStepState furnitureIconStepState;
    private ImportedFurnitureWizardStepsView stepsView;
    private Step step;
    private String name;
    private String creator;
    private Content model;
    private float width;
    private float proportionalWidth;
    private float depth;
    private float proportionalDepth;
    private float height;
    private float proportionalHeight;
    private float elevation;
    private boolean movable;
    private boolean doorOrWindow;
    private String staircaseCutOutShape;
    private Integer color;
    private FurnitureCategory category;
    private long modelSize;
    private float[][] modelRotation;
    private boolean edgeColorMaterialHidden;
    private boolean backFaceShown;
    private float iconYaw;
    private float iconPitch;
    private float iconScale;
    private boolean proportional;
    private final ViewFactory viewFactory;

    public ImportedFurnitureWizardController(UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(null, null, null, userPreferences, null, viewFactory, contentManager, null);
    }

    public ImportedFurnitureWizardController(String string, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(null, null, string, userPreferences, null, viewFactory, contentManager, null);
    }

    public ImportedFurnitureWizardController(CatalogPieceOfFurniture catalogPieceOfFurniture, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this(null, catalogPieceOfFurniture, null, userPreferences, null, viewFactory, contentManager, null);
    }

    public ImportedFurnitureWizardController(Home home, UserPreferences userPreferences, FurnitureController furnitureController, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this(home, null, null, userPreferences, furnitureController, viewFactory, contentManager, undoableEditSupport);
    }

    public ImportedFurnitureWizardController(Home home, String string, UserPreferences userPreferences, FurnitureController furnitureController, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this(home, null, string, userPreferences, furnitureController, viewFactory, contentManager, undoableEditSupport);
    }

    private ImportedFurnitureWizardController(Home home, CatalogPieceOfFurniture catalogPieceOfFurniture, String string, UserPreferences userPreferences, FurnitureController furnitureController, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        super(userPreferences, viewFactory);
        this.home = home;
        this.piece = catalogPieceOfFurniture;
        this.modelName = string;
        this.preferences = userPreferences;
        this.furnitureController = furnitureController;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.setTitle(this.preferences.getLocalizedString(ImportedFurnitureWizardController.class, catalogPieceOfFurniture == null ? "importFurnitureWizard.title" : "modifyFurnitureWizard.title", new Object[0]));
        this.furnitureModelStepState = new FurnitureModelStepState();
        this.furnitureOrientationStepState = new FurnitureOrientationStepState();
        this.furnitureAttributesStepState = new FurnitureAttributesStepState();
        this.furnitureIconStepState = new FurnitureIconStepState();
        this.setStepState(this.furnitureModelStepState);
    }

    @Override
    public void finish() {
        int n = (this.isBackFaceShown() ? 1 : 0) | (this.isEdgeColorMaterialHidden() ? 2 : 0);
        CatalogPieceOfFurniture catalogPieceOfFurniture = this.isDoorOrWindow() ? new CatalogDoorOrWindow(this.getName(), this.getIcon(), this.getModel(), this.getWidth(), this.getDepth(), this.getHeight(), this.getElevation(), this.isMovable(), 1.0f, 0.0f, new Sash[0], this.getColor(), this.getModelRotation(), n, this.getModelSize(), this.getCreator(), this.getIconYaw(), this.getIconPitch(), this.getIconScale(), this.isProportional()) : new CatalogPieceOfFurniture(this.getName(), this.getIcon(), this.getModel(), this.getWidth(), this.getDepth(), this.getHeight(), this.getElevation(), this.isMovable(), this.getStaircaseCutOutShape(), this.getColor(), this.getModelRotation(), n, this.getModelSize(), this.getCreator(), this.getIconYaw(), this.getIconPitch(), this.getIconScale(), this.isProportional());
        if (this.home != null) {
            this.addPieceOfFurniture(this.furnitureController.createHomePieceOfFurniture(catalogPieceOfFurniture));
        }
        FurnitureCatalog furnitureCatalog = this.preferences.getFurnitureCatalog();
        if (this.piece != null) {
            furnitureCatalog.delete(this.piece);
        }
        if (this.category != null) {
            furnitureCatalog.add(this.category, catalogPieceOfFurniture);
        }
    }

    public void addPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        boolean bl = this.home.isBasePlanLocked();
        boolean bl2 = this.home.isAllLevelsSelection();
        List<Selectable> list = this.home.getSelectedItems();
        int n = this.home.getFurniture().size();
        this.home.addPieceOfFurniture(homePieceOfFurniture, n);
        this.home.setSelectedItems(Arrays.asList(homePieceOfFurniture));
        if (!homePieceOfFurniture.isMovable() && bl) {
            this.home.setBasePlanLocked(false);
        }
        this.home.setAllLevelsSelection(false);
        if (this.undoSupport != null) {
            PieceOfFurnitureImportationUndoableEdit pieceOfFurnitureImportationUndoableEdit = new PieceOfFurnitureImportationUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), bl, bl2, homePieceOfFurniture, n);
            this.undoSupport.postEdit(pieceOfFurnitureImportationUndoableEdit);
        }
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    @Override
    protected ImportedFurnitureWizardStepState getStepState() {
        return (ImportedFurnitureWizardStepState)super.getStepState();
    }

    protected ImportedFurnitureWizardStepState getFurnitureModelStepState() {
        return this.furnitureModelStepState;
    }

    protected ImportedFurnitureWizardStepState getFurnitureOrientationStepState() {
        return this.furnitureOrientationStepState;
    }

    protected ImportedFurnitureWizardStepState getFurnitureAttributesStepState() {
        return this.furnitureAttributesStepState;
    }

    protected ImportedFurnitureWizardStepState getFurnitureIconStepState() {
        return this.furnitureIconStepState;
    }

    protected ImportedFurnitureWizardStepsView getStepsView() {
        if (this.stepsView == null) {
            this.stepsView = this.viewFactory.createImportedFurnitureWizardStepsView(this.piece, this.modelName, this.home != null, this.preferences, this);
        }
        return this.stepsView;
    }

    protected void setStep(Step step) {
        if (step != this.step) {
            Step step2 = this.step;
            this.step = step;
            this.propertyChangeSupport.firePropertyChange(Property.STEP.name(), (Object)step2, (Object)step);
        }
    }

    public Step getStep() {
        return this.step;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public Content getModel() {
        return this.model;
    }

    public void setModel(Content content) {
        if (content != this.model) {
            Content content2 = this.model;
            this.model = content;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL.name(), content2, content);
        }
    }

    public boolean isBackFaceShown() {
        return this.backFaceShown;
    }

    public void setBackFaceShown(boolean bl) {
        if (bl != this.backFaceShown) {
            this.backFaceShown = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BACK_FACE_SHOWN.name(), !bl, bl);
        }
    }

    public long getModelSize() {
        return this.modelSize;
    }

    public void setModelSize(long l) {
        if (l != this.modelSize) {
            long l2 = this.modelSize;
            this.modelSize = l;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_SIZE.name(), l2, l);
        }
    }

    public float[][] getModelRotation() {
        return this.modelRotation;
    }

    public void setModelRotation(float[][] fArray) {
        if (fArray != this.modelRotation) {
            float[][] fArray2 = this.modelRotation;
            this.modelRotation = fArray;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_ROTATION.name(), fArray2, fArray);
        }
    }

    public boolean isEdgeColorMaterialHidden() {
        return this.edgeColorMaterialHidden;
    }

    public void setEdgeColorMaterialHidden(boolean bl) {
        if (bl != this.edgeColorMaterialHidden) {
            this.edgeColorMaterialHidden = bl;
            this.propertyChangeSupport.firePropertyChange(Property.EDGE_COLOR_MATERIAL_HIDDEN.name(), !bl, bl);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
            }
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        if (string != this.creator) {
            String string2 = this.creator;
            this.creator = string;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange(Property.CREATOR.name(), string2, string);
            }
        }
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float f) {
        this.setWidth(f, false);
    }

    private void setWidth(float f, boolean bl) {
        float f2 = Math.max(f, 0.001f);
        if (f2 == f || !bl) {
            this.proportionalWidth = f;
        }
        if (f2 != this.width) {
            float f3 = this.width;
            this.width = f2;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), Float.valueOf(f3), Float.valueOf(f2));
        }
    }

    public float getDepth() {
        return this.depth;
    }

    public void setDepth(float f) {
        this.setDepth(f, false);
    }

    private void setDepth(float f, boolean bl) {
        float f2 = Math.max(f, 0.001f);
        if (f2 == f || !bl) {
            this.proportionalDepth = f;
        }
        if (f2 != this.depth) {
            float f3 = this.depth;
            this.depth = f2;
            this.propertyChangeSupport.firePropertyChange(Property.DEPTH.name(), Float.valueOf(f3), Float.valueOf(f2));
        }
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f) {
        this.setHeight(f, false);
    }

    private void setHeight(float f, boolean bl) {
        float f2 = Math.max(f, 0.001f);
        if (f2 == f || !bl) {
            this.proportionalHeight = f;
        }
        if (f2 != this.height) {
            float f3 = this.height;
            this.height = f2;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), Float.valueOf(f3), Float.valueOf(f2));
        }
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float f) {
        if (f != this.elevation) {
            float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean bl) {
        if (bl != this.movable) {
            this.movable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MOVABLE.name(), !bl, bl);
        }
    }

    public boolean isDoorOrWindow() {
        return this.doorOrWindow;
    }

    public void setDoorOrWindow(boolean bl) {
        if (bl != this.doorOrWindow) {
            this.doorOrWindow = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DOOR_OR_WINDOW.name(), !bl, bl);
            if (bl) {
                this.setStaircaseCutOutShape(null);
                this.setMovable(false);
            }
        }
    }

    public String getStaircaseCutOutShape() {
        return this.staircaseCutOutShape;
    }

    public void setStaircaseCutOutShape(String string) {
        if (string != this.staircaseCutOutShape) {
            String string2 = this.staircaseCutOutShape;
            this.staircaseCutOutShape = string;
            if (this.propertyChangeSupport != null) {
                this.propertyChangeSupport.firePropertyChange(Property.STAIRCASE_CUT_OUT_SHAPE.name(), string2, string);
            }
            if (this.staircaseCutOutShape != null) {
                this.setDoorOrWindow(false);
                this.setMovable(false);
            }
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public FurnitureCategory getCategory() {
        return this.category;
    }

    public void setCategory(FurnitureCategory furnitureCategory) {
        if (furnitureCategory != this.category) {
            FurnitureCategory furnitureCategory2 = this.category;
            this.category = furnitureCategory;
            this.propertyChangeSupport.firePropertyChange(Property.CATEGORY.name(), furnitureCategory2, furnitureCategory);
        }
    }

    private Content getIcon() {
        return this.getStepsView().getIcon();
    }

    public float getIconYaw() {
        return this.iconYaw;
    }

    public void setIconYaw(float f) {
        if (f != this.iconYaw) {
            float f2 = this.iconYaw;
            this.iconYaw = f;
            this.propertyChangeSupport.firePropertyChange(Property.ICON_YAW.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getIconPitch() {
        return this.iconPitch;
    }

    public void setIconPitch(float f) {
        if (f != this.iconPitch) {
            float f2 = this.iconPitch;
            this.iconPitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.ICON_PITCH.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getIconScale() {
        return this.iconScale;
    }

    public void setIconScale(float f) {
        if (f != this.iconScale) {
            float f2 = this.iconScale;
            this.iconScale = f;
            this.propertyChangeSupport.firePropertyChange(Property.ICON_SCALE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setProportional(boolean bl) {
        if (bl != this.proportional) {
            this.proportional = bl;
            this.propertyChangeSupport.firePropertyChange(Property.PROPORTIONAL.name(), !bl, bl);
        }
    }

    public boolean isPieceOfFurnitureNameValid() {
        return this.name != null && this.name.length() > 0;
    }

    private class FurnitureIconStepState
    extends ImportedFurnitureWizardStepState {
        private FurnitureIconStepState() {
        }

        @Override
        public void enter() {
            super.enter();
            this.setLastStep(true);
            this.setNextStepEnabled(true);
        }

        @Override
        public Step getStep() {
            return Step.ICON;
        }

        @Override
        public void goBackToPreviousStep() {
            ImportedFurnitureWizardController.this.setStepState(ImportedFurnitureWizardController.this.getFurnitureAttributesStepState());
        }
    }

    private class FurnitureAttributesStepState
    extends ImportedFurnitureWizardStepState {
        PropertyChangeListener widthChangeListener;
        PropertyChangeListener depthChangeListener;
        PropertyChangeListener heightChangeListener;
        PropertyChangeListener nameAndCategoryChangeListener;

        private FurnitureAttributesStepState() {
            this.widthChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ImportedFurnitureWizardController.this.isProportional()) {
                        ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.DEPTH, FurnitureAttributesStepState.this.depthChangeListener);
                        ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.HEIGHT, FurnitureAttributesStepState.this.heightChangeListener);
                        float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                        ImportedFurnitureWizardController.this.setDepth(ImportedFurnitureWizardController.this.proportionalDepth * f, true);
                        ImportedFurnitureWizardController.this.setHeight(ImportedFurnitureWizardController.this.proportionalHeight * f, true);
                        ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.DEPTH, FurnitureAttributesStepState.this.depthChangeListener);
                        ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.HEIGHT, FurnitureAttributesStepState.this.heightChangeListener);
                    }
                }
            };
            this.depthChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ImportedFurnitureWizardController.this.isProportional()) {
                        ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.WIDTH, FurnitureAttributesStepState.this.widthChangeListener);
                        ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.HEIGHT, FurnitureAttributesStepState.this.heightChangeListener);
                        float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                        ImportedFurnitureWizardController.this.setWidth(ImportedFurnitureWizardController.this.proportionalWidth * f, true);
                        ImportedFurnitureWizardController.this.setHeight(ImportedFurnitureWizardController.this.proportionalHeight * f, true);
                        ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.WIDTH, FurnitureAttributesStepState.this.widthChangeListener);
                        ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.HEIGHT, FurnitureAttributesStepState.this.heightChangeListener);
                    }
                }
            };
            this.heightChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (ImportedFurnitureWizardController.this.isProportional()) {
                        ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.WIDTH, FurnitureAttributesStepState.this.widthChangeListener);
                        ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.DEPTH, FurnitureAttributesStepState.this.depthChangeListener);
                        float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                        ImportedFurnitureWizardController.this.setWidth(ImportedFurnitureWizardController.this.proportionalWidth * f, true);
                        ImportedFurnitureWizardController.this.setDepth(ImportedFurnitureWizardController.this.proportionalDepth * f, true);
                        ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.WIDTH, FurnitureAttributesStepState.this.widthChangeListener);
                        ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.DEPTH, FurnitureAttributesStepState.this.depthChangeListener);
                    }
                }
            };
            this.nameAndCategoryChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurnitureAttributesStepState.this.checkPieceOfFurnitureNameInCategory();
                }
            };
        }

        @Override
        public void enter() {
            super.enter();
            ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.WIDTH, this.widthChangeListener);
            ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.DEPTH, this.depthChangeListener);
            ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.HEIGHT, this.heightChangeListener);
            ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.NAME, this.nameAndCategoryChangeListener);
            ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.CATEGORY, this.nameAndCategoryChangeListener);
            this.checkPieceOfFurnitureNameInCategory();
        }

        private void checkPieceOfFurnitureNameInCategory() {
            this.setNextStepEnabled(ImportedFurnitureWizardController.this.isPieceOfFurnitureNameValid());
        }

        @Override
        public Step getStep() {
            return Step.ATTRIBUTES;
        }

        @Override
        public void goBackToPreviousStep() {
            ImportedFurnitureWizardController.this.setStepState(ImportedFurnitureWizardController.this.getFurnitureOrientationStepState());
        }

        @Override
        public void goToNextStep() {
            ImportedFurnitureWizardController.this.setStepState(ImportedFurnitureWizardController.this.getFurnitureIconStepState());
        }

        @Override
        public void exit() {
            ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.WIDTH, this.widthChangeListener);
            ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.DEPTH, this.depthChangeListener);
            ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.HEIGHT, this.heightChangeListener);
            ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.NAME, this.nameAndCategoryChangeListener);
            ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.CATEGORY, this.nameAndCategoryChangeListener);
        }
    }

    private class FurnitureOrientationStepState
    extends ImportedFurnitureWizardStepState {
        private FurnitureOrientationStepState() {
        }

        @Override
        public void enter() {
            super.enter();
            this.setNextStepEnabled(true);
        }

        @Override
        public Step getStep() {
            return Step.ROTATION;
        }

        @Override
        public void goBackToPreviousStep() {
            ImportedFurnitureWizardController.this.setStepState(ImportedFurnitureWizardController.this.getFurnitureModelStepState());
        }

        @Override
        public void goToNextStep() {
            ImportedFurnitureWizardController.this.setStepState(ImportedFurnitureWizardController.this.getFurnitureAttributesStepState());
        }
    }

    private class FurnitureModelStepState
    extends ImportedFurnitureWizardStepState {
        private PropertyChangeListener modelChangeListener;

        private FurnitureModelStepState() {
            this.modelChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurnitureModelStepState.this.setNextStepEnabled(ImportedFurnitureWizardController.this.getModel() != null);
                }
            };
        }

        @Override
        public void enter() {
            super.enter();
            this.setFirstStep(true);
            this.setNextStepEnabled(ImportedFurnitureWizardController.this.getModel() != null);
            ImportedFurnitureWizardController.this.addPropertyChangeListener(Property.MODEL, this.modelChangeListener);
        }

        @Override
        public Step getStep() {
            return Step.MODEL;
        }

        @Override
        public void goToNextStep() {
            ImportedFurnitureWizardController.this.setStepState(ImportedFurnitureWizardController.this.getFurnitureOrientationStepState());
        }

        @Override
        public void exit() {
            ImportedFurnitureWizardController.this.removePropertyChangeListener(Property.MODEL, this.modelChangeListener);
        }
    }

    protected abstract class ImportedFurnitureWizardStepState
    extends WizardController.WizardControllerStepState {
        private URL icon = ImportedFurnitureWizardController.class.getResource("resources/importedFurnitureWizard.png");

        protected ImportedFurnitureWizardStepState() {
        }

        public abstract Step getStep();

        @Override
        public void enter() {
            ImportedFurnitureWizardController.this.setStep(this.getStep());
        }

        @Override
        public View getView() {
            return ImportedFurnitureWizardController.this.getStepsView();
        }

        @Override
        public URL getIcon() {
            return this.icon;
        }
    }

    private static class PieceOfFurnitureImportationUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final HomePieceOfFurniture piece;
        private final int pieceIndex;

        private PieceOfFurnitureImportationUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, HomePieceOfFurniture homePieceOfFurniture, int n) {
            super(userPreferences, ImportedFurnitureWizardController.class, "undoImportFurnitureName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.piece = homePieceOfFurniture;
            this.pieceIndex = n;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.home.deletePieceOfFurniture(this.piece);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
            this.home.setAllLevelsSelection(this.oldAllLevelsSelection);
            this.home.setBasePlanLocked(this.oldBasePlanLocked);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.addPieceOfFurniture(this.piece, this.pieceIndex);
            this.home.setSelectedItems(Arrays.asList(this.piece));
            if (!this.piece.isMovable() && this.oldBasePlanLocked) {
                this.home.setBasePlanLocked(false);
            }
            this.home.setAllLevelsSelection(false);
        }
    }

    public static enum Step {
        MODEL,
        ROTATION,
        ATTRIBUTES,
        ICON;

    }

    public static enum Property {
        STEP,
        NAME,
        CREATOR,
        MODEL,
        WIDTH,
        DEPTH,
        HEIGHT,
        ELEVATION,
        MOVABLE,
        DOOR_OR_WINDOW,
        COLOR,
        CATEGORY,
        BACK_FACE_SHOWN,
        EDGE_COLOR_MATERIAL_HIDDEN,
        MODEL_SIZE,
        MODEL_ROTATION,
        STAIRCASE_CUT_OUT_SHAPE,
        ICON_YAW,
        ICON_PITCH,
        ICON_SCALE,
        PROPORTIONAL;

    }
}

