/* LocaleSetting.c generated by valac 0.56.3, the Vala compiler
 * generated from LocaleSetting.vala, do not modify */

/* Copyright 2011-2018 elementary LLC. (https://elementary.io)
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "locale-plug.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>
#include <libgnome-desktop/gnome-languages.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_locale_setting_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData;
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_END_LABEL_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_END_LABEL_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_locale_setting_end_label_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_END_LABEL_NUM_PROPERTIES];
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_SETTINGS_CHANGED_SIGNAL,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_NUM_SIGNALS
};
static guint switchboard_plug_locale_widgets_locale_setting_signals[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_NUM_SIGNALS] = {0};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingPrivate {
	GtkButton* set_button;
	GtkComboBox* format_combobox;
	GtkComboBox* region_combobox;
	GtkListStore* format_store;
	GtkListStore* region_store;
	SwitchboardPlugLocaleLocaleManager* lm;
	SwitchboardPlugLocaleWidgetsPreview* preview;
	gchar* language;
	SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel* region_endlabel;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	gchar* language;
	GeeHashSet* locales;
	gchar* _tmp0_;
	gchar* selected_locale_id;
	gboolean user_locale_found;
	gint locales_added;
	GtkListStore* _tmp1_;
	GeeHashMap* default_regions;
	GeeHashMap* _tmp2_;
	gchar* user_locale;
	SwitchboardPlugLocaleLocaleManager* _tmp3_;
	gchar* _tmp4_;
	GeeIterator* _locale_it;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	gchar* locale;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	gchar* code;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gchar* region_string;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GtkTreeIter iter;
	GtkListStore* _tmp14_;
	GtkTreeIter _tmp15_;
	GtkListStore* _tmp16_;
	GtkTreeIter _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	GeeHashMap* _tmp25_;
	const gchar* _tmp26_;
	GeeHashMap* _tmp27_;
	gpointer _tmp28_;
	gchar* _tmp29_;
	gboolean _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gint _tmp33_;
	GtkComboBox* _tmp34_;
	GtkComboBox* _tmp35_;
	const gchar* _tmp36_;
	GtkComboBox* _tmp37_;
	const gchar* _tmp38_;
	GtkComboBox* _tmp39_;
	GtkListStore* _tmp40_;
};

struct _Block8Data {
	int _ref_count_;
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	GraniteWidgetsModeButton* temperature;
};

static gint SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset;
static gpointer switchboard_plug_locale_widgets_locale_setting_parent_class = NULL;
static GSettings* switchboard_plug_locale_widgets_locale_setting_temperature_settings;
static GSettings* switchboard_plug_locale_widgets_locale_setting_temperature_settings = NULL;
static gpointer switchboard_plug_locale_widgets_locale_setting_end_label_parent_class = NULL;

static void switchboard_plug_locale_widgets_locale_setting_on_format_changed (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void switchboard_plug_locale_widgets_locale_setting_compare (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void switchboard_plug_locale_widgets_locale_setting_reload_locales_data_free (gpointer _data);
static gboolean switchboard_plug_locale_widgets_locale_setting_reload_locales_co (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_);
static void switchboard_plug_locale_widgets_locale_setting_reload_locales_ready (GObject* source_object,
                                                                          GAsyncResult* _res_,
                                                                          gpointer _user_data_);
static void switchboard_plug_locale_widgets_locale_setting_on_applied_to_system (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static GType switchboard_plug_locale_widgets_locale_setting_end_label_get_type_once (void);
static GObject * switchboard_plug_locale_widgets_locale_setting_constructor (GType type,
                                                                      guint n_construct_properties,
                                                                      GObjectConstructParam * construct_properties);
static void _switchboard_plug_locale_widgets_locale_setting_compare_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                    gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                              gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void _switchboard_plug_locale_widgets_locale_setting____lambda6_ (Block8Data* _data8_);
static void __switchboard_plug_locale_widgets_locale_setting____lambda6__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                                                            GtkWidget* widget,
                                                                                                            gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting___lambda7_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void __switchboard_plug_locale_widgets_locale_setting___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                                                     gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting___lambda8_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void __switchboard_plug_locale_widgets_locale_setting___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                                                     gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting___lambda9_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void __switchboard_plug_locale_widgets_locale_setting___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                                                     gpointer self);
static void switchboard_plug_locale_widgets_locale_setting_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_locale_setting_get_type_once (void);

static inline gpointer
switchboard_plug_locale_widgets_locale_setting_get_instance_private (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset);
}

SwitchboardPlugLocaleWidgetsLocaleSetting*
switchboard_plug_locale_widgets_locale_setting_construct (GType object_type)
{
	SwitchboardPlugLocaleWidgetsLocaleSetting * self = NULL;
	self = (SwitchboardPlugLocaleWidgetsLocaleSetting*) g_object_new (object_type, "icon-name", "preferences-desktop-locale", NULL);
	return self;
}

SwitchboardPlugLocaleWidgetsLocaleSetting*
switchboard_plug_locale_widgets_locale_setting_new (void)
{
	return switchboard_plug_locale_widgets_locale_setting_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LOCALE_SETTING);
}

gchar*
switchboard_plug_locale_widgets_locale_setting_get_selected_locale (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	GtkTreeIter iter = {0};
	gchar* locale = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->region_combobox;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		_g_free0 (locale);
		return result;
	}
	_tmp4_ = self->priv->region_store;
	_tmp5_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 1, &_tmp6_, -1);
	_g_free0 (locale);
	locale = _tmp6_;
	result = locale;
	return result;
}

gchar*
switchboard_plug_locale_widgets_locale_setting_get_format (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	GtkTreeIter iter = {0};
	gchar* format = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->format_combobox;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		_g_free0 (format);
		return result;
	}
	_tmp4_ = self->priv->format_store;
	_tmp5_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 1, &_tmp6_, -1);
	_g_free0 (format);
	format = _tmp6_;
	result = format;
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_on_format_changed (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	gchar* format = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
	format = _tmp0_;
	_tmp1_ = format;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		SwitchboardPlugLocaleWidgetsPreview* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->preview;
		_tmp3_ = format;
		switchboard_plug_locale_widgets_preview_reload_languages (_tmp2_, _tmp3_);
	}
	_g_free0 (format);
}

static void
switchboard_plug_locale_widgets_locale_setting_compare (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->set_button;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		SwitchboardPlugLocaleLocaleManager* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = self->priv->lm;
		_tmp3_ = switchboard_plug_locale_locale_manager_get_user_language (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = switchboard_plug_locale_widgets_locale_setting_get_selected_locale (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (_tmp7_) {
			SwitchboardPlugLocaleLocaleManager* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = self->priv->lm;
			_tmp9_ = switchboard_plug_locale_locale_manager_get_user_format (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
			_tmp12_ = _tmp11_;
			_tmp1_ = g_strcmp0 (_tmp10_, _tmp12_) == 0;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GtkButton* _tmp13_;
			_tmp13_ = self->priv->set_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, FALSE);
		} else {
			GtkButton* _tmp14_;
			_tmp14_ = self->priv->set_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
		}
	}
}

static void
switchboard_plug_locale_widgets_locale_setting_reload_locales_data_free (gpointer _data)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->language);
	_g_object_unref0 (_data_->locales);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_plug_locale_widgets_locale_setting_reload_locales (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                               const gchar* language,
                                                               GeeHashSet* locales,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	SwitchboardPlugLocaleWidgetsLocaleSetting* _tmp0_;
	gchar* _tmp1_;
	GeeHashSet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	g_return_if_fail (locales != NULL);
	_data_ = g_slice_new0 (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_widgets_locale_setting_reload_locales_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (language);
	_g_free0 (_data_->language);
	_data_->language = _tmp1_;
	_tmp2_ = _g_object_ref0 (locales);
	_g_object_unref0 (_data_->locales);
	_data_->locales = _tmp2_;
	switchboard_plug_locale_widgets_locale_setting_reload_locales_co (_data_);
}

void
switchboard_plug_locale_widgets_locale_setting_reload_locales_finish (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                                      GAsyncResult* _res_)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
switchboard_plug_locale_widgets_locale_setting_reload_locales_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_widgets_locale_setting_reload_locales_co (_data_);
}

static gboolean
switchboard_plug_locale_widgets_locale_setting_reload_locales_co (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup (_data_->language);
	_g_free0 (_data_->self->priv->language);
	_data_->self->priv->language = _data_->_tmp0_;
	_data_->selected_locale_id = NULL;
	_data_->user_locale_found = FALSE;
	_data_->locales_added = 0;
	_data_->_tmp1_ = _data_->self->priv->region_store;
	gtk_list_store_clear (_data_->_tmp1_);
	_data_->_state_ = 1;
	switchboard_plug_locale_utils_get_default_regions (switchboard_plug_locale_widgets_locale_setting_reload_locales_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = switchboard_plug_locale_utils_get_default_regions_finish (_data_->_res_);
	_data_->default_regions = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->lm;
	_data_->_tmp4_ = switchboard_plug_locale_locale_manager_get_user_language (_data_->_tmp3_);
	_data_->user_locale = _data_->_tmp4_;
	{
		_data_->_tmp5_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->locales);
		_data_->_locale_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_locale_it;
			if (!gee_iterator_next (_data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_locale_it;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->locale = (gchar*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->locale;
			_data_->_tmp10_ = NULL;
			_data_->_tmp11_ = gnome_parse_locale (_data_->_tmp9_, NULL, &_data_->_tmp10_, NULL, NULL);
			_g_free0 (_data_->code);
			_data_->code = _data_->_tmp10_;
			if (!_data_->_tmp11_) {
				_g_free0 (_data_->code);
				_g_free0 (_data_->locale);
				continue;
			}
			_data_->_tmp12_ = _data_->code;
			_data_->_tmp13_ = switchboard_plug_locale_utils_translate_region (_data_->language, _data_->_tmp12_, _data_->language);
			_data_->region_string = _data_->_tmp13_;
			memset (&_data_->iter, 0, sizeof (GtkTreeIter));
			_data_->_tmp14_ = _data_->self->priv->region_store;
			memset (&_data_->_tmp15_, 0, sizeof (GtkTreeIter));
			gtk_list_store_append (_data_->_tmp14_, &_data_->_tmp15_);
			_data_->iter = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->self->priv->region_store;
			_data_->_tmp17_ = _data_->iter;
			_data_->_tmp18_ = _data_->region_string;
			_data_->_tmp19_ = _data_->locale;
			gtk_list_store_set (_data_->_tmp16_, &_data_->_tmp17_, 0, _data_->_tmp18_, 1, _data_->_tmp19_, -1);
			_data_->_tmp20_ = _data_->user_locale;
			_data_->_tmp21_ = _data_->locale;
			if (g_strcmp0 (_data_->_tmp20_, _data_->_tmp21_) == 0) {
				_data_->_tmp22_ = _data_->locale;
				_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
				_g_free0 (_data_->selected_locale_id);
				_data_->selected_locale_id = _data_->_tmp23_;
				_data_->user_locale_found = TRUE;
			}
			if (!_data_->user_locale_found) {
				_data_->_tmp25_ = _data_->default_regions;
				_data_->_tmp24_ = gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp25_, _data_->language);
			} else {
				_data_->_tmp24_ = FALSE;
			}
			if (_data_->_tmp24_) {
				_data_->_tmp26_ = _data_->locale;
				_data_->_tmp27_ = _data_->default_regions;
				_data_->_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp27_, _data_->language);
				_data_->_tmp29_ = (gchar*) _data_->_tmp28_;
				_data_->_tmp30_ = g_str_has_prefix (_data_->_tmp26_, _data_->_tmp29_);
				_g_free0 (_data_->_tmp29_);
				if (_data_->_tmp30_) {
					_data_->_tmp31_ = _data_->locale;
					_data_->_tmp32_ = g_strdup (_data_->_tmp31_);
					_g_free0 (_data_->selected_locale_id);
					_data_->selected_locale_id = _data_->_tmp32_;
				}
			}
			_data_->_tmp33_ = _data_->locales_added;
			_data_->locales_added = _data_->_tmp33_ + 1;
			_g_free0 (_data_->region_string);
			_g_free0 (_data_->code);
			_g_free0 (_data_->locale);
		}
		_g_object_unref0 (_data_->_locale_it);
	}
	_data_->_tmp34_ = _data_->self->priv->region_combobox;
	gtk_combo_box_set_id_column (_data_->_tmp34_, 1);
	_data_->_tmp35_ = _data_->self->priv->region_combobox;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp35_, _data_->locales_added > 1);
	_data_->_tmp36_ = _data_->selected_locale_id;
	if (_data_->_tmp36_ != NULL) {
		_data_->_tmp37_ = _data_->self->priv->region_combobox;
		_data_->_tmp38_ = _data_->selected_locale_id;
		gtk_combo_box_set_active_id (_data_->_tmp37_, _data_->_tmp38_);
	} else {
		_data_->_tmp39_ = _data_->self->priv->region_combobox;
		gtk_combo_box_set_active (_data_->_tmp39_, 0);
	}
	_data_->_tmp40_ = _data_->self->priv->region_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _data_->_tmp40_, 0, GTK_SORT_ASCENDING);
	switchboard_plug_locale_widgets_locale_setting_compare (_data_->self);
	_g_free0 (_data_->user_locale);
	_g_object_unref0 (_data_->default_regions);
	_g_free0 (_data_->selected_locale_id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
switchboard_plug_locale_widgets_locale_setting_reload_formats (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                               GeeArrayList* locales)
{
	GtkListStore* _tmp0_;
	gchar* user_format = NULL;
	SwitchboardPlugLocaleLocaleManager* _tmp1_;
	gchar* _tmp2_;
	gint i = 0;
	gchar* active_id = NULL;
	GtkComboBox* _tmp24_;
	GtkComboBox* _tmp25_;
	const gchar* _tmp26_;
	GtkListStore* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->format_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->lm;
	_tmp2_ = switchboard_plug_locale_locale_manager_get_user_format (_tmp1_);
	user_format = _tmp2_;
	i = 0;
	active_id = NULL;
	{
		GeeArrayList* _locale_list = NULL;
		gint _locale_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _locale_index = 0;
		_locale_list = locales;
		_tmp3_ = _locale_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_locale_size = _tmp5_;
		_locale_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* locale = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gchar* country = NULL;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_locale_index = _locale_index + 1;
			_tmp6_ = _locale_index;
			_tmp7_ = _locale_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _locale_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _locale_index);
			locale = (gchar*) _tmp9_;
			_tmp10_ = locale;
			_tmp11_ = gnome_get_country_from_locale (_tmp10_, NULL);
			country = _tmp11_;
			_tmp12_ = country;
			if (_tmp12_ != NULL) {
				GtkTreeIter iter = {0};
				GtkListStore* _tmp13_;
				GtkTreeIter _tmp14_ = {0};
				GtkListStore* _tmp15_;
				GtkTreeIter _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp23_;
				memset (&iter, 0, sizeof (GtkTreeIter));
				_tmp13_ = self->priv->format_store;
				gtk_list_store_append (_tmp13_, &_tmp14_);
				iter = _tmp14_;
				_tmp15_ = self->priv->format_store;
				_tmp16_ = iter;
				_tmp17_ = country;
				_tmp18_ = locale;
				gtk_list_store_set (_tmp15_, &_tmp16_, 0, _tmp17_, 1, _tmp18_, -1);
				_tmp19_ = locale;
				_tmp20_ = user_format;
				if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
					const gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp21_ = locale;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (active_id);
					active_id = _tmp22_;
				}
				_tmp23_ = i;
				i = _tmp23_ + 1;
			}
			_g_free0 (country);
			_g_free0 (locale);
		}
	}
	_tmp24_ = self->priv->format_combobox;
	gtk_combo_box_set_id_column (_tmp24_, 1);
	_tmp25_ = self->priv->format_combobox;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, i != 1);
	_tmp26_ = active_id;
	if (_tmp26_ != NULL) {
		GtkComboBox* _tmp27_;
		const gchar* _tmp28_;
		_tmp27_ = self->priv->format_combobox;
		_tmp28_ = active_id;
		gtk_combo_box_set_active_id (_tmp27_, _tmp28_);
	} else {
		GtkComboBox* _tmp29_;
		_tmp29_ = self->priv->format_combobox;
		gtk_combo_box_set_active (_tmp29_, 0);
	}
	_tmp30_ = self->priv->format_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp30_, 0, GTK_SORT_ASCENDING);
	switchboard_plug_locale_widgets_locale_setting_compare (self);
	_g_free0 (active_id);
	_g_free0 (user_format);
}

void
switchboard_plug_locale_widgets_locale_setting_reload_labels (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                              const gchar* language)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	_tmp0_ = switchboard_plug_locale_utils_translate (language, NULL);
	_tmp1_ = _tmp0_;
	granite_simple_settings_page_set_title ((GraniteSimpleSettingsPage*) self, _tmp1_);
	_g_free0 (_tmp1_);
}

static void
switchboard_plug_locale_widgets_locale_setting_on_applied_to_system (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	gchar* selected_locale = NULL;
	gchar* _tmp0_;
	gchar* selected_format = NULL;
	gchar* _tmp1_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_get_selected_locale (self);
	selected_locale = _tmp0_;
	_tmp1_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
	selected_format = _tmp1_;
	g_debug ("LocaleSetting.vala:299: Setting system language to '%s' and format to " \
"'%s'", selected_locale, selected_format);
	_tmp2_ = self->priv->lm;
	switchboard_plug_locale_locale_manager_apply_to_system (_tmp2_, selected_locale, selected_format);
	g_signal_emit (self, switchboard_plug_locale_widgets_locale_setting_signals[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_SETTINGS_CHANGED_SIGNAL], 0);
	_g_free0 (selected_format);
	_g_free0 (selected_locale);
}

SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel*
switchboard_plug_locale_widgets_locale_setting_end_label_construct (GType object_type,
                                                                    const gchar* label)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel*) g_object_new (object_type, "halign", GTK_ALIGN_END, "label", label, NULL);
	return self;
}

SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel*
switchboard_plug_locale_widgets_locale_setting_end_label_new (const gchar* label)
{
	return switchboard_plug_locale_widgets_locale_setting_end_label_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_END_LABEL, label);
}

static void
switchboard_plug_locale_widgets_locale_setting_end_label_class_init (SwitchboardPlugLocaleWidgetsLocaleSettingEndLabelClass * klass,
                                                                     gpointer klass_data)
{
	switchboard_plug_locale_widgets_locale_setting_end_label_parent_class = g_type_class_peek_parent (klass);
}

static void
switchboard_plug_locale_widgets_locale_setting_end_label_instance_init (SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel * self,
                                                                        gpointer klass)
{
}

static GType
switchboard_plug_locale_widgets_locale_setting_end_label_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingEndLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_locale_setting_end_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_locale_setting_end_label_instance_init, NULL };
	GType switchboard_plug_locale_widgets_locale_setting_end_label_type_id;
	switchboard_plug_locale_widgets_locale_setting_end_label_type_id = g_type_register_static (gtk_label_get_type (), "SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel", &g_define_type_info, 0);
	return switchboard_plug_locale_widgets_locale_setting_end_label_type_id;
}

GType
switchboard_plug_locale_widgets_locale_setting_end_label_get_type (void)
{
	static volatile gsize switchboard_plug_locale_widgets_locale_setting_end_label_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_locale_setting_end_label_type_id__once)) {
		GType switchboard_plug_locale_widgets_locale_setting_end_label_type_id;
		switchboard_plug_locale_widgets_locale_setting_end_label_type_id = switchboard_plug_locale_widgets_locale_setting_end_label_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_locale_setting_end_label_type_id__once, switchboard_plug_locale_widgets_locale_setting_end_label_type_id);
	}
	return switchboard_plug_locale_widgets_locale_setting_end_label_type_id__once;
}

static void
_switchboard_plug_locale_widgets_locale_setting_compare_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                               gpointer self)
{
	switchboard_plug_locale_widgets_locale_setting_compare ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static void
_switchboard_plug_locale_widgets_locale_setting_on_format_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                         gpointer self)
{
	switchboard_plug_locale_widgets_locale_setting_on_format_changed ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SwitchboardPlugLocaleWidgetsLocaleSetting* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->temperature);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_switchboard_plug_locale_widgets_locale_setting____lambda6_ (Block8Data* _data8_)
{
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	GraniteWidgetsModeButton* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = _data8_->self;
	_tmp0_ = _data8_->temperature;
	_tmp1_ = granite_widgets_mode_button_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		GSettings* _tmp3_;
		_tmp3_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
		g_settings_set_string (_tmp3_, "temperature-unit", "centigrade");
	} else {
		GSettings* _tmp4_;
		_tmp4_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
		g_settings_set_string (_tmp4_, "temperature-unit", "fahrenheit");
	}
}

static void
__switchboard_plug_locale_widgets_locale_setting____lambda6__granite_widgets_mode_button_mode_changed (GraniteWidgetsModeButton* _sender,
                                                                                                       GtkWidget* widget,
                                                                                                       gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting____lambda6_ (self);
}

static void
_switchboard_plug_locale_widgets_locale_setting___lambda7_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://input/keyboard/layout", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("LocaleSetting.vala:121: Failed to open keyboard settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__switchboard_plug_locale_widgets_locale_setting___lambda7__gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting___lambda7_ ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static void
_switchboard_plug_locale_widgets_locale_setting___lambda8_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	gchar* locale = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	const gchar* _tmp3_;
	gchar* format = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	SwitchboardPlugLocaleLocaleManager* _tmp6_;
	const gchar* _tmp7_;
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_get_selected_locale (self);
	locale = _tmp0_;
	_tmp1_ = locale;
	g_debug ("LocaleSetting.vala:127: Setting user language to '%s'", _tmp1_);
	_tmp2_ = self->priv->lm;
	_tmp3_ = locale;
	switchboard_plug_locale_locale_manager_set_user_language (_tmp2_, _tmp3_);
	switchboard_plug_locale_widgets_locale_setting_compare (self);
	_tmp4_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
	format = _tmp4_;
	_tmp5_ = format;
	g_debug ("LocaleSetting.vala:133: Setting user format to '%s'", _tmp5_);
	_tmp6_ = self->priv->lm;
	_tmp7_ = format;
	switchboard_plug_locale_locale_manager_set_user_format (_tmp6_, _tmp7_);
	g_signal_emit (self, switchboard_plug_locale_widgets_locale_setting_signals[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_SETTINGS_CHANGED_SIGNAL], 0);
	_g_free0 (format);
	_g_free0 (locale);
}

static void
__switchboard_plug_locale_widgets_locale_setting___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting___lambda8_ ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static void
_switchboard_plug_locale_widgets_locale_setting___lambda9_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	if (!switchboard_plug_locale_utils_allowed_permission ()) {
		return;
	}
	switchboard_plug_locale_widgets_locale_setting_on_applied_to_system (self);
}

static void
__switchboard_plug_locale_widgets_locale_setting___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                                                gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting___lambda9_ ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static GObject *
switchboard_plug_locale_widgets_locale_setting_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleWidgetsLocaleSetting * self;
	SwitchboardPlugLocaleLocaleManager* _tmp0_;
	SwitchboardPlugLocaleLocaleManager* _tmp1_;
	GtkLabel* region_label = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp4_;
	GtkListStore* _tmp5_;
	GtkListStore* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkCellRendererText* _tmp12_;
	GtkComboBox* _tmp13_;
	GtkListStore* _tmp14_;
	GtkListStore* _tmp15_;
	GtkComboBox* _tmp16_;
	GtkComboBox* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkComboBox* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkComboBox* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkComboBox* _tmp23_;
	SwitchboardPlugLocaleWidgetsPreview* _tmp24_;
	SwitchboardPlugLocaleWidgetsPreview* _tmp25_;
	SwitchboardPlugLocaleWidgetsPreview* _tmp26_;
	SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel* _tmp27_;
	GtkGrid* _tmp28_;
	GtkGrid* _tmp29_;
	GtkGrid* _tmp30_;
	GtkGrid* _tmp31_;
	SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel* _tmp32_;
	GtkGrid* _tmp33_;
	GtkGrid* _tmp34_;
	GtkComboBox* _tmp35_;
	GtkGrid* _tmp36_;
	GtkGrid* _tmp37_;
	SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel* _tmp38_;
	SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel* _tmp39_;
	GtkGrid* _tmp40_;
	GtkGrid* _tmp41_;
	GtkComboBox* _tmp42_;
	GtkGrid* _tmp43_;
	GtkGrid* _tmp44_;
	SwitchboardPlugLocaleWidgetsPreview* _tmp45_;
	GSettings* _tmp46_;
	GtkButton* _tmp64_;
	GtkButton* _tmp65_;
	GtkButton* _tmp66_;
	GtkStyleContext* _tmp67_;
	GtkButton* set_system_button = NULL;
	GtkButton* _tmp68_;
	GtkButton* _tmp69_;
	GtkButton* keyboard_button = NULL;
	GtkButton* _tmp70_;
	GtkButtonBox* _tmp71_;
	GtkButtonBox* _tmp72_;
	GtkButton* _tmp73_;
	GtkButtonBox* _tmp74_;
	GtkButtonBox* _tmp75_;
	GtkButton* _tmp76_;
	GtkButtonBox* _tmp77_;
	GtkButtonBox* _tmp78_;
	GtkButton* _tmp79_;
	GtkButtonBox* _tmp80_;
	GtkButtonBox* _tmp81_;
	GtkButton* _tmp82_;
	GtkButton* _tmp83_;
	GtkButton* _tmp84_;
	GtkButton* _tmp85_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_widgets_locale_setting_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LOCALE_SETTING, SwitchboardPlugLocaleWidgetsLocaleSetting);
	_tmp0_ = switchboard_plug_locale_locale_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->lm);
	self->priv->lm = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp2_);
	region_label = _tmp2_;
	_tmp3_ = region_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp4_);
	renderer = _tmp4_;
	_tmp5_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->region_store);
	self->priv->region_store = _tmp5_;
	_tmp6_ = self->priv->region_store;
	_tmp7_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->region_combobox);
	self->priv->region_combobox = _tmp7_;
	_tmp8_ = self->priv->region_combobox;
	g_object_set ((GtkWidget*) _tmp8_, "height-request", 27, NULL);
	_tmp9_ = self->priv->region_combobox;
	_tmp10_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) _tmp10_, TRUE);
	_tmp11_ = self->priv->region_combobox;
	_tmp12_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) _tmp12_, "text", 0);
	_tmp13_ = self->priv->region_combobox;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) _switchboard_plug_locale_widgets_locale_setting_compare_gtk_combo_box_changed, self, 0);
	_tmp14_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->format_store);
	self->priv->format_store = _tmp14_;
	_tmp15_ = self->priv->format_store;
	_tmp16_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->format_combobox);
	self->priv->format_combobox = _tmp16_;
	_tmp17_ = self->priv->format_combobox;
	_tmp18_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp17_, (GtkCellRenderer*) _tmp18_, TRUE);
	_tmp19_ = self->priv->format_combobox;
	_tmp20_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp19_, (GtkCellRenderer*) _tmp20_, "text", 0);
	_tmp21_ = self->priv->format_combobox;
	g_signal_connect_object (_tmp21_, "changed", (GCallback) _switchboard_plug_locale_widgets_locale_setting_on_format_changed_gtk_combo_box_changed, self, 0);
	_tmp22_ = self->priv->format_combobox;
	g_signal_connect_object (_tmp22_, "changed", (GCallback) _switchboard_plug_locale_widgets_locale_setting_compare_gtk_combo_box_changed, self, 0);
	_tmp23_ = self->priv->format_combobox;
	gtk_combo_box_set_active (_tmp23_, 0);
	_tmp24_ = switchboard_plug_locale_widgets_preview_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->preview);
	self->priv->preview = _tmp24_;
	_tmp25_ = self->priv->preview;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp25_, 12);
	_tmp26_ = self->priv->preview;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp26_, 12);
	_tmp27_ = switchboard_plug_locale_widgets_locale_setting_end_label_new (_ ("Region: "));
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->region_endlabel);
	self->priv->region_endlabel = _tmp27_;
	_tmp28_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
	_tmp29_ = _tmp28_;
	gtk_widget_set_halign ((GtkWidget*) _tmp29_, GTK_ALIGN_CENTER);
	_tmp30_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
	_tmp31_ = _tmp30_;
	_tmp32_ = self->priv->region_endlabel;
	gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 0, 2, 1, 1);
	_tmp33_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = self->priv->region_combobox;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 1, 2, 1, 1);
	_tmp36_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = switchboard_plug_locale_widgets_locale_setting_end_label_new (_ ("Formats: "));
	g_object_ref_sink (_tmp38_);
	_tmp39_ = _tmp38_;
	gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp39_, 0, 3, 1, 1);
	_g_object_unref0 (_tmp39_);
	_tmp40_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
	_tmp41_ = _tmp40_;
	_tmp42_ = self->priv->format_combobox;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 1, 3, 1, 1);
	_tmp43_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = self->priv->preview;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, 0, 5, 2, 1);
	_tmp46_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
	if (_tmp46_ != NULL) {
		Block8Data* _data8_;
		GraniteWidgetsModeButton* _tmp47_;
		GraniteWidgetsModeButton* _tmp48_;
		GraniteWidgetsModeButton* _tmp49_;
		GtkGrid* _tmp50_;
		GtkGrid* _tmp51_;
		SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel* _tmp52_;
		SwitchboardPlugLocaleWidgetsLocaleSettingEndLabel* _tmp53_;
		GtkGrid* _tmp54_;
		GtkGrid* _tmp55_;
		GraniteWidgetsModeButton* _tmp56_;
		gchar* temp_setting = NULL;
		GSettings* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		GraniteWidgetsModeButton* _tmp63_;
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->self = g_object_ref (self);
		_tmp47_ = granite_widgets_mode_button_new ();
		g_object_ref_sink (_tmp47_);
		_data8_->temperature = _tmp47_;
		_tmp48_ = _data8_->temperature;
		granite_widgets_mode_button_append_text (_tmp48_, _ ("Celsius"));
		_tmp49_ = _data8_->temperature;
		granite_widgets_mode_button_append_text (_tmp49_, _ ("Fahrenheit"));
		_tmp50_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
		_tmp51_ = _tmp50_;
		_tmp52_ = switchboard_plug_locale_widgets_locale_setting_end_label_new (_ ("Temperature:"));
		g_object_ref_sink (_tmp52_);
		_tmp53_ = _tmp52_;
		gtk_grid_attach (_tmp51_, (GtkWidget*) _tmp53_, 0, 4, 1, 1);
		_g_object_unref0 (_tmp53_);
		_tmp54_ = granite_simple_settings_page_get_content_area ((GraniteSimpleSettingsPage*) self);
		_tmp55_ = _tmp54_;
		_tmp56_ = _data8_->temperature;
		gtk_grid_attach (_tmp55_, (GtkWidget*) _tmp56_, 1, 4, 1, 1);
		_tmp57_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
		_tmp58_ = g_settings_get_string (_tmp57_, "temperature-unit");
		temp_setting = _tmp58_;
		_tmp59_ = temp_setting;
		if (g_strcmp0 (_tmp59_, "centigrade") == 0) {
			GraniteWidgetsModeButton* _tmp60_;
			_tmp60_ = _data8_->temperature;
			granite_widgets_mode_button_set_selected (_tmp60_, 0);
		} else {
			const gchar* _tmp61_;
			_tmp61_ = temp_setting;
			if (g_strcmp0 (_tmp61_, "fahrenheit") == 0) {
				GraniteWidgetsModeButton* _tmp62_;
				_tmp62_ = _data8_->temperature;
				granite_widgets_mode_button_set_selected (_tmp62_, 1);
			}
		}
		_tmp63_ = _data8_->temperature;
		g_signal_connect_data (_tmp63_, "mode-changed", (GCallback) __switchboard_plug_locale_widgets_locale_setting____lambda6__granite_widgets_mode_button_mode_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
		_g_free0 (temp_setting);
		block8_data_unref (_data8_);
		_data8_ = NULL;
	}
	_tmp64_ = (GtkButton*) gtk_button_new_with_label (_ ("Set Language"));
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->set_button);
	self->priv->set_button = _tmp64_;
	_tmp65_ = self->priv->set_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp65_, FALSE);
	_tmp66_ = self->priv->set_button;
	_tmp67_ = gtk_widget_get_style_context ((GtkWidget*) _tmp66_);
	gtk_style_context_add_class (_tmp67_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp68_ = (GtkButton*) gtk_button_new_with_label (_ ("Set System Language"));
	g_object_ref_sink (_tmp68_);
	set_system_button = _tmp68_;
	_tmp69_ = set_system_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp69_, _ ("Set language for login screen, guest account and new user accounts"));
	_tmp70_ = (GtkButton*) gtk_button_new_with_label (_ ("Keyboard Settings…"));
	g_object_ref_sink (_tmp70_);
	keyboard_button = _tmp70_;
	_tmp71_ = granite_simple_settings_page_get_action_area ((GraniteSimpleSettingsPage*) self);
	_tmp72_ = _tmp71_;
	_tmp73_ = keyboard_button;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = granite_simple_settings_page_get_action_area ((GraniteSimpleSettingsPage*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = set_system_button;
	gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = granite_simple_settings_page_get_action_area ((GraniteSimpleSettingsPage*) self);
	_tmp78_ = _tmp77_;
	_tmp79_ = self->priv->set_button;
	gtk_container_add ((GtkContainer*) _tmp78_, (GtkWidget*) _tmp79_);
	_tmp80_ = granite_simple_settings_page_get_action_area ((GraniteSimpleSettingsPage*) self);
	_tmp81_ = _tmp80_;
	_tmp82_ = keyboard_button;
	gtk_button_box_set_child_secondary (_tmp81_, (GtkWidget*) _tmp82_, TRUE);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp83_ = keyboard_button;
	g_signal_connect_object (_tmp83_, "clicked", (GCallback) __switchboard_plug_locale_widgets_locale_setting___lambda7__gtk_button_clicked, self, 0);
	_tmp84_ = self->priv->set_button;
	g_signal_connect_object (_tmp84_, "clicked", (GCallback) __switchboard_plug_locale_widgets_locale_setting___lambda8__gtk_button_clicked, self, 0);
	_tmp85_ = set_system_button;
	g_signal_connect_object (_tmp85_, "clicked", (GCallback) __switchboard_plug_locale_widgets_locale_setting___lambda9__gtk_button_clicked, self, 0);
	_g_object_unref0 (keyboard_button);
	_g_object_unref0 (set_system_button);
	_g_object_unref0 (renderer);
	_g_object_unref0 (region_label);
	return obj;
}

static void
switchboard_plug_locale_widgets_locale_setting_class_init (SwitchboardPlugLocaleWidgetsLocaleSettingClass * klass,
                                                           gpointer klass_data)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	switchboard_plug_locale_widgets_locale_setting_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset);
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_widgets_locale_setting_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_locale_setting_finalize;
	switchboard_plug_locale_widgets_locale_setting_signals[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_SETTINGS_CHANGED_SIGNAL] = g_signal_new ("settings-changed", SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LOCALE_SETTING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "org.gnome.GWeather", TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		_tmp4_ = g_settings_new ("org.gnome.GWeather");
		_g_object_unref0 (switchboard_plug_locale_widgets_locale_setting_temperature_settings);
		switchboard_plug_locale_widgets_locale_setting_temperature_settings = _tmp4_;
	}
}

static void
switchboard_plug_locale_widgets_locale_setting_instance_init (SwitchboardPlugLocaleWidgetsLocaleSetting * self,
                                                              gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_locale_setting_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_locale_setting_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLocaleSetting * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LOCALE_SETTING, SwitchboardPlugLocaleWidgetsLocaleSetting);
	_g_object_unref0 (self->priv->set_button);
	_g_object_unref0 (self->priv->format_combobox);
	_g_object_unref0 (self->priv->region_combobox);
	_g_object_unref0 (self->priv->format_store);
	_g_object_unref0 (self->priv->region_store);
	_g_object_unref0 (self->priv->lm);
	_g_object_unref0 (self->priv->preview);
	_g_free0 (self->priv->language);
	_g_object_unref0 (self->priv->region_endlabel);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_locale_setting_parent_class)->finalize (obj);
}

static GType
switchboard_plug_locale_widgets_locale_setting_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_locale_setting_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLocaleSetting), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_locale_setting_instance_init, NULL };
	GType switchboard_plug_locale_widgets_locale_setting_type_id;
	switchboard_plug_locale_widgets_locale_setting_type_id = g_type_register_static (GRANITE_TYPE_SIMPLE_SETTINGS_PAGE, "SwitchboardPlugLocaleWidgetsLocaleSetting", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_locale_setting_type_id, sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingPrivate));
	return switchboard_plug_locale_widgets_locale_setting_type_id;
}

GType
switchboard_plug_locale_widgets_locale_setting_get_type (void)
{
	static volatile gsize switchboard_plug_locale_widgets_locale_setting_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_locale_setting_type_id__once)) {
		GType switchboard_plug_locale_widgets_locale_setting_type_id;
		switchboard_plug_locale_widgets_locale_setting_type_id = switchboard_plug_locale_widgets_locale_setting_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_locale_setting_type_id__once, switchboard_plug_locale_widgets_locale_setting_type_id);
	}
	return switchboard_plug_locale_widgets_locale_setting_type_id__once;
}

