/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.control.ClientInputHandler;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.control.SoundController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.SplashScreen;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.networking.UserServerAPI;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.ServerAPI;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.server.FreeColServer;

public final class FreeColClient {
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private byte[] memoryToBeFreedOnOutOfMemory = new byte[0xA00000];
    private final ConnectController connectController;
    private final PreGameController preGameController;
    private final InGameController inGameController;
    private final ClientInputHandler inputHandler;
    private final MapEditorController mapEditorController;
    private SoundController soundController;
    private FreeColServer freeColServer = null;
    private final ServerAPI serverAPI;
    private GUI gui;
    private final ActionManager actionManager;
    private Game game;
    private Player player;
    private ClientOptions clientOptions;
    private boolean inGame = false;
    private boolean mapEditor;
    private boolean singlePlayer;
    private boolean loggedIn = false;
    private FreeColServer.ServerState cachedServerState = null;
    private List<String> cachedVacantPlayerNames = new ArrayList<String>();

    public FreeColClient(SplashScreen splashScreen, String fontName, Dimension windowSize, String userMsg, boolean sound, boolean showOpeningVideo, File savedGame, Specification spec) {
        String quitName = "FreeColClient:Quit Game";
        Runtime.getRuntime().addShutdownHook(new Thread(quitName){

            @Override
            public void run() {
                FreeColClient.this.stopServer();
            }
        });
        if (FreeCol.getHeadless() && savedGame == null && spec == null) {
            FreeCol.fatal(logger, Messages.message("client.headlessRequires"));
        }
        this.mapEditor = false;
        File baseDirectory = FreeColDirectories.getBaseDirectory();
        FreeColDataFile baseData = null;
        String ioeMessage = null;
        if (baseDirectory.exists() && baseDirectory.isDirectory()) {
            try {
                baseData = new FreeColDataFile(baseDirectory);
            }
            catch (IOException ioe) {
                ioeMessage = ioe.getMessage();
            }
        }
        if (baseData == null) {
            FreeCol.fatal(logger, Messages.message(StringTemplate.template("client.baseData").addName("%dir%", baseDirectory.getName())) + (String)(ioeMessage == null ? "" : "\n" + ioeMessage));
        }
        this.serverAPI = new UserServerAPI();
        this.connectController = new ConnectController(this);
        this.preGameController = new PreGameController(this);
        this.inGameController = new InGameController(this);
        this.mapEditorController = new MapEditorController(this);
        this.inputHandler = new ClientInputHandler(this);
        this.setMessageHandler(this.inputHandler);
        ResourceManager.setBaseData(baseData);
        FreeColTcFile tcData = FreeColTcFile.getFreeColTcFile(FreeCol.getTc());
        ResourceManager.setTcData(tcData);
        this.actionManager = new ActionManager(this);
        this.actionManager.initializeActions(this.inGameController, this.connectController);
        this.clientOptions = this.loadClientOptions(savedGame);
        this.clientOptions.fixClientOptions();
        ResourceManager.setMods(this.clientOptions.getActiveMods());
        GUI gUI = this.gui = FreeCol.getHeadless() ? new GUI(this) : new SwingGUI(this);
        if (!FreeCol.getHeadless()) {
            try {
                this.gui.installLookAndFeel(fontName);
            }
            catch (Exception e) {
                FreeCol.fatal(logger, Messages.message("client.laf") + "\n" + e.getMessage());
            }
        }
        this.soundController = new SoundController(this, sound);
        this.overrideDefaultUncaughtExceptionHandler();
        ResourceManager.startPreloading(() -> SwingUtilities.invokeLater(() -> {
            if (splashScreen != null) {
                splashScreen.setVisible(false);
                splashScreen.dispose();
            }
            this.gui.startGUI(windowSize);
            if (this.actionManager != null) {
                this.updateActions();
            }
            this.startFirstTaskInGui(userMsg, showOpeningVideo, savedGame, spec);
        }));
    }

    private void startFirstTaskInGui(String userMsg, boolean showOpeningVideo, File savedGame, Specification spec) {
        SwingUtilities.invokeLater(() -> {
            if (savedGame != null) {
                this.gui.showStatusPanel(Messages.message("status.loadingGame"));
                SwingUtilities.invokeLater(() -> {
                    if (this.connectController.startSavedGame(savedGame)) {
                        this.gui.closeStatusPanel();
                        if (userMsg != null) {
                            this.gui.showInformationPanel(userMsg);
                        }
                    } else {
                        this.gui.playSound("sound.intro.general");
                        this.gui.closeStatusPanel();
                        this.gui.showMainPanel(userMsg);
                    }
                });
            } else if (spec != null) {
                this.gui.playSound("sound.intro.general");
                if (!this.connectController.startSinglePlayerGame(spec)) {
                    this.gui.showMainPanel(userMsg);
                }
            } else if (showOpeningVideo) {
                this.gui.showOpeningVideo(userMsg, () -> {
                    this.gui.playSound("sound.intro.general");
                    this.gui.showMainPanel(userMsg);
                });
            } else {
                this.gui.playSound("sound.intro.general");
                this.gui.showMainPanel(userMsg);
            }
        });
    }

    private ClientOptions loadClientOptions(File savedGameFile) {
        File userOptions;
        ClientOptions clop = new ClientOptions();
        logger.info("Load default client options.");
        clop.load(FreeColDirectories.getBaseClientOptionsFile());
        if (this.actionManager != null) {
            logger.info("Load client options from the action manager.");
            clop.add(this.actionManager);
        }
        if (savedGameFile != null) {
            try {
                FreeColSavegameFile fcsf = new FreeColSavegameFile(savedGameFile);
                logger.info("Merge client options from saved game: " + savedGameFile.getPath());
                clop.merge(fcsf);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Could not open saved game " + savedGameFile.getPath(), ioe);
            }
        }
        if ((userOptions = FreeColDirectories.getClientOptionsFile()) != null && userOptions.exists()) {
            logger.info("Merge client options from user options file: " + userOptions.getPath());
            clop.load(userOptions);
        }
        return clop;
    }

    public ConnectController getConnectController() {
        return this.connectController;
    }

    public PreGameController getPreGameController() {
        return this.preGameController;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public MapEditorController getMapEditorController() {
        return this.mapEditorController;
    }

    public SoundController getSoundController() {
        return this.soundController;
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public void setFreeColServer(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public ServerAPI askServer() {
        return this.serverAPI;
    }

    public GUI getGUI() {
        return this.gui;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public Game getGame() {
        return this.game;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public Player getMyPlayer() {
        return this.player;
    }

    public void setMyPlayer(Player player) {
        this.player = player;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void toggleClientOption(String op) {
        boolean value = this.clientOptions.getBoolean(op);
        this.clientOptions.setBoolean(op, !value);
    }

    public boolean tutorialMode() {
        return this.getClientOptions().getBoolean("model.option.guiShowTutorial");
    }

    public synchronized boolean isInGame() {
        return this.inGame;
    }

    public synchronized void changeClientState(boolean inGame) {
        this.inGame = inGame;
    }

    public boolean isReadyToStart() {
        if (this.isInGame()) {
            return false;
        }
        Game game = this.getGame();
        return game == null ? false : game.getMap() != null;
    }

    public boolean isMapEditor() {
        return this.mapEditor;
    }

    public void setMapEditor(boolean mapEditor) {
        this.mapEditor = mapEditor;
    }

    public boolean getSinglePlayer() {
        return this.singlePlayer;
    }

    public void setSinglePlayer(boolean singlePlayer) {
        this.singlePlayer = singlePlayer;
    }

    public synchronized boolean isLoggedIn() {
        return this.loggedIn;
    }

    public FreeColServer.ServerState getServerState() {
        return this.freeColServer == null ? this.cachedServerState : this.freeColServer.getServerState();
    }

    public void setServerState(FreeColServer.ServerState state) {
        this.cachedServerState = state;
    }

    public List<String> getVacantPlayerNames() {
        return this.cachedVacantPlayerNames;
    }

    public void setVacantPlayerNames(List<String> names) {
        this.cachedVacantPlayerNames.clear();
        this.cachedVacantPlayerNames.addAll(names);
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.askServer().setMessageHandler(messageHandler);
    }

    public void updateActions() {
        this.actionManager.update();
    }

    public void addSpecificationActions(Specification specification) {
        SwingUtilities.invokeLater(() -> this.actionManager.addSpecificationActions(specification));
    }

    public boolean isAdmin() {
        return this.player != null && this.player.isAdmin();
    }

    public boolean canSaveCurrentGame() {
        return this.freeColServer != null && (this.isAdmin() || this.freeColServer.getServerState() != FreeColServer.ServerState.IN_GAME);
    }

    public boolean currentPlayerIsMyPlayer() {
        return this.game != null && this.isInGame() && this.player != null && this.player.equals(this.game.getCurrentPlayer());
    }

    public int getAnimationSpeed(Player player) {
        String key = this.getMyPlayer() == player ? "model.option.moveAnimationSpeed" : (this.getMyPlayer().isPotentialFriend(player) ? "model.option.enemyMoveAnimationSpeed" : "model.option.friendlyMoveAnimationSpeed");
        return this.getClientOptions().getInteger(key);
    }

    public void restoreGUI(Player player) {
        Unit u = player.restoreActiveUnit();
        this.getGUI().reconnectGUI(u != null && player.owns(u) ? u : null, player.getFallbackTile());
    }

    private FreeColServer failToMain(Exception ex, StringTemplate template) {
        if (FreeCol.getHeadless() || FreeColDebugger.getDebugRunTurns() >= 0) {
            StringTemplate t = FreeCol.errorFromException(ex, template);
            String msg = Messages.message(t);
            FreeCol.fatal(null, msg);
        } else {
            this.getGUI().showErrorPanel(ex, template);
        }
        return null;
    }

    private FreeColServer failToMain(Exception ex, String key) {
        return this.failToMain(ex, StringTemplate.template(key));
    }

    public boolean unblockServer(int port) {
        FreeColServer freeColServer = this.getFreeColServer();
        if (freeColServer != null) {
            if (!this.getGUI().confirm("stopServer.text", "stopServer.yes", "stopServer.no")) {
                return false;
            }
            this.stopServer();
        }
        return true;
    }

    public void stopServer() {
        FreeColServer freeColServer = this.getFreeColServer();
        if (freeColServer != null) {
            freeColServer.getController().shutdown();
            this.setFreeColServer(null);
        }
    }

    public FreeColServer startServer(boolean publicServer, boolean singlePlayer, Specification spec, InetAddress address, int port) {
        FreeColServer fcs;
        try {
            fcs = new FreeColServer(publicServer, singlePlayer, spec, address, port, null);
            if (!fcs.registerWithMetaServer()) {
                fcs.shutdown();
                return this.failToMain(null, "server.noRouteToServer");
            }
        }
        catch (IOException ioe) {
            return this.failToMain((Exception)ioe, "server.initialize");
        }
        this.setFreeColServer(fcs);
        this.setSinglePlayer(singlePlayer);
        return fcs;
    }

    public FreeColServer startServer(boolean publicServer, boolean singlePlayer, File saveFile, InetAddress address, int port, String name) {
        FreeColServer fcs;
        FreeColSavegameFile fsg;
        try {
            fsg = new FreeColSavegameFile(saveFile);
        }
        catch (FileNotFoundException fnfe) {
            return this.failToMain((Exception)fnfe, FreeCol.badFile("error.couldNotFind", saveFile));
        }
        catch (IOException ioe) {
            return this.failToMain((Exception)ioe, "server.initialize");
        }
        try {
            fcs = new FreeColServer(fsg, null, address, port, name);
            fcs.setPublicServer(publicServer);
            if (!fcs.registerWithMetaServer()) {
                return this.failToMain(null, "server.noRouteToServer");
            }
        }
        catch (XMLStreamException xse) {
            return this.failToMain((Exception)xse, FreeCol.badFile("error.couldNotLoad", saveFile));
        }
        catch (Exception ex) {
            return this.failToMain(ex, "server.initialize");
        }
        this.setFreeColServer(fcs);
        this.setSinglePlayer(singlePlayer);
        this.inGameController.setGameConnected();
        ResourceManager.setSavegameFile(fsg);
        return fcs;
    }

    public synchronized void login(boolean inGame, Game game, Player player, boolean single) {
        this.loggedIn = true;
        this.changeClientState(inGame);
        this.setGame(game);
        this.setMyPlayer(player);
        this.setSinglePlayer(single);
        this.addSpecificationActions(game.getSpecification());
        if (player != null) {
            ClientOptions co = this.getClientOptions();
            player.setColonyComparator(co.getColonyComparator());
        }
    }

    public synchronized void logout(boolean inGame) {
        this.loggedIn = false;
        this.changeClientState(inGame);
        this.setGame(null);
        this.setMyPlayer(null);
    }

    public void continuePlaying() {
        this.askServer().continuePlaying();
    }

    public void skipTurns(int turns) {
        if (this.freeColServer == null) {
            return;
        }
        if (turns <= 0) {
            this.freeColServer.getInGameController().setSkippedTurns(0);
            return;
        }
        this.gui.closeMenus();
        this.freeColServer.getInGameController().setSkippedTurns(turns);
        this.askServer().startSkipping();
    }

    public void askToQuit() {
        if (this.gui.confirm("quitDialog.areYouSure.text", "ok", "cancel")) {
            Player player = this.getMyPlayer();
            if (player == null) {
                this.quit();
            } else {
                this.getConnectController().requestLogout(Game.LogoutReason.QUIT);
                this.quit();
            }
        }
    }

    public void retire() {
        if (this.gui.confirm("retireDialog.areYouSure.text", "ok", "cancel")) {
            Player player = this.getMyPlayer();
            player.changePlayerType(Player.PlayerType.RETIRED);
            this.getInGameController().highScore(null);
            this.askServer().retire();
        }
    }

    public void quit() {
        this.stopServer();
        ClientOptions co = this.getClientOptions();
        ArrayList<String> excludeSuffixes = new ArrayList<String>(2);
        excludeSuffixes.add(co.getText("model.option.lastTurnName"));
        excludeSuffixes.add(co.getText("model.option.beforeLastTurnName"));
        String logMe = FreeColDirectories.removeOutdatedAutosaves(co.getText("model.option.autoSavePrefix"), excludeSuffixes, co.getInteger("model.option.autosaveValidity"));
        if (logMe != null) {
            logger.info(logMe);
        }
        try {
            this.gui.quitGUI();
        }
        catch (Exception e) {
            FreeCol.fatal(logger, "Failed to shutdown gui: " + e);
        }
        FreeCol.quit(0);
    }

    private void overrideDefaultUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> {
            block4: {
                if (e instanceof Error) {
                    this.memoryToBeFreedOnOutOfMemory = null;
                    this.gui.emergencyPurge();
                }
                boolean seriousError = e instanceof Error;
                try {
                    logger.log(Level.WARNING, "Uncaught exception from thread: " + thread, e);
                    if (seriousError) {
                        this.gui.showErrorPanel(Messages.message("error.seriousError"), () -> System.exit(1));
                    }
                }
                catch (Throwable t) {
                    if (!seriousError) break block4;
                    t.printStackTrace();
                    System.exit(1);
                }
            }
        });
    }
}

