/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.flags;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.BooleanFlagToModifier;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsKt;
import org.jetbrains.kotlin.analysis.decompiler.stub.flags.FlagsToModifiers;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0011\u0010\f\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0003\"\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0003\"\u0011\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0003\"\u0011\u0010\u0012\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0003\"\u0011\u0010\u0014\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0003\"\u0011\u0010\u0016\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0003\"\u0011\u0010\u0018\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0003\"\u0011\u0010\u001a\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0003\"\u0011\u0010\u001c\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0003\"\u0011\u0010\u001e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0003\"\u0011\u0010 \u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0003\u00a8\u0006'"}, d2={"CONST", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/flags/FlagsToModifiers;", "getCONST", "()Lorg/jetbrains/kotlin/analysis/decompiler/stub/flags/FlagsToModifiers;", "DATA", "getDATA", "EXTERNAL_CLASS", "getEXTERNAL_CLASS", "EXTERNAL_FUN", "getEXTERNAL_FUN", "EXTERNAL_PROPERTY", "getEXTERNAL_PROPERTY", "FUN_INTERFACE", "getFUN_INTERFACE", "INFIX", "getINFIX", "INLINE", "getINLINE", "INNER", "getINNER", "LATEINIT", "getLATEINIT", "MODALITY", "getMODALITY", "OPERATOR", "getOPERATOR", "SUSPEND", "getSUSPEND", "TAILREC", "getTAILREC", "VALUE_CLASS", "getVALUE_CLASS", "VISIBILITY", "getVISIBILITY", "createBooleanFlagToModifier", "flagField", "Lorg/jetbrains/kotlin/metadata/deserialization/Flags$BooleanFlagField;", "ktModifierKeywordToken", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "decompiler-to-stubs"})
public final class FlagsKt {
    @NotNull
    private static final FlagsToModifiers MODALITY = new FlagsToModifiers(){

        @NotNull
        public KtModifierKeywordToken getModifiers(int flags) {
            KtModifierKeywordToken ktModifierKeywordToken;
            ProtoBuf.Modality modality;
            ProtoBuf.Modality modality2 = modality = Flags.MODALITY.get(flags);
            switch (modality2 == null ? -1 : MODALITY.WhenMappings.$EnumSwitchMapping$0[modality2.ordinal()]) {
                case 1: {
                    KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ABSTRACT_KEYWORD;
                    ktModifierKeywordToken = ktModifierKeywordToken2;
                    Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "ABSTRACT_KEYWORD");
                    break;
                }
                case 2: {
                    KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.FINAL_KEYWORD;
                    ktModifierKeywordToken = ktModifierKeywordToken3;
                    Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken3, "FINAL_KEYWORD");
                    break;
                }
                case 3: {
                    KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.OPEN_KEYWORD;
                    ktModifierKeywordToken = ktModifierKeywordToken4;
                    Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken4, "OPEN_KEYWORD");
                    break;
                }
                case 4: {
                    KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.SEALED_KEYWORD;
                    ktModifierKeywordToken = ktModifierKeywordToken5;
                    Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken5, "SEALED_KEYWORD");
                    break;
                }
                case -1: {
                    throw new IllegalStateException("Unexpected modality: null");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return ktModifierKeywordToken;
        }
    };
    @NotNull
    private static final FlagsToModifiers VISIBILITY = new FlagsToModifiers(){

        @Nullable
        public KtModifierKeywordToken getModifiers(int flags) {
            KtModifierKeywordToken ktModifierKeywordToken;
            ProtoBuf.Visibility visibility2;
            ProtoBuf.Visibility visibility3 = visibility2 = Flags.VISIBILITY.get(flags);
            switch (visibility3 == null ? -1 : VISIBILITY.WhenMappings.$EnumSwitchMapping$0[visibility3.ordinal()]) {
                case 1: 
                case 2: {
                    ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
                    break;
                }
                case 3: {
                    ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
                    break;
                }
                case 4: {
                    ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
                    break;
                }
                case 5: {
                    ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected visibility: " + visibility2);
                }
            }
            return ktModifierKeywordToken;
        }
    };
    @NotNull
    private static final FlagsToModifiers INNER;
    @NotNull
    private static final FlagsToModifiers CONST;
    @NotNull
    private static final FlagsToModifiers LATEINIT;
    @NotNull
    private static final FlagsToModifiers OPERATOR;
    @NotNull
    private static final FlagsToModifiers INFIX;
    @NotNull
    private static final FlagsToModifiers DATA;
    @NotNull
    private static final FlagsToModifiers EXTERNAL_FUN;
    @NotNull
    private static final FlagsToModifiers EXTERNAL_PROPERTY;
    @NotNull
    private static final FlagsToModifiers EXTERNAL_CLASS;
    @NotNull
    private static final FlagsToModifiers INLINE;
    @NotNull
    private static final FlagsToModifiers VALUE_CLASS;
    @NotNull
    private static final FlagsToModifiers FUN_INTERFACE;
    @NotNull
    private static final FlagsToModifiers TAILREC;
    @NotNull
    private static final FlagsToModifiers SUSPEND;

    @NotNull
    public static final FlagsToModifiers getMODALITY() {
        return MODALITY;
    }

    @NotNull
    public static final FlagsToModifiers getVISIBILITY() {
        return VISIBILITY;
    }

    @NotNull
    public static final FlagsToModifiers getINNER() {
        return INNER;
    }

    @NotNull
    public static final FlagsToModifiers getCONST() {
        return CONST;
    }

    @NotNull
    public static final FlagsToModifiers getLATEINIT() {
        return LATEINIT;
    }

    @NotNull
    public static final FlagsToModifiers getOPERATOR() {
        return OPERATOR;
    }

    @NotNull
    public static final FlagsToModifiers getINFIX() {
        return INFIX;
    }

    @NotNull
    public static final FlagsToModifiers getDATA() {
        return DATA;
    }

    @NotNull
    public static final FlagsToModifiers getEXTERNAL_FUN() {
        return EXTERNAL_FUN;
    }

    @NotNull
    public static final FlagsToModifiers getEXTERNAL_PROPERTY() {
        return EXTERNAL_PROPERTY;
    }

    @NotNull
    public static final FlagsToModifiers getEXTERNAL_CLASS() {
        return EXTERNAL_CLASS;
    }

    @NotNull
    public static final FlagsToModifiers getINLINE() {
        return INLINE;
    }

    @NotNull
    public static final FlagsToModifiers getVALUE_CLASS() {
        return VALUE_CLASS;
    }

    @NotNull
    public static final FlagsToModifiers getFUN_INTERFACE() {
        return FUN_INTERFACE;
    }

    @NotNull
    public static final FlagsToModifiers getTAILREC() {
        return TAILREC;
    }

    @NotNull
    public static final FlagsToModifiers getSUSPEND() {
        return SUSPEND;
    }

    private static final FlagsToModifiers createBooleanFlagToModifier(Flags.BooleanFlagField flagField, KtModifierKeywordToken ktModifierKeywordToken) {
        return new BooleanFlagToModifier(flagField, ktModifierKeywordToken);
    }

    static {
        Flags.BooleanFlagField booleanFlagField = Flags.IS_INNER;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField, "IS_INNER");
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "INNER_KEYWORD");
        INNER = FlagsKt.createBooleanFlagToModifier(booleanFlagField, ktModifierKeywordToken);
        Flags.BooleanFlagField booleanFlagField2 = Flags.IS_CONST;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField2, "IS_CONST");
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "CONST_KEYWORD");
        CONST = FlagsKt.createBooleanFlagToModifier(booleanFlagField2, ktModifierKeywordToken2);
        Flags.BooleanFlagField booleanFlagField3 = Flags.IS_LATEINIT;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField3, "IS_LATEINIT");
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.LATEINIT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken3, "LATEINIT_KEYWORD");
        LATEINIT = FlagsKt.createBooleanFlagToModifier(booleanFlagField3, ktModifierKeywordToken3);
        Flags.BooleanFlagField booleanFlagField4 = Flags.IS_OPERATOR;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField4, "IS_OPERATOR");
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.OPERATOR_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken4, "OPERATOR_KEYWORD");
        OPERATOR = FlagsKt.createBooleanFlagToModifier(booleanFlagField4, ktModifierKeywordToken4);
        Flags.BooleanFlagField booleanFlagField5 = Flags.IS_INFIX;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField5, "IS_INFIX");
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.INFIX_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken5, "INFIX_KEYWORD");
        INFIX = FlagsKt.createBooleanFlagToModifier(booleanFlagField5, ktModifierKeywordToken5);
        Flags.BooleanFlagField booleanFlagField6 = Flags.IS_DATA;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField6, "IS_DATA");
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken6, "DATA_KEYWORD");
        DATA = FlagsKt.createBooleanFlagToModifier(booleanFlagField6, ktModifierKeywordToken6);
        Flags.BooleanFlagField booleanFlagField7 = Flags.IS_EXTERNAL_FUNCTION;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField7, "IS_EXTERNAL_FUNCTION");
        KtModifierKeywordToken ktModifierKeywordToken7 = KtTokens.EXTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken7, "EXTERNAL_KEYWORD");
        EXTERNAL_FUN = FlagsKt.createBooleanFlagToModifier(booleanFlagField7, ktModifierKeywordToken7);
        Flags.BooleanFlagField booleanFlagField8 = Flags.IS_EXTERNAL_PROPERTY;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField8, "IS_EXTERNAL_PROPERTY");
        KtModifierKeywordToken ktModifierKeywordToken8 = KtTokens.EXTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken8, "EXTERNAL_KEYWORD");
        EXTERNAL_PROPERTY = FlagsKt.createBooleanFlagToModifier(booleanFlagField8, ktModifierKeywordToken8);
        Flags.BooleanFlagField booleanFlagField9 = Flags.IS_EXTERNAL_CLASS;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField9, "IS_EXTERNAL_CLASS");
        KtModifierKeywordToken ktModifierKeywordToken9 = KtTokens.EXTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken9, "EXTERNAL_KEYWORD");
        EXTERNAL_CLASS = FlagsKt.createBooleanFlagToModifier(booleanFlagField9, ktModifierKeywordToken9);
        Flags.BooleanFlagField booleanFlagField10 = Flags.IS_INLINE;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField10, "IS_INLINE");
        KtModifierKeywordToken ktModifierKeywordToken10 = KtTokens.INLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken10, "INLINE_KEYWORD");
        INLINE = FlagsKt.createBooleanFlagToModifier(booleanFlagField10, ktModifierKeywordToken10);
        Flags.BooleanFlagField booleanFlagField11 = Flags.IS_VALUE_CLASS;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField11, "IS_VALUE_CLASS");
        KtModifierKeywordToken ktModifierKeywordToken11 = KtTokens.VALUE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken11, "VALUE_KEYWORD");
        VALUE_CLASS = FlagsKt.createBooleanFlagToModifier(booleanFlagField11, ktModifierKeywordToken11);
        Flags.BooleanFlagField booleanFlagField12 = Flags.IS_FUN_INTERFACE;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField12, "IS_FUN_INTERFACE");
        KtModifierKeywordToken ktModifierKeywordToken12 = KtTokens.FUN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken12, "FUN_KEYWORD");
        FUN_INTERFACE = FlagsKt.createBooleanFlagToModifier(booleanFlagField12, ktModifierKeywordToken12);
        Flags.BooleanFlagField booleanFlagField13 = Flags.IS_TAILREC;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField13, "IS_TAILREC");
        KtModifierKeywordToken ktModifierKeywordToken13 = KtTokens.TAILREC_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken13, "TAILREC_KEYWORD");
        TAILREC = FlagsKt.createBooleanFlagToModifier(booleanFlagField13, ktModifierKeywordToken13);
        Flags.BooleanFlagField booleanFlagField14 = Flags.IS_SUSPEND;
        Intrinsics.checkNotNullExpressionValue(booleanFlagField14, "IS_SUSPEND");
        KtModifierKeywordToken ktModifierKeywordToken14 = KtTokens.SUSPEND_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken14, "SUSPEND_KEYWORD");
        SUSPEND = FlagsKt.createBooleanFlagToModifier(booleanFlagField14, ktModifierKeywordToken14);
    }
}

