/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmBaseCodegenContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullExternrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullNoneType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u000f\u00a8\u0006\u0012"}, d2={"generateConstExpression", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmBaseCodegenContext;", "generateDefaultInitializerForType", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "g", "getEffectiveValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isExported", "", "backend.wasm"})
public final class DeclarationGeneratorKt {
    public static final void generateDefaultInitializerForType(@NotNull WasmType type2, @NotNull WasmExpressionBuilder g) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(g, "g");
        WasmType wasmType = type2;
        if (Intrinsics.areEqual(wasmType, WasmI32.INSTANCE)) {
            g.buildConstI32(0);
        } else if (Intrinsics.areEqual(wasmType, WasmI64.INSTANCE)) {
            g.buildConstI64(0L);
        } else if (Intrinsics.areEqual(wasmType, WasmF32.INSTANCE)) {
            g.buildConstF32(0.0f);
        } else if (Intrinsics.areEqual(wasmType, WasmF64.INSTANCE)) {
            g.buildConstF64(0.0);
        } else if (wasmType instanceof WasmRefNullType) {
            g.buildRefNull(((WasmRefNullType)type2).getHeapType());
        } else if (wasmType instanceof WasmRefNullNoneType) {
            g.buildRefNull(WasmHeapType.Simple.NullNone.INSTANCE);
        } else if (wasmType instanceof WasmRefNullExternrefType) {
            g.buildRefNull(WasmHeapType.Simple.NullNoExtern.INSTANCE);
        } else if (wasmType instanceof WasmAnyRef) {
            g.buildRefNull(WasmHeapType.Simple.Any.INSTANCE);
        } else if (wasmType instanceof WasmExternRef) {
            g.buildRefNull(WasmHeapType.Simple.Extern.INSTANCE);
        } else {
            if (Intrinsics.areEqual(wasmType, WasmUnreachableType.INSTANCE)) {
                throw new IllegalStateException("Unreachable type can't be initialized".toString());
            }
            throw new IllegalStateException(("Unknown value type " + type2.getName()).toString());
        }
    }

    @NotNull
    public static final List<IrValueParameter> getEffectiveValueParameters(@NotNull IrFunction $this$getEffectiveValueParameters) {
        IrValueParameter irValueParameter;
        Intrinsics.checkNotNullParameter($this$getEffectiveValueParameters, "<this>");
        if ($this$getEffectiveValueParameters instanceof IrConstructor) {
            IrValueParameter irValueParameter2 = IrUtilsKt.getParentAsClass($this$getEffectiveValueParameters).getThisReceiver();
            irValueParameter = irValueParameter2;
            Intrinsics.checkNotNull(irValueParameter2);
        } else {
            irValueParameter = null;
        }
        IrValueParameter implicitThis = irValueParameter;
        IrValueParameter[] irValueParameterArray = new IrValueParameter[]{implicitThis, $this$getEffectiveValueParameters.getDispatchReceiverParameter(), $this$getEffectiveValueParameters.getExtensionReceiverParameter()};
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(irValueParameterArray), (Iterable)$this$getEffectiveValueParameters.getValueParameters());
    }

    public static final boolean isExported(@NotNull IrFunction $this$isExported) {
        Intrinsics.checkNotNullParameter($this$isExported, "<this>");
        return AnnotationUtilsKt.isJsExport($this$isExported);
    }

    public static final void generateConstExpression(@NotNull IrConst<?> expression2, @NotNull WasmExpressionBuilder body2, @NotNull WasmBaseCodegenContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(body2, "body");
        Intrinsics.checkNotNullParameter(context, "context");
        IrConstKind<?> kind = expression2.getKind();
        if (kind instanceof IrConstKind.Null) {
            IrClass irClass2 = IrTypesKt.getClass(expression2.getType());
            WasmType bottomType = (irClass2 != null ? irClass2.isExternal() : false) ? (WasmType)WasmRefNullExternrefType.INSTANCE : (WasmType)WasmRefNullNoneType.INSTANCE;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType(bottomType)};
            body2.buildInstr(WasmOp.REF_NULL, wasmImmediateArray);
        } else if (kind instanceof IrConstKind.Boolean) {
            body2.buildConstI32((Boolean)((IrConstKind.Boolean)kind).valueOf(expression2) != false ? 1 : 0);
        } else if (kind instanceof IrConstKind.Byte) {
            body2.buildConstI32(((Number)((IrConstKind.Byte)kind).valueOf(expression2)).byteValue());
        } else if (kind instanceof IrConstKind.Short) {
            body2.buildConstI32(((Number)((IrConstKind.Short)kind).valueOf(expression2)).shortValue());
        } else if (kind instanceof IrConstKind.Int) {
            body2.buildConstI32(((Number)((IrConstKind.Int)kind).valueOf(expression2)).intValue());
        } else if (kind instanceof IrConstKind.Long) {
            body2.buildConstI64(((Number)((IrConstKind.Long)kind).valueOf(expression2)).longValue());
        } else if (kind instanceof IrConstKind.Char) {
            body2.buildConstI32(((Character)((IrConstKind.Char)kind).valueOf(expression2)).charValue());
        } else if (kind instanceof IrConstKind.Float) {
            body2.buildConstF32(((Number)((IrConstKind.Float)kind).valueOf(expression2)).floatValue());
        } else if (kind instanceof IrConstKind.Double) {
            body2.buildConstF64(((Number)((IrConstKind.Double)kind).valueOf(expression2)).doubleValue());
        } else if (kind instanceof IrConstKind.String) {
            body2.buildConstI32Symbol(context.referenceStringLiteral((String)((IrConstKind.String)kind).valueOf(expression2)));
            body2.buildConstI32(((String)((IrConstKind.String)kind).valueOf(expression2)).length());
            body2.buildCall(context.referenceFunction(context.getBackendContext().getWasmSymbols().getStringGetLiteral()));
        } else {
            throw new IllegalStateException("Unknown constant kind".toString());
        }
    }
}

