/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.WhenOnClassExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnExpectExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnEnumExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "()V", "getMissingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "", "isApplicable", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
final class WhenOnEnumExhaustivenessChecker
extends WhenOnClassExhaustivenessChecker {
    @NotNull
    public static final WhenOnEnumExhaustivenessChecker INSTANCE = new WhenOnEnumExhaustivenessChecker();

    private WhenOnEnumExhaustivenessChecker() {
    }

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        List list2;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean bl = DescriptorUtils.isEnumClass(subjectDescriptor);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WhenOnEnumExhaustivenessChecker$getMissingCases$22 = false;
            String $i$a$-assert-WhenOnEnumExhaustivenessChecker$getMissingCases$22 = "isWhenOnEnumExhaustive should be called with an enum class descriptor";
            throw new AssertionError((Object)$i$a$-assert-WhenOnEnumExhaustivenessChecker$getMissingCases$22);
        }
        List $this$getMissingCases_u24lambda_u241 = list2 = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl2 = false;
        ClassDescriptor classDescriptor2 = subjectDescriptor;
        Intrinsics.checkNotNull(classDescriptor2);
        $this$getMissingCases_u24lambda_u241.addAll(INSTANCE.getMissingClassCases(expression2, INSTANCE.getEnumEntries(classDescriptor2), context));
        $this$getMissingCases_u24lambda_u241.addAll(WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, nullable));
        CollectionsKt.addIfNotNull($this$getMissingCases_u24lambda_u241, WhenOnExpectExhaustivenessChecker.INSTANCE.getMissingCase(subjectDescriptor));
        return kotlin.collections.CollectionsKt.build(list2);
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        return WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType) != null;
    }
}

