/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001aM\u0010\t\u001a\u0004\u0018\u00010\n\"\b\b\u0000\u0010\u000b*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u0001H\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\b\u00a8\u0006\u001a"}, d2={"checkKotlinPackageUsage", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "getLibraryFromHome", "Ljava/io/File;", "PathProvider", "", "paths", "getLibrary", "Lkotlin/Function1;", "libraryName", "", "noLibraryArgument", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/lang/String;)Ljava/io/File;", "incrementalCompilationIsEnabled", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "incrementalCompilationIsEnabledForJs", "toLogger", "Lorg/jetbrains/kotlin/util/Logger;", "cli"})
public final class UtilsKt {
    public static final boolean incrementalCompilationIsEnabled(@NotNull CommonCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Boolean bl = arguments2.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJvm();
    }

    public static final boolean incrementalCompilationIsEnabledForJs(@NotNull CommonCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Boolean bl = arguments2.getIncrementalCompilation();
        return bl != null ? bl : IncrementalCompilation.isEnabledForJs();
    }

    public static final boolean checkKotlinPackageUsage(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends KtFile> files2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        if (configuration2.getBoolean(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE)) {
            return true;
        }
        FqName kotlinPackage = new FqName("kotlin");
        for (KtFile ktFile : files2) {
            if (!FqNamesUtilKt.isSubpackageOf(ktFile.getPackageFqName(), kotlinPackage)) continue;
            KtPackageDirective ktPackageDirective = ktFile.getPackageDirective();
            Intrinsics.checkNotNull(ktPackageDirective);
            messageCollector.report(CompilerMessageSeverity.ERROR, "Only the Kotlin standard library is allowed to use the 'kotlin' package", MessageUtil.psiElementToMessageLocation(ktPackageDirective));
            return false;
        }
        return true;
    }

    public static final boolean checkKotlinPackageUsage(@NotNull CompilerConfiguration configuration2, @NotNull Collection<? extends KtFile> files2) {
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(files2, "files");
        MessageCollector messageCollector = configuration2.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, MessageCollector.Companion.getNONE());
        Intrinsics.checkNotNullExpressionValue(messageCollector, "configuration.get(CLICon\u2026Y, MessageCollector.NONE)");
        return UtilsKt.checkKotlinPackageUsage(configuration2, files2, messageCollector);
    }

    @Nullable
    public static final <PathProvider> File getLibraryFromHome(@Nullable PathProvider paths, @NotNull Function1<? super PathProvider, ? extends File> getLibrary, @NotNull String libraryName2, @NotNull MessageCollector messageCollector, @NotNull String noLibraryArgument) {
        File stdlibJar;
        Intrinsics.checkNotNullParameter(getLibrary, "getLibrary");
        Intrinsics.checkNotNullParameter(libraryName2, "libraryName");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        Intrinsics.checkNotNullParameter(noLibraryArgument, "noLibraryArgument");
        if (paths != null && (stdlibJar = getLibrary.invoke(paths)).exists()) {
            return stdlibJar;
        }
        messageCollector.report(CompilerMessageSeverity.STRONG_WARNING, "Unable to find " + libraryName2 + " in the Kotlin home directory. " + "Pass either " + noLibraryArgument + " to prevent adding it to the classpath, " + "or the correct '-kotlin-home'", null);
        return null;
    }

    @NotNull
    public static final Logger toLogger(@NotNull MessageCollector $this$toLogger) {
        Intrinsics.checkNotNullParameter($this$toLogger, "$this$toLogger");
        return new Logger($this$toLogger){
            final /* synthetic */ MessageCollector $this_toLogger;

            public void error(@NotNull String message) {
                Intrinsics.checkNotNullParameter(message, "message");
                MessageCollector.report$default(this.$this_toLogger, CompilerMessageSeverity.ERROR, message, null, 4, null);
            }

            @NotNull
            public Void fatal(@NotNull String message) {
                Intrinsics.checkNotNullParameter(message, "message");
                MessageCollector.report$default(this.$this_toLogger, CompilerMessageSeverity.ERROR, message, null, 4, null);
                int n = 1;
                System.exit(n);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }

            public void warning(@NotNull String message) {
                Intrinsics.checkNotNullParameter(message, "message");
                MessageCollector.report$default(this.$this_toLogger, CompilerMessageSeverity.WARNING, message, null, 4, null);
            }

            public void log(@NotNull String message) {
                Intrinsics.checkNotNullParameter(message, "message");
                MessageCollector.report$default(this.$this_toLogger, CompilerMessageSeverity.LOGGING, message, null, 4, null);
            }
            {
                this.$this_toLogger = $receiver;
            }
        };
    }
}

