/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirArrayOfCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.UseSiteTargetsList;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a8\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a.\u0010\u0003\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0013\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001a\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012*\u00020\u001a\u001a\u0010\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u001d\u001a\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0015\u001a\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u0019*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u000e\u0010\u001f\u001a\u00020 *\u0006\u0012\u0002\b\u00030\u0015\u001a\u001c\u0010!\u001a\u0004\u0018\u00010\u0006*\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012*\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010#\u001a\u00020 *\u00020\u001d\u001a\n\u0010#\u001a\u00020 *\u00020\n\u001a\f\u0010$\u001a\u0004\u0018\u00010\n*\u00020%\u001a\f\u0010&\u001a\u0004\u0018\u00010\n*\u00020%\u001a\u0010\u0010&\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u0015\u001a\u0012\u0010'\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012*\u00020\u001aH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"defaultAnnotationTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "checkRepeatedAnnotation", "", "useSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "existingTargetsForAnnotation", "", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "annotationContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "annotations", "", "containsRepeatableAnnotation", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "extractClassFromArgument", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "extractClassesFromArgument", "getAllowedAnnotationTargets", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "getAnnotationClassForOptInMarker", "getAnnotationRetention", "Lkotlin/annotation/AnnotationRetention;", "getDefaultUseSiteTarget", "getImplicitUseSiteTargetList", "getRetention", "getRetentionAnnotation", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getTargetAnnotation", "isRepeatable", "unfoldArrayOrVararg", "checkers"})
public final class FirAnnotationHelpersKt {
    @NotNull
    private static final Set<KotlinTarget> defaultAnnotationTargets = KotlinTarget.Companion.getDEFAULT_TARGET_SET();

    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirRegularClass $this$getRetention) {
        Intrinsics.checkNotNullParameter($this$getRetention, "<this>");
        Object object = FirAnnotationHelpersKt.getRetentionAnnotation($this$getRetention);
        if (object == null || (object = FirAnnotationHelpersKt.getRetention(object)) == null) {
            object = AnnotationRetention.RUNTIME;
        }
        return object;
    }

    @NotNull
    public static final AnnotationRetention getRetention(@NotNull FirAnnotation $this$getRetention) {
        AnnotationRetention annotationRetention;
        AnnotationRetention annotationRetention2;
        block4: {
            Intrinsics.checkNotNullParameter($this$getRetention, "<this>");
            FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName($this$getRetention, StandardClassIds.Annotations.ParameterNames.INSTANCE.getRetentionValue());
            FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
            if (firQualifiedAccessExpression == null) {
                return AnnotationRetention.RUNTIME;
            }
            FirQualifiedAccessExpression retentionArgument = firQualifiedAccessExpression;
            Object object = UtilsKt.getResolved(retentionArgument.getCalleeReference());
            if (object == null || (object = ((FirResolvedNamedReference)object).getName()) == null || (object = ((Name)object).asString()) == null) {
                return AnnotationRetention.RUNTIME;
            }
            Object retentionName = object;
            AnnotationRetention[] $this$firstOrNull$iv = AnnotationRetention.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                AnnotationRetention element$iv;
                AnnotationRetention it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual(it.name(), retentionName)) continue;
                annotationRetention2 = element$iv;
                break block4;
            }
            annotationRetention2 = annotationRetention = null;
        }
        if (annotationRetention2 == null) {
            annotationRetention = AnnotationRetention.RUNTIME;
        }
        return annotationRetention;
    }

    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirAnnotation $this$getAllowedAnnotationTargets, @NotNull FirSession session2) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag;
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter($this$getAllowedAnnotationTargets, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if ($this$getAllowedAnnotationTargets.getAnnotationTypeRef() instanceof FirErrorTypeRef) {
            return ArraysKt.toSet(KotlinTarget.values());
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType($this$getAllowedAnnotationTargets.getAnnotationTypeRef());
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null || (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType, session2, null, 2, null)) == null || (coneClassLikeLookupTag = ((ConeClassLikeType)coneKotlinType).getLookupTag()) == null || (firClassLikeSymbol = LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, session2)) == null) {
            return defaultAnnotationTargets;
        }
        FirClassLikeSymbol<?> annotationClassSymbol = firClassLikeSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)annotationClassSymbol, FirResolvePhase.BODY_RESOLVE);
        return FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotationClassSymbol);
    }

    @Nullable
    public static final FirRegularClassSymbol getAnnotationClassForOptInMarker(@NotNull FirAnnotation $this$getAnnotationClassForOptInMarker, @NotNull FirSession session2) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getAnnotationClassForOptInMarker, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        FirTypeRef $this$coneTypeSafe$iv = $this$getAnnotationClassForOptInMarker.getAnnotationTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        if ((object = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) {
            return null;
        }
        Object lookupTag2 = object;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag2, session2);
        FirRegularClassSymbol firRegularClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol annotationClassSymbol = firRegularClassSymbol;
        if (FirAnnotationUtilsKt.getAnnotationByClassId(annotationClassSymbol, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID()) == null) {
            return null;
        }
        return annotationClassSymbol;
    }

    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirRegularClass $this$getAllowedAnnotationTargets) {
        Intrinsics.checkNotNullParameter($this$getAllowedAnnotationTargets, "<this>");
        return FirAnnotationHelpersKt.getAllowedAnnotationTargets($this$getAllowedAnnotationTargets.getSymbol());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<KotlinTarget> getAllowedAnnotationTargets(@NotNull FirClassLikeSymbol<?> $this$getAllowedAnnotationTargets) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter($this$getAllowedAnnotationTargets, "<this>");
        FirAnnotation firAnnotation = FirAnnotationHelpersKt.getTargetAnnotation($this$getAllowedAnnotationTargets);
        if (firAnnotation == null) {
            return defaultAnnotationTargets;
        }
        FirAnnotation targetAnnotation = firAnnotation;
        FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(targetAnnotation, StandardClassIds.Annotations.ParameterNames.INSTANCE.getTargetAllowedTargets());
        List<FirExpression> list2 = firExpression2 != null ? FirAnnotationHelpersKt.unfoldArrayOrVararg(firExpression2) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<FirExpression> arguments2 = list2;
        Iterable iterable = arguments2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinTarget kotlinTarget;
            block6: {
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                FirExpression argument2 = (FirExpression)element$iv;
                boolean bl2 = false;
                FirQualifiedAccessExpression targetExpression = argument2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)argument2 : null;
                Object object = targetExpression;
                if (object == null || (object = ((FirQualifiedAccessExpression)object).getCalleeReference()) == null || (object = UtilsKt.getResolved((FirReference)object)) == null || (object = ((FirResolvedNamedReference)object).getName()) == null || (object = ((Name)object).asString()) == null) {
                    kotlinTarget = null;
                } else {
                    Intrinsics.checkNotNullExpressionValue(object, "targetExpression?.callee\u2026 return@mapNotNullTo null");
                    Object targetName = object;
                    KotlinTarget[] $this$firstOrNull$iv = KotlinTarget.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        KotlinTarget element$iv2;
                        KotlinTarget target = element$iv2 = $this$firstOrNull$iv[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(target.name(), targetName)) continue;
                        kotlinTarget = element$iv2;
                        break block6;
                    }
                    kotlinTarget = null;
                }
            }
            if (kotlinTarget == null) continue;
            KotlinTarget it$iv = kotlinTarget;
            boolean bl = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    @Nullable
    public static final FirAnnotation getRetentionAnnotation(@NotNull FirDeclaration $this$getRetentionAnnotation) {
        Intrinsics.checkNotNullParameter($this$getRetentionAnnotation, "<this>");
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$getRetentionAnnotation, StandardClassIds.Annotations.INSTANCE.getRetention());
    }

    @Nullable
    public static final FirAnnotation getTargetAnnotation(@NotNull FirDeclaration $this$getTargetAnnotation) {
        Intrinsics.checkNotNullParameter($this$getTargetAnnotation, "<this>");
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$getTargetAnnotation, StandardClassIds.Annotations.INSTANCE.getTarget());
    }

    @Nullable
    public static final FirAnnotation getTargetAnnotation(@NotNull FirClassLikeSymbol<?> $this$getTargetAnnotation) {
        Intrinsics.checkNotNullParameter($this$getTargetAnnotation, "<this>");
        return FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$getTargetAnnotation, StandardClassIds.Annotations.INSTANCE.getTarget());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirRegularClassSymbol> extractClassesFromArgument(@NotNull FirExpression $this$extractClassesFromArgument) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$extractClassesFromArgument, "<this>");
        Iterable $this$mapNotNull$iv = FirAnnotationHelpersKt.unfoldArrayOrVararg($this$extractClassesFromArgument);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirRegularClassSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirExpression it = (FirExpression)element$iv$iv;
            boolean bl2 = false;
            if (FirAnnotationHelpersKt.extractClassFromArgument(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirRegularClassSymbol extractClassFromArgument(@NotNull FirExpression $this$extractClassFromArgument) {
        Intrinsics.checkNotNullParameter($this$extractClassFromArgument, "<this>");
        if (!($this$extractClassFromArgument instanceof FirGetClassCall)) {
            return null;
        }
        FirExpression firExpression2 = ((FirGetClassCall)$this$extractClassFromArgument).getArgument();
        FirResolvedQualifier firResolvedQualifier = firExpression2 instanceof FirResolvedQualifier ? (FirResolvedQualifier)firExpression2 : null;
        if (firResolvedQualifier == null) {
            return null;
        }
        FirResolvedQualifier qualifier = firResolvedQualifier;
        FirClassLikeSymbol<?> firClassLikeSymbol = qualifier.getSymbol();
        return firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void checkRepeatedAnnotation(@Nullable AnnotationUseSiteTarget useSiteTarget, @NotNull List<AnnotationUseSiteTarget> existingTargetsForAnnotation, @NotNull FirAnnotation annotation2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(existingTargetsForAnnotation, "existingTargetsForAnnotation");
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!existingTargetsForAnnotation.contains((Object)useSiteTarget)) {
            AnnotationUseSiteTarget it;
            Iterable $this$any$iv = existingTargetsForAnnotation;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return;
                Object element$iv = iterator2.next();
                it = (AnnotationUseSiteTarget)((Object)element$iv);
                boolean bl = false;
            } while (!(it == null != (useSiteTarget == null)));
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        boolean duplicated = bl;
        if (!duplicated) return;
        if (FirAnnotationHelpersKt.isRepeatable(annotation2, context.getSession())) return;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getREPEATED_ANNOTATION(), (DiagnosticContext)context, null, 8, null);
    }

    public static final boolean isRepeatable(@NotNull FirAnnotation $this$isRepeatable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isRepeatable, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId($this$isRepeatable);
        if (classId == null) {
            return false;
        }
        ClassId annotationClassId = classId;
        if (annotationClassId.isLocal()) {
            return false;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(session2).getClassLikeSymbolByClassId(annotationClassId);
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol<?> annotationClass = firClassLikeSymbol;
        return FirAnnotationHelpersKt.containsRepeatableAnnotation(annotationClass, session2);
    }

    public static final boolean containsRepeatableAnnotation(@NotNull FirClassLikeSymbol<?> $this$containsRepeatableAnnotation, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$containsRepeatableAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$containsRepeatableAnnotation, StandardClassIds.Annotations.INSTANCE.getRepeatable()) != null) {
            return true;
        }
        if (FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$containsRepeatableAnnotation, StandardClassIds.Annotations.Java.INSTANCE.getRepeatable()) != null || FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$containsRepeatableAnnotation, StandardClassIds.Annotations.INSTANCE.getJvmRepeatable()) != null) {
            return FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.RepeatableAnnotations) || FirAnnotationHelpersKt.getAnnotationRetention($this$containsRepeatableAnnotation) == AnnotationRetention.SOURCE && $this$containsRepeatableAnnotation.getOrigin() instanceof FirDeclarationOrigin.Java;
        }
        return false;
    }

    @NotNull
    public static final AnnotationRetention getAnnotationRetention(@NotNull FirClassLikeSymbol<?> $this$getAnnotationRetention) {
        Intrinsics.checkNotNullParameter($this$getAnnotationRetention, "<this>");
        Object object = FirAnnotationUtilsKt.getAnnotationByClassId((FirBasedSymbol)$this$getAnnotationRetention, StandardClassIds.Annotations.INSTANCE.getRetention());
        if (object == null || (object = FirAnnotationHelpersKt.getRetention(object)) == null) {
            object = AnnotationRetention.RUNTIME;
        }
        return object;
    }

    @Nullable
    public static final AnnotationUseSiteTarget getDefaultUseSiteTarget(@NotNull FirAnnotationContainer $this$getDefaultUseSiteTarget, @NotNull FirAnnotation annotation2, @NotNull CheckerContext context) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$getDefaultUseSiteTarget, "<this>");
            Intrinsics.checkNotNullParameter(annotation2, "annotation");
            Intrinsics.checkNotNullParameter(context, "context");
            Iterable $this$firstOrNull$iv = FirAnnotationHelpersKt.getImplicitUseSiteTargetList($this$getDefaultUseSiteTarget, context);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationUseSiteTarget it = (AnnotationUseSiteTarget)((Object)element$iv);
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context.getSession()), KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final List<AnnotationUseSiteTarget> getImplicitUseSiteTargetList(@NotNull FirAnnotationContainer $this$getImplicitUseSiteTargetList, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$getImplicitUseSiteTargetList, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        FirAnnotationContainer firAnnotationContainer = $this$getImplicitUseSiteTargetList;
        if (firAnnotationContainer instanceof FirValueParameter) {
            FirElement firElement;
            block4: {
                CheckerContext $this$findClosest_u24default$iv = context;
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    FirElement firElement2;
                    FirDeclaration firDeclaration = it$iv;
                    if (!(firDeclaration instanceof FirDeclaration)) {
                        firDeclaration = null;
                    }
                    if ((firElement = (FirElement)firDeclaration) == null) continue;
                    FirElement firElement3 = firElement2 = firElement;
                    boolean bl = false;
                    FirElement it = firElement3;
                    firElement = true ? firElement2 : null;
                    if (firElement == null) {
                        continue;
                    }
                    break block4;
                }
                firElement = null;
            }
            return firElement instanceof FirPrimaryConstructor ? UseSiteTargetsList.INSTANCE.getT_CONSTRUCTOR_PARAMETER() : CollectionsKt.emptyList();
        }
        return firAnnotationContainer instanceof FirProperty ? (!((FirProperty)$this$getImplicitUseSiteTargetList).isLocal() ? UseSiteTargetsList.INSTANCE.getT_PROPERTY() : CollectionsKt.emptyList()) : (firAnnotationContainer instanceof FirPropertyAccessor ? (((FirPropertyAccessor)$this$getImplicitUseSiteTargetList).isGetter() ? CollectionsKt.listOf(AnnotationUseSiteTarget.PROPERTY_GETTER) : CollectionsKt.listOf(AnnotationUseSiteTarget.PROPERTY_SETTER)) : CollectionsKt.emptyList());
    }

    private static final List<FirExpression> unfoldArrayOrVararg(FirExpression $this$unfoldArrayOrVararg) {
        List<FirExpression> list2;
        FirExpression firExpression2 = $this$unfoldArrayOrVararg;
        if (firExpression2 instanceof FirVarargArgumentsExpression) {
            list2 = ((FirVarargArgumentsExpression)$this$unfoldArrayOrVararg).getArguments();
        } else if (firExpression2 instanceof FirArrayOfCall) {
            FirCall $this$arguments$iv = (FirCall)((Object)$this$unfoldArrayOrVararg);
            boolean $i$f$getArguments = false;
            list2 = $this$arguments$iv.getArgumentList().getArguments();
        } else {
            return CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkRepeatedAnnotation(@Nullable FirAnnotationContainer annotationContainer, @NotNull List<? extends FirAnnotation> annotations2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (annotations2.size() <= 1) {
            return;
        }
        HashMap annotationsMap = new HashMap();
        for (FirAnnotation firAnnotation : annotations2) {
            Object object;
            void $this$getOrPut$iv;
            AnnotationUseSiteTarget annotationUseSiteTarget = firAnnotation.getUseSiteTarget();
            if (annotationUseSiteTarget == null) {
                FirAnnotationContainer firAnnotationContainer = annotationContainer;
                annotationUseSiteTarget = firAnnotationContainer != null ? FirAnnotationHelpersKt.getDefaultUseSiteTarget(firAnnotationContainer, firAnnotation, context) : null;
            }
            AnnotationUseSiteTarget useSiteTarget = annotationUseSiteTarget;
            Map map = annotationsMap;
            ConeKotlinType key$iv = FirTypeUtilsKt.getConeType(firAnnotation.getAnnotationTypeRef());
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            List existingTargetsForAnnotation = (List)object;
            FirAnnotationHelpersKt.checkRepeatedAnnotation(useSiteTarget, existingTargetsForAnnotation, firAnnotation, context, reporter);
            existingTargetsForAnnotation.add(useSiteTarget);
        }
    }
}

