/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.TrackingFileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultTrackingFileManager
implements TrackingFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTrackingFileManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties read(File file) {
        FileInputStream stream;
        block5: {
            stream = null;
            if (file.exists()) break block5;
            Properties properties = null;
            this.close(stream, file);
            return properties;
        }
        try {
            stream = new FileInputStream(file);
            Properties props = new Properties();
            props.load(stream);
            Properties properties = props;
            this.close(stream, file);
            return properties;
        }
        catch (IOException e) {
            try {
                LOGGER.warn("Failed to read tracking file {}", (Object)file, (Object)e);
                this.close(stream, file);
            }
            catch (Throwable throwable) {
                this.close(stream, file);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties update(File file, Map<String, String> updates) {
        Properties props = new Properties();
        File directory = file.getParentFile();
        if (!directory.mkdirs() && !directory.exists()) {
            LOGGER.warn("Failed to create parent directories for tracking file {}", (Object)file);
            return props;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
            if (file.canRead()) {
                Object buffer = new byte[(int)raf.length()];
                raf.readFully((byte[])buffer);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])buffer);
                props.load(byteArrayInputStream);
            }
            for (Map.Entry entry : updates.entrySet()) {
                if (entry.getValue() == null) {
                    props.remove(entry.getKey());
                    continue;
                }
                props.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
            LOGGER.debug("Writing tracking file {}", (Object)file);
            props.store(stream, "NOTE: This is a Maven Resolver internal implementation file, its format can be changed without prior notice.");
            raf.seek(0L);
            raf.write(stream.toByteArray());
            raf.setLength(raf.getFilePointer());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write tracking file {}", (Object)file, (Object)e);
        }
        finally {
            this.close(raf, file);
        }
        return props;
    }

    private void close(Closeable closeable, File file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing tracking file {}", (Object)file, (Object)e);
            }
        }
    }
}

