/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Command;
import eu.hansolo.tilesfx.Tile;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.paint.Color;

public class Alarm {
    public static final boolean ARMED = true;
    public static final boolean UNARMED = false;
    public final AlarmMarkerEvent ALARM_MARKER_PRESSED_EVENT = new AlarmMarkerEvent((Object)this, null, AlarmMarkerEvent.ALARM_MARKER_PRESSED);
    public final AlarmMarkerEvent ALARM_MARKER_RELEASED_EVENT = new AlarmMarkerEvent((Object)this, null, AlarmMarkerEvent.ALARM_MARKER_RELEASED);
    private Repetition repetition;
    private ZonedDateTime time;
    private boolean armed;
    private String text;
    private Command command;
    private Color color;
    private ObjectProperty<EventHandler<AlarmMarkerEvent>> onMarkerPressed = new SimpleObjectProperty<EventHandler<AlarmMarkerEvent>>(this, "onMarkerPressed");
    private ObjectProperty<EventHandler<AlarmMarkerEvent>> onMarkerReleased = new SimpleObjectProperty<EventHandler<AlarmMarkerEvent>>(this, "onMarkerReleased");

    public Alarm() {
        this(Repetition.ONCE, ZonedDateTime.now().plus(5L, ChronoUnit.MINUTES), true, "", null, Tile.BACKGROUND);
    }

    public Alarm(ZonedDateTime TIME) {
        this(Repetition.ONCE, TIME, true, "", null, Tile.BACKGROUND);
    }

    public Alarm(ZonedDateTime TIME, Color COLOR) {
        this(Repetition.ONCE, TIME, true, "", null, COLOR);
    }

    public Alarm(Repetition REPETITION, ZonedDateTime TIME) {
        this(REPETITION, TIME, true, "", null, Tile.BACKGROUND);
    }

    public Alarm(Repetition REPETITION, ZonedDateTime TIME, Color COLOR) {
        this(REPETITION, TIME, true, "", null, COLOR);
    }

    public Alarm(Repetition REPETITION, ZonedDateTime TIME, boolean ARMED) {
        this(REPETITION, TIME, ARMED, "");
    }

    public Alarm(Repetition REPETITION, ZonedDateTime TIME, boolean ARMED, String TEXT) {
        this(REPETITION, TIME, ARMED, TEXT, null, Tile.BACKGROUND);
    }

    public Alarm(Repetition REPETITION, ZonedDateTime TIME, boolean ARMED, String TEXT, Command COMMAND) {
        this(REPETITION, TIME, ARMED, TEXT, COMMAND, Tile.BACKGROUND);
    }

    public Alarm(Repetition REPETITION, ZonedDateTime TIME, boolean ARMED, String TEXT, Command COMMAND, Color COLOR) {
        this.repetition = REPETITION;
        this.time = TIME;
        this.armed = ARMED;
        this.text = TEXT;
        this.command = COMMAND;
        this.color = COLOR;
    }

    public Repetition getRepetition() {
        return this.repetition;
    }

    public void setRepetition(Repetition REPETITION) {
        this.repetition = REPETITION;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public void setTime(ZonedDateTime TIME) {
        this.time = TIME;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setArmed(boolean ARMED) {
        this.armed = ARMED;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String TEXT) {
        this.text = TEXT;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command COMMAND) {
        this.command = COMMAND;
    }

    public void executeCommand() {
        if (null != this.command) {
            this.command.execute();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color COLOR) {
        this.color = COLOR;
    }

    public String toString() {
        return "{\n" + "\"reptition\":\"" + this.repetition.name() + "\",\n" + "\"time\":\"" + this.time + "\",\n" + "\"armed\":" + this.armed + ",\n" + "\"color\":\"" + this.getColor().toString().substring(0, 8).replace("0x", "#") + "\",\n" + "\"text\":\"" + this.text + "\"\n" + "}";
    }

    public final ObjectProperty<EventHandler<AlarmMarkerEvent>> onMarkerPressedProperty() {
        return this.onMarkerPressed;
    }

    public final void setOnMarkerPressed(EventHandler<AlarmMarkerEvent> value) {
        this.onMarkerPressedProperty().set(value);
    }

    public final EventHandler<AlarmMarkerEvent> getOnMarkerPressed() {
        return (EventHandler)this.onMarkerPressedProperty().get();
    }

    public final ObjectProperty<EventHandler<AlarmMarkerEvent>> onMarkerReleasedProperty() {
        return this.onMarkerReleased;
    }

    public final void setOnMarkerReleased(EventHandler<AlarmMarkerEvent> value) {
        this.onMarkerReleasedProperty().set(value);
    }

    public final EventHandler<AlarmMarkerEvent> getOnMarkerReleased() {
        return (EventHandler)this.onMarkerReleasedProperty().get();
    }

    public void fireAlarmMarkerEvent(AlarmMarkerEvent EVENT) {
        EventType<? extends Event> TYPE = EVENT.getEventType();
        EventHandler<AlarmMarkerEvent> HANDLER = AlarmMarkerEvent.ALARM_MARKER_PRESSED == TYPE ? this.getOnMarkerPressed() : (AlarmMarkerEvent.ALARM_MARKER_RELEASED == TYPE ? this.getOnMarkerReleased() : null);
        if (null == HANDLER) {
            return;
        }
        Platform.runLater(() -> HANDLER.handle(EVENT));
    }

    public static class AlarmMarkerEvent
    extends Event {
        public static final EventType<AlarmMarkerEvent> ALARM_MARKER_PRESSED = new EventType(ANY, "ALARM_MARKER_PRESSED");
        public static final EventType<AlarmMarkerEvent> ALARM_MARKER_RELEASED = new EventType(ANY, "ALARM_MARKER_RELEASED");

        public AlarmMarkerEvent(Object SOURCE, EventTarget TARGET, EventType<AlarmMarkerEvent> TYPE) {
            super(SOURCE, TARGET, TYPE);
        }
    }

    public static enum Repetition {
        ONCE,
        HALF_HOURLY,
        HOURLY,
        DAILY,
        WEEKLY;

    }
}

