/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveDownloadController
implements Initializable {
    private final JDialog dialog;
    @FXML
    private Button saveBtn;
    @FXML
    private Button cancelBtn;
    @FXML
    private Label lblThema;
    @FXML
    private Label lblTitle;
    @FXML
    ImageView ivSender;
    @FXML
    ComboBox<String> cBxPSet;
    private boolean success;
    private final DatenFilm film;
    private final DatenPset pSet;

    public SaveDownloadController(@NotNull JDialog dialog, @NotNull DatenFilm film, @Nullable DatenPset pSet) {
        this.dialog = dialog;
        this.film = film;
        this.pSet = pSet;
    }

    private void setupButtonBarActions() {
        this.saveBtn.setOnAction(e -> {
            this.success = true;
            this.dialog.dispose();
        });
        this.cancelBtn.setOnAction(e -> {
            this.success = false;
            this.dialog.dispose();
        });
    }

    private void setupSenderLogo() {
        Optional<ImageIcon> icn = MVSenderIconCache.get(this.film.getSender(), false);
        icn.ifPresentOrElse(icon -> {
            WritableImage image = SwingFXUtils.toFXImage(JavaFxUtils.toBufferedImage(icon), null);
            this.ivSender.setImage(image);
        }, () -> this.ivSender.setImage(null));
    }

    private void setupProgramSetComboBox() {
        ListePset saveOnlyPSets = Daten.listePset.getListeSpeichern();
        for (DatenPset pSet : saveOnlyPSets) {
            this.cBxPSet.getItems().add(pSet.arr[0]);
        }
        if (this.pSet != null) {
            this.cBxPSet.getSelectionModel().select(this.pSet.arr[0]);
        } else {
            this.cBxPSet.getSelectionModel().selectFirst();
        }
        if (this.cBxPSet.getItems().size() <= 1) {
            this.cBxPSet.setDisable(true);
        }
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.setupButtonBarActions();
        this.setupSenderLogo();
        this.lblThema.setText(this.film.getThema());
        this.lblTitle.setText(this.film.getTitle());
        this.setupProgramSetComboBox();
    }

    public boolean success() {
        return this.success;
    }
}

