tm Module
     __________________________________________________________

   Table of Contents

   1. Admin Guide

        1.1. Overview

              1.1.1. Per-Branch flags
              1.1.2. Timeout-Based Failover
              1.1.3. DNS Failover
              1.1.4. Anycast Scenario
              1.1.5. Usage Scope

        1.2. Dependencies

              1.2.1. OpenSIPS Modules
              1.2.2. External Libraries or Applications

        1.3. Exported Parameters

              1.3.1. fr_timeout (integer)
              1.3.2. fr_inv_timeout (integer)
              1.3.3. wt_timer (integer)
              1.3.4. delete_timer (integer)
              1.3.5. T1_timer (integer)
              1.3.6. T2_timer (integer)
              1.3.7. ruri_matching (integer)
              1.3.8. via1_matching (integer)
              1.3.9. unix_tx_timeout (integer)
              1.3.10. restart_fr_on_each_reply (integer)
              1.3.11. tw_append (string)
              1.3.12. pass_provisional_replies (integer)
              1.3.13. syn_branch (integer)
              1.3.14. onreply_avp_mode (integer)
              1.3.15. disable_6xx_block (integer)
              1.3.16. enable_stats (integer)
              1.3.17. minor_branch_flag (string/integer)
              1.3.18. timer_partitions (integer)
              1.3.19. auto_100trying (integer)
              1.3.20. tm_replication_cluster (integer)
              1.3.21. cluster_param (string)
              1.3.22. cluster_auto_cancel (boolean)

        1.4. Exported Functions

              1.4.1. t_relay([flags],[outbound_proxy])
              1.4.2. t_reply(code, reason_phrase)
              1.4.3. t_reply_with_body(code, reason_phrase, body)
              1.4.4. t_newtran()
              1.4.5. t_check_trans()
              1.4.6. t_check_status(re)
              1.4.7. t_local_replied(reply)
              1.4.8. t_was_cancelled()
              1.4.9. t_cancel_branch([flags])
              1.4.10.
                      t_new_request(method,RURI,from,to[,body[,ctx]
                      ])

              1.4.11. t_on_failure(failure_route)
              1.4.12. t_on_reply(reply_route)
              1.4.13. t_on_branch(branch_route)
              1.4.14. t_inject_branches(source[,flags])
              1.4.15. t_wait_for_new_branches([branches])
              1.4.16. t_wait_no_more_branches()
              1.4.17. t_add_hdrs("sip_hdrs")
              1.4.18. t_add_cancel_reason("Reason_hdr")
              1.4.19. t_replicate(URI,[flags])
              1.4.20. t_write_req(info,fifo)
                      t_write_unix(info,sock)

              1.4.21. t_flush_flags()
              1.4.22. t_anycast_replicate()

        1.5. Exported Pseudo-Variables

              1.5.1. $T_branch_idx
              1.5.2. $T_reply_code
              1.5.3. $T_fr_timeout
              1.5.4. $T_fr_inv_timeout
              1.5.5. $T_ruri
              1.5.6. $bavp(name)
              1.5.7. $T_id

        1.6. Exported MI Functions

              1.6.1. t_uac_dlg
              1.6.2. t_uac_cancel
              1.6.3. t_hash
              1.6.4. t_reply

        1.7. Exported Statistics

              1.7.1. received_replies
              1.7.2. relayed_replies
              1.7.3. local_replies
              1.7.4. UAS_transactions
              1.7.5. UAC_transactions
              1.7.6. 2xx_transactions
              1.7.7. 3xx_transactions
              1.7.8. 4xx_transactions
              1.7.9. 5xx_transactions
              1.7.10. 6xx_transactions
              1.7.11. inuse_transactions

   2. Developer Guide

        2.1. Functions

              2.1.1. load_tm(*import_structure)

   3. Frequently Asked Questions
   4. Contributors

        4.1. By Commit Statistics
        4.2. By Commit Activity

   5. Documentation

        5.1. Contributors

   List of Tables

   4.1. Top contributors by DevScore^(1), authored commits^(2) and
          lines added/removed^(3)

   4.2. Most recently active contributors^(1) to this module

   List of Examples

   1.1. Set fr_timeout parameter
   1.2. Set fr_inv_timeout parameter
   1.3. Set wt_timer parameter
   1.4. Set delete_timer parameter
   1.5. Set T1_timer parameter
   1.6. Set T2_timer parameter
   1.7. Set ruri_matching parameter
   1.8. Set via1_matching parameter
   1.9. Set unix_tx_timeout parameter
   1.10. Set restart_fr_on_each_reply parameter
   1.11. Set tw_append parameter
   1.12. Set pass_provisional_replies parameter
   1.13. Set syn_branch parameter
   1.14. Set onreply_avp_mode parameter
   1.15. Set disable_6xx_block parameter
   1.16. Set enable_stats parameter
   1.17. Set minor_branch_flag parameter
   1.18. Set timer_partitions parameter
   1.19. Set auto_100trying parameter
   1.20. Set tm_replication_cluster parameter
   1.21. Set the cluster_param parameter
   1.22. Set the cluster_auto_cancel parameter
   1.23. t_relay usage
   1.24. t_reply usage
   1.25. t_reply_with_body usage
   1.26. t_newtran usage
   1.27. t_check_trans usage
   1.28. t_check_status usage
   1.29. t_local_replied usage
   1.30. t_was_cancelled usage
   1.31. t_cancel_branch usage
   1.32. t_new_request usage
   1.33. t_on_failure usage
   1.34. t_on_reply usage
   1.35. t_on_branch usage
   1.36. t_inject_branches usage
   1.37. t_wait_for_new_branches usage
   1.38. t_wait_no_more_branches usage
   1.39. t_add_hdrs usage
   1.40. t_add_cancel_reason usage
   1.41. t_replicate usage
   1.42. t_write_req/unix usage
   1.43. t_flush_flags usage
   1.44. t_anycast_replicate usage

Chapter 1. Admin Guide

1.1. Overview

   TM module enables stateful processing of SIP transactions. The
   main use of stateful logic, which is costly in terms of memory
   and CPU, is some services inherently need state. For example,
   transaction-based accounting (module acc) needs to process
   transaction state as opposed to individual messages, and any
   kinds of forking must be implemented statefully. Other use of
   stateful processing is it trading CPU caused by retransmission
   processing for memory. That makes however only sense if CPU
   consumption per request is huge. For example, if you want to
   avoid costly DNS resolution for every retransmission of a
   request to an unresolvable destination, use stateful mode.
   Then, only the initial message burdens server by DNS queries,
   subsequent retransmissions will be dropped and will not result
   in more processes blocked by DNS resolution. The price is more
   memory consumption and higher processing latency.

   From user's perspective, the major function is t_relay(). It
   setup transaction state, absorb retransmissions from upstream,
   generate downstream retransmissions and correlate replies to
   requests.

   In general, if TM is used, it copies clones of received SIP
   messages in shared memory. That costs the memory and also CPU
   time (memcpys, lookups, shmem locks, etc.) Note that non-TM
   functions operate over the received message in private memory,
   that means that any core operations will have no effect on
   statefully processed messages after creating the transactional
   state. For example, calling record_route after t_relay is
   pretty useless, as the RR is added to privately held message
   whereas its TM clone is being forwarded.

   TM is quite big and uneasy to program--lot of mutexes, shared
   memory access, malloc and free, timers--you really need to be
   careful when you do anything. To simplify TM programming, there
   is the instrument of callbacks. The callback mechanisms allow
   programmers to register their functions to specific event. See
   t_hooks.h for a list of possible events.

   Other things programmers may want to know is UAC--it is a very
   simplistic code which allows you to generate your own
   transactions. Particularly useful for things like NOTIFYs or IM
   gateways. The UAC takes care of all the transaction machinery:
   retransmissions , FR timeouts, forking, etc. See t_uac
   prototype in uac.h for more details. Who wants to see the
   transaction result may register for a callback.

1.1.1. Per-Branch flags

   First what is the idea with the branch concept: branch route is
   a route to be execute separately for each branch before being
   sent out - changes in that route should reflect only on that
   branch.

   There are several types of flags in OpenSIPS :
     * message/transaction flags - they are visible everywhere in
       the transaction (in all routes and in all sequential
       replies/request).
     * branch flags - flags that are visible only from a specific
       branch - in all replies and routes connected to this
       branch.
     * script flags - flags that exist only during script
       execution. They are not store anywhere and are lost once
       the top level route was left.

   For example: I have a call parallel forking to GW and to a
   user. And I would like to know from which branch I will get the
   final negative reply (if so). I will set a branch route before
   relaying the calls (with the 2 branches). The branch route will
   be separately executed for each branch; in the branch going to
   GW (I can identified it by looking to RURI), I will set a
   branch flag. This flag will appear only in the onreply route
   run for replied from GW. It will be also be visible in failure
   route if the final elected reply belongs to the GW branch. This
   flags will not be visible in the other branch (in routes
   executing replies from the other branch).

   For how to define branch flags and use via script, see
   t_on_branch() and the setbflag(), resetbflag() and isbflagset()
   script functions.

   Also, modules may set branch flags before transaction creation
   (for the moment this feature is not available in script). The
   REGISTRAR module was the first to use this type of flags. The
   NAT flag is pushed in branch flags instead in message flags

1.1.2. Timeout-Based Failover

   Timeouts can be used to trigger failover behavior. E.g. if we
   send a call to a gateway and the gateway does not send a
   provisional response within 3 seconds, we want to cancel this
   call and send the call to another gateway. Another example is
   to ring a SIP client only for 30 seconds and then redirect the
   call to the voicemail.

   The transaction module exports two types of timeouts:
     * fr_timeout - used when no response was received yet. If
       there is no response after fr_timeout seconds, the timer
       triggers (and failure route will be executed if
       t_on_failure() was called). For INVITE transactions, if a
       provisional response was received, the timeout is reset to
       fr_inv_timeout seconds and RT_T2 for all other
       transactions. Once a final response is received, the
       transaction has finished.
     * fr_inv_timeout - this timeout starts counting down once a
       provisional response was received for an INVITE
       transaction.

   For example: You want to have failover if there is no
   provisional response after 3 seconds, but you want to ring for
   60 seconds. Thus, set the fr_timeout to 3 and fr_inv_timeout to
   60.

1.1.3. DNS Failover

   DNS based failover can be use when relaying stateful requests.
   According to RFC 3263, DNS failover should be done on transport
   level or transaction level. TM module supports them both.

   Failover at transport level may be triggered by a failure of
   sending out the request message. A failure occurs if the
   corresponding interface was found for sending the request, if
   the TCP connection was refused or if a generic internal error
   happened during send. There is no ICMP error report support.

   Failover at transaction level may be triggered when the
   transaction completed either with a 503 reply, either with a
   timeout without any received reply. In such a case,
   automatically, a new branch will be forked if any other
   destination IPs can be used to deliver the requests. The new
   branch will be a clone of the winning branch.

   The set of destinations IPs is step-by-step build (on demand)
   based on the NAPTR, SRV and A records available for the
   destination domain.

   DNS-based failover is by default applied excepting when this
   failover is globally disabled (see the core parameter
   disable_dns_failover) or when the relay flag (per transaction)
   is set (see the t_relay() function).

1.1.4. Anycast Scenario

   Doing a load balancing scenario using Anycast IPs, one might
   run into an issue where a transaction request comes on one
   instance, and the reply (or replies) comes on different ones.
   This would normaly break the transaction state, because the
   local transaction will start re-transmissios and would
   eventually timeout. Moreover, from UA's perspective, the reply
   whould have been sent, but since it reaches a proxy that is not
   aware of that transaction, it will not be forwarded (nor ACKed
   in case of INVITES). And from this point things can escalade
   quickly.

   To sort out these problems, the module uses a distributed
   mechanism to figure out where the transaction for a specific
   reply was created. When an instance receives a reply that does
   not have an associated transaction, it replicates it to be
   handled by the instance that “owns” it. This is achieved using
   the clusterer module support.

   Setting up an anycast scenario is very simple: all the
   instances that are part of an anycast secnario must be set up
   in a cluster (more info at the tm_replication_cluster param).
   When a transaction is created, a special identifier is appended
   to the branch parameter, namely the instance that created the
   transaction. When a reply comes in, the transaction module
   checks who “owns” the transaction. If the identifier is the
   instance's own id, then the reply is processed locally.
   Otherwise it is replicated to the node indicated by the id.
   Replication is done in a very efficient manner, using the
   proto_bin transport.

   Special handling is applied to CANCEL and ACK methods. Due to
   the fact that these methods do not contain the special
   identifier in the branch parameter (since they are generated by
   the UAC and not by us), there is no way to determine who “owns”
   the transaction. Therefore, if we do not find a local
   transaction for these requests, we broadcast them to all the
   other instances using the t_anycast_replicate() function.
   Again, this is done in a very efficient manner using the
   proto_bin transport.

1.1.5. Usage Scope

   Transaction functions and variables are only designed to be
   called on SIP request messages where a transaction can be
   created, or in routes that are transaction aware, such as
   branch_route[name], failure_route[name] or onreply_route[name].
   Using TM functtions or variables in a route that is not
   transaction aware, such as the generic onreply_route,
   error_route or timer_route[name, timer] may lead to undefined
   behavior, and most of the time in bogus or malformed
   signalling. Therefore it is strongly recommended to avoid using
   them in non-tm context aware routes.

1.2. Dependencies

1.2.1. OpenSIPS Modules

   The following modules must be loaded before this module:
     * clusterer module, if the anycast scenario is enabled (see
       tm_replication_cluster param for more information).

1.2.2. External Libraries or Applications

   The following libraries or applications must be installed
   before running OpenSIPS with this module loaded:
     * None.

1.3. Exported Parameters

1.3.1. fr_timeout (integer)

   Timeout which is triggered if no final reply for a request or
   ACK for a negative INVITE reply arrives (in seconds).

   Default value is 30 seconds.

   Example 1.1. Set fr_timeout parameter
...
modparam("tm", "fr_timeout", 10)
...

1.3.2. fr_inv_timeout (integer)

   Timeout which is triggered if no final reply for an INVITE
   arrives after a provisional message was received (in seconds).
   This timeout starts counting down once the first provisional
   response is received. Thus, fast failover (no 100 trying from
   gateway) can be achieved by setting fr_timeout to low values.
   See example below.

   Default value is 120 seconds.

   Example 1.2. Set fr_inv_timeout parameter
...
modparam("tm", "fr_inv_timeout", 200)
...

1.3.3. wt_timer (integer)

   Time for which a transaction stays in memory to absorb delayed
   messages after it completed; also, when this timer hits,
   retransmission of local cancels is stopped (a puristic but
   complex behavior would be not to enter wait state until local
   branches are finished by a final reply or FR timer--we
   simplified).

   For non-INVITE transaction this timer relates to timer J of RFC
   3261 section 17.2.2. According to the RFC this timer should be
   64*T1 (= 32 seconds). But this would increase memory usage as
   the transactions are kept in memory very long.

   Default value is 5 seconds.

   Example 1.3. Set wt_timer parameter
...
modparam("tm", "wt_timer", 10)
...

1.3.4. delete_timer (integer)

   Time after which a to-be-deleted transaction currently ref-ed
   by a process will be tried to be deleted again.

   Default value is 2 seconds.

   Example 1.4. Set delete_timer parameter
...
modparam("tm", "delete_timer", 5)
...

1.3.5. T1_timer (integer)

   Retransmission T1 period, in milliseconds.

   Default value is 500 milliseconds.

   Example 1.5. Set T1_timer parameter
...
modparam("tm", "T1_timer", 700)
...

1.3.6. T2_timer (integer)

   Maximum retransmission period, in milliseconds.

   Default value is 4000 milliseconds.

   Example 1.6. Set T2_timer parameter
...
modparam("tm", "T2_timer", 8000)
...

1.3.7. ruri_matching (integer)

   Should be request-uri matching used as a part of pre-3261
   transaction matching as the standard wants us to do so? Turn
   only off for better interaction with devices that are broken
   and send different r-uri in CANCEL/ACK than in original INVITE.

   Default value is 1 (true).

   Example 1.7. Set ruri_matching parameter
...
modparam("tm", "ruri_matching", 0)
...

1.3.8. via1_matching (integer)

   Should be top most VIA matching used as a part of pre-3261
   transaction matching as the standard wants us to do so? Turn
   only off for better interaction with devices that are broken
   and send different top most VIA in CANCEL/ACK than in original
   INVITE.

   Default value is 1 (true).

   Example 1.8. Set via1_matching parameter
...
modparam("tm", "via1_matching", 0)
...

1.3.9. unix_tx_timeout (integer)

   Send timeout to be used by function which use UNIX sockets (as
   t_write_unix).

   Default value is 2 seconds.

   Example 1.9. Set unix_tx_timeout parameter
...
modparam("tm", "unix_tx_timeout", 5)
...

1.3.10. restart_fr_on_each_reply (integer)

   If true (non null value), the final response timer will be
   re-triggered for each received provisional reply. In this case,
   final response timeout may occur after a time longer than
   fr_inv_timeout (if UAS keeps sending provisional replies)

   Default value is 1 (true).

   Example 1.10. Set restart_fr_on_each_reply parameter
...
modparam("tm", "restart_fr_on_each_reply", 0)
...

1.3.11. tw_append (string)

   List of additional information to be appended by t_write_req
   and t_write_unix functions.

   Default value is null string.

   Syntax of the parameter is:
     * tw_append = append_name':' element (';'element)*
     * element = ( [name '='] variable)

   Each element will be appended per line in “name: value” format.
   Element “$rb (message body)” is the only one which does not
   accept name; the body it will be printed all the time at the
   end, disregarding its position in the definition string.

   Example 1.11. Set tw_append parameter
...
modparam("tm", "tw_append",
   "test: ua=$hdr(User-Agent) ;avp=$avp(avp);$rb;time=$Ts")
...

1.3.12. pass_provisional_replies (integer)

   Enable/disable passing of provisional replies to FIFO
   applications.

   Default value is 0.

   Example 1.12. Set pass_provisional_replies parameter
...
modparam("tm", "pass_provisional_replies", 1)
...

1.3.13. syn_branch (integer)

   Enable/disable the usage of stateful synonym branch IDs in the
   generated Via headers. They are faster but not reboot-safe.

   Default value is 1 (use synonym branches).

   Example 1.13. Set syn_branch parameter
...
modparam("tm", "syn_branch", 0)
...

1.3.14. onreply_avp_mode (integer)

   Describes how the AVPs should be handled in reply route:
     * 0 - the AVPs will be per message only; they will not
       interfere with the AVPS stored in transaction; initially
       there will be an empty list and at the end of the route,
       all AVPs that were created will be discarded.
     * 1 - the AVPs will be the transaction AVPs; initially the
       transaction AVPs will be visible; at the end of the route,
       the list will attached back to transaction (with all the
       changes)

   In mode 1, you can see the AVPs you set in request route,
   branch route or failure route. The side effect is performance
   as more locking is required in order to keep the AVP's list
   integrity.

   Default value is 0.

   Example 1.14. Set onreply_avp_mode parameter
...
modparam("tm", "onreply_avp_mode", 1)
...

1.3.15. disable_6xx_block (integer)

   Tells how the 6xx replies should be internally handled:
     * 0 - the 6xx replies will block any further serial forking
       (adding new branches). This is the RFC3261 behaviour.
     * 1 - the 6xx replies will be handled as any other negative
       reply - serial forking will be allowed. Logically, you need
       to break RFC3261 if you want to do redirects to
       announcement and voicemail services.

   Default value is 0.

   Example 1.15. Set disable_6xx_block parameter
...
modparam("tm", "disable_6xx_block", 1)
...

1.3.16. enable_stats (integer)

   Enables statistics support in TM module - If enabled, the TM
   module will internally keep several statistics and export them
   via the MI - Management Interface.

   Default value is 1 (enabled).

   Example 1.16. Set enable_stats parameter
...
modparam("tm", "enable_stats", 0)
...

1.3.17. minor_branch_flag (string/integer)

   A branch flag index to be used in script to mark the minor
   branches ( before t_relay() ).

   A minor branch is a branch OpenSIPS will not wait to complete
   during parallel forking. So, if the rest of the branches are
   negativly replied OpenSIPS will not wait for a final answer
   from the minor branch, but it will simply cancel it.

   Main applicability of minor branch is to fork a branch to a
   media server for injecting (via 183 Early Media) some pre-call
   media - of course, this branch will be transparanent for the
   rest of the call branches (from branch selection point of
   view).

   Default value is none (disabled).

   Example 1.17. Set minor_branch_flag parameter
...
modparam("tm", "minor_branch_flag", "MINOR_BFLAG")
...

1.3.18. timer_partitions (integer)

   The number of partitions for the internal TM timers
   (retransmissions, delete, wait, etc). Partitioning the timers
   increase the throughput under heavly load by handling timer
   events in parallel, rather than all serial.

   Recomanded range for timer partitions is max 16 (soft limit).

   Default value is 1 (disabled).

   Example 1.18. Set timer_partitions parameter
...
# Enable two timer partitions
modparam("tm", "timer_partitions", 2)
...

1.3.19. auto_100trying (integer)

   This parameter controls if the TM module should automatically
   generate an 100 Trying stateful reply when an INVITE
   transaction is created.

   You may want to disable this behavior if you want to control
   from script level when the 100 Trying is to be sent out.

   Default value is 1 (enabled).

   Example 1.19. Set auto_100trying parameter
...
# Disable automatic 100 Trying
modparam("tm", "auto_100trying", 0)
...

1.3.20. tm_replication_cluster (integer)

   This parameter should be used in an anycast setup, and
   specifies the cluster id of all the nodes that use an anycast
   IP.

   Check out the tm_anycast section for more details.

   Anycast replication is disabled by default.

   Example 1.20. Set tm_replication_cluster parameter
...
# replicate anycast messages in cluster 1
modparam("tm", "tm_replication_cluster", 1)
...

1.3.21. cluster_param (string)

   This parameter should be used in an anycast setup, and
   specifies the name of the parameter used in the VIA branch
   param to specifiy the instance id that created the transaction.

   Check out the tm_anycast section for more details.

   Default value is cid.

   Example 1.21. Set the cluster_param parameter
...
modparam("tm", "cluster_param", "tid")
...

1.3.22. cluster_auto_cancel (boolean)

   This parameter should be used in an anycast setup, and
   specifies whether a CANCEL message received on a listener that
   is marked as anycast should be automatically handled, or should
   get in the OpenSIPS script. If this parameter is enabled
   (default), CANCEL messages received on an anycast listener will
   never enter the script, thus making the script cleaner.

   Check out the tm_anycast section for more details.

   Default value is yes (enabled).

   Example 1.22. Set the cluster_auto_cancel parameter
...
# disable auto-cancel handling
modparam("tm", "cluster_auto_cancel", no)
...

1.4. Exported Functions

1.4.1.  t_relay([flags],[outbound_proxy])

   Relay a message statefully to destination indicated in current
   URI. (If the original URI was rewritten by UsrLoc, RR,
   strip/prefix, etc., the new URI will be taken). Returns a
   negative value on failure--you may still want to send a
   negative reply upstream statelessly not to leave upstream UAC
   in lurch.

   The coresponding transaction may or may not be already created.
   If not yet created, the function will automatically create it.

   The function may take two optional parameters.

   The first parameter is a number representing a set of flags for
   controlling the internal behaviour. The flags may be given in
   decimal or hexa format; supported flags are:
     * 0x01 - deprecated, not used any more
     * 0x02 - do not internally generate and send a "477 Send
       failed (477/TM)" SIP reply in case of a global forwarding
       failure (i.e. forwarding for each branch has failed due to
       internal errors, bad R-URI, bad message, lack of network
       reachability, etc.).
       This flag only applies if the transaction was not
       previously created by t_newtran(). When a global forwarding
       failure occurs, no SIP request is relayed and therefore no
       negative SIP reply or timeout will show up on the
       failure_route, if one is set.
       Useful if you want to implement a failover logic for when
       none of the currently created branches can be forwarded to.
     * 0x04 - disable the DNS failover for the transaction. Only
       first IP will be used. It disables the failover both at
       transport and transaction level.
     * 0x08 - If the request is a CANCEL, trust and pass further
       the Reason header from the received CANCEL - shortly, will
       propagate the Reason header.
     * 0x10 - Allows OpenSIPS to inspect and follow the
       Content-Disposition "no-cancel" indication (if present). As
       per RFC3841, section 9.1, the TM module may be instructed
       not to cancel all ongoing branches when a 2xx reply is
       received. It will keep the pending branches ongoing until
       (1) all branches will receive a final reply or (2) the
       transactionhits the timeout.

   The second parameter is a string representing an outbound proxy
   (a fixed destination) where the message should be sent. The
   destination is specified as “[proto:]host[:port]”. If a
   destination URI “$du” for this message was set before the
   function is called then this value will be used as the
   destination instead of the function parameter.

   In case of error, the function returns the following codes:
     * -1 - generic internal error
     * -2 - bad message (parsing errors)
     * -3 - no destination available (no branches were added or
       request already cancelled)
     * -4 - bad destination (unresolvable address)
     * -5 - destination filtered (black listed)
     * -6 - generic send failed

   This function can be used from REQUEST_ROUTE, FAILURE_ROUTE.

   Example 1.23. t_relay usage
...
if (!t_relay()) {
    sl_reply_error();
    exit;
}
...
t_relay( ,"tcp:192.168.1.10:5060");
...
t_relay(0x1, "mydomain.com:5070");
...

1.4.2.  t_reply(code, reason_phrase)

   Sends a stateful SIP reply to the currently processed requests.
   Note that if the transaction was not created yet, it will
   automatically created by internally using the t_newtran
   function.

   Meaning of the parameters is as follows:
     * code (int) - Reply code number.
     * reason_phrase (string) - Reason string.

   This function can be used from REQUEST_ROUTE, FAILURE_ROUTE.

   Example 1.24. t_reply usage
...
t_reply(404, "Use $rU not found");
...

1.4.3.  t_reply_with_body(code, reason_phrase, body)

   Sends a stateful SIP reply with a body to the currently
   processed requests. Note that if the transaction was not
   created yet, it will automatically created by internally using
   the t_newtran function.

   Meaning of the parameters is as follows:
     * code (int) - Reply code number.
     * reason_phrase (string) - Reason string.
     * body (string) - Reply body.

   This function can be used from REQUEST_ROUTE and FAILURE_ROUTE.

   Example 1.25. t_reply_with_body usage
...
        if(is_method("INVITE"))
        {
                append_to_reply("Contact: $var(contact)\r\n"
                                "Content-Type: application/sdp\r\n");
                t_reply_with_body(200, "Ok", $var(body));
                exit;
        }
...

1.4.4.  t_newtran()

   Creates the SIP transaction for the currently processed SIP
   request, thus switching to stateful processing. For INVITE
   requests, a 100 Trying reply will be immediately sent, unless
   auto_100trying is disabled. Once a SIP transaction is created,
   calling t_newtran() for retransmitted requests will end the
   OpenSIPS script execution, with the lastly sent reply being
   retransmitted upstream.

   This function can be used from REQUEST_ROUTE.

   Example 1.26. t_newtran usage
...
t_newtran();  # 100 Trying is fired here
xlog("doing my complicated routing logic\n");
....
t_relay(); # send the call further
...

1.4.5.  t_check_trans()

   Returns true if the current request is associated to a
   transaction. The relationship between the request and
   transaction is defined as follows:
     * non-CANCEL/non-ACK requests - if the request belongs to a
       transaction (it's a retransmision), the function will do a
       standard processing of the retransmission and will
       break/stop the script. The function returns false if the
       request is not a retransmission.
     * CANCEL request - true if the cancelled INVITE transaction
       exists.
     * ACK request - true if the ACK is a hop-by-hop ACK (to a
       negative reply) corresponding to an previous INVITE
       transaction. IMPORTANT: this function returns false (return
       code -2) for end-to-end ACKs (to 2xx replies from a
       different transaction).

   Note: To detect retransmissions using this function you have to
   make sure that the initial request has already created a
   transaction, e.g. by using t_relay(). If the processing of
   requests may take long time (e.g. DB lookups) and the
   retransmission arrives before t_relay() is called, you can use
   the t_newtran() function to manually create a transaction.

   This function can be used from REQUEST_ROUTE and BRANCH_ROUTE.

   Example 1.27. t_check_trans usage
...
if ( is_method("CANCEL") ) {
        if ( t_check_trans() )
                t_relay();
        exit;
}
...

1.4.6.  t_check_status(re)

   Returns true if the regualr expression “re” match the reply
   code of the response message as follows:
     * in routing block - the code of the last sent reply.
     * in on_reply block - the code of the current received reply.
     * in on_failure block - the code of the selected negative
       final reply.

   This function can be used from REQUEST_ROUTE, ONREPLY_ROUTE,
   FAILURE_ROUTE and BRANCH_ROUTE .

   Example 1.28. t_check_status usage
...
if (t_check_status("(487)|(408)")) {
    log("487 or 408 negative reply\n");
}
...

1.4.7.  t_local_replied(reply)

   Returns true if all or last (depending of the parameter)
   reply(es) were local generated (and not received).

   Parameter may be “all” or “last”.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   FAILURE_ROUTE and ONREPLY_ROUTE.

   Example 1.29. t_local_replied usage
...
if (t_local_replied("all")) {
        log ("no reply received\n");
}
...

1.4.8.  t_was_cancelled()

   Retuns true if called for an INVITE transaction that was
   explicitly cancelled by UAC side via a CANCEL request.

   This function can be used from ONREPLY_ROUTE, FAILURE_ROUTE.

   Example 1.30. t_was_cancelled usage
...
if (t_was_cancelled()) {
    log("transaction was cancelled by UAC\n");
}
...

1.4.9.  t_cancel_branch([flags])

   This function is to be call when a reply is received for
   cancelling a set of branches (see flags) of the current call.

   Meaning of the parameters is as follows:
     * flags (string, optional) - set of flags (char based flags)
       to control what branches to be cancelled:
          + a - all - cancel all pending branches
          + o - others - cancel all the other pending branches
            except the current one
          + empty - current - cancel only the current branch

   This function can be used from ONREPLY_ROUTE.

   Example 1.31. t_cancel_branch usage
onreply_route[3] {
...
        if (t_check_status(183)) {
                # no support for early media
                t_cancel_branch();
        }
...
}

1.4.10.  t_new_request(method,RURI,from,to[,body[,ctx]])

   This function generates and sends out a new SIP request (in a
   stateful way). The new request is completly unrelated to the
   currently processed SIP message.

   Meaning of the parameters is as follows (all do accept
   variables):
     * method (string) - the SIP method
     * RURI (string) - the SIP Request URI (the request will be
       sent out to this destination)
     * from (string) - the SIP From hdr information as "[display
       ]URI"
     * to (string) - the SIP To hdr information as "[display ]URI"
     * body (string, optional) - the SIP body content starting
       with the content type string: "conten_type body"
     * ctx (string, optional) - a context string that will be
       added to the new transaction as an AVP with name "uac_ctx"
       (it may be visible in local route)

   Example 1.32. t_new_request usage
...
        # send a MESSAGE request
        t_new_request("MESSAGE","sip:alice@192.168.2.2","BOB sip:userB@m
ydomain.net","ALICE sip:userA@mydomain.net","text/plain Hello Alice!"))
{
...

1.4.11.  t_on_failure(failure_route)

   Sets reply routing block, to which control is passed after a
   transaction completed with a negative result but before sending
   a final reply. In the referred block, you can either start a
   new branch (good for services such as forward_on_no_reply) or
   send a final reply on your own (good for example for message
   silo, which received a negative reply from upstream and wants
   to tell upstream “202 I will take care of it”).

   As not all functions are available from failure route, please
   check the documentation for each function to see the
   permissions. Any other commands may result in unpredictable
   behavior and possible server failure.

   Only one failure_route can be armed for a request. If you use
   many times t_on_failure(), only the last one has effect.

   Note that whenever failure_route is entered, RURI is set to
   value of the winning branch.

   Meaning of the parameters is as follows:
     * failure_route (string) - Reply route block to be called.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   ONREPLY_ROUTE and FAILURE_ROUTE.

   Example 1.33. t_on_failure usage
...
route {
        t_on_failure("1");
        t_relay();
}

failure_route[1] {
        seturi("sip:user@voicemail");
        t_relay();
}
...

1.4.12.  t_on_reply(reply_route)

   Sets reply routing block, to which control is passed each time
   a reply (provisional or final) for the transaction is received.
   The route is not called for local generated replies! In the
   referred block, you can inspect the reply and perform text
   operations on it.

   As not all functions are available from this type of route,
   please check the documentation for each function to see the
   permissions. Any other commands may result in unpredictable
   behavior and possible server failure.

   If called from branch route, the reply route will be set only
   for the current branch - that's it, it will be called only for
   relies belonging to that particular branch. Of course, from
   branch route, you can set different reply routes for each
   branch.

   When called from a non-branc route, the reply route will be
   globally set for tha current transaction - it will be called
   for all replies belonging to that transaction. NOTE that only
   one> onreply_route can be armed for a transaction. If you use
   many times t_on_reply(), only the last one has effect.

   If the processed reply is provisionla reply (1xx code), by
   calling the drop() function (exported by core), the execution
   of the route will end and the reply will not be forwarded
   further.

   Meaning of the parameters is as follows:
     * reply_route (string) - Reply route block to be called.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   ONREPLY_ROUTE and FAILURE_ROUTE.

   Example 1.34. t_on_reply usage
...
route {
        seturi("sip:bob@opensips.org");  # first branch
        append_branch("sip:alice@opensips.org"); # second branch

        t_on_reply("global"); # the "global" reply route
                              # is set the whole transaction
        t_on_branch("1");

        t_relay();
}

branch_route[1] {
        if ($rU=="alice")
                t_on_reply("alice"); # the "alice" reply route
                                      # is set only for second branch
}

onreply_route[alice] {
        xlog("received reply from alice\n");
}

onreply_route[global] {
        if (t_check_status("1[0-9][0-9]")) {
                setflag(LOG_FLAG);
                log("provisional reply received\n");
                if (t_check_status("183"))
                        drop;
        }
}
...

1.4.13.  t_on_branch(branch_route)

   Sets a branch route to be execute separately for each branch of
   the transaction before being sent out - changes in that route
   should reflect only on that branch.

   As not all functions are available from this type of route,
   please check the documentation for each function to see the
   permissions. Any other commands may result in unpredictable
   behavior and possible server failure.

   Only one branch_route can be armed for a request. If you use
   many time t_on_branch(), only the last one has effect.

   By calling the drop() function (exported by core), the
   execution of the branch route will end and the branch will not
   be forwarded further.

   Meaning of the parameters is as follows:
     * branch_route (string) - Branch route block to be called.

   This function can be used from REQUEST_ROUTE, BRANCH_ROUTE,
   ONREPLY_ROUTE and FAILURE_ROUTE.

   Example 1.35. t_on_branch usage
...
route {
        t_on_branch("1");
        t_relay();
}

branch_route[1] {
        if ($ru=~"bad_uri") {
                xlog("dropping branch $ru \n");
                drop;
        }
        if ($ru=~"GW_uri") {
                append_rpid();
        }
}
...

1.4.14.  t_inject_branches(source[,flags])

   The function adds new SIP branches (destinations) to an
   existing transaction and fires them (sends them out). The
   transaction may already have ongoing branches (like in ringing
   state), which will not be affected by the injection of the new
   branches. Also it is possible for the transaction not to have
   any ongoing branches at the moment of the injection (still, the
   transaction must wait for new branches, even if all existing
   ones are completed - see the t_wait_for_new_branches() function
   for this).

   The main usage scenario for this function (and also what makes
   it different from t_relay() is the ability to add new branches
   to an ongoing transaction from script routes not related to the
   transaction ( like timer route, event route, notification
   route, and other). In such routes, other functions/module used
   before the injection will point to the transaction to be
   affected by this injection - see the event_routing module.

   Parameters:
     * source (string) - where to take the description for the new
       branches to be injected. It can be
          + event - the branch will be taken from the event
            attributes exposed in an event notification route (see
            event_routing module).
          + msg - the branches will be taken from the RURI of the
            SIP message and from the additional branches (created
            by append_branch() function or similar).
     * flags (string, optional) - some additional flags related to
       the injection process:
          + cancel or c - cancel all the ongoing existing branches
            from the transaction before injecting the new
            branches.
          + l (last) - this is the last injected branch on this
            transaction, do not wait for any other branches to be
            injected.

   Example 1.36. t_inject_branches usage
...
route[event_notification] {
        t_inject_branches("event");
}
...

1.4.15.  t_wait_for_new_branches([branches])

   This function instructs the existing SIP transaction to wait
   for new branches to be injected even after the completion of
   the existing branches. This waiting will be done until the
   Final Response INVITE timer (fr_inv_timeout) will hit for the
   transaction OR until the maximum number of branches were
   injected (see parameter); of course, the waiting will be
   terminated if the transaction gets a 2xx final reply from one
   of the branches.

   Normally if you have a transaction with two branches and they
   get, let's say, a 404 and 486 replies, the branches will be
   completed and transaction terminated by sending the 404 reply
   to the caller. Still, if you do t_wait_for_new_branches before
   relaying the transaction, the transaction will not terminate
   upon the completion of the branches and not send the 404 to the
   caller - it will wait for new branches to be injected (see
   t_inject_branches() function) until the fr_inv timer hits.

   Parameters:
     * branches (integer, options) - what is the maximum number of
       branches to be waited for.

   Example 1.37. t_wait_for_new_branches usage
...
t_newtran();
t_wait_for_new_branches();
t_relay();
...

1.4.16.  t_wait_no_more_branches()

   This function instructs the existing SIP transaction to stop
   wait for new any new branches to be injected. This functions
   should be used for a transaction that is waiting for dynamic
   branches, via the t_wait_for_new_branches() function.

   Usage scenario: your transaction is waiting for dynamic new
   branches (as a reusult of Push Notification). To a point, on an
   ongoing branch you receive a final reply - and the fact that
   the branch fails translates into stop waiting for any more
   branche (this is an example of a logic on deciding how long to
   wait for more branches, depending on the answers you get from
   various devices, fix or mobile).

   Example 1.38. t_wait_no_more_branches usage
...
t_wait_no_more_branches();
...

1.4.17.  t_add_hdrs("sip_hdrs")

   Attach a set of headers to the existing transaction - these
   headers will be appended to all requests related to the
   transaction (outgoing branches, local ACKS, CANCELs).

   Parameters:
     * sip_hdrs (string)

   Example 1.39. t_add_hdrs usage
...
t_add_hdrs("X-origin: 1.1.1.1\r\n");
...

1.4.18.  t_add_cancel_reason("Reason_hdr")

   This function is used to enforce from the script level a custom
   "Reason" header into a CANCEL request. Normally, the Reason
   header is inherited form the received CANCEL (note that CANCEL
   propagates in a hop-by-hop manner - it is re-generated at each
   hop), but this function can overwrite it. It must be called
   before relaying the CANCEL request and its input must be a
   fully formated Reason header with name, body and CRLF.

   Parameters:
     * reason_hdr (string)

   Example 1.40. t_add_cancel_reason usage
...
t_add_cancel_reason("Reason: SIP ;cause=200 ;text=\"Call completed elsew
here\"\r\n");
t_relay();
...

1.4.19.  t_replicate(URI,[flags])

   Replicates a request to another destination. No information due
   the replicated request (like reply code) will be forwarded to
   the original SIP UAC.

   The destination is specified by a SIP URI. If multiple
   destinations are to be used, the additional SIP URIs have to be
   set as branches.

   Parameters:
     * uri (string)
     * flags (int, optional) - a set of flags for controlling the
       internal behaviour - for description see the above
       “t_relay([flags])” function. Note that only 0x4 is
       applicable here.

   This functions can be used from REQUEST_ROUTE.

   Example 1.41. t_replicate usage
...
t_replicate("sip:1.2.3.4:5060");
t_replicate("sip:1.2.3.4:5060;transport=tcp");
t_replicate("sip:1.2.3.4",0x4);
...

1.4.20.  t_write_req(info,fifo) t_write_unix(info,sock)

   Write via FIFO file or UNIX socket a lot of information
   regarding the request. Which information should be written may
   be control via the “tw_append” parameter.

   Parameters:
     * info (string)
     * path (string)

   This functions can be used from REQUEST_ROUTE, FAILURE_ROUTE
   and BRANCH_ROUTE.

   Example 1.42. t_write_req/unix usage
...
modparam("tm","tw_append","append1:Email=$avp(email);UA=$ua")
modparam("tm","tw_append","append2:body=$rb")
...
t_write_req("voicemail/append1","/tmp/appx_fifo");
...
t_write_unix("logger/append2","/var/run/logger.sock");
...

1.4.21.  t_flush_flags()

   Flush the flags from current request into the already created
   transaction. It make sense only in routing block if the
   transaction was created via t_newtran() and the flags have been
   altered since.

   This function can be used from REQUEST_ROUTE and BRANCH_ROUTE .

   Example 1.43. t_flush_flags usage
...
t_flush_flags();
...

1.4.22.  t_anycast_replicate()

   This function is used in an anycast setup to replicate a CANCEL
   or ACK method for whom there are no local transactions found.
   The function broadcasts the message to all the other nodes in
   the cluster, but only the “owner” of the transaction will be
   able to handle it.

   Example 1.44. t_anycast_replicate usage
...
if (is_method("ACK|CANCEL") && !t_check_trans()) {
        t_anycast_replicate();
        exit;
}
...

1.5. Exported Pseudo-Variables

   Exported variables are listed in the next sections.

1.5.1. $T_branch_idx

   $T_branch_idx - the index (starting with 0 for the first
   branch) of the currently proccessed branch. This index makes
   sense only in BRANCH and REPLY routes (where there is a concept
   of per branch processing). In all the other types of routes,
   the value of this index will be NULL.

1.5.2. $T_reply_code

   $T_reply_code - the code of the reply, as follows: in
   request_route will be the last stateful sent reply; in
   reply_route will be the current processed reply; in
   failure_route will be the negative winning reply. In case of
   no-reply or error, '0' value is returned.

1.5.3. $T_fr_timeout

   $T_fr_timeout (R/W) - the timeout for the final reply to the
   current transaction

   With each different request received, $T_fr_timeout will
   initially be equal to the fr_timeout parameter.

   "$T_fr_timeout = NULL;" will reset it to fr_timeout.

1.5.4. $T_fr_inv_timeout

   $T_fr_inv_timeout (R/W) - the timeout for the final reply to an
   INVITE request, after a 1XX reply was received

   With each different request received, $T_fr_inv_timeout will
   initially be equal to the fr_inv_timeout parameter.

   "$T_fr_inv_timeout = NULL;" will reset it to fr_inv_timeout.

1.5.5. $T_ruri

   $T_ruri - the ruri of the current branch; this information is
   taken from the transaction structure, so you can access this
   information for any sip message (request/reply) that has a
   transaction.

1.5.6. $bavp(name)

   $bavp(name) - a particular type of avp that can have different
   values for each branch. They can only be used in BRANCH, REPLY
   and FAILURE routes. Otherwise NULL value is returned.

1.5.7. $T_id

   $T_id - returns the ID of the current transaction. The ID is an
   opaque hexa string, unique for each transaction. If there is no
   current transaction, NULL value is returned.

1.6. Exported MI Functions

1.6.1.  t_uac_dlg

   Generates and sends a local SIP request.

   Parameters:
     * method - request method
     * ruri - request SIP URI
     * headers - set of additional headers to be added to the
       request; at least “From” and “To” headers must be
       specified)
     * next_hop (optional) - next hop SIP URI (OBP).
     * socket (optional) - local socket to be used for sending the
       request.
     * body (optional) - request body (if present, requires the
       “Content-Type” and “Content-length” headers)

   MI FIFO Command Format:
                opensips-cli -x mi t_uac_dlg method=INVITE ruri="sip:ali
ce@127.0.0.1:7050" headers="From: sip:bobster@127.0.0.1:1337\r\nTo: sip:
alice@127.0.0.1:7050\r\nContact: sip:bobster@127.0.0.1:1337\r\n"

1.6.2.  t_uac_cancel

   Generates and sends a CANCEL for an existing SIP request.

   Parameters:
     * callid - callid of the INVITE request to be cancelled.
     * cseq - cseq of the INVITE request to be cancelled.

   MI FIFO Command Format:
                opensips-cli -x mi t_uac_cancel "1-23454@127.0.0.1" "1 I
NVITE"

1.6.3.  t_hash

   Gets information about the load of TM internal hash table.

   Parameters:
     * none

   MI FIFO Command Format:
                opensips-cli -x mi t_hash

1.6.4.  t_reply

   Generates and sends a reply for an existing inbound SIP
   transaction.

   Parameters:
     * code - reply code
     * reason - reason phrase.
     * trans_id - transaction identifier (has the hash_entry:label
       format)
     * to_tag - To tag to be added to TO header
     * new_headers (optional) - extra headers to be appended to
       the reply.
     * body - (optional) reply body (if present, requires the
       “Content-Type” and “Content-length” headers)

   MI FIFO Command Format:
                opensips-cli -x mi t_reply 403 Forbidden 46961:127968763
7 abcde .

1.7. Exported Statistics

   Exported statistics are listed in the next sections. All
   statistics except “inuse_transactions” can be reset.

1.7.1. received_replies

   Total number of total replies received by TM module.

1.7.2. relayed_replies

   Total number of replies received and relayed by TM module.

1.7.3. local_replies

   Total number of replies local generated by TM module.

1.7.4. UAS_transactions

   Total number of transactions created by received requests.

1.7.5. UAC_transactions

   Total number of transactions created by local generated
   requests.

1.7.6. 2xx_transactions

   Total number of transactions completed with 2xx replies.

1.7.7. 3xx_transactions

   Total number of transactions completed with 3xx replies.

1.7.8. 4xx_transactions

   Total number of transactions completed with 4xx replies.

1.7.9. 5xx_transactions

   Total number of transactions completed with 5xx replies.

1.7.10. 6xx_transactions

   Total number of transactions completed with 6xx replies.

1.7.11. inuse_transactions

   Number of transactions existing in memory at current time.

Chapter 2. Developer Guide

2.1. Functions

2.1.1.  load_tm(*import_structure)

   For programmatic use only--import the TM API. See the cpl_c,
   acc or jabber modules to see how it works.

   Meaning of the parameters is as follows:
     * import_structure - Pointer to the import structure - see
       “struct tm_binds” in modules/tm/tm_load.h

Chapter 3. Frequently Asked Questions

   3.1.

   What happened with old cancel_call() function

   The function was replace (as functionality) by
   cancel_branch("a") - cancel all braches.

   3.2.

   How can I report a bug?

   Please follow the guidelines provided at:
   https://github.com/OpenSIPS/opensips/issues.

Chapter 4. Contributors

4.1. By Commit Statistics

   Table 4.1. Top contributors by DevScore^(1), authored
   commits^(2) and lines added/removed^(3)
     Name DevScore Commits Lines ++ Lines --
   1. Bogdan-Andrei Iancu (@bogdan-iancu) 1068 619 21637 16650
   2. Jiri Kuthan (@jiriatipteldotorg) 534 198 18723 11167
   3. Jan Janak (@janakj) 160 76 6462 1840
   4. Andrei Pelinescu-Onciul 145 105 2447 1210
   5. Razvan Crainea (@razvancrainea) 126 96 1888 841
   6. Liviu Chircu (@liviuchircu) 105 79 1232 874
   7. Daniel-Constantin Mierla (@miconda) 43 37 322 166
   8. Vlad Patrascu (@rvlad-patrascu) 38 16 881 801
   9. Anca Vamanu 37 19 778 651
   10. Vlad Paiu (@vladpaiu) 26 23 170 57

   All remaining contributors: Dan Pascu (@danpascu), Henning
   Westerholt (@henningw), Ovidiu Sas (@ovidiusas), Maksym
   Sobolyev (@sobomax), Juha Heinanen (@juha-h), Ionut Ionita
   (@ionutrazvanionita), Raphael Coeffic, Nils Ohlmeier, Klaus
   Darilion, Peter Lemenkov (@lemenkov), Andreas Granig, Elias
   Baixas, Marcus Hunger, Christophe Sollet (@csollet), Jeffrey
   Magder, Ezequiel Lovelle (@lovelle), Saúl Ibarra Corretgé
   (@saghul), Elena-Ramona Modroiu, John Riordan, Julián Moreno
   Patiño, Andrei Dragus, Jesus Rodrigues, Konstantin Bokarius,
   Aron Podrigal (@ar45), Anonymous, Dusan Klinec (@ph4r05), Mark
   Dalby, Walter Doekes (@wdoekes), Alexey Vasilyev
   (@vasilevalex), Fabian Gast (@fgast), Nick Altmann (@nikbyte),
   Zero King (@l2dy), Edson Gellert Schubert, Ingo Wolfsberger,
   Daniel Hsueh.

   (1) DevScore = author_commits + author_lines_added /
   (project_lines_added / project_commits) + author_lines_deleted
   / (project_lines_deleted / project_commits)

   (2) including any documentation-related commits, excluding
   merge commits. Regarding imported patches/code, we do our best
   to count the work on behalf of the proper owner, as per the
   "fix_authors" and "mod_renames" arrays in
   opensips/doc/build-contrib.sh. If you identify any
   patches/commits which do not get properly attributed to you,
   please submit a pull request which extends "fix_authors" and/or
   "mod_renames".

   (3) ignoring whitespace edits, renamed files and auto-generated
   files

4.2. By Commit Activity

   Table 4.2. Most recently active contributors^(1) to this module
                      Name                   Commit Activity
   1.  Bogdan-Andrei Iancu (@bogdan-iancu) Nov 2001 - Oct 2022
   2.  Liviu Chircu (@liviuchircu)         Jan 2013 - Oct 2022
   3.  Vlad Patrascu (@rvlad-patrascu)     May 2017 - Jun 2022
   4.  Razvan Crainea (@razvancrainea)     Jul 2010 - May 2022
   5.  Maksym Sobolyev (@sobomax)          Mar 2004 - Mar 2021
   6.  Peter Lemenkov (@lemenkov)          Jun 2018 - Feb 2021
   7.  Zero King (@l2dy)                   Mar 2020 - Mar 2020
   8.  Dan Pascu (@danpascu)               Feb 2006 - Feb 2020
   9.  Vlad Paiu (@vladpaiu)               Jun 2011 - May 2019
   10. Fabian Gast (@fgast)                Apr 2019 - Apr 2019

   All remaining contributors: Aron Podrigal (@ar45), Alexey
   Vasilyev (@vasilevalex), Ionut Ionita (@ionutrazvanionita),
   Julián Moreno Patiño, Nick Altmann (@nikbyte), Ovidiu Sas
   (@ovidiusas), Dusan Klinec (@ph4r05), Ezequiel Lovelle
   (@lovelle), Walter Doekes (@wdoekes), Christophe Sollet
   (@csollet), Saúl Ibarra Corretgé (@saghul), Anonymous, Mark
   Dalby, Anca Vamanu, Andrei Dragus, John Riordan, Henning
   Westerholt (@henningw), Klaus Darilion, Daniel-Constantin
   Mierla (@miconda), Konstantin Bokarius, Edson Gellert Schubert,
   Jesus Rodrigues, Marcus Hunger, Juha Heinanen (@juha-h),
   Jeffrey Magder, Elias Baixas, Daniel Hsueh, Andreas Granig,
   Elena-Ramona Modroiu, Ingo Wolfsberger, Andrei
   Pelinescu-Onciul, Jan Janak (@janakj), Jiri Kuthan
   (@jiriatipteldotorg), Raphael Coeffic, Nils Ohlmeier.

   (1) including any documentation-related commits, excluding
   merge commits

Chapter 5. Documentation

5.1. Contributors

   Last edited by: Bogdan-Andrei Iancu (@bogdan-iancu), Razvan
   Crainea (@razvancrainea), Liviu Chircu (@liviuchircu), Vlad
   Patrascu (@rvlad-patrascu), Fabian Gast (@fgast), Alexey
   Vasilyev (@vasilevalex), Peter Lemenkov (@lemenkov), Nick
   Altmann (@nikbyte), Ovidiu Sas (@ovidiusas), Vlad Paiu
   (@vladpaiu), Anca Vamanu, Henning Westerholt (@henningw), Klaus
   Darilion, Daniel-Constantin Mierla (@miconda), Konstantin
   Bokarius, Edson Gellert Schubert, Dan Pascu (@danpascu), Juha
   Heinanen (@juha-h), Elena-Ramona Modroiu, Jan Janak (@janakj),
   Jiri Kuthan (@jiriatipteldotorg).

   Documentation Copyrights:

   Copyright © 2005-2008 Voice Sistem SRL

   Copyright © 2003 FhG FOKUS
