/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.baraye;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.baraye.Plasma;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Ident;

public class Quark
extends Ident
implements Code {
    private final Plasma plasma;
    private Quark parent;
    private Object data;

    Quark(Plasma plasma, Quark parent, List<String> parts) {
        super(new ArrayList<String>(parts));
        this.plasma = plasma;
        this.parent = parent;
        if (parent == null ? parts.size() != 0 : !parent.parts.equals(parts.subList(0, parts.size() - 1))) {
            throw new IllegalStateException();
        }
    }

    public Quark getParent() {
        return this.parent;
    }

    @Override
    public String toString() {
        return this.parts.toString();
    }

    public List<String> getSignature() {
        return new ArrayList<String>(this.parts);
    }

    public boolean containsLarge(Quark other) {
        return other.parts.size() > this.parts.size() && other.parts.subList(0, this.parts.size()).equals(this.parts);
    }

    public boolean startsWith(Quark other) {
        if (other.parts.size() > this.parts.size()) {
            return false;
        }
        for (int i = 0; i < other.parts.size(); ++i) {
            if (((String)other.parts.get(i)).equals(this.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString(String sep) {
        if (sep == null) {
            sep = ".";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : this.parts) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        if (this.parts.size() == 0) {
            return "";
        }
        return (String)this.parts.get(this.parts.size() - 1);
    }

    @Override
    public boolean isRoot() {
        return this.parts.size() == 0;
    }

    public int getDepth() {
        return this.parts.size();
    }

    public final Plasma getPlasma() {
        return this.plasma;
    }

    public final Object getData() {
        return this.data;
    }

    public final void setData(Object data) {
        this.data = data;
    }

    @Override
    public Ident eventuallyRemoveStartingAndEndingDoubleQuote(String format) {
        return this;
    }

    public Quark childIfExists(String name) {
        ArrayList<String> sig = new ArrayList<String>(this.getSignature());
        sig.add(name);
        return this.plasma.getIfExists(sig);
    }

    public Quark parse(Quark path) {
        ArrayList<String> sig = new ArrayList<String>(this.getSignature());
        sig.addAll(path.getSignature());
        return this.plasma.ensurePresent(sig);
    }

    public Quark child(String name) {
        return this.plasma.parse(this, name);
    }

    public int countChildren() {
        return this.plasma.countChildren(this);
    }

    public List<Quark> getChildren() {
        return this.plasma.getChildren(this);
    }

    public void moveTo(Quark dest) {
        this.plasma.moveAllTo(this, dest);
    }

    public void internalMove(Quark src, Quark dest) {
        System.err.print("Intermal move from " + this + " to ");
        if (src.getDepth() + 1 != dest.getDepth()) {
            throw new UnsupportedOperationException("to be finished");
        }
        List<String> previous = this.getSignature();
        this.parts.clear();
        this.parts.addAll(dest.getSignature());
        this.parts.addAll(previous.subList(src.getDepth(), previous.size()));
        this.parent = this.plasma.ensurePresent(this.parts.subList(0, this.parts.size() - 1));
        System.err.println(this.toString());
    }
}

