/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandUrl
extends SingleLineCommand2<SequenceDiagram> {
    public CommandUrl() {
        super(CommandUrl.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandUrl.class.getName(), RegexLeaf.start(), new RegexLeaf("url"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("of|for")), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE", "([%pLN_.@]+|[%g][^%g]+[%g])"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexLeaf("is")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        String code = arg.get("CODE", 0);
        String urlString = arg.get("URL", 0);
        Participant p = diagram.getOrCreateParticipant(code);
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
        Url url = urlBuilder.getUrl(urlString);
        p.setUrl(url);
        return CommandExecutionResult.ok();
    }
}

